/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.pointsto.heap;

import com.oracle.graal.pointsto.heap.ImageHeapArray;
import com.oracle.graal.pointsto.heap.ImageHeapConstant;
import com.oracle.graal.pointsto.meta.AnalysisType;
import com.oracle.graal.pointsto.util.AnalysisError;
import java.lang.reflect.Array;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.JavaKind;

public final class ImageHeapPrimitiveArray
extends ImageHeapArray {
    ImageHeapPrimitiveArray(AnalysisType type, int length) {
        super(new PrimitiveArrayData(type, null, Array.newInstance(type.getComponentType().getStorageKind().toJavaClass(), length), length, -1, -1), false);
    }

    ImageHeapPrimitiveArray(AnalysisType type, JavaConstant hostedObject, Object array, int length) {
        this(type, hostedObject, array, length, -1, -1);
    }

    public ImageHeapPrimitiveArray(AnalysisType type, JavaConstant hostedObject, Object array, int length, int identityHashCode, int id) {
        super(new PrimitiveArrayData(type, hostedObject, ImageHeapPrimitiveArray.getClone(type.getComponentType().getJavaKind(), array), length, identityHashCode, id), false);
    }

    private ImageHeapPrimitiveArray(ImageHeapConstant.ConstantData constantData, boolean compressed) {
        super(constantData, compressed);
    }

    @Override
    public PrimitiveArrayData getConstantData() {
        return (PrimitiveArrayData)super.getConstantData();
    }

    private static Object getClone(JavaKind kind, Object arrayObject) {
        return switch (kind) {
            case JavaKind.Boolean -> (boolean[])((boolean[])arrayObject).clone();
            case JavaKind.Byte -> (Object[])((byte[])((byte[])arrayObject).clone());
            case JavaKind.Short -> (Object[])((short[])((short[])arrayObject).clone());
            case JavaKind.Char -> (Object[])((char[])((char[])arrayObject).clone());
            case JavaKind.Int -> (Object[])((int[])((int[])arrayObject).clone());
            case JavaKind.Long -> (Object[])((long[])((long[])arrayObject).clone());
            case JavaKind.Float -> (Object[])((float[])((float[])arrayObject).clone());
            case JavaKind.Double -> (Object[])((double[])((double[])arrayObject).clone());
            default -> throw new IllegalArgumentException("Unsupported kind: " + String.valueOf(kind));
        };
    }

    public Object getArray() {
        return this.getConstantData().array;
    }

    @Override
    public Object getElement(int idx) {
        return this.readElementValue(idx);
    }

    @Override
    public JavaConstant readElementValue(int idx) {
        return JavaConstant.forBoxedPrimitive((Object)Array.get(this.getArray(), idx));
    }

    @Override
    public void setElement(int idx, JavaConstant value) {
        if (value.getJavaKind() != this.constantData.type.getComponentType().getJavaKind()) {
            throw AnalysisError.shouldNotReachHere("Cannot store value of kind " + String.valueOf(value.getJavaKind()) + " into primitive array of type " + String.valueOf(this.getConstantData().type));
        }
        Array.set(this.getArray(), idx, value.asBoxedPrimitive());
    }

    @Override
    public int getLength() {
        return this.getConstantData().length;
    }

    public JavaConstant compress() {
        assert (!this.compressed) : this;
        return new ImageHeapPrimitiveArray(this.constantData, true);
    }

    public JavaConstant uncompress() {
        assert (this.compressed) : this;
        return new ImageHeapPrimitiveArray(this.constantData, false);
    }

    @Override
    public ImageHeapConstant forObjectClone() {
        assert (this.constantData.type.isCloneableWithAllocation()) : "all arrays implement Cloneable";
        PrimitiveArrayData data = this.getConstantData();
        Object newArray = ImageHeapPrimitiveArray.getClone(data.type.getComponentType().getJavaKind(), data.array);
        return new ImageHeapPrimitiveArray(new PrimitiveArrayData(data.type, null, newArray, data.length, -1, -1), this.compressed);
    }

    private static final class PrimitiveArrayData
    extends ImageHeapConstant.ConstantData {
        private final Object array;
        private final int length;

        private PrimitiveArrayData(AnalysisType type, JavaConstant hostedObject, Object array, int length, int identityHashCode, int id) {
            super(type, hostedObject, identityHashCode, id);
            this.array = array;
            this.length = length;
            assert (type.isArray() && type.getComponentType().isPrimitive()) : type;
        }
    }
}

