/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.pointsto.infrastructure;

import java.lang.invoke.MethodType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.MetaAccessProvider;
import jdk.vm.ci.meta.ResolvedJavaType;
import jdk.vm.ci.meta.Signature;

public final class ResolvedSignature<T extends ResolvedJavaType>
implements Signature {
    private final List<T> parameterTypes;
    private final T returnType;

    public static <T extends ResolvedJavaType> ResolvedSignature<T> fromArray(T[] parameterTypes, T returnType) {
        return new ResolvedSignature<T>(List.of(parameterTypes), returnType);
    }

    public static <T extends ResolvedJavaType> ResolvedSignature<T> fromList(List<T> parameterTypes, T returnType) {
        return new ResolvedSignature<T>(List.copyOf(parameterTypes), returnType);
    }

    public static ResolvedSignature<ResolvedJavaType> fromKinds(JavaKind[] parameterKinds, JavaKind returnKind, MetaAccessProvider metaAccess) {
        return new ResolvedSignature<ResolvedJavaType>(Arrays.stream(parameterKinds).map(kind -> ResolvedSignature.resolveType(kind, metaAccess)).collect(Collectors.toUnmodifiableList()), ResolvedSignature.resolveType(returnKind, metaAccess));
    }

    private static ResolvedJavaType resolveType(JavaKind kind, MetaAccessProvider metaAccess) {
        return metaAccess.lookupJavaType(kind.isObject() ? Object.class : kind.toJavaClass());
    }

    public static ResolvedSignature<ResolvedJavaType> fromMethodType(MethodType mt, MetaAccessProvider metaAccess) {
        return new ResolvedSignature<ResolvedJavaType>(Arrays.stream(mt.parameterArray()).map(arg_0 -> ((MetaAccessProvider)metaAccess).lookupJavaType(arg_0)).collect(Collectors.toUnmodifiableList()), metaAccess.lookupJavaType((Class)mt.returnType()));
    }

    private ResolvedSignature(List<T> parameterTypes, T returnType) {
        this.parameterTypes = parameterTypes;
        this.returnType = returnType;
    }

    public int getParameterCount(boolean withReceiver) {
        return this.parameterTypes.size() + (withReceiver ? 1 : 0);
    }

    @Deprecated
    public T getParameterType(int index, ResolvedJavaType accessingClass) {
        return this.getParameterType(index);
    }

    public T getParameterType(int index) {
        return (T)((ResolvedJavaType)this.parameterTypes.get(index));
    }

    @Deprecated
    public T getReturnType(ResolvedJavaType accessingClass) {
        return this.getReturnType();
    }

    public T getReturnType() {
        return this.returnType;
    }

    public List<T> toParameterList(T receiverType) {
        if (receiverType == null) {
            return this.parameterTypes;
        }
        ArrayList<T> withReceiver = new ArrayList<T>(this.parameterTypes.size() + 1);
        withReceiver.add(receiverType);
        withReceiver.addAll(this.parameterTypes);
        return Collections.unmodifiableList(withReceiver);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object obj) {
        if (this == obj) return true;
        if (!(obj instanceof ResolvedSignature)) return false;
        ResolvedSignature other = (ResolvedSignature)obj;
        if (!Objects.equals(this.parameterTypes, other.parameterTypes)) return false;
        if (!Objects.equals(this.returnType, other.returnType)) return false;
        return true;
    }

    public int hashCode() {
        return Objects.hash(this.parameterTypes, this.returnType);
    }

    public String toString() {
        return this.toMethodDescriptor();
    }
}

