/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.truffle;

import com.oracle.svm.core.BuildPhaseProvider;
import com.oracle.svm.core.annotate.Alias;
import com.oracle.svm.core.annotate.RecomputeFieldValue;
import com.oracle.svm.core.annotate.TargetClass;
import com.oracle.svm.core.fieldvaluetransformer.FieldValueTransformerWithAvailability;
import com.oracle.svm.core.reflect.target.ReflectionSubstitutionSupport;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.truffle.TruffleBaseFeature;
import com.oracle.svm.util.ReflectionUtil;
import java.lang.reflect.Field;

@TargetClass(className="com.oracle.truffle.api.nodes.NodeClassImpl", innerClass={"NodeFieldData"}, onlyWith={TruffleBaseFeature.IsEnabled.class})
final class Target_com_oracle_truffle_api_nodes_NodeClassImpl_NodeFieldData {
    @Alias
    @RecomputeFieldValue(kind=RecomputeFieldValue.Kind.Custom, declClass=OffsetComputer.class, isFinal=true)
    private long offset;

    Target_com_oracle_truffle_api_nodes_NodeClassImpl_NodeFieldData() {
    }

    private static final class OffsetComputer
    implements FieldValueTransformerWithAvailability {
        private OffsetComputer() {
        }

        public boolean isAvailable() {
            return BuildPhaseProvider.isHostedUniverseBuilt();
        }

        public Object transform(Object receiver, Object originalValue) {
            Class declaringClass = (Class)ReflectionUtil.readField(receiver.getClass(), (String)"declaringClass", (Object)receiver);
            String name = (String)ReflectionUtil.readField(receiver.getClass(), (String)"name", (Object)receiver);
            Field field = ReflectionUtil.lookupField((Class)declaringClass, (String)name);
            int offset = ReflectionSubstitutionSupport.singleton().getFieldOffset(field, false);
            if (offset <= 0) {
                throw VMError.shouldNotReachHere((String)("Field is not marked as accessed: " + String.valueOf(field)));
            }
            return (long)offset;
        }
    }
}

