/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.truffle.isolated;

import com.oracle.svm.core.SubstrateOptions;
import com.oracle.svm.core.c.function.CEntryPointOptions;
import com.oracle.svm.core.graal.isolated.ClientHandle;
import com.oracle.svm.core.graal.isolated.ClientIsolateThread;
import com.oracle.svm.core.graal.isolated.CompilerIsolateThread;
import com.oracle.svm.core.graal.isolated.IsolatedCompileClient;
import com.oracle.svm.core.graal.isolated.IsolatedCompileContext;
import com.oracle.svm.core.heap.Heap;
import com.oracle.svm.core.jdk.UninterruptibleUtils;
import com.oracle.svm.graal.isolated.ImageHeapObjects;
import com.oracle.svm.graal.isolated.ImageHeapRef;
import com.oracle.svm.graal.isolated.IsolatedGraalUtils;
import com.oracle.svm.graal.isolated.IsolatedHandles;
import com.oracle.svm.truffle.api.SubstrateCompilableTruffleAST;
import com.oracle.svm.truffle.api.SubstrateTruffleCompiler;
import com.oracle.svm.truffle.api.SubstrateTruffleCompilerImpl;
import com.oracle.svm.truffle.isolated.IsolatedCompilableTruffleAST;
import com.oracle.svm.truffle.isolated.IsolatedEventContext;
import com.oracle.svm.truffle.isolated.IsolatedTruffleCompilationIdentifier;
import com.oracle.svm.truffle.isolated.IsolatedTruffleCompilationTask;
import com.oracle.svm.truffle.isolated.IsolatedTruffleCompilerEventForwarder;
import com.oracle.truffle.compiler.TruffleCompilable;
import com.oracle.truffle.compiler.TruffleCompilationTask;
import com.oracle.truffle.compiler.TruffleCompilerListener;
import java.util.concurrent.atomic.AtomicBoolean;
import jdk.graal.compiler.core.common.SuppressFBWarnings;
import jdk.graal.compiler.nodes.PauseNode;
import jdk.graal.compiler.truffle.PartialEvaluator;
import jdk.graal.compiler.truffle.TruffleCompilation;
import jdk.graal.compiler.truffle.TruffleCompilationIdentifier;
import jdk.graal.compiler.truffle.phases.TruffleTier;
import jdk.graal.compiler.word.Word;
import org.graalvm.nativeimage.CurrentIsolate;
import org.graalvm.nativeimage.Isolate;
import org.graalvm.nativeimage.IsolateThread;
import org.graalvm.nativeimage.Isolates;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.nativeimage.VMRuntime;
import org.graalvm.nativeimage.c.function.CEntryPoint;
import org.graalvm.nativeimage.c.type.CTypeConversion;
import org.graalvm.word.ComparableWord;
import org.graalvm.word.PointerBase;
import org.graalvm.word.WordBase;

public class IsolateAwareTruffleCompiler
implements SubstrateTruffleCompiler {
    private static final Word ISOLATE_INITIALIZING = (Word)Word.signed((int)-1);
    private final UninterruptibleUtils.AtomicWord<Isolate> sharedIsolate = new UninterruptibleUtils.AtomicWord();
    protected final SubstrateTruffleCompilerImpl delegate;
    private final AtomicBoolean firstCompilation;

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public IsolateAwareTruffleCompiler(SubstrateTruffleCompilerImpl delegate) {
        this.delegate = delegate;
        this.firstCompilation = new AtomicBoolean(true);
    }

    public void initialize(TruffleCompilable compilable, boolean firstInitialization) {
        if (!SubstrateOptions.shouldCompileInIsolates()) {
            this.delegate.initialize(compilable, firstInitialization);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SuppressFBWarnings(value={"DLS_DEAD_LOCAL_STORE"}, justification="False positive.")
    public void doCompile(TruffleCompilationTask task, TruffleCompilable compilable, TruffleCompilerListener listener) {
        if (!SubstrateOptions.shouldCompileInIsolates()) {
            this.delegate.doCompile(task, compilable, listener);
            return;
        }
        CompilerIsolateThread context = this.beforeCompilation();
        try {
            IsolatedCompileClient client = new IsolatedCompileClient(context);
            IsolatedCompileClient.set((IsolatedCompileClient)client);
            try {
                IsolatedEventContext eventContext = null;
                if (listener != null) {
                    eventContext = new IsolatedEventContext(listener, compilable, task);
                }
                ClientHandle compilationIdentifier = client.hand((Object)this.delegate.createCompilationIdentifier(task, compilable));
                IsolateAwareTruffleCompiler.doCompile0(context, (ClientIsolateThread)CurrentIsolate.getCurrentThread(), (ImageHeapRef<SubstrateTruffleCompilerImpl>)ImageHeapObjects.ref((Object)this.delegate), (ClientHandle<TruffleCompilationTask>)client.hand((Object)task), (ClientHandle<SubstrateCompilableTruffleAST>)client.hand((Object)((SubstrateCompilableTruffleAST)compilable)), (ClientHandle<TruffleCompilationIdentifier>)compilationIdentifier, (ClientHandle<IsolatedEventContext>)client.hand((Object)eventContext), this.firstCompilation.getAndSet(false));
            }
            finally {
                IsolatedCompileClient.set(null);
            }
        }
        finally {
            this.afterCompilation(context);
        }
    }

    protected CompilerIsolateThread beforeCompilation() {
        Isolate isolate = this.getSharedIsolate();
        if (isolate.isNull()) {
            if (this.sharedIsolate.compareAndSet((WordBase)((Isolate)Word.nullPointer()), (WordBase)((Isolate)ISOLATE_INITIALIZING))) {
                try {
                    Runtime.getRuntime().addShutdownHook(new Thread(this::sharedIsolateShutdown));
                    CompilerIsolateThread thread = IsolatedGraalUtils.createCompilationIsolate();
                    this.sharedIsolate.set((WordBase)Isolates.getIsolate((IsolateThread)thread));
                    return thread;
                }
                catch (Throwable e) {
                    assert (((Isolate)this.sharedIsolate.get()).equal((ComparableWord)ISOLATE_INITIALIZING));
                    this.sharedIsolate.set((WordBase)((Isolate)Word.nullPointer()));
                    throw e;
                }
            }
            isolate = this.getSharedIsolate();
            assert (isolate.isNonNull());
        }
        return (CompilerIsolateThread)Isolates.attachCurrentThread((Isolate)isolate);
    }

    private Isolate getSharedIsolate() {
        Isolate isolate = (Isolate)this.sharedIsolate.get();
        while (isolate.equal((ComparableWord)ISOLATE_INITIALIZING)) {
            PauseNode.pause();
            isolate = (Isolate)this.sharedIsolate.get();
        }
        return isolate;
    }

    private void sharedIsolateShutdown() {
        Isolate isolate = this.getSharedIsolate();
        if (isolate.isNonNull()) {
            CompilerIsolateThread context = (CompilerIsolateThread)Isolates.attachCurrentThread((Isolate)isolate);
            IsolateAwareTruffleCompiler.compilerIsolateThreadShutdown(context);
            Isolates.detachThread((IsolateThread)context);
        }
    }

    @CEntryPoint(exceptionHandler=IsolatedCompileContext.VoidExceptionHandler.class, include=CEntryPoint.NotIncludedAutomatically.class, publishAs=CEntryPoint.Publish.NotPublished)
    @CEntryPointOptions(callerEpilogue=IsolatedCompileContext.ExceptionRethrowCallerEpilogue.class)
    protected static void compilerIsolateThreadShutdown(@CEntryPoint.IsolateThreadContext CompilerIsolateThread context) {
        VMRuntime.shutdown();
    }

    protected void afterCompilation(CompilerIsolateThread context) {
        Isolates.detachThread((IsolateThread)context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CEntryPoint(exceptionHandler=IsolatedCompileContext.ResetContextWordExceptionHandler.class, include=CEntryPoint.NotIncludedAutomatically.class, publishAs=CEntryPoint.Publish.NotPublished)
    @CEntryPointOptions(epilogue=IsolatedCompileContext.ExitCompilationEpilogue.class, callerEpilogue=IsolatedCompileContext.ExceptionRethrowCallerEpilogue.class)
    private static WordBase doCompile0(@CEntryPoint.IsolateThreadContext CompilerIsolateThread context, ClientIsolateThread client, ImageHeapRef<SubstrateTruffleCompilerImpl> delegateRef, ClientHandle<TruffleCompilationTask> taskHandle, ClientHandle<SubstrateCompilableTruffleAST> compilableHandle, ClientHandle<TruffleCompilationIdentifier> compilationIdentifier, ClientHandle<IsolatedEventContext> eventContextHandle, boolean firstCompilation) {
        IsolatedCompileContext.set((IsolatedCompileContext)new IsolatedCompileContext(client));
        try {
            SubstrateTruffleCompilerImpl delegate = (SubstrateTruffleCompilerImpl)ImageHeapObjects.deref(delegateRef);
            IsolatedCompilableTruffleAST compilable = new IsolatedCompilableTruffleAST(compilableHandle);
            delegate.initialize(compilable, firstCompilation);
            IsolatedTruffleCompilationTask task = null;
            if (taskHandle.notEqual((ComparableWord)IsolatedHandles.nullHandle())) {
                task = new IsolatedTruffleCompilationTask(taskHandle);
            }
            IsolatedTruffleCompilerEventForwarder listener = null;
            if (eventContextHandle.notEqual((ComparableWord)IsolatedHandles.nullHandle())) {
                listener = new IsolatedTruffleCompilerEventForwarder(eventContextHandle);
            }
            try (TruffleCompilation compilation = delegate.openCompilation(task, compilable);){
                compilation.setCompilationId((TruffleCompilationIdentifier)new IsolatedTruffleCompilationIdentifier(compilationIdentifier, task, compilable));
                delegate.doCompile(compilation, listener);
            }
        }
        finally {
            Heap.getHeap().doReferenceHandling();
        }
        return Word.zero();
    }

    @CEntryPoint(exceptionHandler=IsolatedCompileClient.VoidExceptionHandler.class, include=CEntryPoint.NotIncludedAutomatically.class, publishAs=CEntryPoint.Publish.NotPublished)
    @CEntryPointOptions(callerEpilogue=IsolatedCompileClient.ExceptionRethrowCallerEpilogue.class)
    private static void copyEncodedOptions(@CEntryPoint.IsolateThreadContext ClientIsolateThread client, ClientHandle<byte[]> encodedOptionsHandle, PointerBase buffer) {
        byte[] encodedOptions = (byte[])IsolatedCompileClient.get().unhand(encodedOptionsHandle);
        CTypeConversion.asByteBuffer((PointerBase)buffer, (int)encodedOptions.length).put(encodedOptions);
    }

    @Override
    public void teardown(Runnable shutdownCompilationsAndWaitAction) {
        if (SubstrateOptions.shouldCompileInIsolates()) {
            Thread t = new Thread(() -> {
                shutdownCompilationsAndWaitAction.run();
                this.tearDownIsolateOnShutdown();
            });
            t.setUncaughtExceptionHandler((x, y) -> {});
            t.setDaemon(true);
            t.start();
        }
    }

    public void shutdown() {
        this.delegate.shutdown();
    }

    protected void tearDownIsolateOnShutdown() {
        Isolate shared = this.getSharedIsolate();
        if (shared.isNonNull()) {
            IsolateThread current = Isolates.attachCurrentThread((Isolate)shared);
            Isolates.tearDownIsolate((IsolateThread)current);
        }
    }

    @Override
    @Platforms(value={Platform.HOSTED_ONLY.class})
    public PartialEvaluator getPartialEvaluator() {
        return this.delegate.getPartialEvaluator();
    }

    @Override
    @Platforms(value={Platform.HOSTED_ONLY.class})
    public TruffleTier getTruffleTier() {
        return this.delegate.getTruffleTier();
    }
}

