/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.truffle.isolated;

import com.oracle.svm.core.c.function.CEntryPointOptions;
import com.oracle.svm.core.graal.isolated.ClientHandle;
import com.oracle.svm.core.graal.isolated.ClientIsolateThread;
import com.oracle.svm.core.graal.isolated.CompilerHandle;
import com.oracle.svm.core.graal.isolated.IsolatedCompileClient;
import com.oracle.svm.core.graal.isolated.IsolatedCompileContext;
import com.oracle.svm.graal.isolated.IsolatedObjectProxy;
import com.oracle.truffle.compiler.TruffleCompilable;
import com.oracle.truffle.compiler.TruffleCompilationTask;
import jdk.graal.compiler.core.common.CompilationIdentifier;
import jdk.graal.compiler.truffle.TruffleCompilationIdentifier;
import org.graalvm.nativeimage.c.function.CEntryPoint;

final class IsolatedTruffleCompilationIdentifier
extends IsolatedObjectProxy<TruffleCompilationIdentifier>
implements TruffleCompilationIdentifier {
    private static final CompilationIdentifier.Verbosity[] VERBOSITIES = CompilationIdentifier.Verbosity.values();
    private final String[] descriptions = new String[VERBOSITIES.length];
    private final TruffleCompilationTask task;
    private final TruffleCompilable compilable;

    IsolatedTruffleCompilationIdentifier(ClientHandle<TruffleCompilationIdentifier> handle, TruffleCompilationTask task, TruffleCompilable compilable) {
        super(handle);
        this.task = task;
        this.compilable = compilable;
    }

    public TruffleCompilable getCompilable() {
        return this.compilable;
    }

    public TruffleCompilationTask getTask() {
        return this.task;
    }

    public String toString() {
        return this.toString(CompilationIdentifier.Verbosity.DETAILED);
    }

    public String toString(CompilationIdentifier.Verbosity verbosity) {
        int ordinal = verbosity.ordinal();
        if (this.descriptions[ordinal] == null) {
            CompilerHandle<String> h = IsolatedTruffleCompilationIdentifier.toString0(IsolatedCompileContext.get().getClient(), (ClientHandle<TruffleCompilationIdentifier>)this.handle, ordinal);
            this.descriptions[ordinal] = (String)IsolatedCompileContext.get().unhand(h);
        }
        return this.descriptions[ordinal];
    }

    @CEntryPoint(exceptionHandler=IsolatedCompileClient.WordExceptionHandler.class, include=CEntryPoint.NotIncludedAutomatically.class, publishAs=CEntryPoint.Publish.NotPublished)
    @CEntryPointOptions(callerEpilogue=IsolatedCompileClient.ExceptionRethrowCallerEpilogue.class)
    private static CompilerHandle<String> toString0(ClientIsolateThread client, ClientHandle<TruffleCompilationIdentifier> idHandle, int verbosityOrdinal) {
        TruffleCompilationIdentifier id = (TruffleCompilationIdentifier)IsolatedCompileClient.get().unhand(idHandle);
        String description = id.toString(VERBOSITIES[verbosityOrdinal]);
        return IsolatedCompileClient.get().createStringInCompiler(description);
    }

    public long getTruffleCompilationId() {
        return IsolatedTruffleCompilationIdentifier.getTruffleCompilationId0(IsolatedCompileContext.get().getClient(), (ClientHandle<TruffleCompilationIdentifier>)this.handle);
    }

    @CEntryPoint(include=CEntryPoint.NotIncludedAutomatically.class, publishAs=CEntryPoint.Publish.NotPublished)
    private static long getTruffleCompilationId0(ClientIsolateThread client, ClientHandle<TruffleCompilationIdentifier> idHandle) {
        TruffleCompilationIdentifier id = (TruffleCompilationIdentifier)IsolatedCompileClient.get().unhand(idHandle);
        return id.getTruffleCompilationId();
    }
}

