// CheckStyle: stop header check
// CheckStyle: stop line length check
// GENERATED CONTENT - DO NOT EDIT
// Source: MetadataTracer.Options.java
package com.oracle.svm.core.metadata;

import java.util.*;
import jdk.graal.compiler.options.*;
import jdk.graal.compiler.options.OptionType;
import jdk.graal.compiler.options.OptionStability;

public class MetadataTracer_Options_OptionDescriptors implements OptionDescriptors {
    private OptionsContainer cachedContainer;
    @Override
    public OptionsContainer getContainer() {
        if (cachedContainer == null) {
            cachedContainer = new OptionsContainer.Default(MetadataTracer.Options.class);
        }
        return cachedContainer;
    }

    @Override
    public OptionDescriptor get(String value) {
        switch (getContainer().unprefixed(value)) {
        // CheckStyle: stop line length check
        case "MetadataTracingSupport": {
            return OptionDescriptor.create(
                /*name*/ "MetadataTracingSupport",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Generate an image that supports reachability metadata access tracing. When tracing is supported, use the -XX:TraceMetadata option to enable tracing at run time.",
                /*container*/ getContainer(),
                /*option*/ MetadataTracer.Options.MetadataTracingSupport,
                /*fieldName*/ "MetadataTracingSupport",
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "TraceMetadata": {
            return OptionDescriptor.create(
                /*name*/ "TraceMetadata",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ String.class,
                /*help*/ """
Enables metadata tracing at run time. This option is only supported if -H:+MetadataTracingSupport is set when building the image.
The value of this option is a comma-separated list of arguments specified as key-value pairs. The following arguments are supported:

- path=<trace-output-directory> (required): Specifies the directory to write traced metadata to.
- merge=<boolean> (optional): Specifies whether to merge or overwrite metadata with existing files at the output path (default: true).
- debug-log=<path> (optional): Specifies a path to write debug output to. This option is meant for debugging; the option name and its
  output format may change at any time.

Example usage:
    -H:TraceMetadata=path=trace_output_directory
    -H:TraceMetadata=path=trace_output_directory,merge=false""",
                /*container*/ getContainer(),
                /*option*/ MetadataTracer.Options.TraceMetadata,
                /*fieldName*/ "TraceMetadata",
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        // CheckStyle: resume line length check
        }
        return null;
    }

    @Override
    public Iterator<OptionDescriptor> iterator() {
        return new Iterator<>() {
            int i = 0;
            @Override
            public boolean hasNext() {
                return i < 2;
            }
            @Override
            public OptionDescriptor next() {
                switch (i++) {
                    case 0: return get("MetadataTracingSupport");
                    case 1: return get("TraceMetadata");
                }
                throw new NoSuchElementException();
            }
        };
    }
}
