/*
 * Copyright (c) 2013, 2023, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 3 only, as
 * published by the Free Software Foundation.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 3 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 3 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */
package com.oracle.truffle.r.nodes.builtin.base;

import java.util.function.Supplier;

import com.oracle.truffle.api.frame.MaterializedFrame;
import com.oracle.truffle.r.library.utils.Download.CurlDownload;
import com.oracle.truffle.r.library.utils.DownloadNodeGen.CurlDownloadNodeGen;
import com.oracle.truffle.r.nodes.RRootNode;
import com.oracle.truffle.r.nodes.access.variables.ReadVariableNode;
import com.oracle.truffle.r.nodes.binary.BinaryArithmeticNodeGen;
import com.oracle.truffle.r.nodes.binary.BinaryArithmeticSpecial;
import com.oracle.truffle.r.nodes.binary.BinaryBooleanNodeGen;
import com.oracle.truffle.r.nodes.binary.BinaryBooleanScalarNodeGen;
import com.oracle.truffle.r.nodes.binary.BinaryBooleanSpecial;
import com.oracle.truffle.r.nodes.builtin.RBuiltinNode;
import com.oracle.truffle.r.nodes.builtin.RBuiltinPackage;
import com.oracle.truffle.r.nodes.builtin.base.AttachFunctions.Attach;
import com.oracle.truffle.r.nodes.builtin.base.AttachFunctions.Detach;
import com.oracle.truffle.r.nodes.builtin.base.AttachFunctionsFactory.AttachNodeGen;
import com.oracle.truffle.r.nodes.builtin.base.AttachFunctionsFactory.DetachNodeGen;
import com.oracle.truffle.r.nodes.builtin.base.BaseBesselFunctions.BesselI;
import com.oracle.truffle.r.nodes.builtin.base.BaseBesselFunctions.BesselJ;
import com.oracle.truffle.r.nodes.builtin.base.BaseBesselFunctions.BesselK;
import com.oracle.truffle.r.nodes.builtin.base.BaseBesselFunctions.BesselY;
import com.oracle.truffle.r.nodes.builtin.base.BaseBesselFunctionsFactory.BesselINodeGen;
import com.oracle.truffle.r.nodes.builtin.base.BaseBesselFunctionsFactory.BesselJNodeGen;
import com.oracle.truffle.r.nodes.builtin.base.BaseBesselFunctionsFactory.BesselKNodeGen;
import com.oracle.truffle.r.nodes.builtin.base.BaseBesselFunctionsFactory.BesselYNodeGen;
import com.oracle.truffle.r.nodes.builtin.base.BaseGammaFunctions.DiGamma;
import com.oracle.truffle.r.nodes.builtin.base.BaseGammaFunctions.Gamma;
import com.oracle.truffle.r.nodes.builtin.base.BaseGammaFunctions.Lgamma;
import com.oracle.truffle.r.nodes.builtin.base.BaseGammaFunctions.PentaGamma;
import com.oracle.truffle.r.nodes.builtin.base.BaseGammaFunctions.PsiGamma;
import com.oracle.truffle.r.nodes.builtin.base.BaseGammaFunctions.TetraGamma;
import com.oracle.truffle.r.nodes.builtin.base.BaseGammaFunctions.TriGamma;
import com.oracle.truffle.r.nodes.builtin.base.BaseGammaFunctionsFactory.DiGammaNodeGen;
import com.oracle.truffle.r.nodes.builtin.base.BaseGammaFunctionsFactory.GammaNodeGen;
import com.oracle.truffle.r.nodes.builtin.base.BaseGammaFunctionsFactory.LgammaNodeGen;
import com.oracle.truffle.r.nodes.builtin.base.BaseGammaFunctionsFactory.PentaGammaNodeGen;
import com.oracle.truffle.r.nodes.builtin.base.BaseGammaFunctionsFactory.PsiGammaNodeGen;
import com.oracle.truffle.r.nodes.builtin.base.BaseGammaFunctionsFactory.TetraGammaNodeGen;
import com.oracle.truffle.r.nodes.builtin.base.BaseGammaFunctionsFactory.TriGammaNodeGen;
import com.oracle.truffle.r.nodes.builtin.base.BetaFunctions.BetaBuiltin;
import com.oracle.truffle.r.nodes.builtin.base.BetaFunctions.LBeta;
import com.oracle.truffle.r.nodes.builtin.base.BetaFunctionsFactory.BetaBuiltinNodeGen;
import com.oracle.truffle.r.nodes.builtin.base.BetaFunctionsFactory.LBetaNodeGen;
import com.oracle.truffle.r.nodes.builtin.base.Bind.CbindInternal;
import com.oracle.truffle.r.nodes.builtin.base.Bind.RbindInternal;
import com.oracle.truffle.r.nodes.builtin.base.BindNodeGen.CbindInternalNodeGen;
import com.oracle.truffle.r.nodes.builtin.base.BindNodeGen.RbindInternalNodeGen;
import com.oracle.truffle.r.nodes.builtin.base.BitwiseFunctions.BitwiseAnd;
import com.oracle.truffle.r.nodes.builtin.base.BitwiseFunctions.BitwiseNot;
import com.oracle.truffle.r.nodes.builtin.base.BitwiseFunctions.BitwiseOr;
import com.oracle.truffle.r.nodes.builtin.base.BitwiseFunctions.BitwiseShiftL;
import com.oracle.truffle.r.nodes.builtin.base.BitwiseFunctions.BitwiseShiftR;
import com.oracle.truffle.r.nodes.builtin.base.BitwiseFunctions.BitwiseXor;
import com.oracle.truffle.r.nodes.builtin.base.BitwiseFunctionsFactory.BitwiseAndNodeGen;
import com.oracle.truffle.r.nodes.builtin.base.BitwiseFunctionsFactory.BitwiseNotNodeGen;
import com.oracle.truffle.r.nodes.builtin.base.BitwiseFunctionsFactory.BitwiseOrNodeGen;
import com.oracle.truffle.r.nodes.builtin.base.BitwiseFunctionsFactory.BitwiseShiftLNodeGen;
import com.oracle.truffle.r.nodes.builtin.base.BitwiseFunctionsFactory.BitwiseShiftRNodeGen;
import com.oracle.truffle.r.nodes.builtin.base.BitwiseFunctionsFactory.BitwiseXorNodeGen;
import com.oracle.truffle.r.nodes.builtin.base.BrowserFunctions.BrowserCondition;
import com.oracle.truffle.r.nodes.builtin.base.BrowserFunctions.BrowserNode;
import com.oracle.truffle.r.nodes.builtin.base.BrowserFunctions.BrowserSetDebug;
import com.oracle.truffle.r.nodes.builtin.base.BrowserFunctions.BrowserText;
import com.oracle.truffle.r.nodes.builtin.base.BrowserFunctionsFactory.BrowserConditionNodeGen;
import com.oracle.truffle.r.nodes.builtin.base.BrowserFunctionsFactory.BrowserNodeGen;
import com.oracle.truffle.r.nodes.builtin.base.BrowserFunctionsFactory.BrowserSetDebugNodeGen;
import com.oracle.truffle.r.nodes.builtin.base.BrowserFunctionsFactory.BrowserTextNodeGen;
import com.oracle.truffle.r.nodes.builtin.base.ChooseFunctions.Choose;
import com.oracle.truffle.r.nodes.builtin.base.ChooseFunctions.LChoose;
import com.oracle.truffle.r.nodes.builtin.base.ChooseFunctionsFactory.ChooseNodeGen;
import com.oracle.truffle.r.nodes.builtin.base.ChooseFunctionsFactory.LChooseNodeGen;
import com.oracle.truffle.r.nodes.builtin.base.CompileFunctions.BcClose;
import com.oracle.truffle.r.nodes.builtin.base.CompileFunctions.BcVersion;
import com.oracle.truffle.r.nodes.builtin.base.CompileFunctions.CompilePKGS;
import com.oracle.truffle.r.nodes.builtin.base.CompileFunctions.Disassemble;
import com.oracle.truffle.r.nodes.builtin.base.CompileFunctions.EnableJIT;
import com.oracle.truffle.r.nodes.builtin.base.CompileFunctions.Getconst;
import com.oracle.truffle.r.nodes.builtin.base.CompileFunctions.Growconst;
import com.oracle.truffle.r.nodes.builtin.base.CompileFunctions.IsBuiltinInternal;
import com.oracle.truffle.r.nodes.builtin.base.CompileFunctions.LoadFromFile;
import com.oracle.truffle.r.nodes.builtin.base.CompileFunctions.MkCode;
import com.oracle.truffle.r.nodes.builtin.base.CompileFunctions.Putconst;
import com.oracle.truffle.r.nodes.builtin.base.CompileFunctions.SaveToFile;
import com.oracle.truffle.r.nodes.builtin.base.CompileFunctionsFactory.BcCloseNodeGen;
import com.oracle.truffle.r.nodes.builtin.base.CompileFunctionsFactory.BcVersionNodeGen;
import com.oracle.truffle.r.nodes.builtin.base.CompileFunctionsFactory.CompilePKGSNodeGen;
import com.oracle.truffle.r.nodes.builtin.base.CompileFunctionsFactory.DisassembleNodeGen;
import com.oracle.truffle.r.nodes.builtin.base.CompileFunctionsFactory.EnableJITNodeGen;
import com.oracle.truffle.r.nodes.builtin.base.CompileFunctionsFactory.GetconstNodeGen;
import com.oracle.truffle.r.nodes.builtin.base.CompileFunctionsFactory.GrowconstNodeGen;
import com.oracle.truffle.r.nodes.builtin.base.CompileFunctionsFactory.IsBuiltinInternalNodeGen;
import com.oracle.truffle.r.nodes.builtin.base.CompileFunctionsFactory.LoadFromFileNodeGen;
import com.oracle.truffle.r.nodes.builtin.base.CompileFunctionsFactory.MkCodeNodeGen;
import com.oracle.truffle.r.nodes.builtin.base.CompileFunctionsFactory.PutconstNodeGen;
import com.oracle.truffle.r.nodes.builtin.base.CompileFunctionsFactory.SaveToFileNodeGen;
import com.oracle.truffle.r.nodes.builtin.base.ConditionFunctions.AddCondHands;
import com.oracle.truffle.r.nodes.builtin.base.ConditionFunctions.AddRestart;
import com.oracle.truffle.r.nodes.builtin.base.ConditionFunctions.DfltStop;
import com.oracle.truffle.r.nodes.builtin.base.ConditionFunctions.DfltWarn;
import com.oracle.truffle.r.nodes.builtin.base.ConditionFunctions.GetRestart;
import com.oracle.truffle.r.nodes.builtin.base.ConditionFunctions.Geterrmessage;
import com.oracle.truffle.r.nodes.builtin.base.ConditionFunctions.InvokeRestart;
import com.oracle.truffle.r.nodes.builtin.base.ConditionFunctions.PrintDeferredWarnings;
import com.oracle.truffle.r.nodes.builtin.base.ConditionFunctions.ResetCondHands;
import com.oracle.truffle.r.nodes.builtin.base.ConditionFunctions.Seterrmessage;
import com.oracle.truffle.r.nodes.builtin.base.ConditionFunctions.SignalCondition;
import com.oracle.truffle.r.nodes.builtin.base.ConditionFunctionsFactory.AddCondHandsNodeGen;
import com.oracle.truffle.r.nodes.builtin.base.ConditionFunctionsFactory.AddRestartNodeGen;
import com.oracle.truffle.r.nodes.builtin.base.ConditionFunctionsFactory.DfltStopNodeGen;
import com.oracle.truffle.r.nodes.builtin.base.ConditionFunctionsFactory.DfltWarnNodeGen;
import com.oracle.truffle.r.nodes.builtin.base.ConditionFunctionsFactory.GetRestartNodeGen;
import com.oracle.truffle.r.nodes.builtin.base.ConditionFunctionsFactory.GeterrmessageNodeGen;
import com.oracle.truffle.r.nodes.builtin.base.ConditionFunctionsFactory.InvokeRestartNodeGen;
import com.oracle.truffle.r.nodes.builtin.base.ConditionFunctionsFactory.PrintDeferredWarningsNodeGen;
import com.oracle.truffle.r.nodes.builtin.base.ConditionFunctionsFactory.ResetCondHandsNodeGen;
import com.oracle.truffle.r.nodes.builtin.base.ConditionFunctionsFactory.SeterrmessageNodeGen;
import com.oracle.truffle.r.nodes.builtin.base.ConditionFunctionsFactory.SignalConditionNodeGen;
import com.oracle.truffle.r.nodes.builtin.base.ConnectionFunctions.BZFile;
import com.oracle.truffle.r.nodes.builtin.base.ConnectionFunctions.ChannelConnection;
import com.oracle.truffle.r.nodes.builtin.base.ConnectionFunctions.Close;
import com.oracle.truffle.r.nodes.builtin.base.ConnectionFunctions.Fifo;
import com.oracle.truffle.r.nodes.builtin.base.ConnectionFunctions.File;
import com.oracle.truffle.r.nodes.builtin.base.ConnectionFunctions.Flush;
import com.oracle.truffle.r.nodes.builtin.base.ConnectionFunctions.GZCon;
import com.oracle.truffle.r.nodes.builtin.base.ConnectionFunctions.GZFile;
import com.oracle.truffle.r.nodes.builtin.base.ConnectionFunctions.GetAllConnections;
import com.oracle.truffle.r.nodes.builtin.base.ConnectionFunctions.GetConnection;
import com.oracle.truffle.r.nodes.builtin.base.ConnectionFunctions.IsIncomplete;
import com.oracle.truffle.r.nodes.builtin.base.ConnectionFunctions.IsOpen;
import com.oracle.truffle.r.nodes.builtin.base.ConnectionFunctions.IsSeekable;
import com.oracle.truffle.r.nodes.builtin.base.ConnectionFunctions.Open;
import com.oracle.truffle.r.nodes.builtin.base.ConnectionFunctions.Pipe;
import com.oracle.truffle.r.nodes.builtin.base.ConnectionFunctions.PushBack;
import com.oracle.truffle.r.nodes.builtin.base.ConnectionFunctions.PushBackClear;
import com.oracle.truffle.r.nodes.builtin.base.ConnectionFunctions.PushBackLength;
import com.oracle.truffle.r.nodes.builtin.base.ConnectionFunctions.RawConnection;
import com.oracle.truffle.r.nodes.builtin.base.ConnectionFunctions.RawConnectionValue;
import com.oracle.truffle.r.nodes.builtin.base.ConnectionFunctions.ReadBin;
import com.oracle.truffle.r.nodes.builtin.base.ConnectionFunctions.ReadChar;
import com.oracle.truffle.r.nodes.builtin.base.ConnectionFunctions.ReadLines;
import com.oracle.truffle.r.nodes.builtin.base.ConnectionFunctions.Seek;
import com.oracle.truffle.r.nodes.builtin.base.ConnectionFunctions.SockSelect;
import com.oracle.truffle.r.nodes.builtin.base.ConnectionFunctions.SocketConnection;
import com.oracle.truffle.r.nodes.builtin.base.ConnectionFunctions.Stderr;
import com.oracle.truffle.r.nodes.builtin.base.ConnectionFunctions.Stdin;
import com.oracle.truffle.r.nodes.builtin.base.ConnectionFunctions.Stdout;
import com.oracle.truffle.r.nodes.builtin.base.ConnectionFunctions.Summary;
import com.oracle.truffle.r.nodes.builtin.base.ConnectionFunctions.TextConnection;
import com.oracle.truffle.r.nodes.builtin.base.ConnectionFunctions.TextConnectionValue;
import com.oracle.truffle.r.nodes.builtin.base.ConnectionFunctions.Truncate;
import com.oracle.truffle.r.nodes.builtin.base.ConnectionFunctions.URLConnection;
import com.oracle.truffle.r.nodes.builtin.base.ConnectionFunctions.WriteBin;
import com.oracle.truffle.r.nodes.builtin.base.ConnectionFunctions.WriteChar;
import com.oracle.truffle.r.nodes.builtin.base.ConnectionFunctions.WriteLines;
import com.oracle.truffle.r.nodes.builtin.base.ConnectionFunctions.XZFile;
import com.oracle.truffle.r.nodes.builtin.base.ConnectionFunctionsFactory.BZFileNodeGen;
import com.oracle.truffle.r.nodes.builtin.base.ConnectionFunctionsFactory.ChannelConnectionNodeGen;
import com.oracle.truffle.r.nodes.builtin.base.ConnectionFunctionsFactory.CloseNodeGen;
import com.oracle.truffle.r.nodes.builtin.base.ConnectionFunctionsFactory.FifoNodeGen;
import com.oracle.truffle.r.nodes.builtin.base.ConnectionFunctionsFactory.FileNodeGen;
import com.oracle.truffle.r.nodes.builtin.base.ConnectionFunctionsFactory.FlushNodeGen;
import com.oracle.truffle.r.nodes.builtin.base.ConnectionFunctionsFactory.GZConNodeGen;
import com.oracle.truffle.r.nodes.builtin.base.ConnectionFunctionsFactory.GZFileNodeGen;
import com.oracle.truffle.r.nodes.builtin.base.ConnectionFunctionsFactory.GetAllConnectionsNodeGen;
import com.oracle.truffle.r.nodes.builtin.base.ConnectionFunctionsFactory.GetConnectionNodeGen;
import com.oracle.truffle.r.nodes.builtin.base.ConnectionFunctionsFactory.IsIncompleteNodeGen;
import com.oracle.truffle.r.nodes.builtin.base.ConnectionFunctionsFactory.IsOpenNodeGen;
import com.oracle.truffle.r.nodes.builtin.base.ConnectionFunctionsFactory.IsSeekableNodeGen;
import com.oracle.truffle.r.nodes.builtin.base.ConnectionFunctionsFactory.OpenNodeGen;
import com.oracle.truffle.r.nodes.builtin.base.ConnectionFunctionsFactory.PipeNodeGen;
import com.oracle.truffle.r.nodes.builtin.base.ConnectionFunctionsFactory.PushBackClearNodeGen;
import com.oracle.truffle.r.nodes.builtin.base.ConnectionFunctionsFactory.PushBackLengthNodeGen;
import com.oracle.truffle.r.nodes.builtin.base.ConnectionFunctionsFactory.PushBackNodeGen;
import com.oracle.truffle.r.nodes.builtin.base.ConnectionFunctionsFactory.RawConnectionNodeGen;
import com.oracle.truffle.r.nodes.builtin.base.ConnectionFunctionsFactory.RawConnectionValueNodeGen;
import com.oracle.truffle.r.nodes.builtin.base.ConnectionFunctionsFactory.ReadBinNodeGen;
import com.oracle.truffle.r.nodes.builtin.base.ConnectionFunctionsFactory.ReadCharNodeGen;
import com.oracle.truffle.r.nodes.builtin.base.ConnectionFunctionsFactory.ReadLinesNodeGen;
import com.oracle.truffle.r.nodes.builtin.base.ConnectionFunctionsFactory.SeekNodeGen;
import com.oracle.truffle.r.nodes.builtin.base.ConnectionFunctionsFactory.SockSelectNodeGen;
import com.oracle.truffle.r.nodes.builtin.base.ConnectionFunctionsFactory.SocketConnectionNodeGen;
import com.oracle.truffle.r.nodes.builtin.base.ConnectionFunctionsFactory.StderrNodeGen;
import com.oracle.truffle.r.nodes.builtin.base.ConnectionFunctionsFactory.StdinNodeGen;
import com.oracle.truffle.r.nodes.builtin.base.ConnectionFunctionsFactory.StdoutNodeGen;
import com.oracle.truffle.r.nodes.builtin.base.ConnectionFunctionsFactory.SummaryNodeGen;
import com.oracle.truffle.r.nodes.builtin.base.ConnectionFunctionsFactory.TextConnectionNodeGen;
import com.oracle.truffle.r.nodes.builtin.base.ConnectionFunctionsFactory.TextConnectionValueNodeGen;
import com.oracle.truffle.r.nodes.builtin.base.ConnectionFunctionsFactory.TruncateNodeGen;
import com.oracle.truffle.r.nodes.builtin.base.ConnectionFunctionsFactory.URLConnectionNodeGen;
import com.oracle.truffle.r.nodes.builtin.base.ConnectionFunctionsFactory.WriteBinNodeGen;
import com.oracle.truffle.r.nodes.builtin.base.ConnectionFunctionsFactory.WriteCharNodeGen;
import com.oracle.truffle.r.nodes.builtin.base.ConnectionFunctionsFactory.WriteLinesNodeGen;
import com.oracle.truffle.r.nodes.builtin.base.ConnectionFunctionsFactory.XZFileNodeGen;
import com.oracle.truffle.r.nodes.builtin.base.CrossprodCommon.Crossprod;
import com.oracle.truffle.r.nodes.builtin.base.CrossprodCommon.TCrossprod;
import com.oracle.truffle.r.nodes.builtin.base.DatePOSIXFunctions.AsPOSIXct;
import com.oracle.truffle.r.nodes.builtin.base.DatePOSIXFunctions.AsPOSIXlt;
import com.oracle.truffle.r.nodes.builtin.base.DatePOSIXFunctions.Date2POSIXlt;
import com.oracle.truffle.r.nodes.builtin.base.DatePOSIXFunctions.FormatPOSIXlt;
import com.oracle.truffle.r.nodes.builtin.base.DatePOSIXFunctions.POSIXlt2Date;
import com.oracle.truffle.r.nodes.builtin.base.DatePOSIXFunctions.StrPTime;
import com.oracle.truffle.r.nodes.builtin.base.DatePOSIXFunctionsFactory.AsPOSIXctNodeGen;
import com.oracle.truffle.r.nodes.builtin.base.DatePOSIXFunctionsFactory.AsPOSIXltNodeGen;
import com.oracle.truffle.r.nodes.builtin.base.DatePOSIXFunctionsFactory.Date2POSIXltNodeGen;
import com.oracle.truffle.r.nodes.builtin.base.DatePOSIXFunctionsFactory.FormatPOSIXltNodeGen;
import com.oracle.truffle.r.nodes.builtin.base.DatePOSIXFunctionsFactory.POSIXlt2DateNodeGen;
import com.oracle.truffle.r.nodes.builtin.base.DatePOSIXFunctionsFactory.StrPTimeNodeGen;
import com.oracle.truffle.r.nodes.builtin.base.DebugFunctions.Debug;
import com.oracle.truffle.r.nodes.builtin.base.DebugFunctions.DebugOnce;
import com.oracle.truffle.r.nodes.builtin.base.DebugFunctions.FastRSetBreakpoint;
import com.oracle.truffle.r.nodes.builtin.base.DebugFunctions.IsDebugged;
import com.oracle.truffle.r.nodes.builtin.base.DebugFunctions.UnDebug;
import com.oracle.truffle.r.nodes.builtin.base.DebugFunctionsFactory.DebugNodeGen;
import com.oracle.truffle.r.nodes.builtin.base.DebugFunctionsFactory.DebugOnceNodeGen;
import com.oracle.truffle.r.nodes.builtin.base.DebugFunctionsFactory.FastRSetBreakpointNodeGen;
import com.oracle.truffle.r.nodes.builtin.base.DebugFunctionsFactory.IsDebuggedNodeGen;
import com.oracle.truffle.r.nodes.builtin.base.DebugFunctionsFactory.UnDebugNodeGen;
import com.oracle.truffle.r.nodes.builtin.base.DuplicatedFunctions.AnyDuplicated;
import com.oracle.truffle.r.nodes.builtin.base.DuplicatedFunctions.Duplicated;
import com.oracle.truffle.r.nodes.builtin.base.DuplicatedFunctionsFactory.AnyDuplicatedNodeGen;
import com.oracle.truffle.r.nodes.builtin.base.DuplicatedFunctionsFactory.DuplicatedNodeGen;
import com.oracle.truffle.r.nodes.builtin.base.DynLoadFunctions.DynLoad;
import com.oracle.truffle.r.nodes.builtin.base.DynLoadFunctions.DynUnload;
import com.oracle.truffle.r.nodes.builtin.base.DynLoadFunctions.GetLoadedDLLs;
import com.oracle.truffle.r.nodes.builtin.base.DynLoadFunctions.GetSymbolInfo;
import com.oracle.truffle.r.nodes.builtin.base.DynLoadFunctions.IsLoaded;
import com.oracle.truffle.r.nodes.builtin.base.DynLoadFunctionsFactory.DynLoadNodeGen;
import com.oracle.truffle.r.nodes.builtin.base.DynLoadFunctionsFactory.DynUnloadNodeGen;
import com.oracle.truffle.r.nodes.builtin.base.DynLoadFunctionsFactory.GetLoadedDLLsNodeGen;
import com.oracle.truffle.r.nodes.builtin.base.DynLoadFunctionsFactory.GetSymbolInfoNodeGen;
import com.oracle.truffle.r.nodes.builtin.base.DynLoadFunctionsFactory.IsLoadedNodeGen;
import com.oracle.truffle.r.nodes.builtin.base.EncodingFunctions.Encoding;
import com.oracle.truffle.r.nodes.builtin.base.EncodingFunctions.SetEncoding;
import com.oracle.truffle.r.nodes.builtin.base.EncodingFunctionsFactory.EncodingNodeGen;
import com.oracle.truffle.r.nodes.builtin.base.EncodingFunctionsFactory.SetEncodingNodeGen;
import com.oracle.truffle.r.nodes.builtin.base.EnvFunctions.AsEnvironment;
import com.oracle.truffle.r.nodes.builtin.base.EnvFunctions.BaseEnv;
import com.oracle.truffle.r.nodes.builtin.base.EnvFunctions.BindingIsActive;
import com.oracle.truffle.r.nodes.builtin.base.EnvFunctions.BindingIsLocked;
import com.oracle.truffle.r.nodes.builtin.base.EnvFunctions.EmptyEnv;
import com.oracle.truffle.r.nodes.builtin.base.EnvFunctions.EnvToList;
import com.oracle.truffle.r.nodes.builtin.base.EnvFunctions.Environment;
import com.oracle.truffle.r.nodes.builtin.base.EnvFunctions.EnvironmentIsLocked;
import com.oracle.truffle.r.nodes.builtin.base.EnvFunctions.EnvironmentName;
import com.oracle.truffle.r.nodes.builtin.base.EnvFunctions.GlobalEnv;
import com.oracle.truffle.r.nodes.builtin.base.EnvFunctions.IsEnvironment;
import com.oracle.truffle.r.nodes.builtin.base.EnvFunctions.LockBinding;
import com.oracle.truffle.r.nodes.builtin.base.EnvFunctions.LockEnvironment;
import com.oracle.truffle.r.nodes.builtin.base.EnvFunctions.MakeActiveBinding;
import com.oracle.truffle.r.nodes.builtin.base.EnvFunctions.NewEnv;
import com.oracle.truffle.r.nodes.builtin.base.EnvFunctions.ParentEnv;
import com.oracle.truffle.r.nodes.builtin.base.EnvFunctions.Search;
import com.oracle.truffle.r.nodes.builtin.base.EnvFunctions.SetParentEnv;
import com.oracle.truffle.r.nodes.builtin.base.EnvFunctions.TopEnv;
import com.oracle.truffle.r.nodes.builtin.base.EnvFunctions.UnlockBinding;
import com.oracle.truffle.r.nodes.builtin.base.EnvFunctions.UpdateEnvironment;
import com.oracle.truffle.r.nodes.builtin.base.EnvFunctionsFactory.AsEnvironmentNodeGen;
import com.oracle.truffle.r.nodes.builtin.base.EnvFunctionsFactory.BaseEnvNodeGen;
import com.oracle.truffle.r.nodes.builtin.base.EnvFunctionsFactory.BindingIsActiveNodeGen;
import com.oracle.truffle.r.nodes.builtin.base.EnvFunctionsFactory.BindingIsLockedNodeGen;
import com.oracle.truffle.r.nodes.builtin.base.EnvFunctionsFactory.EmptyEnvNodeGen;
import com.oracle.truffle.r.nodes.builtin.base.EnvFunctionsFactory.EnvToListNodeGen;
import com.oracle.truffle.r.nodes.builtin.base.EnvFunctionsFactory.EnvironmentIsLockedNodeGen;
import com.oracle.truffle.r.nodes.builtin.base.EnvFunctionsFactory.EnvironmentNameNodeGen;
import com.oracle.truffle.r.nodes.builtin.base.EnvFunctionsFactory.EnvironmentNodeGen;
import com.oracle.truffle.r.nodes.builtin.base.EnvFunctionsFactory.GlobalEnvNodeGen;
import com.oracle.truffle.r.nodes.builtin.base.EnvFunctionsFactory.IsEnvironmentNodeGen;
import com.oracle.truffle.r.nodes.builtin.base.EnvFunctionsFactory.LockBindingNodeGen;
import com.oracle.truffle.r.nodes.builtin.base.EnvFunctionsFactory.LockEnvironmentNodeGen;
import com.oracle.truffle.r.nodes.builtin.base.EnvFunctionsFactory.MakeActiveBindingNodeGen;
import com.oracle.truffle.r.nodes.builtin.base.EnvFunctionsFactory.NewEnvNodeGen;
import com.oracle.truffle.r.nodes.builtin.base.EnvFunctionsFactory.ParentEnvNodeGen;
import com.oracle.truffle.r.nodes.builtin.base.EnvFunctionsFactory.SearchNodeGen;
import com.oracle.truffle.r.nodes.builtin.base.EnvFunctionsFactory.SetParentEnvNodeGen;
import com.oracle.truffle.r.nodes.builtin.base.EnvFunctionsFactory.TopEnvNodeGen;
import com.oracle.truffle.r.nodes.builtin.base.EnvFunctionsFactory.UnlockBindingNodeGen;
import com.oracle.truffle.r.nodes.builtin.base.EnvFunctionsFactory.UpdateEnvironmentNodeGen;
import com.oracle.truffle.r.nodes.builtin.base.FileFunctions.BaseName;
import com.oracle.truffle.r.nodes.builtin.base.FileFunctions.DirCreate;
import com.oracle.truffle.r.nodes.builtin.base.FileFunctions.DirExists;
import com.oracle.truffle.r.nodes.builtin.base.FileFunctions.DirName;
import com.oracle.truffle.r.nodes.builtin.base.FileFunctions.FileAccess;
import com.oracle.truffle.r.nodes.builtin.base.FileFunctions.FileAppend;
import com.oracle.truffle.r.nodes.builtin.base.FileFunctions.FileCopy;
import com.oracle.truffle.r.nodes.builtin.base.FileFunctions.FileCreate;
import com.oracle.truffle.r.nodes.builtin.base.FileFunctions.FileExists;
import com.oracle.truffle.r.nodes.builtin.base.FileFunctions.FileInfo;
import com.oracle.truffle.r.nodes.builtin.base.FileFunctions.FileLink;
import com.oracle.truffle.r.nodes.builtin.base.FileFunctions.FilePath;
import com.oracle.truffle.r.nodes.builtin.base.FileFunctions.FileRemove;
import com.oracle.truffle.r.nodes.builtin.base.FileFunctions.FileRename;
import com.oracle.truffle.r.nodes.builtin.base.FileFunctions.FileShow;
import com.oracle.truffle.r.nodes.builtin.base.FileFunctions.FileSymLink;
import com.oracle.truffle.r.nodes.builtin.base.FileFunctions.ListDirs;
import com.oracle.truffle.r.nodes.builtin.base.FileFunctions.ListFiles;
import com.oracle.truffle.r.nodes.builtin.base.FileFunctions.Unlink;
import com.oracle.truffle.r.nodes.builtin.base.FileFunctionsFactory.BaseNameNodeGen;
import com.oracle.truffle.r.nodes.builtin.base.FileFunctionsFactory.DirCreateNodeGen;
import com.oracle.truffle.r.nodes.builtin.base.FileFunctionsFactory.DirExistsNodeGen;
import com.oracle.truffle.r.nodes.builtin.base.FileFunctionsFactory.DirNameNodeGen;
import com.oracle.truffle.r.nodes.builtin.base.FileFunctionsFactory.FileAccessNodeGen;
import com.oracle.truffle.r.nodes.builtin.base.FileFunctionsFactory.FileAppendNodeGen;
import com.oracle.truffle.r.nodes.builtin.base.FileFunctionsFactory.FileCopyNodeGen;
import com.oracle.truffle.r.nodes.builtin.base.FileFunctionsFactory.FileCreateNodeGen;
import com.oracle.truffle.r.nodes.builtin.base.FileFunctionsFactory.FileExistsNodeGen;
import com.oracle.truffle.r.nodes.builtin.base.FileFunctionsFactory.FileInfoNodeGen;
import com.oracle.truffle.r.nodes.builtin.base.FileFunctionsFactory.FileLinkNodeGen;
import com.oracle.truffle.r.nodes.builtin.base.FileFunctionsFactory.FilePathNodeGen;
import com.oracle.truffle.r.nodes.builtin.base.FileFunctionsFactory.FileRemoveNodeGen;
import com.oracle.truffle.r.nodes.builtin.base.FileFunctionsFactory.FileRenameNodeGen;
import com.oracle.truffle.r.nodes.builtin.base.FileFunctionsFactory.FileShowNodeGen;
import com.oracle.truffle.r.nodes.builtin.base.FileFunctionsFactory.FileSymLinkNodeGen;
import com.oracle.truffle.r.nodes.builtin.base.FileFunctionsFactory.ListDirsNodeGen;
import com.oracle.truffle.r.nodes.builtin.base.FileFunctionsFactory.ListFilesNodeGen;
import com.oracle.truffle.r.nodes.builtin.base.FileFunctionsFactory.UnlinkNodeGen;
import com.oracle.truffle.r.nodes.builtin.base.FrameFunctions.MatchCall;
import com.oracle.truffle.r.nodes.builtin.base.FrameFunctions.ParentFrame;
import com.oracle.truffle.r.nodes.builtin.base.FrameFunctions.SysCall;
import com.oracle.truffle.r.nodes.builtin.base.FrameFunctions.SysCalls;
import com.oracle.truffle.r.nodes.builtin.base.FrameFunctions.SysFrame;
import com.oracle.truffle.r.nodes.builtin.base.FrameFunctions.SysFrames;
import com.oracle.truffle.r.nodes.builtin.base.FrameFunctions.SysFunction;
import com.oracle.truffle.r.nodes.builtin.base.FrameFunctions.SysNFrame;
import com.oracle.truffle.r.nodes.builtin.base.FrameFunctions.SysParent;
import com.oracle.truffle.r.nodes.builtin.base.FrameFunctions.SysParents;
import com.oracle.truffle.r.nodes.builtin.base.FrameFunctionsFactory.MatchCallNodeGen;
import com.oracle.truffle.r.nodes.builtin.base.FrameFunctionsFactory.ParentFrameNodeGen;
import com.oracle.truffle.r.nodes.builtin.base.FrameFunctionsFactory.SysCallNodeGen;
import com.oracle.truffle.r.nodes.builtin.base.FrameFunctionsFactory.SysCallsNodeGen;
import com.oracle.truffle.r.nodes.builtin.base.FrameFunctionsFactory.SysFrameNodeGen;
import com.oracle.truffle.r.nodes.builtin.base.FrameFunctionsFactory.SysFramesNodeGen;
import com.oracle.truffle.r.nodes.builtin.base.FrameFunctionsFactory.SysFunctionNodeGen;
import com.oracle.truffle.r.nodes.builtin.base.FrameFunctionsFactory.SysNFrameNodeGen;
import com.oracle.truffle.r.nodes.builtin.base.FrameFunctionsFactory.SysParentNodeGen;
import com.oracle.truffle.r.nodes.builtin.base.FrameFunctionsFactory.SysParentsNodeGen;
import com.oracle.truffle.r.nodes.builtin.base.GcFunctions.Gc;
import com.oracle.truffle.r.nodes.builtin.base.GcFunctions.Gctorture;
import com.oracle.truffle.r.nodes.builtin.base.GcFunctions.Gctorture2;
import com.oracle.truffle.r.nodes.builtin.base.GcFunctionsFactory.GcNodeGen;
import com.oracle.truffle.r.nodes.builtin.base.GcFunctionsFactory.Gctorture2NodeGen;
import com.oracle.truffle.r.nodes.builtin.base.GcFunctionsFactory.GctortureNodeGen;
import com.oracle.truffle.r.nodes.builtin.base.GetFunctions.Get0;
import com.oracle.truffle.r.nodes.builtin.base.GetFunctions.MGet;
import com.oracle.truffle.r.nodes.builtin.base.GetFunctionsFactory.Get0NodeGen;
import com.oracle.truffle.r.nodes.builtin.base.GetFunctionsFactory.GetNodeGen;
import com.oracle.truffle.r.nodes.builtin.base.GetFunctionsFactory.MGetNodeGen;
import com.oracle.truffle.r.nodes.builtin.base.GrepFunctions.AGrep;
import com.oracle.truffle.r.nodes.builtin.base.GrepFunctions.AGrepL;
import com.oracle.truffle.r.nodes.builtin.base.GrepFunctions.GSub;
import com.oracle.truffle.r.nodes.builtin.base.GrepFunctions.Gregexpr;
import com.oracle.truffle.r.nodes.builtin.base.GrepFunctions.Grep;
import com.oracle.truffle.r.nodes.builtin.base.GrepFunctions.GrepL;
import com.oracle.truffle.r.nodes.builtin.base.GrepFunctions.GrepRaw;
import com.oracle.truffle.r.nodes.builtin.base.GrepFunctions.Regexec;
import com.oracle.truffle.r.nodes.builtin.base.GrepFunctions.Regexpr;
import com.oracle.truffle.r.nodes.builtin.base.GrepFunctions.Strsplit;
import com.oracle.truffle.r.nodes.builtin.base.GrepFunctions.Sub;
import com.oracle.truffle.r.nodes.builtin.base.GrepFunctionsFactory.AGrepLNodeGen;
import com.oracle.truffle.r.nodes.builtin.base.GrepFunctionsFactory.AGrepNodeGen;
import com.oracle.truffle.r.nodes.builtin.base.GrepFunctionsFactory.GSubNodeGen;
import com.oracle.truffle.r.nodes.builtin.base.GrepFunctionsFactory.GregexprNodeGen;
import com.oracle.truffle.r.nodes.builtin.base.GrepFunctionsFactory.GrepLNodeGen;
import com.oracle.truffle.r.nodes.builtin.base.GrepFunctionsFactory.GrepNodeGen;
import com.oracle.truffle.r.nodes.builtin.base.GrepFunctionsFactory.GrepRawNodeGen;
import com.oracle.truffle.r.nodes.builtin.base.GrepFunctionsFactory.RegexecNodeGen;
import com.oracle.truffle.r.nodes.builtin.base.GrepFunctionsFactory.RegexprNodeGen;
import com.oracle.truffle.r.nodes.builtin.base.GrepFunctionsFactory.StrsplitNodeGen;
import com.oracle.truffle.r.nodes.builtin.base.GrepFunctionsFactory.SubNodeGen;
import com.oracle.truffle.r.nodes.builtin.base.HiddenInternalFunctions.GetRegisteredRoutines;
import com.oracle.truffle.r.nodes.builtin.base.HiddenInternalFunctions.GetVarsFromFrame;
import com.oracle.truffle.r.nodes.builtin.base.HiddenInternalFunctions.ImportIntoEnv;
import com.oracle.truffle.r.nodes.builtin.base.HiddenInternalFunctions.LazyLoadDBFetch;
import com.oracle.truffle.r.nodes.builtin.base.HiddenInternalFunctions.LazyLoadDBFlush;
import com.oracle.truffle.r.nodes.builtin.base.HiddenInternalFunctions.LazyLoadDBinsertValue;
import com.oracle.truffle.r.nodes.builtin.base.HiddenInternalFunctions.MakeLazy;
import com.oracle.truffle.r.nodes.builtin.base.HiddenInternalFunctionsFactory.GetRegisteredRoutinesNodeGen;
import com.oracle.truffle.r.nodes.builtin.base.HiddenInternalFunctionsFactory.GetVarsFromFrameNodeGen;
import com.oracle.truffle.r.nodes.builtin.base.HiddenInternalFunctionsFactory.ImportIntoEnvNodeGen;
import com.oracle.truffle.r.nodes.builtin.base.HiddenInternalFunctionsFactory.LazyLoadDBFetchNodeGen;
import com.oracle.truffle.r.nodes.builtin.base.HiddenInternalFunctionsFactory.LazyLoadDBFlushNodeGen;
import com.oracle.truffle.r.nodes.builtin.base.HiddenInternalFunctionsFactory.LazyLoadDBinsertValueNodeGen;
import com.oracle.truffle.r.nodes.builtin.base.HiddenInternalFunctionsFactory.MakeLazyNodeGen;
import com.oracle.truffle.r.nodes.builtin.base.IsFiniteFunctions.IsFinite;
import com.oracle.truffle.r.nodes.builtin.base.IsFiniteFunctions.IsInfinite;
import com.oracle.truffle.r.nodes.builtin.base.IsFiniteFunctions.IsNaN;
import com.oracle.truffle.r.nodes.builtin.base.IsFiniteFunctionsFactory.IsFiniteNodeGen;
import com.oracle.truffle.r.nodes.builtin.base.IsFiniteFunctionsFactory.IsInfiniteNodeGen;
import com.oracle.truffle.r.nodes.builtin.base.IsFiniteFunctionsFactory.IsNaNNodeGen;
import com.oracle.truffle.r.nodes.builtin.base.IsTypeFunctions.IsArray;
import com.oracle.truffle.r.nodes.builtin.base.IsTypeFunctions.IsAtomic;
import com.oracle.truffle.r.nodes.builtin.base.IsTypeFunctions.IsCall;
import com.oracle.truffle.r.nodes.builtin.base.IsTypeFunctions.IsCharacter;
import com.oracle.truffle.r.nodes.builtin.base.IsTypeFunctions.IsComplex;
import com.oracle.truffle.r.nodes.builtin.base.IsTypeFunctions.IsDouble;
import com.oracle.truffle.r.nodes.builtin.base.IsTypeFunctions.IsExpression;
import com.oracle.truffle.r.nodes.builtin.base.IsTypeFunctions.IsFunction;
import com.oracle.truffle.r.nodes.builtin.base.IsTypeFunctions.IsInteger;
import com.oracle.truffle.r.nodes.builtin.base.IsTypeFunctions.IsLanguage;
import com.oracle.truffle.r.nodes.builtin.base.IsTypeFunctions.IsList;
import com.oracle.truffle.r.nodes.builtin.base.IsTypeFunctions.IsLogical;
import com.oracle.truffle.r.nodes.builtin.base.IsTypeFunctions.IsMatrix;
import com.oracle.truffle.r.nodes.builtin.base.IsTypeFunctions.IsName;
import com.oracle.truffle.r.nodes.builtin.base.IsTypeFunctions.IsNull;
import com.oracle.truffle.r.nodes.builtin.base.IsTypeFunctions.IsNumeric;
import com.oracle.truffle.r.nodes.builtin.base.IsTypeFunctions.IsObject;
import com.oracle.truffle.r.nodes.builtin.base.IsTypeFunctions.IsPairList;
import com.oracle.truffle.r.nodes.builtin.base.IsTypeFunctions.IsRaw;
import com.oracle.truffle.r.nodes.builtin.base.IsTypeFunctions.IsRecursive;
import com.oracle.truffle.r.nodes.builtin.base.IsTypeFunctions.IsVector;
import com.oracle.truffle.r.nodes.builtin.base.IsTypeFunctionsFactory.IsArrayNodeGen;
import com.oracle.truffle.r.nodes.builtin.base.IsTypeFunctionsFactory.IsAtomicNodeGen;
import com.oracle.truffle.r.nodes.builtin.base.IsTypeFunctionsFactory.IsCallNodeGen;
import com.oracle.truffle.r.nodes.builtin.base.IsTypeFunctionsFactory.IsCharacterNodeGen;
import com.oracle.truffle.r.nodes.builtin.base.IsTypeFunctionsFactory.IsComplexNodeGen;
import com.oracle.truffle.r.nodes.builtin.base.IsTypeFunctionsFactory.IsDoubleNodeGen;
import com.oracle.truffle.r.nodes.builtin.base.IsTypeFunctionsFactory.IsExpressionNodeGen;
import com.oracle.truffle.r.nodes.builtin.base.IsTypeFunctionsFactory.IsFunctionNodeGen;
import com.oracle.truffle.r.nodes.builtin.base.IsTypeFunctionsFactory.IsIntegerNodeGen;
import com.oracle.truffle.r.nodes.builtin.base.IsTypeFunctionsFactory.IsLanguageNodeGen;
import com.oracle.truffle.r.nodes.builtin.base.IsTypeFunctionsFactory.IsListNodeGen;
import com.oracle.truffle.r.nodes.builtin.base.IsTypeFunctionsFactory.IsLogicalNodeGen;
import com.oracle.truffle.r.nodes.builtin.base.IsTypeFunctionsFactory.IsMatrixNodeGen;
import com.oracle.truffle.r.nodes.builtin.base.IsTypeFunctionsFactory.IsNameNodeGen;
import com.oracle.truffle.r.nodes.builtin.base.IsTypeFunctionsFactory.IsNullNodeGen;
import com.oracle.truffle.r.nodes.builtin.base.IsTypeFunctionsFactory.IsNumericNodeGen;
import com.oracle.truffle.r.nodes.builtin.base.IsTypeFunctionsFactory.IsObjectNodeGen;
import com.oracle.truffle.r.nodes.builtin.base.IsTypeFunctionsFactory.IsPairListNodeGen;
import com.oracle.truffle.r.nodes.builtin.base.IsTypeFunctionsFactory.IsRawNodeGen;
import com.oracle.truffle.r.nodes.builtin.base.IsTypeFunctionsFactory.IsRecursiveNodeGen;
import com.oracle.truffle.r.nodes.builtin.base.IsTypeFunctionsFactory.IsVectorNodeGen;
import com.oracle.truffle.r.nodes.builtin.base.LaFunctions.Backsolve;
import com.oracle.truffle.r.nodes.builtin.base.LaFunctions.DetGeReal;
import com.oracle.truffle.r.nodes.builtin.base.LaFunctions.LaChol;
import com.oracle.truffle.r.nodes.builtin.base.LaFunctions.LaChol2Inv;
import com.oracle.truffle.r.nodes.builtin.base.LaFunctions.LaLibrary;
import com.oracle.truffle.r.nodes.builtin.base.LaFunctions.LaSolve;
import com.oracle.truffle.r.nodes.builtin.base.LaFunctions.Qr;
import com.oracle.truffle.r.nodes.builtin.base.LaFunctions.QrCoefCmplx;
import com.oracle.truffle.r.nodes.builtin.base.LaFunctions.QrCoefReal;
import com.oracle.truffle.r.nodes.builtin.base.LaFunctions.Rg;
import com.oracle.truffle.r.nodes.builtin.base.LaFunctions.Rs;
import com.oracle.truffle.r.nodes.builtin.base.LaFunctions.Svd;
import com.oracle.truffle.r.nodes.builtin.base.LaFunctions.Version;
import com.oracle.truffle.r.nodes.builtin.base.LaFunctionsFactory.BacksolveNodeGen;
import com.oracle.truffle.r.nodes.builtin.base.LaFunctionsFactory.DetGeRealNodeGen;
import com.oracle.truffle.r.nodes.builtin.base.LaFunctionsFactory.LaChol2InvNodeGen;
import com.oracle.truffle.r.nodes.builtin.base.LaFunctionsFactory.LaCholNodeGen;
import com.oracle.truffle.r.nodes.builtin.base.LaFunctionsFactory.LaLibraryNodeGen;
import com.oracle.truffle.r.nodes.builtin.base.LaFunctionsFactory.LaSolveNodeGen;
import com.oracle.truffle.r.nodes.builtin.base.LaFunctionsFactory.QrCoefCmplxNodeGen;
import com.oracle.truffle.r.nodes.builtin.base.LaFunctionsFactory.QrCoefRealNodeGen;
import com.oracle.truffle.r.nodes.builtin.base.LaFunctionsFactory.QrNodeGen;
import com.oracle.truffle.r.nodes.builtin.base.LaFunctionsFactory.RgNodeGen;
import com.oracle.truffle.r.nodes.builtin.base.LaFunctionsFactory.RsNodeGen;
import com.oracle.truffle.r.nodes.builtin.base.LaFunctionsFactory.SvdNodeGen;
import com.oracle.truffle.r.nodes.builtin.base.LaFunctionsFactory.VersionNodeGen;
import com.oracle.truffle.r.nodes.builtin.base.LoadSaveFunctions.Load;
import com.oracle.truffle.r.nodes.builtin.base.LoadSaveFunctions.LoadFromConn2;
import com.oracle.truffle.r.nodes.builtin.base.LoadSaveFunctions.LoadInfoFromConn2;
import com.oracle.truffle.r.nodes.builtin.base.LoadSaveFunctions.SaveToConn;
import com.oracle.truffle.r.nodes.builtin.base.LoadSaveFunctionsFactory.LoadFromConn2NodeGen;
import com.oracle.truffle.r.nodes.builtin.base.LoadSaveFunctionsFactory.LoadInfoFromConn2NodeGen;
import com.oracle.truffle.r.nodes.builtin.base.LoadSaveFunctionsFactory.LoadNodeGen;
import com.oracle.truffle.r.nodes.builtin.base.LoadSaveFunctionsFactory.SaveToConnNodeGen;
import com.oracle.truffle.r.nodes.builtin.base.LocaleFunctions.BindTextDomain;
import com.oracle.truffle.r.nodes.builtin.base.LocaleFunctions.Enc2Native;
import com.oracle.truffle.r.nodes.builtin.base.LocaleFunctions.Enc2Utf8;
import com.oracle.truffle.r.nodes.builtin.base.LocaleFunctions.GetLocale;
import com.oracle.truffle.r.nodes.builtin.base.LocaleFunctions.L10nInfo;
import com.oracle.truffle.r.nodes.builtin.base.LocaleFunctions.LocaleConv;
import com.oracle.truffle.r.nodes.builtin.base.LocaleFunctions.SetLocale;
import com.oracle.truffle.r.nodes.builtin.base.LocaleFunctionsFactory.BindTextDomainNodeGen;
import com.oracle.truffle.r.nodes.builtin.base.LocaleFunctionsFactory.Enc2NativeNodeGen;
import com.oracle.truffle.r.nodes.builtin.base.LocaleFunctionsFactory.Enc2Utf8NodeGen;
import com.oracle.truffle.r.nodes.builtin.base.LocaleFunctionsFactory.GetLocaleNodeGen;
import com.oracle.truffle.r.nodes.builtin.base.LocaleFunctionsFactory.L10nInfoNodeGen;
import com.oracle.truffle.r.nodes.builtin.base.LocaleFunctionsFactory.LocaleConvNodeGen;
import com.oracle.truffle.r.nodes.builtin.base.LocaleFunctionsFactory.SetLocaleNodeGen;
import com.oracle.truffle.r.nodes.builtin.base.LogFunctions.Log;
import com.oracle.truffle.r.nodes.builtin.base.LogFunctions.Log10;
import com.oracle.truffle.r.nodes.builtin.base.LogFunctions.Log1p;
import com.oracle.truffle.r.nodes.builtin.base.LogFunctions.Log2;
import com.oracle.truffle.r.nodes.builtin.base.LogFunctionsFactory.LogNodeGen;
import com.oracle.truffle.r.nodes.builtin.base.NamespaceFunctions.GetNamespaceRegistry;
import com.oracle.truffle.r.nodes.builtin.base.NamespaceFunctions.GetRegisteredNamespace;
import com.oracle.truffle.r.nodes.builtin.base.NamespaceFunctions.IsNamespaceEnv;
import com.oracle.truffle.r.nodes.builtin.base.NamespaceFunctions.IsRegisteredNamespace;
import com.oracle.truffle.r.nodes.builtin.base.NamespaceFunctions.RegisterNamespace;
import com.oracle.truffle.r.nodes.builtin.base.NamespaceFunctions.UnregisterNamespace;
import com.oracle.truffle.r.nodes.builtin.base.NamespaceFunctionsFactory.GetNamespaceRegistryNodeGen;
import com.oracle.truffle.r.nodes.builtin.base.NamespaceFunctionsFactory.GetRegisteredNamespaceNodeGen;
import com.oracle.truffle.r.nodes.builtin.base.NamespaceFunctionsFactory.IsNamespaceEnvNodeGen;
import com.oracle.truffle.r.nodes.builtin.base.NamespaceFunctionsFactory.IsRegisteredNamespaceNodeGen;
import com.oracle.truffle.r.nodes.builtin.base.NamespaceFunctionsFactory.RegisterNamespaceNodeGen;
import com.oracle.truffle.r.nodes.builtin.base.NamespaceFunctionsFactory.UnregisterNamespaceNodeGen;
import com.oracle.truffle.r.nodes.builtin.base.NumericalFunctions.Abs;
import com.oracle.truffle.r.nodes.builtin.base.NumericalFunctions.Arg;
import com.oracle.truffle.r.nodes.builtin.base.NumericalFunctions.Conj;
import com.oracle.truffle.r.nodes.builtin.base.NumericalFunctions.Im;
import com.oracle.truffle.r.nodes.builtin.base.NumericalFunctions.Mod;
import com.oracle.truffle.r.nodes.builtin.base.NumericalFunctions.Re;
import com.oracle.truffle.r.nodes.builtin.base.NumericalFunctions.Sign;
import com.oracle.truffle.r.nodes.builtin.base.NumericalFunctions.Sqrt;
import com.oracle.truffle.r.nodes.builtin.base.OptionsFunctions.GetOption;
import com.oracle.truffle.r.nodes.builtin.base.OptionsFunctions.Options;
import com.oracle.truffle.r.nodes.builtin.base.OptionsFunctionsFactory.GetOptionNodeGen;
import com.oracle.truffle.r.nodes.builtin.base.OptionsFunctionsFactory.OptionsNodeGen;
import com.oracle.truffle.r.nodes.builtin.base.PMinMax.PMax;
import com.oracle.truffle.r.nodes.builtin.base.PMinMax.PMin;
import com.oracle.truffle.r.nodes.builtin.base.PMinMaxNodeGen.PMaxNodeGen;
import com.oracle.truffle.r.nodes.builtin.base.PMinMaxNodeGen.PMinNodeGen;
import com.oracle.truffle.r.nodes.builtin.base.PrintFunctions.PrintDefault;
import com.oracle.truffle.r.nodes.builtin.base.PrintFunctionsFactory.PrintDefaultNodeGen;
import com.oracle.truffle.r.nodes.builtin.base.RNGFunctions.FastRSetSeed;
import com.oracle.truffle.r.nodes.builtin.base.RNGFunctions.RNGkind;
import com.oracle.truffle.r.nodes.builtin.base.RNGFunctions.SetSeed;
import com.oracle.truffle.r.nodes.builtin.base.RNGFunctionsFactory.FastRSetSeedNodeGen;
import com.oracle.truffle.r.nodes.builtin.base.RNGFunctionsFactory.RNGkindNodeGen;
import com.oracle.truffle.r.nodes.builtin.base.RNGFunctionsFactory.SetSeedNodeGen;
import com.oracle.truffle.r.nodes.builtin.base.RawFunctions.CharToRaw;
import com.oracle.truffle.r.nodes.builtin.base.RawFunctions.RawShift;
import com.oracle.truffle.r.nodes.builtin.base.RawFunctions.RawToChar;
import com.oracle.truffle.r.nodes.builtin.base.RawFunctionsFactory.CharToRawNodeGen;
import com.oracle.truffle.r.nodes.builtin.base.RawFunctionsFactory.RawShiftNodeGen;
import com.oracle.truffle.r.nodes.builtin.base.RawFunctionsFactory.RawToCharNodeGen;
import com.oracle.truffle.r.nodes.builtin.base.RowsumFunctions.Rowsum;
import com.oracle.truffle.r.nodes.builtin.base.RowsumFunctionsFactory.RowsumNodeGen;
import com.oracle.truffle.r.nodes.builtin.base.S3DispatchFunctions.NextMethod;
import com.oracle.truffle.r.nodes.builtin.base.S3DispatchFunctions.UseMethod;
import com.oracle.truffle.r.nodes.builtin.base.S3DispatchFunctionsFactory.NextMethodNodeGen;
import com.oracle.truffle.r.nodes.builtin.base.S3DispatchFunctionsFactory.UseMethodNodeGen;
import com.oracle.truffle.r.nodes.builtin.base.SeqFunctions.SeqAlong;
import com.oracle.truffle.r.nodes.builtin.base.SeqFunctions.SeqInt;
import com.oracle.truffle.r.nodes.builtin.base.SeqFunctions.SeqLen;
import com.oracle.truffle.r.nodes.builtin.base.SeqFunctionsFactory.SeqAlongNodeGen;
import com.oracle.truffle.r.nodes.builtin.base.SeqFunctionsFactory.SeqIntNodeGen;
import com.oracle.truffle.r.nodes.builtin.base.SeqFunctionsFactory.SeqLenNodeGen;
import com.oracle.truffle.r.nodes.builtin.base.SerializeFunctions.Serialize;
import com.oracle.truffle.r.nodes.builtin.base.SerializeFunctions.SerializeB;
import com.oracle.truffle.r.nodes.builtin.base.SerializeFunctions.SerializeInfoFromConn;
import com.oracle.truffle.r.nodes.builtin.base.SerializeFunctions.SerializeToConn;
import com.oracle.truffle.r.nodes.builtin.base.SerializeFunctions.Unserialize;
import com.oracle.truffle.r.nodes.builtin.base.SerializeFunctions.UnserializeFromConn;
import com.oracle.truffle.r.nodes.builtin.base.SerializeFunctionsFactory.SerializeBNodeGen;
import com.oracle.truffle.r.nodes.builtin.base.SerializeFunctionsFactory.SerializeInfoFromConnNodeGen;
import com.oracle.truffle.r.nodes.builtin.base.SerializeFunctionsFactory.SerializeNodeGen;
import com.oracle.truffle.r.nodes.builtin.base.SerializeFunctionsFactory.SerializeToConnNodeGen;
import com.oracle.truffle.r.nodes.builtin.base.SerializeFunctionsFactory.UnserializeFromConnNodeGen;
import com.oracle.truffle.r.nodes.builtin.base.SerializeFunctionsFactory.UnserializeNodeGen;
import com.oracle.truffle.r.nodes.builtin.base.SinkFunctions.Sink;
import com.oracle.truffle.r.nodes.builtin.base.SinkFunctions.SinkNumber;
import com.oracle.truffle.r.nodes.builtin.base.SinkFunctionsFactory.SinkNodeGen;
import com.oracle.truffle.r.nodes.builtin.base.SinkFunctionsFactory.SinkNumberNodeGen;
import com.oracle.truffle.r.nodes.builtin.base.SortFunctions.PartialSort;
import com.oracle.truffle.r.nodes.builtin.base.SortFunctions.QSort;
import com.oracle.truffle.r.nodes.builtin.base.SortFunctions.RadixSort;
import com.oracle.truffle.r.nodes.builtin.base.SortFunctions.Sort;
import com.oracle.truffle.r.nodes.builtin.base.SortFunctionsFactory.PartialSortNodeGen;
import com.oracle.truffle.r.nodes.builtin.base.SortFunctionsFactory.QSortNodeGen;
import com.oracle.truffle.r.nodes.builtin.base.SortFunctionsFactory.RadixSortNodeGen;
import com.oracle.truffle.r.nodes.builtin.base.SortFunctionsFactory.SortNodeGen;
import com.oracle.truffle.r.nodes.builtin.base.StartsEndsWithFunctions.EndsWith;
import com.oracle.truffle.r.nodes.builtin.base.StartsEndsWithFunctions.StartsWith;
import com.oracle.truffle.r.nodes.builtin.base.StartsEndsWithFunctionsFactory.EndsWithNodeGen;
import com.oracle.truffle.r.nodes.builtin.base.StartsEndsWithFunctionsFactory.StartsWithNodeGen;
import com.oracle.truffle.r.nodes.builtin.base.SysFunctions.SysChmod;
import com.oracle.truffle.r.nodes.builtin.base.SysFunctions.SysGetenv;
import com.oracle.truffle.r.nodes.builtin.base.SysFunctions.SysGetpid;
import com.oracle.truffle.r.nodes.builtin.base.SysFunctions.SysGlob;
import com.oracle.truffle.r.nodes.builtin.base.SysFunctions.SysInfo;
import com.oracle.truffle.r.nodes.builtin.base.SysFunctions.SysReadlink;
import com.oracle.truffle.r.nodes.builtin.base.SysFunctions.SysSetEnv;
import com.oracle.truffle.r.nodes.builtin.base.SysFunctions.SysSetFileTime;
import com.oracle.truffle.r.nodes.builtin.base.SysFunctions.SysSleep;
import com.oracle.truffle.r.nodes.builtin.base.SysFunctions.SysTime;
import com.oracle.truffle.r.nodes.builtin.base.SysFunctions.SysUmask;
import com.oracle.truffle.r.nodes.builtin.base.SysFunctions.SysUnSetEnv;
import com.oracle.truffle.r.nodes.builtin.base.SysFunctionsFactory.SysChmodNodeGen;
import com.oracle.truffle.r.nodes.builtin.base.SysFunctionsFactory.SysGetenvNodeGen;
import com.oracle.truffle.r.nodes.builtin.base.SysFunctionsFactory.SysGetpidNodeGen;
import com.oracle.truffle.r.nodes.builtin.base.SysFunctionsFactory.SysGlobNodeGen;
import com.oracle.truffle.r.nodes.builtin.base.SysFunctionsFactory.SysInfoNodeGen;
import com.oracle.truffle.r.nodes.builtin.base.SysFunctionsFactory.SysReadlinkNodeGen;
import com.oracle.truffle.r.nodes.builtin.base.SysFunctionsFactory.SysSetEnvNodeGen;
import com.oracle.truffle.r.nodes.builtin.base.SysFunctionsFactory.SysSetFileTimeNodeGen;
import com.oracle.truffle.r.nodes.builtin.base.SysFunctionsFactory.SysSleepNodeGen;
import com.oracle.truffle.r.nodes.builtin.base.SysFunctionsFactory.SysTimeNodeGen;
import com.oracle.truffle.r.nodes.builtin.base.SysFunctionsFactory.SysUmaskNodeGen;
import com.oracle.truffle.r.nodes.builtin.base.SysFunctionsFactory.SysUnSetEnvNodeGen;
import com.oracle.truffle.r.nodes.builtin.base.ToLowerOrUpper.ToLower;
import com.oracle.truffle.r.nodes.builtin.base.ToLowerOrUpper.ToUpper;
import com.oracle.truffle.r.nodes.builtin.base.ToLowerOrUpperFactory.ToLowerNodeGen;
import com.oracle.truffle.r.nodes.builtin.base.ToLowerOrUpperFactory.ToUpperNodeGen;
import com.oracle.truffle.r.nodes.builtin.base.TraceFunctions.PrimTrace;
import com.oracle.truffle.r.nodes.builtin.base.TraceFunctions.PrimUnTrace;
import com.oracle.truffle.r.nodes.builtin.base.TraceFunctions.Retracemem;
import com.oracle.truffle.r.nodes.builtin.base.TraceFunctions.TraceOnOff;
import com.oracle.truffle.r.nodes.builtin.base.TraceFunctions.Tracemem;
import com.oracle.truffle.r.nodes.builtin.base.TraceFunctions.Untracemem;
import com.oracle.truffle.r.nodes.builtin.base.TraceFunctionsFactory.PrimTraceNodeGen;
import com.oracle.truffle.r.nodes.builtin.base.TraceFunctionsFactory.PrimUnTraceNodeGen;
import com.oracle.truffle.r.nodes.builtin.base.TraceFunctionsFactory.RetracememNodeGen;
import com.oracle.truffle.r.nodes.builtin.base.TraceFunctionsFactory.TraceOnOffNodeGen;
import com.oracle.truffle.r.nodes.builtin.base.TraceFunctionsFactory.TracememNodeGen;
import com.oracle.truffle.r.nodes.builtin.base.TraceFunctionsFactory.UntracememNodeGen;
import com.oracle.truffle.r.nodes.builtin.base.TrigExpFunctions.Acos;
import com.oracle.truffle.r.nodes.builtin.base.TrigExpFunctions.Acosh;
import com.oracle.truffle.r.nodes.builtin.base.TrigExpFunctions.Asin;
import com.oracle.truffle.r.nodes.builtin.base.TrigExpFunctions.Asinh;
import com.oracle.truffle.r.nodes.builtin.base.TrigExpFunctions.Atan;
import com.oracle.truffle.r.nodes.builtin.base.TrigExpFunctions.Atan2;
import com.oracle.truffle.r.nodes.builtin.base.TrigExpFunctions.Atanh;
import com.oracle.truffle.r.nodes.builtin.base.TrigExpFunctions.Cos;
import com.oracle.truffle.r.nodes.builtin.base.TrigExpFunctions.Cosh;
import com.oracle.truffle.r.nodes.builtin.base.TrigExpFunctions.Cospi;
import com.oracle.truffle.r.nodes.builtin.base.TrigExpFunctions.Exp;
import com.oracle.truffle.r.nodes.builtin.base.TrigExpFunctions.ExpM1;
import com.oracle.truffle.r.nodes.builtin.base.TrigExpFunctions.Sin;
import com.oracle.truffle.r.nodes.builtin.base.TrigExpFunctions.Sinh;
import com.oracle.truffle.r.nodes.builtin.base.TrigExpFunctions.Sinpi;
import com.oracle.truffle.r.nodes.builtin.base.TrigExpFunctions.Tan;
import com.oracle.truffle.r.nodes.builtin.base.TrigExpFunctions.Tanh;
import com.oracle.truffle.r.nodes.builtin.base.TrigExpFunctions.Tanpi;
import com.oracle.truffle.r.nodes.builtin.base.TrigExpFunctionsFactory.Atan2NodeGen;
import com.oracle.truffle.r.nodes.builtin.base.VersionFunctions.ExtSoftVersion;
import com.oracle.truffle.r.nodes.builtin.base.VersionFunctions.RVersion;
import com.oracle.truffle.r.nodes.builtin.base.VersionFunctionsFactory.ExtSoftVersionNodeGen;
import com.oracle.truffle.r.nodes.builtin.base.VersionFunctionsFactory.RVersionNodeGen;
import com.oracle.truffle.r.nodes.builtin.base.WhichFunctions.Which;
import com.oracle.truffle.r.nodes.builtin.base.WhichFunctions.WhichMax;
import com.oracle.truffle.r.nodes.builtin.base.WhichFunctions.WhichMin;
import com.oracle.truffle.r.nodes.builtin.base.WhichFunctionsFactory.WhichNodeGen;
import com.oracle.truffle.r.nodes.builtin.base.fastpaths.AssignFastPathNodeGen;
import com.oracle.truffle.r.nodes.builtin.base.fastpaths.ExistsFastPathNodeGen;
import com.oracle.truffle.r.nodes.builtin.base.fastpaths.GetFastPathNodeGen;
import com.oracle.truffle.r.nodes.builtin.base.fastpaths.IntersectFastPathNodeGen;
import com.oracle.truffle.r.nodes.builtin.base.fastpaths.IsElementFastPathNodeGen;
import com.oracle.truffle.r.nodes.builtin.base.fastpaths.MatchArgFastPath;
import com.oracle.truffle.r.nodes.builtin.base.fastpaths.MatchArgFastPathNodeGen;
import com.oracle.truffle.r.nodes.builtin.base.fastpaths.MatrixFastPathNodeGen;
import com.oracle.truffle.r.nodes.builtin.base.fastpaths.SetDiffFastPathNodeGen;
import com.oracle.truffle.r.nodes.builtin.base.fastpaths.StopifnotFastPath;
import com.oracle.truffle.r.nodes.builtin.base.fastpaths.SubscriptDataFrameFastPathNodeGen;
import com.oracle.truffle.r.nodes.builtin.base.fastpaths.SubsetDataFrameFastPath;
import com.oracle.truffle.r.nodes.builtin.base.fastpaths.SubsetDataFrameFastPathNodeGen;
import com.oracle.truffle.r.nodes.builtin.base.fastpaths.VectorFastPathsFactory.ComplexFastPathNodeGen;
import com.oracle.truffle.r.nodes.builtin.base.fastpaths.VectorFastPathsFactory.DoubleFastPathNodeGen;
import com.oracle.truffle.r.nodes.builtin.base.fastpaths.VectorFastPathsFactory.IntegerFastPathNodeGen;
import com.oracle.truffle.r.nodes.builtin.base.foreign.CallAndExternalFunctions.DotCall;
import com.oracle.truffle.r.nodes.builtin.base.foreign.CallAndExternalFunctions.DotCallGraphics;
import com.oracle.truffle.r.nodes.builtin.base.foreign.CallAndExternalFunctions.DotExternal;
import com.oracle.truffle.r.nodes.builtin.base.foreign.CallAndExternalFunctions.DotExternal2;
import com.oracle.truffle.r.nodes.builtin.base.foreign.CallAndExternalFunctions.DotExternalGraphics;
import com.oracle.truffle.r.nodes.builtin.base.foreign.CallAndExternalFunctionsFactory.DotCallGraphicsNodeGen;
import com.oracle.truffle.r.nodes.builtin.base.foreign.CallAndExternalFunctionsFactory.DotCallNodeGen;
import com.oracle.truffle.r.nodes.builtin.base.foreign.CallAndExternalFunctionsFactory.DotExternal2NodeGen;
import com.oracle.truffle.r.nodes.builtin.base.foreign.CallAndExternalFunctionsFactory.DotExternalGraphicsNodeGen;
import com.oracle.truffle.r.nodes.builtin.base.foreign.CallAndExternalFunctionsFactory.DotExternalNodeGen;
import com.oracle.truffle.r.nodes.builtin.base.foreign.FortranAndCFunctions.DotC;
import com.oracle.truffle.r.nodes.builtin.base.foreign.FortranAndCFunctions.DotFortran;
import com.oracle.truffle.r.nodes.builtin.base.foreign.FortranAndCFunctionsFactory.DotCNodeGen;
import com.oracle.truffle.r.nodes.builtin.base.foreign.FortranAndCFunctionsFactory.DotFortranNodeGen;
import com.oracle.truffle.r.nodes.builtin.base.infix.AccessField;
import com.oracle.truffle.r.nodes.builtin.base.infix.AccessFieldNodeGen;
import com.oracle.truffle.r.nodes.builtin.base.infix.AssignBuiltin;
import com.oracle.truffle.r.nodes.builtin.base.infix.AssignBuiltinEq;
import com.oracle.truffle.r.nodes.builtin.base.infix.AssignBuiltinEqNodeGen;
import com.oracle.truffle.r.nodes.builtin.base.infix.AssignBuiltinNodeGen;
import com.oracle.truffle.r.nodes.builtin.base.infix.AssignOuterBuiltin;
import com.oracle.truffle.r.nodes.builtin.base.infix.AssignOuterBuiltinNodeGen;
import com.oracle.truffle.r.nodes.builtin.base.infix.BraceBuiltin;
import com.oracle.truffle.r.nodes.builtin.base.infix.BraceBuiltinNodeGen;
import com.oracle.truffle.r.nodes.builtin.base.infix.BreakBuiltin;
import com.oracle.truffle.r.nodes.builtin.base.infix.BreakBuiltinNodeGen;
import com.oracle.truffle.r.nodes.builtin.base.infix.ForBuiltin;
import com.oracle.truffle.r.nodes.builtin.base.infix.ForBuiltinNodeGen;
import com.oracle.truffle.r.nodes.builtin.base.infix.FunctionBuiltin;
import com.oracle.truffle.r.nodes.builtin.base.infix.IfBuiltin;
import com.oracle.truffle.r.nodes.builtin.base.infix.IfBuiltinNodeGen;
import com.oracle.truffle.r.nodes.builtin.base.infix.NextBuiltin;
import com.oracle.truffle.r.nodes.builtin.base.infix.NextBuiltinNodeGen;
import com.oracle.truffle.r.nodes.builtin.base.infix.ParenBuiltin;
import com.oracle.truffle.r.nodes.builtin.base.infix.RepeatBuiltin;
import com.oracle.truffle.r.nodes.builtin.base.infix.RepeatBuiltinNodeGen;
import com.oracle.truffle.r.nodes.builtin.base.infix.Subscript;
import com.oracle.truffle.r.nodes.builtin.base.infix.Subscript.DefaultBuiltin;
import com.oracle.truffle.r.nodes.builtin.base.infix.SubscriptNodeGen;
import com.oracle.truffle.r.nodes.builtin.base.infix.Subset;
import com.oracle.truffle.r.nodes.builtin.base.infix.SubsetNodeGen;
import com.oracle.truffle.r.nodes.builtin.base.infix.Tilde;
import com.oracle.truffle.r.nodes.builtin.base.infix.TildeNodeGen;
import com.oracle.truffle.r.nodes.builtin.base.infix.UpdateField;
import com.oracle.truffle.r.nodes.builtin.base.infix.UpdateFieldNodeGen;
import com.oracle.truffle.r.nodes.builtin.base.infix.UpdateSubscript;
import com.oracle.truffle.r.nodes.builtin.base.infix.UpdateSubscriptNodeGen;
import com.oracle.truffle.r.nodes.builtin.base.infix.UpdateSubset;
import com.oracle.truffle.r.nodes.builtin.base.infix.UpdateSubsetNodeGen;
import com.oracle.truffle.r.nodes.builtin.base.infix.WhileBuiltin;
import com.oracle.truffle.r.nodes.builtin.base.infix.WhileBuiltinNodeGen;
import com.oracle.truffle.r.nodes.builtin.base.system.SystemFunction;
import com.oracle.truffle.r.nodes.builtin.base.system.SystemFunctionNodeGen;
import com.oracle.truffle.r.nodes.builtin.fastr.FastRContext;
import com.oracle.truffle.r.nodes.builtin.fastr.FastRContext.ChannelPoll;
import com.oracle.truffle.r.nodes.builtin.fastr.FastRContext.ChannelReceive;
import com.oracle.truffle.r.nodes.builtin.fastr.FastRContext.ChannelSelect;
import com.oracle.truffle.r.nodes.builtin.fastr.FastRContext.ChannelSend;
import com.oracle.truffle.r.nodes.builtin.fastr.FastRContext.CloseChannel;
import com.oracle.truffle.r.nodes.builtin.fastr.FastRContext.CreateChannel;
import com.oracle.truffle.r.nodes.builtin.fastr.FastRContext.CreateForkChannel;
import com.oracle.truffle.r.nodes.builtin.fastr.FastRContext.FastRContextClose;
import com.oracle.truffle.r.nodes.builtin.fastr.FastRContext.FastRContextNew;
import com.oracle.truffle.r.nodes.builtin.fastr.FastRContext.Get;
import com.oracle.truffle.r.nodes.builtin.fastr.FastRContext.GetChannel;
import com.oracle.truffle.r.nodes.builtin.fastr.FastRContext.Interrupt;
import com.oracle.truffle.r.nodes.builtin.fastr.FastRContext.Join;
import com.oracle.truffle.r.nodes.builtin.fastr.FastRContext.Spawn;
import com.oracle.truffle.r.nodes.builtin.fastr.FastRContextFactory;
import com.oracle.truffle.r.nodes.builtin.fastr.FastRContextFactory.ChannelPollNodeGen;
import com.oracle.truffle.r.nodes.builtin.fastr.FastRContextFactory.ChannelReceiveNodeGen;
import com.oracle.truffle.r.nodes.builtin.fastr.FastRContextFactory.ChannelSelectNodeGen;
import com.oracle.truffle.r.nodes.builtin.fastr.FastRContextFactory.ChannelSendNodeGen;
import com.oracle.truffle.r.nodes.builtin.fastr.FastRContextFactory.CloseChannelNodeGen;
import com.oracle.truffle.r.nodes.builtin.fastr.FastRContextFactory.CreateChannelNodeGen;
import com.oracle.truffle.r.nodes.builtin.fastr.FastRContextFactory.CreateForkChannelNodeGen;
import com.oracle.truffle.r.nodes.builtin.fastr.FastRContextFactory.GetChannelNodeGen;
import com.oracle.truffle.r.nodes.builtin.fastr.FastRContextFactory.InterruptNodeGen;
import com.oracle.truffle.r.nodes.builtin.fastr.FastRContextFactory.JoinNodeGen;
import com.oracle.truffle.r.nodes.builtin.fastr.FastRContextFactory.SpawnNodeGen;
import com.oracle.truffle.r.nodes.builtin.fastr.FastRDebug;
import com.oracle.truffle.r.nodes.builtin.fastr.FastRDebugNodeGen;
import com.oracle.truffle.r.nodes.builtin.fastr.FastRDispatchNativeHandlers;
import com.oracle.truffle.r.nodes.builtin.fastr.FastREmbedded;
import com.oracle.truffle.r.nodes.builtin.fastr.FastREmbeddedFactory;
import com.oracle.truffle.r.nodes.builtin.fastr.FastRGDSetGraphics;
import com.oracle.truffle.r.nodes.builtin.fastr.FastRGDSetGraphicsNodeGen;
import com.oracle.truffle.r.nodes.builtin.fastr.FastRGetExecutor;
import com.oracle.truffle.r.nodes.builtin.fastr.FastRHelp.FastRAddHelpPath;
import com.oracle.truffle.r.nodes.builtin.fastr.FastRHelp.FastRHelpPath;
import com.oracle.truffle.r.nodes.builtin.fastr.FastRHelp.FastRHelpRd;
import com.oracle.truffle.r.nodes.builtin.fastr.FastRHelpFactory.FastRHelpPathNodeGen;
import com.oracle.truffle.r.nodes.builtin.fastr.FastRHelpFactory.FastRHelpRdNodeGen;
import com.oracle.truffle.r.nodes.builtin.fastr.FastRIdentity;
import com.oracle.truffle.r.nodes.builtin.fastr.FastRIdentityNodeGen;
import com.oracle.truffle.r.nodes.builtin.fastr.FastRInitEventLoop;
import com.oracle.truffle.r.nodes.builtin.fastr.FastRInitEventLoopNodeGen;
import com.oracle.truffle.r.nodes.builtin.fastr.FastRInspect;
import com.oracle.truffle.r.nodes.builtin.fastr.FastRInspectFrame;
import com.oracle.truffle.r.nodes.builtin.fastr.FastRInspectFrameNodeGen;
import com.oracle.truffle.r.nodes.builtin.fastr.FastRInspectNodeGen;
import com.oracle.truffle.r.nodes.builtin.fastr.FastRInterop;
import com.oracle.truffle.r.nodes.builtin.fastr.FastRInterop.Export;
import com.oracle.truffle.r.nodes.builtin.fastr.FastRInterop.FastRInteropCheckException;
import com.oracle.truffle.r.nodes.builtin.fastr.FastRInterop.FastRInteropClearException;
import com.oracle.truffle.r.nodes.builtin.fastr.FastRInterop.FastRInteropGetException;
import com.oracle.truffle.r.nodes.builtin.fastr.FastRInterop.FastRInteropTry;
import com.oracle.truffle.r.nodes.builtin.fastr.FastRInterop.Import;
import com.oracle.truffle.r.nodes.builtin.fastr.FastRInterop.InteropNew;
import com.oracle.truffle.r.nodes.builtin.fastr.FastRInterop.IsExternal;
import com.oracle.truffle.r.nodes.builtin.fastr.FastRInterop.JavaAddToClasspath;
import com.oracle.truffle.r.nodes.builtin.fastr.FastRInterop.JavaAsTruffleObject;
import com.oracle.truffle.r.nodes.builtin.fastr.FastRInterop.JavaIsAssignableFrom;
import com.oracle.truffle.r.nodes.builtin.fastr.FastRInterop.JavaIsIdentical;
import com.oracle.truffle.r.nodes.builtin.fastr.FastRInterop.JavaIsInstance;
import com.oracle.truffle.r.nodes.builtin.fastr.FastRInterop.JavaType;
import com.oracle.truffle.r.nodes.builtin.fastr.FastRInterop.ToByte;
import com.oracle.truffle.r.nodes.builtin.fastr.FastRInterop.ToChar;
import com.oracle.truffle.r.nodes.builtin.fastr.FastRInterop.ToFloat;
import com.oracle.truffle.r.nodes.builtin.fastr.FastRInterop.ToJavaArray;
import com.oracle.truffle.r.nodes.builtin.fastr.FastRInterop.ToLong;
import com.oracle.truffle.r.nodes.builtin.fastr.FastRInterop.ToShort;
import com.oracle.truffle.r.nodes.builtin.fastr.FastRInteropFactory;
import com.oracle.truffle.r.nodes.builtin.fastr.FastRInteropFactory.ExportNodeGen;
import com.oracle.truffle.r.nodes.builtin.fastr.FastRInteropFactory.FastRInteropCheckExceptionNodeGen;
import com.oracle.truffle.r.nodes.builtin.fastr.FastRInteropFactory.FastRInteropClearExceptionNodeGen;
import com.oracle.truffle.r.nodes.builtin.fastr.FastRInteropFactory.FastRInteropGetExceptionNodeGen;
import com.oracle.truffle.r.nodes.builtin.fastr.FastRInteropFactory.FastRInteropTryNodeGen;
import com.oracle.truffle.r.nodes.builtin.fastr.FastRInteropFactory.ImportNodeGen;
import com.oracle.truffle.r.nodes.builtin.fastr.FastRInteropFactory.InteropNewNodeGen;
import com.oracle.truffle.r.nodes.builtin.fastr.FastRInteropFactory.IsExternalNodeGen;
import com.oracle.truffle.r.nodes.builtin.fastr.FastRInteropFactory.JavaAddToClasspathNodeGen;
import com.oracle.truffle.r.nodes.builtin.fastr.FastRInteropFactory.JavaAsTruffleObjectNodeGen;
import com.oracle.truffle.r.nodes.builtin.fastr.FastRInteropFactory.JavaIsAssignableFromNodeGen;
import com.oracle.truffle.r.nodes.builtin.fastr.FastRInteropFactory.JavaIsIdenticalNodeGen;
import com.oracle.truffle.r.nodes.builtin.fastr.FastRInteropFactory.JavaIsInstanceNodeGen;
import com.oracle.truffle.r.nodes.builtin.fastr.FastRInteropFactory.JavaTypeNodeGen;
import com.oracle.truffle.r.nodes.builtin.fastr.FastRInteropFactory.ToByteNodeGen;
import com.oracle.truffle.r.nodes.builtin.fastr.FastRInteropFactory.ToCharNodeGen;
import com.oracle.truffle.r.nodes.builtin.fastr.FastRInteropFactory.ToFloatNodeGen;
import com.oracle.truffle.r.nodes.builtin.fastr.FastRInteropFactory.ToJavaArrayNodeGen;
import com.oracle.truffle.r.nodes.builtin.fastr.FastRInteropFactory.ToLongNodeGen;
import com.oracle.truffle.r.nodes.builtin.fastr.FastRInteropFactory.ToShortNodeGen;
import com.oracle.truffle.r.nodes.builtin.fastr.FastRJavaGDResize;
import com.oracle.truffle.r.nodes.builtin.fastr.FastRLibPaths;
import com.oracle.truffle.r.nodes.builtin.fastr.FastRLibPathsNodeGen;
import com.oracle.truffle.r.nodes.builtin.fastr.FastROptionBuiltin;
import com.oracle.truffle.r.nodes.builtin.fastr.FastRPatchPackage;
import com.oracle.truffle.r.nodes.builtin.fastr.FastRPatchPackageNodeGen;
import com.oracle.truffle.r.nodes.builtin.fastr.FastRPkgSource;
import com.oracle.truffle.r.nodes.builtin.fastr.FastRPkgSourceNodeGen;
import com.oracle.truffle.r.nodes.builtin.fastr.FastRPrintError;
import com.oracle.truffle.r.nodes.builtin.fastr.FastRPrintErrorNodeGen;
import com.oracle.truffle.r.nodes.builtin.fastr.FastRRCallerTrace;
import com.oracle.truffle.r.nodes.builtin.fastr.FastRRefCountInfo;
import com.oracle.truffle.r.nodes.builtin.fastr.FastRRefCountInfoNodeGen;
import com.oracle.truffle.r.nodes.builtin.fastr.FastRRegisterFunctions;
import com.oracle.truffle.r.nodes.builtin.fastr.FastRRegisterFunctionsNodeGen;
import com.oracle.truffle.r.nodes.builtin.fastr.FastRSVGFileName;
import com.oracle.truffle.r.nodes.builtin.fastr.FastRSVGFileNameNodeGen;
import com.oracle.truffle.r.nodes.builtin.fastr.FastRSVGGetContent;
import com.oracle.truffle.r.nodes.builtin.fastr.FastRSVGGetContentNodeGen;
import com.oracle.truffle.r.nodes.builtin.fastr.FastRSVGSetFileName;
import com.oracle.truffle.r.nodes.builtin.fastr.FastRSVGSetFileNameNodeGen;
import com.oracle.truffle.r.nodes.builtin.fastr.FastRSavePlot;
import com.oracle.truffle.r.nodes.builtin.fastr.FastRSavePlotNodeGen;
import com.oracle.truffle.r.nodes.builtin.fastr.FastRSetConsoleHandler;
import com.oracle.truffle.r.nodes.builtin.fastr.FastRSetConsoleHandlerNodeGen;
import com.oracle.truffle.r.nodes.builtin.fastr.FastRSetToolchain;
import com.oracle.truffle.r.nodes.builtin.fastr.FastRSetToolchainNodeGen;
import com.oracle.truffle.r.nodes.builtin.fastr.FastRSlotAssign;
import com.oracle.truffle.r.nodes.builtin.fastr.FastRSlotAssignNodeGen;
import com.oracle.truffle.r.nodes.builtin.fastr.FastRSourceInfo;
import com.oracle.truffle.r.nodes.builtin.fastr.FastRSourceInfoNodeGen;
import com.oracle.truffle.r.nodes.builtin.fastr.FastRStackTrace;
import com.oracle.truffle.r.nodes.builtin.fastr.FastRStackTraceNodeGen;
import com.oracle.truffle.r.nodes.builtin.fastr.FastRSyntaxTree;
import com.oracle.truffle.r.nodes.builtin.fastr.FastRSyntaxTreeNodeGen;
import com.oracle.truffle.r.nodes.builtin.fastr.FastRTestsTry;
import com.oracle.truffle.r.nodes.builtin.fastr.FastRTestsTryNodeGen;
import com.oracle.truffle.r.nodes.builtin.fastr.FastRThrowCompilerError;
import com.oracle.truffle.r.nodes.builtin.fastr.FastRThrowIt;
import com.oracle.truffle.r.nodes.builtin.fastr.FastRThrowItNodeGen;
import com.oracle.truffle.r.nodes.builtin.fastr.FastRTrace.Trace;
import com.oracle.truffle.r.nodes.builtin.fastr.FastRTrace.Untrace;
import com.oracle.truffle.r.nodes.builtin.fastr.FastRTraceFactory.TraceNodeGen;
import com.oracle.truffle.r.nodes.builtin.fastr.FastRTraceFactory.UntraceNodeGen;
import com.oracle.truffle.r.nodes.builtin.fastr.FastRTree;
import com.oracle.truffle.r.nodes.builtin.fastr.FastRTreeNodeGen;
import com.oracle.truffle.r.nodes.builtin.fastr.FastRTreeStats;
import com.oracle.truffle.r.nodes.builtin.fastr.FastRTreeStatsNodeGen;
import com.oracle.truffle.r.nodes.builtin.fastr.FastRUseDebugMakevars;
import com.oracle.truffle.r.nodes.builtin.fastr.FastRUseDebugMakevarsNodeGen;
import com.oracle.truffle.r.nodes.builtin.fastr.FastrDqrls;
import com.oracle.truffle.r.nodes.builtin.fastr.FastrDqrlsNodeGen;
import com.oracle.truffle.r.nodes.builtin.fastr.memprof.FastRprofmem;
import com.oracle.truffle.r.nodes.builtin.fastr.memprof.FastRprofmemNodeGen;
import com.oracle.truffle.r.nodes.builtin.fastr.memprof.FastRprofmemShow;
import com.oracle.truffle.r.nodes.builtin.fastr.memprof.FastRprofmemShowNodeGen;
import com.oracle.truffle.r.nodes.builtin.fastr.memprof.FastRprofmemSnapshot;
import com.oracle.truffle.r.nodes.builtin.fastr.memprof.FastRprofmemSnapshotNodeGen;
import com.oracle.truffle.r.nodes.builtin.fastr.memprof.FastRprofmemSource;
import com.oracle.truffle.r.nodes.builtin.fastr.memprof.FastRprofmemSourceNodeGen;
import com.oracle.truffle.r.nodes.unary.UnaryArithmeticBuiltinNode;
import com.oracle.truffle.r.nodes.unary.UnaryArithmeticSpecial;
import com.oracle.truffle.r.nodes.unary.UnaryNotNode;
import com.oracle.truffle.r.nodes.unary.UnaryNotNodeGen;
import com.oracle.truffle.r.runtime.RInternalError;
import com.oracle.truffle.r.runtime.RVisibility;
import com.oracle.truffle.r.runtime.builtins.FastPathFactory;
import com.oracle.truffle.r.runtime.builtins.RBuiltin;
import com.oracle.truffle.r.runtime.context.RContext;
import com.oracle.truffle.r.runtime.data.RFunction;
import com.oracle.truffle.r.runtime.nodes.RFastPathNode;
import com.oracle.truffle.r.runtime.ops.BinaryArithmetic;
import com.oracle.truffle.r.runtime.ops.BinaryArithmetic.AddBuiltin;
import com.oracle.truffle.r.runtime.ops.BinaryArithmetic.DivBuiltin;
import com.oracle.truffle.r.runtime.ops.BinaryArithmetic.IntegerDivBuiltin;
import com.oracle.truffle.r.runtime.ops.BinaryArithmetic.ModBuiltin;
import com.oracle.truffle.r.runtime.ops.BinaryArithmetic.MultiplyBuiltin;
import com.oracle.truffle.r.runtime.ops.BinaryArithmetic.PowBuiltin;
import com.oracle.truffle.r.runtime.ops.BinaryArithmetic.SubtractBuiltin;
import com.oracle.truffle.r.runtime.ops.BinaryArithmeticFactory;
import com.oracle.truffle.r.runtime.ops.BinaryCompare;
import com.oracle.truffle.r.runtime.ops.BinaryCompare.EqualBuiltin;
import com.oracle.truffle.r.runtime.ops.BinaryCompare.GreaterBuiltin;
import com.oracle.truffle.r.runtime.ops.BinaryCompare.GreaterEqualBuiltin;
import com.oracle.truffle.r.runtime.ops.BinaryCompare.LessBuiltin;
import com.oracle.truffle.r.runtime.ops.BinaryCompare.LessEqualBuiltin;
import com.oracle.truffle.r.runtime.ops.BinaryCompare.NotEqualBuiltin;
import com.oracle.truffle.r.runtime.ops.BinaryLogic;
import com.oracle.truffle.r.runtime.ops.BinaryLogic.AndBuiltin;
import com.oracle.truffle.r.runtime.ops.BinaryLogic.NonVectorAndBuiltin;
import com.oracle.truffle.r.runtime.ops.BinaryLogic.NonVectorOrBuiltin;
import com.oracle.truffle.r.runtime.ops.BinaryLogic.OrBuiltin;
import com.oracle.truffle.r.runtime.ops.BooleanOperationFactory;
import com.oracle.truffle.r.runtime.ops.UnaryArithmetic;
import com.oracle.truffle.r.runtime.ops.UnaryArithmeticFactory;

public final class BasePackage extends RBuiltinPackage {

    public BasePackage(RContext context) {
        super(context, "base");

        /*
         * Primitive operations (these are really builtins, but not currently defined that way, so
         * we fake it). N.B. UnaryNotNode is annotated, but not loaded automatically because it is
         * not in the {nodes.builtin.base} package, (along with all the other nodes). A corollary of
         * this is that all the node classes referenced here must be annotated with
         */
        add(UnaryNotNode.class, UnaryNotNodeGen::create);

        addUnaryArithmetic(Ceiling.class, Ceiling::new);
        addUnaryArithmetic(Floor.class, Floor::new);
        addUnaryArithmetic(Trunc.class, Trunc::new);
        addUnaryArithmetic(Log10.class, Log10::new);
        addUnaryArithmetic(Log1p.class, Log1p::new);
        addUnaryArithmetic(Log2.class, Log2::new);
        addUnaryArithmetic(Abs.class, Abs::new);
        addUnaryArithmetic(Arg.class, Arg::new);
        addUnaryArithmetic(Conj.class, Conj::new);
        addUnaryArithmetic(Im.class, Im::new);
        addUnaryArithmetic(Mod.class, Mod::new);
        addUnaryArithmetic(Re.class, Re::new);
        addUnaryArithmetic(Sign.class, Sign::new);
        addUnaryArithmetic(Sqrt.class, Sqrt::new);
        addUnaryArithmetic(Acos.class, Acos::new);
        addUnaryArithmetic(Acosh.class, Acosh::new);
        addUnaryArithmetic(Asin.class, Asin::new);
        addUnaryArithmetic(Asinh.class, Asinh::new);
        addUnaryArithmetic(Atan.class, Atan::new);
        addUnaryArithmetic(Atanh.class, Atanh::new);
        addUnaryArithmetic(Cos.class, Cos::new);
        addUnaryArithmetic(Cosh.class, Cosh::new);
        addUnaryArithmetic(Cospi.class, Cospi::new);
        addUnaryArithmetic(Exp.class, Exp::new);
        addUnaryArithmetic(ExpM1.class, ExpM1::new);
        addUnaryArithmetic(Sin.class, Sin::new);
        addUnaryArithmetic(Sinh.class, Sinh::new);
        addUnaryArithmetic(Sinpi.class, Sinpi::new);
        addUnaryArithmetic(Tan.class, Tan::new);
        addUnaryArithmetic(Tanh.class, Tanh::new);
        addUnaryArithmetic(Tanpi.class, Tanpi::new);

        addBinaryArithmetic(AddBuiltin.class, BinaryArithmetic.ADD, UnaryArithmetic.PLUS);
        addBinaryArithmetic(SubtractBuiltin.class, BinaryArithmetic.SUBTRACT, UnaryArithmetic.NEGATE);
        addBinaryArithmetic(DivBuiltin.class, BinaryArithmetic.DIV, null);
        addBinaryArithmetic(IntegerDivBuiltin.class, BinaryArithmetic.INTEGER_DIV, null);
        addBinaryArithmetic(ModBuiltin.class, BinaryArithmetic.MOD, null);
        addBinaryArithmetic(MultiplyBuiltin.class, BinaryArithmetic.MULTIPLY, null);
        addBinaryArithmetic(PowBuiltin.class, BinaryArithmetic.POW, null);

        addBinaryCompare(EqualBuiltin.class, BinaryCompare.EQUAL);
        addBinaryCompare(NotEqualBuiltin.class, BinaryCompare.NOT_EQUAL);
        addBinaryCompare(GreaterEqualBuiltin.class, BinaryCompare.GREATER_EQUAL);
        addBinaryCompare(GreaterBuiltin.class, BinaryCompare.GREATER_THAN);
        addBinaryCompare(LessBuiltin.class, BinaryCompare.LESS_THAN);
        addBinaryCompare(LessEqualBuiltin.class, BinaryCompare.LESS_EQUAL);

        add(AndBuiltin.class, () -> BinaryBooleanNodeGen.create(BinaryLogic.AND));
        add(OrBuiltin.class, () -> BinaryBooleanNodeGen.create(BinaryLogic.OR));

        add(NonVectorAndBuiltin.class, () -> BinaryBooleanScalarNodeGen.create(BinaryLogic.NON_VECTOR_AND));
        add(NonVectorOrBuiltin.class, () -> BinaryBooleanScalarNodeGen.create(BinaryLogic.NON_VECTOR_OR));

        // Now load the rest of the builtins in "base"
        add(Abbrev.class, AbbrevNodeGen::create);
        add(APerm.class, APermNodeGen::create);
        add(All.class, AllNodeGen::create);
        add(AllNames.class, AllNamesNodeGen::create);
        add(Any.class, AnyNodeGen::create);
        add(AnyNA.class, AnyNANodeGen::create);
        add(Args.class, ArgsNodeGen::create);
        add(Array.class, ArrayNodeGen::create);
        add(AsCall.class, AsCallNodeGen::create);
        add(AsCharacter.class, AsCharacterNodeGen::create);
        add(AsCharacterFactor.class, AsCharacterFactorNodeGen::create);
        add(AsComplex.class, AsComplexNodeGen::create);
        add(AsDouble.class, AsDoubleNodeGen::create);
        add(AsFunction.class, AsFunctionNodeGen::create);
        add(AsInteger.class, AsIntegerNodeGen::create);
        add(AsLogical.class, AsLogicalNodeGen::create);
        add(SetS4Object.class, SetS4ObjectNodeGen::create);
        add(SetTimeLimit.class, SetTimeLimitNodeGen::create);
        add(AsRaw.class, AsRawNodeGen::create);
        add(AsVector.class, AsVectorNodeGen::create);
        add(Assign.class, AssignNodeGen::create);
        add(Attach.class, AttachNodeGen::create);
        add(Detach.class, DetachNodeGen::create);
        add(Attr.class, AttrNodeGen::create);
        add(Attributes.class, AttributesNodeGen::create);
        add(DiGamma.class, DiGammaNodeGen::create);
        add(Gamma.class, GammaNodeGen::create);
        add(Lgamma.class, LgammaNodeGen::create);
        add(TriGamma.class, TriGammaNodeGen::create);
        add(TetraGamma.class, TetraGammaNodeGen::create);
        add(PentaGamma.class, PentaGammaNodeGen::create);
        add(PsiGamma.class, PsiGammaNodeGen::create);
        add(BesselI.class, BesselINodeGen::create);
        add(BesselJ.class, BesselJNodeGen::create);
        add(BesselK.class, BesselKNodeGen::create);
        add(BesselY.class, BesselYNodeGen::create);
        add(Choose.class, ChooseNodeGen::create);
        add(LChoose.class, LChooseNodeGen::create);
        add(LBeta.class, LBetaNodeGen::create);
        add(BetaBuiltin.class, BetaBuiltinNodeGen::create);
        add(Bincode.class, BincodeNodeGen::create);
        add(CbindInternal.class, CbindInternalNodeGen::create);
        add(RbindInternal.class, RbindInternalNodeGen::create);
        add(BitwiseAnd.class, BitwiseAndNodeGen::create);
        add(BitwiseNot.class, BitwiseNotNodeGen::create);
        add(BitwiseOr.class, BitwiseOrNodeGen::create);
        add(BitwiseShiftL.class, BitwiseShiftLNodeGen::create);
        add(BitwiseShiftR.class, BitwiseShiftRNodeGen::create);
        add(BitwiseXor.class, BitwiseXorNodeGen::create);
        add(Body.class, BodyNodeGen::create);
        add(BrowserCondition.class, BrowserConditionNodeGen::create);
        add(BrowserNode.class, BrowserNodeGen::create);
        add(BrowserSetDebug.class, BrowserSetDebugNodeGen::create);
        add(BrowserText.class, BrowserTextNodeGen::create);
        add(Call.class, CallNodeGen::create);
        add(DotCall.class, DotCallNodeGen::create);
        add(DotCallGraphics.class, DotCallGraphicsNodeGen::create);
        add(DotExternal.class, DotExternalNodeGen::create);
        add(DotExternal2.class, DotExternal2NodeGen::create);
        add(DotExternalGraphics.class, DotExternalGraphicsNodeGen::create);
        add(Capabilities.class, CapabilitiesNodeGen::create);
        add(Cat.class, CatNodeGen::create);
        add(CharMatch.class, CharMatchNodeGen::create);
        add(Col.class, ColNodeGen::create);
        add(Colon.class, ColonNodeGen::create, Colon::special);
        add(ColMeans.class, ColMeansNodeGen::create);
        add(ColSums.class, ColSumsNodeGen::create);
        add(Combine.class, CombineNodeGen::create);
        add(CommandArgs.class, CommandArgsNodeGen::create);
        add(Comment.class, CommentNodeGen::create);
        add(Complex.class, ComplexNodeGen::create);
        add(CompilePKGS.class, CompilePKGSNodeGen::create);
        add(EnableJIT.class, EnableJITNodeGen::create);
        add(MkCode.class, MkCodeNodeGen::create);
        add(BcClose.class, BcCloseNodeGen::create);
        add(IsBuiltinInternal.class, IsBuiltinInternalNodeGen::create);
        add(Disassemble.class, DisassembleNodeGen::create);
        add(BcVersion.class, BcVersionNodeGen::create);
        add(LoadFromFile.class, LoadFromFileNodeGen::create);
        add(SaveToFile.class, SaveToFileNodeGen::create);
        add(Growconst.class, GrowconstNodeGen::create);
        add(Putconst.class, PutconstNodeGen::create);
        add(Getconst.class, GetconstNodeGen::create);
        add(AddCondHands.class, AddCondHandsNodeGen::create);
        add(AddRestart.class, AddRestartNodeGen::create);
        add(DfltStop.class, DfltStopNodeGen::create);
        add(DfltWarn.class, DfltWarnNodeGen::create);
        add(GetRestart.class, GetRestartNodeGen::create);
        add(Geterrmessage.class, GeterrmessageNodeGen::create);
        add(InvokeRestart.class, InvokeRestartNodeGen::create);
        add(PrintDeferredWarnings.class, PrintDeferredWarningsNodeGen::create);
        add(ResetCondHands.class, ResetCondHandsNodeGen::create);
        add(Seterrmessage.class, SeterrmessageNodeGen::create);
        add(SignalCondition.class, SignalConditionNodeGen::create);
        add(Close.class, CloseNodeGen::create);
        add(File.class, FileNodeGen::create);
        add(Flush.class, FlushNodeGen::create);
        add(GZFile.class, GZFileNodeGen::create);
        add(BZFile.class, BZFileNodeGen::create);
        add(XZFile.class, XZFileNodeGen::create);
        add(GZCon.class, GZConNodeGen::create);
        add(GetAllConnections.class, GetAllConnectionsNodeGen::create);
        add(GetConnection.class, GetConnectionNodeGen::create);
        add(IsOpen.class, IsOpenNodeGen::create);
        add(IsSeekable.class, IsSeekableNodeGen::create);
        add(Open.class, OpenNodeGen::create);
        add(PushBack.class, PushBackNodeGen::create);
        add(PushBackClear.class, PushBackClearNodeGen::create);
        add(PushBackLength.class, PushBackLengthNodeGen::create);
        add(ReadBin.class, ReadBinNodeGen::create);
        add(ReadChar.class, ReadCharNodeGen::create);
        add(ReadLines.class, ReadLinesNodeGen::create);
        add(Seek.class, SeekNodeGen::create);
        add(Truncate.class, TruncateNodeGen::create);
        add(SocketConnection.class, SocketConnectionNodeGen::create);
        add(RawConnection.class, RawConnectionNodeGen::create);
        add(RawConnectionValue.class, RawConnectionValueNodeGen::create);
        add(ChannelConnection.class, ChannelConnectionNodeGen::create);
        add(Fifo.class, FifoNodeGen::create);
        add(Pipe.class, PipeNodeGen::create);
        add(Stderr.class, StderrNodeGen::create);
        add(Stdin.class, StdinNodeGen::create);
        add(Stdout.class, StdoutNodeGen::create);
        add(Summary.class, SummaryNodeGen::create);
        add(TextConnection.class, TextConnectionNodeGen::create);
        add(TextConnectionValue.class, TextConnectionValueNodeGen::create);
        add(URLConnection.class, URLConnectionNodeGen::create);
        add(WriteBin.class, WriteBinNodeGen::create);
        add(WriteChar.class, WriteCharNodeGen::create);
        add(WriteLines.class, WriteLinesNodeGen::create);
        add(IsIncomplete.class, IsIncompleteNodeGen::create);
        add(Contributors.class, ContributorsNodeGen::create);
        add(CopyDFAttr.class, CopyDFAttrNodeGen::create);
        add(TCrossprod.class, CrossprodCommon.class, CrossprodCommon::createTCrossprod);
        add(Crossprod.class, CrossprodCommon.class, CrossprodCommon::createCrossprod);
        add(CRC64.class, CRC64NodeGen::create);
        add(CumMax.class, CumMaxNodeGen::create);
        add(CumMin.class, CumMinNodeGen::create);
        add(CumProd.class, CumProdNodeGen::create);
        add(CumSum.class, CumSumNodeGen::create);
        add(MaxCol.class, MaxCol::create);
        add(CacheClass.class, CacheClassNodeGen::create);
        add(CurlDownload.class, CurlDownloadNodeGen::create);
        add(Date.class, DateNodeGen::create);
        add(Date2POSIXlt.class, Date2POSIXltNodeGen::create);
        add(AsPOSIXct.class, AsPOSIXctNodeGen::create);
        add(AsPOSIXlt.class, AsPOSIXltNodeGen::create);
        add(FormatPOSIXlt.class, FormatPOSIXltNodeGen::create);
        add(POSIXlt2Date.class, POSIXlt2DateNodeGen::create);
        add(StrPTime.class, StrPTimeNodeGen::create);
        add(Debug.class, DebugNodeGen::create);
        add(DebugOnce.class, DebugOnceNodeGen::create);
        add(IsDebugged.class, IsDebuggedNodeGen::create);
        add(UnDebug.class, UnDebugNodeGen::create);
        add(DelayedAssign.class, DelayedAssignNodeGen::create);
        add(Deparse.class, DeparseNodeGen::create);
        add(Diag.class, DiagNodeGen::create);
        add(Dim.class, DimNodeGen::create);
        add(DimNames.class, DimNamesNodeGen::create);
        add(DoCall.class, DoCallNodeGen::create);
        add(DPut.class, DPutNodeGen::create);
        add(Dump.class, DumpNodeGen::create);
        add(Drop.class, DropNodeGen::create);
        add(AnyDuplicated.class, AnyDuplicatedNodeGen::create);
        add(Duplicated.class, DuplicatedNodeGen::create);
        add(DynLoad.class, DynLoadNodeGen::create);
        add(DynUnload.class, DynUnloadNodeGen::create);
        add(GetLoadedDLLs.class, GetLoadedDLLsNodeGen::create);
        add(GetSymbolInfo.class, GetSymbolInfoNodeGen::create);
        add(IsLoaded.class, IsLoadedNodeGen::create);
        add(ExtSoftVersion.class, ExtSoftVersionNodeGen::create);
        add(EApply.class, EApplyNodeGen::create);
        add(EncodeString.class, EncodeStringNodeGen::create);
        add(Encoding.class, EncodingNodeGen::create);
        add(SetEncoding.class, SetEncodingNodeGen::create);
        add(AsEnvironment.class, AsEnvironmentNodeGen::create);
        add(BaseEnv.class, BaseEnvNodeGen::create);
        add(BindingIsActive.class, BindingIsActiveNodeGen::create);
        add(BindingIsLocked.class, BindingIsLockedNodeGen::create);
        add(EmptyEnv.class, EmptyEnvNodeGen::create);
        add(EnvToList.class, EnvToListNodeGen::create);
        add(Environment.class, EnvironmentNodeGen::create);
        add(EnvironmentIsLocked.class, EnvironmentIsLockedNodeGen::create);
        add(EnvironmentName.class, EnvironmentNameNodeGen::create);
        add(GlobalEnv.class, GlobalEnvNodeGen::create);
        add(IsEnvironment.class, IsEnvironmentNodeGen::create);
        add(LockBinding.class, LockBindingNodeGen::create);
        add(LockEnvironment.class, LockEnvironmentNodeGen::create);
        add(MakeActiveBinding.class, MakeActiveBindingNodeGen::create);
        add(NewEnv.class, NewEnvNodeGen::create);
        add(ParentEnv.class, ParentEnvNodeGen::create);
        add(TopEnv.class, TopEnvNodeGen::create);
        add(Search.class, SearchNodeGen::create);
        add(SetParentEnv.class, SetParentEnvNodeGen::create);
        add(UnlockBinding.class, UnlockBindingNodeGen::create);
        add(Eval.class, EvalNodeGen::create);
        add(RecordGraphics.class, RecordGraphics::create);
        add(WithVisible.class, WithVisibleNodeGen::create, WithVisible::createSpecial);
        add(Exists.class, ExistsNodeGen::create);
        add(Expression.class, ExpressionNodeGen::create);
        add(FastRGetExecutor.class, FastRGetExecutor::new);
        add(CloseChannel.class, CloseChannelNodeGen::create);
        add(CreateChannel.class, CreateChannelNodeGen::create);
        add(CreateForkChannel.class, CreateForkChannelNodeGen::create);
        add(FastRContext.Eval.class, FastRContextFactory.EvalNodeGen::create);
        add(Get.class, Get::new);
        add(FastRContextNew.class, FastRContextNew::new);
        add(FastRContextClose.class, FastRContextClose::new);
        add(GetChannel.class, GetChannelNodeGen::create);
        add(ChannelPoll.class, ChannelPollNodeGen::create);
        add(ChannelReceive.class, ChannelReceiveNodeGen::create);
        add(ChannelSelect.class, ChannelSelectNodeGen::create);
        add(ChannelSend.class, ChannelSendNodeGen::create);
        add(Spawn.class, SpawnNodeGen::create);
        add(Interrupt.class, InterruptNodeGen::create);
        add(Join.class, JoinNodeGen::create);
        add(FastRRegisterFunctions.class, FastRRegisterFunctionsNodeGen::create);
        add(FastrDqrls.class, FastrDqrlsNodeGen::create);
        add(FastRDebug.class, FastRDebugNodeGen::create);
        add(FastRPatchPackage.class, FastRPatchPackageNodeGen::create);
        add(FastRDispatchNativeHandlers.class, FastRDispatchNativeHandlers::new);
        add(FastRInitEventLoop.class, FastRInitEventLoopNodeGen::create);
        add(FastRJavaGDResize.class, FastRJavaGDResize::new);
        add(FastRSetBreakpoint.class, FastRSetBreakpointNodeGen::create);
        add(FastRAddHelpPath.class, FastRAddHelpPath::create);
        add(FastRHelpPath.class, FastRHelpPathNodeGen::create);
        add(FastRHelpRd.class, FastRHelpRdNodeGen::create);
        add(FastRIdentity.class, FastRIdentityNodeGen::create);
        add(FastROptionBuiltin.class, FastROptionBuiltin::create);
        add(FastRTestsTry.class, FastRTestsTryNodeGen::create);
        add(FastRInteropTry.class, FastRInteropTryNodeGen::create);
        add(FastRInteropCheckException.class, FastRInteropCheckExceptionNodeGen::create);
        add(FastRInteropGetException.class, FastRInteropGetExceptionNodeGen::create);
        add(FastRInteropClearException.class, FastRInteropClearExceptionNodeGen::create);
        add(FastRInspect.class, FastRInspectNodeGen::create);
        add(FastRInspectFrame.class, FastRInspectFrameNodeGen::create);
        add(FastRInterop.Eval.class, FastRInteropFactory.EvalNodeGen::create);
        add(Export.class, ExportNodeGen::create);
        add(Import.class, ImportNodeGen::create);
        add(InteropNew.class, InteropNewNodeGen::create);
        add(IsExternal.class, IsExternalNodeGen::create);
        add(JavaType.class, JavaTypeNodeGen::create);
        add(JavaAddToClasspath.class, JavaAddToClasspathNodeGen::create);
        add(JavaIsIdentical.class, JavaIsIdenticalNodeGen::create);
        add(JavaIsAssignableFrom.class, JavaIsAssignableFromNodeGen::create);
        add(JavaIsInstance.class, JavaIsInstanceNodeGen::create);
        add(JavaAsTruffleObject.class, JavaAsTruffleObjectNodeGen::create);
        add(ToJavaArray.class, ToJavaArrayNodeGen::create);
        add(FastRInterop.AsVector.class, FastRInteropFactory.AsVectorNodeGen::create);
        add(ToByte.class, ToByteNodeGen::create);
        add(ToChar.class, ToCharNodeGen::create);
        add(ToFloat.class, ToFloatNodeGen::create);
        add(ToLong.class, ToLongNodeGen::create);
        add(ToShort.class, ToShortNodeGen::create);
        add(FastRRefCountInfo.class, FastRRefCountInfoNodeGen::create);
        add(FastRPkgSource.class, FastRPkgSourceNodeGen::create);
        add(FastRPrintError.class, FastRPrintErrorNodeGen::create);
        add(FastRRCallerTrace.class, FastRRCallerTrace::create);
        add(FastRSourceInfo.class, FastRSourceInfoNodeGen::create);
        add(FastRSetConsoleHandler.class, FastRSetConsoleHandlerNodeGen::create);
        add(FastRSetToolchain.class, FastRSetToolchainNodeGen::create);
        add(FastRStackTrace.class, FastRStackTraceNodeGen::create);
        add(FastRSlotAssign.class, FastRSlotAssignNodeGen::create);
        add(FastRSyntaxTree.class, FastRSyntaxTreeNodeGen::create);
        add(FastRGDSetGraphics.class, FastRGDSetGraphicsNodeGen::create);
        add(FastRSVGGetContent.class, FastRSVGGetContentNodeGen::create);
        add(FastRSVGFileName.class, FastRSVGFileNameNodeGen::create);
        add(FastRSVGSetFileName.class, FastRSVGSetFileNameNodeGen::create);
        add(FastRSavePlot.class, FastRSavePlotNodeGen::create);
        add(FastRThrowIt.class, FastRThrowItNodeGen::create);
        add(FastRThrowCompilerError.class, FastRThrowCompilerError::new);
        add(Trace.class, TraceNodeGen::create);
        add(Untrace.class, UntraceNodeGen::create);
        add(FastREmbedded.RCallbackIsOverridden.class, FastREmbeddedFactory.RCallbackIsOverriddenNodeGen::create);
        add(FastREmbedded.WriteConsole.class, FastREmbeddedFactory.WriteConsoleNodeGen::create);
        add(FastREmbedded.WriteErrConsole.class, FastREmbeddedFactory.WriteErrConsoleNodeGen::create);
        add(FastREmbedded.ReadConsole.class, FastREmbeddedFactory.ReadConsoleNodeGen::create);
        add(FastRTree.class, FastRTreeNodeGen::create);
        add(FastRTreeStats.class, FastRTreeStatsNodeGen::create);
        add(FastRUseDebugMakevars.class, FastRUseDebugMakevarsNodeGen::create);
        add(FastRprofmem.class, FastRprofmemNodeGen::create);
        add(FastRprofmemShow.class, FastRprofmemShowNodeGen::create);
        add(FastRprofmemSource.class, FastRprofmemSourceNodeGen::create);
        add(FastRprofmemSnapshot.class, FastRprofmemSnapshotNodeGen::create);
        add(FastRLibPaths.class, FastRLibPathsNodeGen::create);
        add(BaseName.class, BaseNameNodeGen::create);
        add(DirCreate.class, DirCreateNodeGen::create);
        add(DirExists.class, DirExistsNodeGen::create);
        add(DirName.class, DirNameNodeGen::create);
        add(FileAccess.class, FileAccessNodeGen::create);
        add(FileAppend.class, FileAppendNodeGen::create);
        add(FileCopy.class, FileCopyNodeGen::create);
        add(FileCreate.class, FileCreateNodeGen::create);
        add(FileExists.class, FileExistsNodeGen::create);
        add(FileInfo.class, FileInfoNodeGen::create);
        add(FileLink.class, FileLinkNodeGen::create);
        add(FilePath.class, FilePathNodeGen::create);
        add(FileRemove.class, FileRemoveNodeGen::create);
        add(FileRename.class, FileRenameNodeGen::create);
        add(FileShow.class, FileShowNodeGen::create);
        add(FileSymLink.class, FileSymLinkNodeGen::create);
        add(ListFiles.class, ListFilesNodeGen::create);
        add(ListDirs.class, ListDirsNodeGen::create);
        add(Unlink.class, UnlinkNodeGen::create);
        add(FindInterval.class, FindIntervalNodeGen::create);
        add(ForceAndCall.class, ForceAndCallNodeGen::create);
        add(Formals.class, FormalsNodeGen::create);
        add(Format.class, FormatNodeGen::create);
        add(FormatC.class, FormatCNodeGen::create);
        add(FormatInfo.class, FormatInfoNodeGen::create);
        add(DotC.class, DotCNodeGen::create);
        add(DotFortran.class, DotFortranNodeGen::create);
        add(MatchCall.class, MatchCallNodeGen::create);
        add(ParentFrame.class, ParentFrameNodeGen::create);
        add(PosToEnv.class, PosToEnv::create);
        add(SysCall.class, SysCallNodeGen::create);
        add(SysCalls.class, SysCallsNodeGen::create);
        add(SysFrame.class, SysFrameNodeGen::create);
        add(SysFrames.class, SysFramesNodeGen::create);
        add(SysFunction.class, SysFunctionNodeGen::create);
        add(SysNFrame.class, SysNFrameNodeGen::create);
        add(SysParent.class, SysParentNodeGen::create);
        add(SysParents.class, SysParentsNodeGen::create);
        add(Gc.class, GcNodeGen::create);
        add(Gctorture.class, GctortureNodeGen::create);
        add(Gctorture2.class, Gctorture2NodeGen::create);
        add(GetClass.class, GetClassNodeGen::create);
        add(GetFunctions.Get.class, GetNodeGen::create);
        add(Get0.class, Get0NodeGen::create);
        add(MGet.class, MGetNodeGen::create);
        add(GetOption.class, GetOptionNodeGen::create);
        add(GetText.class, GetTextNodeGen::create);
        add(Getwd.class, GetwdNodeGen::create);
        add(AGrep.class, AGrepNodeGen::create);
        add(AGrepL.class, AGrepLNodeGen::create);
        add(GSub.class, GSubNodeGen::create);
        add(Gregexpr.class, GregexprNodeGen::create);
        add(Grep.class, GrepNodeGen::create);
        add(GrepL.class, GrepLNodeGen::create);
        add(Regexpr.class, RegexprNodeGen::create);
        add(Regexec.class, RegexecNodeGen::create);
        add(Strsplit.class, StrsplitNodeGen::create);
        add(Sub.class, SubNodeGen::create);
        add(GrepRaw.class, GrepRawNodeGen::create);
        add(GetRegisteredRoutines.class, GetRegisteredRoutinesNodeGen::create);
        add(ImportIntoEnv.class, ImportIntoEnvNodeGen::create);
        add(LazyLoadDBFetch.class, LazyLoadDBFetchNodeGen::create);
        add(LazyLoadDBFlush.class, LazyLoadDBFlushNodeGen::create);
        add(MakeLazy.class, MakeLazyNodeGen::create);
        add(GetVarsFromFrame.class, GetVarsFromFrameNodeGen::create);
        add(LazyLoadDBinsertValue.class, LazyLoadDBinsertValueNodeGen::create);
        add(IConv.class, IConvNodeGen::create);
        add(Identical.class, Identical::create);
        add(InheritsBuiltin.class, InheritsBuiltinNodeGen::create);
        add(Inspect.class, InspectNodeGen::create);
        add(Interactive.class, InteractiveNodeGen::create);
        add(Internal.class, InternalNodeGen::create);
        add(InternalsID.class, InternalsIDNodeGen::create);
        add(IntToBits.class, IntToBitsNodeGen::create);
        add(IntToUtf8.class, IntToUtf8NodeGen::create);
        add(Invisible.class, InvisibleNodeGen::create);
        add(IsATTY.class, IsATTYNodeGen::create);
        add(IsFinite.class, IsFiniteNodeGen::create);
        add(IsInfinite.class, IsInfiniteNodeGen::create);
        add(IsNaN.class, IsNaNNodeGen::create);
        add(IsListFactor.class, IsListFactorNodeGen::create);
        add(IsMethodsDispatchOn.class, IsMethodsDispatchOnNodeGen::create);
        add(IsNA.class, IsNANodeGen::create);
        add(IsS4.class, IsS4NodeGen::create);
        add(IsArray.class, IsArrayNodeGen::create);
        add(IsAtomic.class, IsAtomicNodeGen::create);
        add(IsCall.class, IsCallNodeGen::create);
        add(IsCharacter.class, IsCharacterNodeGen::create);
        add(IsComplex.class, IsComplexNodeGen::create);
        add(IsDouble.class, IsDoubleNodeGen::create);
        add(IsExpression.class, IsExpressionNodeGen::create);
        add(IsFunction.class, IsFunctionNodeGen::create);
        add(IsInteger.class, IsIntegerNodeGen::create);
        add(IsLanguage.class, IsLanguageNodeGen::create);
        add(IsList.class, IsListNodeGen::create);
        add(IsLogical.class, IsLogicalNodeGen::create);
        add(IsMatrix.class, IsMatrixNodeGen::create);
        add(IsName.class, IsNameNodeGen::create);
        add(IsNull.class, IsNullNodeGen::create);
        add(IsNumeric.class, IsNumericNodeGen::create);
        add(IsObject.class, IsObjectNodeGen::create);
        add(IsPairList.class, IsPairListNodeGen::create);
        add(IsRaw.class, IsRawNodeGen::create);
        add(IsRecursive.class, IsRecursiveNodeGen::create);
        add(IsVector.class, IsVectorNodeGen::create);
        add(IsUnsorted.class, IsUnsortedNodeGen::create);
        add(SortedFastPass.class, SortedFastPass::create);
        add(WrapMeta.class, WrapMeta::create);
        add(DotDotDotLength.class, DotDotDotLength::create);
        add(DotDotDotElt.class, DotDotDotElt::create);
        add(ValidUTF8.class, ValidUTF8NodeGen::create);
        add(DetGeReal.class, DetGeRealNodeGen::create);
        add(LaChol.class, LaCholNodeGen::create);
        add(LaChol2Inv.class, LaChol2InvNodeGen::create);
        add(Qr.class, QrNodeGen::create);
        add(QrCoefReal.class, QrCoefRealNodeGen::create);
        add(QrCoefCmplx.class, QrCoefCmplxNodeGen::create);
        add(Rg.class, RgNodeGen::create);
        add(Rs.class, RsNodeGen::create);
        add(Version.class, VersionNodeGen::create);
        add(LaSolve.class, LaSolveNodeGen::create);
        add(Svd.class, SvdNodeGen::create);
        add(LaLibrary.class, LaLibraryNodeGen::create);
        add(Backsolve.class, BacksolveNodeGen::create);
        add(Lapply.class, LapplyNodeGen::create);
        add(Rapply.class, RapplyNodeGen::create);
        add(Length.class, LengthNodeGen::create);
        add(Lengths.class, LengthsNodeGen::create);
        add(License.class, LicenseNodeGen::create);
        add(ListBuiltin.class, ListBuiltinNodeGen::create);
        add(List2Env.class, List2EnvNodeGen::create);
        add(Load.class, LoadNodeGen::create);
        add(LoadFromConn2.class, LoadFromConn2NodeGen::create);
        add(LoadInfoFromConn2.class, LoadInfoFromConn2NodeGen::create);
        add(SaveToConn.class, SaveToConnNodeGen::create);
        add(BindTextDomain.class, BindTextDomainNodeGen::create);
        add(Enc2Native.class, Enc2NativeNodeGen::create);
        add(Enc2Utf8.class, Enc2Utf8NodeGen::create);
        add(GetLocale.class, GetLocaleNodeGen::create);
        add(L10nInfo.class, L10nInfoNodeGen::create);
        add(LocaleConv.class, LocaleConvNodeGen::create);
        add(SetLocale.class, SetLocaleNodeGen::create);
        add(Log.class, LogNodeGen::create);
        add(Ls.class, LsNodeGen::create);
        add(MakeNames.class, MakeNamesNodeGen::create);
        add(MakeUnique.class, MakeUniqueNodeGen::create);
        add(Mapply.class, MapplyNodeGen::create);
        add(MatMult.class, MatMult::create);
        add(Match.class, MatchNodeGen::create);
        add(MatchFun.class, MatchFunNodeGen::create);
        add(Matrix.class, MatrixNodeGen::create);
        add(Max.class, MaxNodeGen::create);
        add(Mean.class, MeanNodeGen::create);
        add(Merge.class, MergeNodeGen::create);
        add(Min.class, MinNodeGen::create);
        add(Missing.class, MissingNodeGen::create);
        add(NArgs.class, NArgsNodeGen::create);
        add(NChar.class, NCharNodeGen::create);
        add(NGetText.class, NGetTextNodeGen::create);
        add(NZChar.class, NZCharNodeGen::create);
        add(Names.class, NamesNodeGen::create);
        add(GetNamespaceRegistry.class, GetNamespaceRegistryNodeGen::create);
        add(GetRegisteredNamespace.class, GetRegisteredNamespaceNodeGen::create);
        add(IsNamespaceEnv.class, IsNamespaceEnvNodeGen::create);
        add(IsRegisteredNamespace.class, IsRegisteredNamespaceNodeGen::create);
        add(RegisterNamespace.class, RegisterNamespaceNodeGen::create);
        add(UnregisterNamespace.class, UnregisterNamespaceNodeGen::create);
        add(NormalizePath.class, NormalizePathNodeGen::create);
        add(OldClass.class, OldClassNodeGen::create);
        add(OnExit.class, OnExitNodeGen::create);
        add(Options.class, OptionsNodeGen::create);
        add(Order.class, OrderNodeGen::create);
        add(PCREConfig.class, PCREConfigNodeGen::create);
        add(PMatch.class, PMatchNodeGen::create);
        add(PMax.class, PMaxNodeGen::create);
        add(PMin.class, PMinNodeGen::create);
        add(PackBits.class, PackBitsNodeGen::create);
        add(Parse.class, ParseNodeGen::create);
        add(Paste.class, PasteNodeGen::create);
        add(Paste0.class, Paste0NodeGen::create);
        add(PathExpand.class, PathExpandNodeGen::create);
        add(Polyroot.class, PolyrootNodeGen::create);
        add(Pretty.class, PrettyNodeGen::create);
        add(Primitive.class, PrimitiveNodeGen::create);
        add(PrintDefault.class, PrintDefaultNodeGen::create);
        add(ProcTime.class, ProcTimeNodeGen::create);
        add(Prod.class, ProdNodeGen::create);
        add(Quit.class, QuitNodeGen::create);
        add(Quote.class, QuoteNodeGen::create);
        add(Range.class, RangeNodeGen::create);
        add(Rank.class, RankNodeGen::create);
        add(RNGkind.class, RNGkindNodeGen::create);
        add(SetSeed.class, SetSeedNodeGen::create);
        add(FastRSetSeed.class, FastRSetSeedNodeGen::create);
        add(RVersion.class, RVersionNodeGen::create);
        add(CharToRaw.class, CharToRawNodeGen::create);
        add(RawToChar.class, RawToCharNodeGen::create);
        add(RawShift.class, RawShiftNodeGen::create);
        add(RawToBits.class, RawToBitsNodeGen::create);
        add(ReadDCF.class, ReadDCFNodeGen::create);
        add(ReadREnviron.class, ReadREnvironNodeGen::create);
        add(Readline.class, ReadlineNodeGen::create);
        add(Recall.class, RecallNodeGen::create);
        add(RegFinalizer.class, RegFinalizerNodeGen::create);
        add(Repeat.class, RepeatNodeGen::create);
        add(RepeatInternal.class, RepeatInternalNodeGen::create);
        add(RepeatLength.class, RepeatLengthNodeGen::create);
        add(Return.class, ReturnNodeGen::create, Return::createSpecial);
        add(Rhome.class, RhomeNodeGen::create);
        add(Rm.class, RmNodeGen::create);
        add(Round.class, RoundNodeGen::create);
        add(Row.class, RowNodeGen::create);
        add(RowMeans.class, RowMeansNodeGen::create);
        add(RowSums.class, RowSumsNodeGen::create);
        add(Rowsum.class, RowsumNodeGen::create);
        add(NextMethod.class, NextMethodNodeGen::create);
        add(UseMethod.class, UseMethodNodeGen::create);
        add(Sample.class, SampleNodeGen::create);
        add(Sample2.class, Sample2NodeGen::create);
        add(Scan.class, ScanNodeGen::create);
        add(SeqInt.class, SeqIntNodeGen::create);
        add(SeqAlong.class, SeqAlongNodeGen::create);
        add(SeqLen.class, SeqLenNodeGen::create);
        add(Serialize.class, SerializeNodeGen::create);
        add(SerializeB.class, SerializeBNodeGen::create);
        add(SerializeToConn.class, SerializeToConnNodeGen::create);
        add(Unserialize.class, UnserializeNodeGen::create);
        add(UnserializeFromConn.class, UnserializeFromConnNodeGen::create);
        add(SerializeInfoFromConn.class, SerializeInfoFromConnNodeGen::create);
        add(Setwd.class, SetwdNodeGen::create);
        add(ShortRowNames.class, ShortRowNamesNodeGen::create);
        add(Signif.class, SignifNodeGen::create);
        add(Sink.class, SinkNodeGen::create);
        add(SinkNumber.class, SinkNumberNodeGen::create);
        add(Slot.class, SlotNodeGen::create);
        add(SockSelect.class, SockSelectNodeGen::create);
        add(PartialSort.class, PartialSortNodeGen::create);
        add(QSort.class, QSortNodeGen::create);
        add(RadixSort.class, RadixSortNodeGen::create);
        add(Sort.class, SortNodeGen::create);
        add(Split.class, SplitNodeGen::create);
        add(Sprintf.class, SprintfNodeGen::create);
        add(StandardGeneric.class, StandardGenericNodeGen::create);
        add(StartsWith.class, StartsWithNodeGen::create);
        add(EndsWith.class, EndsWithNodeGen::create);
        add(Stop.class, StopNodeGen::create);
        add(Str2Expression.class, Str2ExpressionNodeGen::create);
        add(Str2Lang.class, Str2LangNodeGen::create);
        add(Strtoi.class, StrtoiNodeGen::create);
        add(Strrep.class, StrrepNodeGen::create);
        add(Strtrim.class, StrtrimNodeGen::create);
        add(Substitute.class, SubstituteNodeGen::create);
        add(Substr.class, SubstrNodeGen::create);
        add(Sum.class, SumNodeGen::create);
        add(Switch.class, SwitchNodeGen::create);
        add(SysChmod.class, SysChmodNodeGen::create);
        add(SysGetenv.class, SysGetenvNodeGen::create);
        add(SysGetpid.class, SysGetpidNodeGen::create);
        add(SysGlob.class, SysGlobNodeGen::create);
        add(SysInfo.class, SysInfoNodeGen::create);
        add(SysReadlink.class, SysReadlinkNodeGen::create);
        add(SysSetEnv.class, SysSetEnvNodeGen::create);
        add(SysSetFileTime.class, SysSetFileTimeNodeGen::create);
        add(SysSleep.class, SysSleepNodeGen::create);
        add(SysTime.class, SysTimeNodeGen::create);
        add(SysUmask.class, SysUmaskNodeGen::create);
        add(SysUnSetEnv.class, SysUnSetEnvNodeGen::create);
        add(SystemFunction.class, SystemFunctionNodeGen::create);
        add(Tabulate.class, TabulateNodeGen::create);
        add(TempDir.class, TempDirNodeGen::create);
        add(TempFile.class, TempFileNodeGen::create);
        add(CharTr.class, CharTr::create);
        add(ToLower.class, ToLowerNodeGen::create);
        add(ToUpper.class, ToUpperNodeGen::create);
        add(Traceback.class, TracebackNodeGen::create);
        add(PrimTrace.class, PrimTraceNodeGen::create);
        add(PrimUnTrace.class, PrimUnTraceNodeGen::create);
        add(TraceOnOff.class, TraceOnOffNodeGen::create);
        add(Tracemem.class, TracememNodeGen::create);
        add(Retracemem.class, RetracememNodeGen::create);
        add(Untracemem.class, UntracememNodeGen::create);
        add(Transpose.class, TransposeNodeGen::create);
        add(Atan2.class, Atan2NodeGen::create);
        add(Typeof.class, TypeofNodeGen::create);
        add(UnClass.class, UnClassNodeGen::create);
        add(Unique.class, UniqueNodeGen::create);
        add(Unlist.class, UnlistNodeGen::create);
        add(UpdateAttr.class, UpdateAttrNodeGen::create);
        add(UpdateAttributes.class, UpdateAttributesNodeGen::create);
        add(UpdateClass.class, UpdateClassNodeGen::create);
        add(UpdateComment.class, UpdateCommentNodeGen::create);
        add(UpdateDim.class, UpdateDimNodeGen::create);
        add(UpdateDimNames.class, UpdateDimNamesNodeGen::create);
        add(Utf8ToInt.class, Utf8ToIntNodeGen::create);
        add(UpdateEnvironment.class, UpdateEnvironmentNodeGen::create);
        add(UpdateLength.class, UpdateLengthNodeGen::create);
        add(UpdateLevels.class, UpdateLevelsNodeGen::create);
        add(UpdateNames.class, UpdateNamesNodeGen::create);
        add(UpdateOldClass.class, UpdateOldClassNodeGen::create);
        add(UpdateSlot.class, UpdateSlotNodeGen::create);
        add(UpdateStorageMode.class, UpdateStorageModeNodeGen::create);
        add(UpdateSubstr.class, UpdateSubstrNodeGen::create);
        add(ValidEnc.class, ValidEncNodeGen::create);
        add(VApply.class, VApplyNodeGen::create);
        add(Vector.class, VectorNodeGen::create);
        add(Warning.class, WarningNodeGen::create);
        add(Which.class, WhichNodeGen::create);
        add(WhichMax.class, WhichMax::create);
        add(WhichMin.class, WhichMin::create);
        add(Xtfrm.class, XtfrmNodeGen::create);
        add(IsSingle.class, IsSingleNodeGen::create);

        // infix functions
        add(Subscript.class, SubscriptNodeGen::create, Subscript::special);
        add(DefaultBuiltin.class, SubscriptNodeGen::create, Subscript::special);
        add(Subset.class, SubsetNodeGen::create, Subset::special);
        add(Subset.DefaultBuiltin.class, SubsetNodeGen::create, Subset::special);
        add(AccessField.class, AccessFieldNodeGen::create, AccessField::createSpecial);
        add(AssignBuiltin.class, AssignBuiltinNodeGen::create);
        add(AssignBuiltinEq.class, AssignBuiltinEqNodeGen::create);
        add(AssignOuterBuiltin.class, AssignOuterBuiltinNodeGen::create);
        add(BraceBuiltin.class, BraceBuiltinNodeGen::create);
        add(BreakBuiltin.class, BreakBuiltinNodeGen::create);
        add(ForBuiltin.class, ForBuiltinNodeGen::create);
        add(FunctionBuiltin.class, FunctionBuiltin::create);
        add(IfBuiltin.class, IfBuiltinNodeGen::create);
        add(NextBuiltin.class, NextBuiltinNodeGen::create);
        add(ParenBuiltin.class, ParenBuiltin::new, ParenBuiltin::special);
        add(RepeatBuiltin.class, RepeatBuiltinNodeGen::create);
        add(Tilde.class, TildeNodeGen::create);
        add(UpdateSubscript.class, UpdateSubscriptNodeGen::create, UpdateSubscript::special);
        add(UpdateSubset.class, UpdateSubsetNodeGen::create, UpdateSubset::special);
        add(UpdateField.class, UpdateFieldNodeGen::create, UpdateField::createSpecial);
        add(WhileBuiltin.class, WhileBuiltinNodeGen::create);
    }

    private void addBinaryArithmetic(Class<?> builtinClass, BinaryArithmeticFactory binaryFactory, UnaryArithmeticFactory unaryFactory) {
        add(builtinClass, new BinaryArithmeticBuiltinFactory(binaryFactory, unaryFactory), BinaryArithmeticSpecial.createSpecialFactory(binaryFactory, unaryFactory));
    }

    private void addUnaryArithmetic(Class<?> builtinClass, UnaryArithmeticFactory unaryFactory) {
        add(builtinClass, new UnaryArithmeticBuiltinFactory(unaryFactory), UnaryArithmeticSpecial.createSpecialFactory(unaryFactory));
    }

    private void addBinaryCompare(Class<?> builtinClass, BooleanOperationFactory factory) {
        add(builtinClass, new BinaryCompareBuiltinFactory(factory), BinaryBooleanSpecial.createSpecialFactory(factory));
    }

    private static final class BinaryArithmeticBuiltinFactory implements Supplier<RBuiltinNode> {
        private final BinaryArithmeticFactory binaryFactory;
        private final UnaryArithmeticFactory unaryFactory;

        BinaryArithmeticBuiltinFactory(BinaryArithmeticFactory binaryFactory, UnaryArithmeticFactory unaryFactory) {
            this.binaryFactory = binaryFactory;
            this.unaryFactory = unaryFactory;
        }

        @Override
        public RBuiltinNode get() {
            return BinaryArithmeticNodeGen.create(binaryFactory, unaryFactory);
        }
    }

    private static final class UnaryArithmeticBuiltinFactory implements Supplier<RBuiltinNode> {
        private final UnaryArithmeticFactory unaryFactory;

        UnaryArithmeticBuiltinFactory(UnaryArithmeticFactory unaryFactory) {
            this.unaryFactory = unaryFactory;
        }

        @Override
        public RBuiltinNode get() {
            return new UnaryArithmeticBuiltinNode(unaryFactory);
        }
    }

    private static final class BinaryCompareBuiltinFactory implements Supplier<RBuiltinNode> {
        private final BooleanOperationFactory factory;

        BinaryCompareBuiltinFactory(BooleanOperationFactory factory) {
            this.factory = factory;
        }

        @Override
        public RBuiltinNode get() {
            return BinaryBooleanNodeGen.create(factory);
        }
    }

    private static void addFastPath(MaterializedFrame baseFrame, String name, FastPathFactory factory) {
        RFunction function = ReadVariableNode.lookupFunction(name, baseFrame);
        if (function == null) {
            throw new RInternalError("failed adding the fast path for the R function " + name +
                            ". The function was not found. This could be due to previous errors that prevented it from being loaded.");
        }
        ((RRootNode) function.getRootNode()).setFastPath(factory);
    }

    private static void addFastPath(MaterializedFrame baseFrame, String name, Supplier<RFastPathNode> factory, RVisibility visibility) {
        addFastPath(baseFrame, name, FastPathFactory.fromVisibility(visibility, factory));
    }

    private static void addFastPath(MaterializedFrame baseFrame, String name, Supplier<RFastPathNode> factory, Class<?> builtinNodeClass) {
        RBuiltin builtin = builtinNodeClass.getAnnotation(RBuiltin.class);
        addFastPath(baseFrame, name, FastPathFactory.fromRBuiltin(builtin, factory));
    }

    @Override
    public void loadOverrides(MaterializedFrame baseFrame) {
        super.loadOverrides(baseFrame);
        addFastPath(baseFrame, "[[.data.frame", SubscriptDataFrameFastPathNodeGen::create, RVisibility.ON);
        addFastPath(baseFrame, "[.data.frame", SubsetDataFrameFastPath.createFastPathFactory(SubsetDataFrameFastPathNodeGen::create));
        addFastPath(baseFrame, "matrix", MatrixFastPathNodeGen::create, Matrix.class);
        addFastPath(baseFrame, "setdiff", SetDiffFastPathNodeGen::create, RVisibility.ON);
        addFastPath(baseFrame, "get", GetFastPathNodeGen::create, RVisibility.ON);
        addFastPath(baseFrame, "exists", ExistsFastPathNodeGen::create, Exists.class);
        addFastPath(baseFrame, "assign", AssignFastPathNodeGen::create, Assign.class);
        addFastPath(baseFrame, "is.element", IsElementFastPathNodeGen::create, RVisibility.ON);
        addFastPath(baseFrame, "integer", IntegerFastPathNodeGen::create, RVisibility.ON);
        addFastPath(baseFrame, "numeric", DoubleFastPathNodeGen::create, RVisibility.ON);
        addFastPath(baseFrame, "double", DoubleFastPathNodeGen::create, RVisibility.ON);
        addFastPath(baseFrame, "complex", ComplexFastPathNodeGen::create, RVisibility.ON);
        addFastPath(baseFrame, "intersect", IntersectFastPathNodeGen::create, RVisibility.ON);
        addFastPath(baseFrame, "pmax", FastPathFactory.EVALUATE_ARGS);
        addFastPath(baseFrame, "pmin", FastPathFactory.EVALUATE_ARGS);
        addFastPath(baseFrame, "cbind", FastPathFactory.FORCED_EAGER_ARGS);
        addFastPath(baseFrame, "rbind", FastPathFactory.FORCED_EAGER_ARGS);
        addFastPath(baseFrame, "seq.default", SeqFunctionsFactory.SeqDefaultFastPathNodeGen::create, RVisibility.ON);
        addFastPath(baseFrame, "seq", SeqFunctionsFactory.SeqFastPathNodeGen::create, RVisibility.ON);
        addFastPath(baseFrame, "match.arg", MatchArgFastPathNodeGen::create, MatchArgFastPath.class);
        addFastPath(baseFrame, "stopifnot", StopifnotFastPath::new, StopifnotFastPath.class);

        setContainsDispatch(baseFrame, "eval", "[.data.frame", "[[.data.frame", "[<-.data.frame", "[[<-.data.frame");
    }

    private static void setContainsDispatch(MaterializedFrame baseFrame, String... functions) {
        for (String name : functions) {
            RFunction function = ReadVariableNode.lookupFunction(name, baseFrame);
            ((RRootNode) function.getRootNode()).setContainsDispatch(true);
        }
    }
}
