% Copyright (c) 2019, Oracle and/or its affiliates. All rights reserved.
% DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
%
% This code is free software; you can redistribute it and/or modify it
% under the terms of the GNU General Public License version 3 only, as
% published by the Free Software Foundation.
%
% This code is distributed in the hope that it will be useful, but WITHOUT
% ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
% FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
% version 3 for more details (a copy is included in the LICENSE file that
% accompanied this code).
%
% You should have received a copy of the GNU General Public License version
% 3 along with this work; if not, write to the Free Software Foundation,
% Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
%
% Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
% or visit www.oracle.com if you need additional information or have any
% questions.

% Initial version generated by roxygen2
\name{fastr.setToolchain}
\alias{fastr.setToolchain}
\title{Sets the compiler toolchain used to compile native code in packages.}
\usage{
fastr.setToolchain(name)
}
\arguments{
\item{name}{the name of the compiler toolchain. Currently only 'native' and 'llvm' are valid values.
'native' denotes the toolchain on the host and 'llvm' stands for the LLVM toolchain, which is distributed as part of GraalVM. }
}
\description{
By default, to build the native code of packages FastR uses a modified version of the Clang compiler distributed as part of the LLVM langauage.
The main benefit of using this compiler is that the resulting native libraries contain both native and LLVM code, which allows for
loading a package library by the FastR's LLVM loader and debugging the native code. A user can deactivate this default compiler toolchain and
switch back to the native one by means of this function.
}
\examples{
fastr.setToolchain('native') # switches back to the native toolchain
fastr.setToolchain('llvm')   # restores the LLVM toolchain
}
\seealso{
\code{\link{fastr.useDebugMakevars}}
}

