% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/g.R
\name{g}
\alias{g}
\title{Execute code by GraalVM using the language interpreter that corresponds
to the language mimetype.}
\usage{
g(code, echo = TRUE, mimetype = "application/x-r")
}
\arguments{
\item{code}{the code to be executed. It must be a language element as long as the target
language is R, otherwise it must be a string.}

\item{echo}{controls whether this function returns the result of the interpreted code.
The default value is TRUE.}

\item{mimetype}{The mimetype of the target language. Currently supported values are
"application/x-r", "text/javascript" and "application/x-ruby".}
}
\description{
Execute code by GraalVM using the language interpreter that corresponds
to the language mimetype.
}
\examples{
g(runif(10^3))
g(runif(10^8), echo = FALSE) # We do not want that the result is returned due to its size
g("1 < 2", mimetype = "text/javascript")
}
\seealso{
Other execution functions: \code{\link{g.js}},
  \code{\link{g.rb}}, \code{\link{g.r}}
}
