/*
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the Free
 * Software Foundation; either version 2 of the License, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
 * more details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 * Copyright (c) 2014, Purdue University
 * Copyright (c) 2014, 2018, Oracle and/or its affiliates
 *
 * All rights reserved.
 */
package com.oracle.truffle.r.test.builtins;

import org.junit.Test;

import com.oracle.truffle.r.test.TestBase;

// Checkstyle: stop line length check
public class TestBuiltin_cosh extends TestBase {

    @Test
    public void testcosh1() {
        assertEval("argv <- list(logical(0));cosh(argv[[1]]);");
    }

    @Test
    public void testcosh2() {
        assertEval("argv <- list(FALSE);cosh(argv[[1]]);");
    }

    @Test
    public void testcosh3() {
        assertEval("argv <- list(structure(numeric(0), .Dim = c(0L, 0L)));cosh(argv[[1]]);");
    }

    @Test
    public void testcosh4() {
        assertEval("argv <- list(c(-3, -2.96984924623116, -2.93969849246231, -2.90954773869347, -2.87939698492462, -2.84924623115578, -2.81909547738693, -2.78894472361809, -2.75879396984925, -2.7286432160804, -2.69849246231156, -2.66834170854271, -2.63819095477387, -2.60804020100502, -2.57788944723618, -2.54773869346734, -2.51758793969849, -2.48743718592965, -2.4572864321608, -2.42713567839196, -2.39698492462312, -2.36683417085427, -2.33668341708543, -2.30653266331658, -2.27638190954774, -2.24623115577889, -2.21608040201005, -2.18592964824121, -2.15577889447236, -2.12562814070352, -2.09547738693467, -2.06532663316583, -2.03517587939699, -2.00502512562814, -1.9748743718593, -1.94472361809045, -1.91457286432161, -1.88442211055276, -1.85427135678392, -1.82412060301508, -1.79396984924623, -1.76381909547739, -1.73366834170854, -1.7035175879397, -1.67336683417085, -1.64321608040201, -1.61306532663317, -1.58291457286432, -1.55276381909548, -1.52261306532663, -1.49246231155779, -1.46231155778894, -1.4321608040201, -1.40201005025126, -1.37185929648241, -1.34170854271357, -1.31155778894472, -1.28140703517588, -1.25125628140704, -1.22110552763819, -1.19095477386935, -1.1608040201005, -1.13065326633166, -1.10050251256281, -1.07035175879397, -1.04020100502513, -1.01005025125628, -0.979899497487437, -0.949748743718593, -0.919597989949749, -0.889447236180905, -0.859296482412061, -0.829145728643216, -0.798994974874372, -0.768844221105528, -0.738693467336684, -0.708542713567839, -0.678391959798995, -0.648241206030151, -0.618090452261307, -0.587939698492463, -0.557788944723618, -0.527638190954774, -0.49748743718593, -0.467336683417086, -0.437185929648241, -0.407035175879397, -0.376884422110553, -0.346733668341709, -0.316582914572864, -0.28643216080402, -0.256281407035176, -0.226130653266332, -0.195979899497488, -0.165829145728643, -0.135678391959799, -0.105527638190955, -0.0753768844221105, -0.0452261306532664, -0.0150753768844223, 0.0150753768844218, 0.0452261306532664, 0.0753768844221105, 0.105527638190955, 0.135678391959799, 0.165829145728643, 0.195979899497488, 0.226130653266332, 0.256281407035176, 0.28643216080402, 0.316582914572864, 0.346733668341709, 0.376884422110553, 0.407035175879397, 0.437185929648241, 0.467336683417085, 0.49748743718593, 0.527638190954774, 0.557788944723618, 0.587939698492462, 0.618090452261306, 0.648241206030151, 0.678391959798995, 0.708542713567839, 0.738693467336683, 0.768844221105527, 0.798994974874372, 0.829145728643216, 0.85929648241206, 0.889447236180904, 0.919597989949748, 0.949748743718593, 0.979899497487437, 1.01005025125628, 1.04020100502513, 1.07035175879397, 1.10050251256281, 1.13065326633166, 1.1608040201005, 1.19095477386935, 1.22110552763819, 1.25125628140704, 1.28140703517588, 1.31155778894472, 1.34170854271357, 1.37185929648241, 1.40201005025126, 1.4321608040201, 1.46231155778894, 1.49246231155779, 1.52261306532663, 1.55276381909548, 1.58291457286432, 1.61306532663317, 1.64321608040201, 1.67336683417085, 1.7035175879397, 1.73366834170854, 1.76381909547739, 1.79396984924623, 1.82412060301507, 1.85427135678392, 1.88442211055276, 1.91457286432161, 1.94472361809045, 1.9748743718593, 2.00502512562814, 2.03517587939698, 2.06532663316583, 2.09547738693467, 2.12562814070352, 2.15577889447236, 2.18592964824121, 2.21608040201005, 2.24623115577889, 2.27638190954774, 2.30653266331658, 2.33668341708543, 2.36683417085427, 2.39698492462312, 2.42713567839196, 2.4572864321608, 2.48743718592965, 2.51758793969849, 2.54773869346734, 2.57788944723618, 2.60804020100502, 2.63819095477387, 2.66834170854271, 2.69849246231156, 2.7286432160804, 2.75879396984925, 2.78894472361809, 2.81909547738693, 2.84924623115578, 2.87939698492462, 2.90954773869347, 2.93969849246231, 2.96984924623116, 3));cosh(argv[[1]]);");
    }

    @Test
    public void testcosh5() {
        assertEval("argv <- list(c(0-3i, 0-2.96984924623116i, 0-2.93969849246231i, 0-2.90954773869347i, 0-2.87939698492462i, 0-2.84924623115578i, 0-2.81909547738693i, 0-2.78894472361809i, 0-2.75879396984925i, 0-2.7286432160804i, 0-2.69849246231156i, 0-2.66834170854271i, 0-2.63819095477387i, 0-2.60804020100502i, 0-2.57788944723618i, 0-2.54773869346734i, 0-2.51758793969849i, 0-2.48743718592965i, 0-2.4572864321608i, 0-2.42713567839196i, 0-2.39698492462312i, 0-2.36683417085427i, 0-2.33668341708543i, 0-2.30653266331658i, 0-2.27638190954774i, 0-2.24623115577889i, 0-2.21608040201005i, 0-2.18592964824121i, 0-2.15577889447236i, 0-2.12562814070352i, 0-2.09547738693467i, 0-2.06532663316583i, 0-2.03517587939699i, 0-2.00502512562814i, 0-1.9748743718593i, 0-1.94472361809045i, 0-1.91457286432161i, 0-1.88442211055276i, 0-1.85427135678392i, 0-1.82412060301508i, 0-1.79396984924623i, 0-1.76381909547739i, 0-1.73366834170854i, 0-1.7035175879397i, 0-1.67336683417085i, 0-1.64321608040201i, 0-1.61306532663317i, 0-1.58291457286432i, 0-1.55276381909548i, 0-1.52261306532663i, 0-1.49246231155779i, 0-1.46231155778894i, 0-1.4321608040201i, 0-1.40201005025126i, 0-1.37185929648241i, 0-1.34170854271357i, 0-1.31155778894472i, 0-1.28140703517588i, 0-1.25125628140704i, 0-1.22110552763819i, 0-1.19095477386935i, 0-1.1608040201005i, 0-1.13065326633166i, 0-1.10050251256281i, 0-1.07035175879397i, 0-1.04020100502513i, 0-1.01005025125628i, 0-0.979899497487437i, 0-0.949748743718593i, 0-0.919597989949749i, 0-0.889447236180905i, 0-0.859296482412061i, 0-0.829145728643216i, 0-0.798994974874372i, 0-0.768844221105528i, 0-0.738693467336684i, 0-0.70854271356784i, 0-0.678391959798995i, 0-0.648241206030151i, 0-0.618090452261307i, 0-0.587939698492463i, 0-0.557788944723618i, 0-0.527638190954774i, 0-0.49748743718593i, 0-0.467336683417086i, 0-0.437185929648241i, 0-0.407035175879397i, 0-0.376884422110553i, 0-0.346733668341709i, 0-0.316582914572864i, 0-0.28643216080402i, 0-0.256281407035176i, 0-0.226130653266332i, 0-0.195979899497488i, 0-0.165829145728643i, 0-0.135678391959799i, 0-0.105527638190955i, 0-0.0753768844221105i, 0-0.0452261306532664i, 0-0.0150753768844223i, 0+0.0150753768844218i, 0+0.0452261306532664i, 0+0.0753768844221105i, 0+0.105527638190955i, 0+0.135678391959799i, 0+0.165829145728643i, 0+0.195979899497488i, 0+0.226130653266332i, 0+0.256281407035176i, 0+0.28643216080402i, 0+0.316582914572864i, 0+0.346733668341709i, 0+0.376884422110553i, 0+0.407035175879397i, 0+0.437185929648241i, 0+0.467336683417085i, 0+0.49748743718593i, 0+0.527638190954774i, 0+0.557788944723618i, 0+0.587939698492462i, 0+0.618090452261306i, 0+0.648241206030151i, 0+0.678391959798995i, 0+0.708542713567839i, 0+0.738693467336683i, 0+0.768844221105527i, 0+0.798994974874372i, 0+0.829145728643216i, 0+0.85929648241206i, 0+0.889447236180904i, 0+0.919597989949748i, 0+0.949748743718593i, 0+0.979899497487437i, 0+1.01005025125628i, 0+1.04020100502513i, 0+1.07035175879397i, 0+1.10050251256281i, 0+1.13065326633166i, 0+1.1608040201005i, 0+1.19095477386935i, 0+1.22110552763819i, 0+1.25125628140704i, 0+1.28140703517588i, 0+1.31155778894472i, 0+1.34170854271357i, 0+1.37185929648241i, 0+1.40201005025126i, 0+1.4321608040201i, 0+1.46231155778894i, 0+1.49246231155779i, 0+1.52261306532663i, 0+1.55276381909548i, 0+1.58291457286432i, 0+1.61306532663317i, 0+1.64321608040201i, 0+1.67336683417085i, 0+1.7035175879397i, 0+1.73366834170854i, 0+1.76381909547739i, 0+1.79396984924623i, 0+1.82412060301507i, 0+1.85427135678392i, 0+1.88442211055276i, 0+1.91457286432161i, 0+1.94472361809045i, 0+1.9748743718593i, 0+2.00502512562814i, 0+2.03517587939698i, 0+2.06532663316583i, 0+2.09547738693467i, 0+2.12562814070352i, 0+2.15577889447236i, 0+2.18592964824121i, 0+2.21608040201005i, 0+2.24623115577889i, 0+2.27638190954774i, 0+2.30653266331658i, 0+2.33668341708543i, 0+2.36683417085427i, 0+2.39698492462312i, 0+2.42713567839196i, 0+2.4572864321608i, 0+2.48743718592965i, 0+2.51758793969849i, 0+2.54773869346734i, 0+2.57788944723618i, 0+2.60804020100502i, 0+2.63819095477387i, 0+2.66834170854271i, 0+2.69849246231156i, 0+2.7286432160804i, 0+2.75879396984925i, 0+2.78894472361809i, 0+2.81909547738693i, 0+2.84924623115578i, 0+2.87939698492462i, 0+2.90954773869347i, 0+2.93969849246231i, 0+2.96984924623116i, 0+3i));cosh(argv[[1]]);");
    }
}
