/*
 * Copyright (c) 2019, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */
package jdk.graal.compiler.hotspot.test;

import jdk.graal.compiler.api.directives.GraalDirectives;
import jdk.graal.compiler.core.test.GraalCompilerTest;
import org.junit.Assert;
import org.junit.Test;

public class BoxDeoptimizationTest extends GraalCompilerTest {

    public static void testIntegerSnippet() {
        Object[] values = {42, -42, new Exception()};
        GraalDirectives.deoptimize();
        Assert.assertSame(values[0], Integer.valueOf(42));
        Assert.assertSame(values[1], Integer.valueOf(-42));
    }

    @Test
    public void testInteger() {
        test("testIntegerSnippet");
    }

    public static void testLongSnippet() {
        long highBitsOnly = 2L << 40;
        Object[] values = {42L, -42L, highBitsOnly, new Exception()};
        GraalDirectives.deoptimize();
        Assert.assertSame(values[0], Long.valueOf(42));
        Assert.assertSame(values[1], Long.valueOf(-42));
        Assert.assertNotSame(values[2], highBitsOnly);
    }

    @Test
    public void testLong() {
        test("testLongSnippet");
    }

    public static void testCharSnippet() {
        Object[] values = {'a', 'Z', new Exception()};
        GraalDirectives.deoptimize();
        Assert.assertSame(values[0], Character.valueOf('a'));
        Assert.assertSame(values[1], Character.valueOf('Z'));
    }

    @Test
    public void testChar() {
        test("testCharSnippet");
    }

    public static void testShortSnippet() {
        Object[] values = {(short) 42, (short) -42, new Exception()};
        GraalDirectives.deoptimize();
        Assert.assertSame(values[0], Short.valueOf((short) 42));
        Assert.assertSame(values[1], Short.valueOf((short) -42));
    }

    @Test
    public void testShort() {
        test("testShortSnippet");
    }

    public static void testByteSnippet() {
        Object[] values = {(byte) 42, (byte) -42, new Exception()};
        GraalDirectives.deoptimize();
        Assert.assertSame(values[0], Byte.valueOf((byte) 42));
        Assert.assertSame(values[1], Byte.valueOf((byte) -42));
    }

    @Test
    public void testByte() {
        test("testByteSnippet");
    }

    public static void testBooleanSnippet() {
        Object[] values = {true, false, new Exception()};
        GraalDirectives.deoptimize();
        Assert.assertSame(values[0], Boolean.valueOf(true));
        Assert.assertSame(values[1], Boolean.valueOf(false));
    }

    @Test
    public void testBoolean() {
        test("testBooleanSnippet");
    }
}
