---
layout: ohc
permalink: /support/
---

# Support

## Available Distributions

Oracle GraalVM for JDK 23 is based on Oracle JDK 23. 
Each release of Oracle GraalVM for JDK 23 includes all Oracle Java critical patch updates (CPUs), which are provided on a regular schedule to remedy defects and known vulnerabilities.

Oracle GraalVM for JDK 23 is available for Linux, macOS, and Windows on the x64 architecture, and for Linux and macOS on the AArch64 architecture.

## Certified Platforms

Oracle GraalVM for JDK 24 is certified on the following platforms.

**Linux**

| Platform                        | CPU Architecture(s) |
|---------------------------------|---------------------|
| Oracle Linux 9                  | AArch64, x64        |
| Oracle Linux 8                  | AArch64, x64        |
| Oracle Linux 7                  | x64                 |
| Red Hat Enterprise Linux 9      | AArch64, x64        |
| Red Hat Enterprise Linux 8      | AArch64, x64        |
| Red Hat Enterprise Linux 7      | x64                 |
| Ubuntu Linux 24.10              | x64                 |
| Ubuntu Linux 24.04 LTS          | x64                 |

**macOS**

| Platform | CPU Architecture(s) |
|----------|---------------------|
| macOS 15 | AArch64, x64        |
| macOS 14 | AArch64, x64        |
| macOS 13 | AArch64, x64        |

**Windows**

| Platform            | CPU Architecture(s) |
|---------------------|---------------------|
| Windows Server 2025 | x64                 |
| Windows Server 2022 | x64                 |
| Windows Server 2019 | x64                 |
| Windows Server 2016 | x64                 |
| Windows 11          | x64                 |
| Windows 10          | x64                 |

See [Oracle GraalVM Support Roadmap](https://docs.oracle.com/en/graalvm/support-roadmap.html) to understand maintenance, support options, and related timelines.

## Related Technologies

Additional open source language runtimes designed for use with Oracle GraalVM for JDK 23 are available on [graalvm.org](https://www.graalvm.org/reference-manual/languages/).

## Licensing and Support

Oracle GraalVM is licensed under [GraalVM Free Terms and Conditions (GFTC) including License for Early Adopter Versions](https://www.oracle.com/downloads/licenses/graal-free-license.html). 
Subject to the conditions in the license, including the License for Early Adopter Versions, the GFTC is intended to permit use by any user including commercial and production use. 
Redistribution is permitted as long as it is not for a fee. 
Oracle GraalVM is also free to use on Oracle Cloud Infrastructure. 
For more information about Oracle GraalVM licensing, see the [Oracle Java SE Licensing FAQ](https://www.oracle.com/java/technologies/javase/jdk-faqs.html#GraalVM-licensing).

Oracle GraalVM is available as part of the [Oracle Java SE Subscription](https://www.oracle.com/java/java-se-subscription/) which includes 24x7x365 [Oracle premier support](https://www.oracle.com/support/premier/) and access to [My Oracle Support (MOS)](https://www.oracle.com/support/).