---
layout: ni-docs-landing
toc_group: how-to-guides
link_title: Guides
permalink: /guides/
redirect_from:
    - /native-image/guides/
    - /reference-manual/native-image/guides/
---

# Guides

These guides help developers get started with GraalVM Native Image, acquaint them with available features, and describe potential usage scenarios. 
Here you will learn how to:

- [Access Environment Variables](access-environment-variables.md)
- [Add Logging to a Native Executable](add-logging-to-native-executable.md)
- [Build a Native Executable from a JAR File](build-native-executable-from-jar.md)
- [Build a Native Shared Library](build-native-shared-library.md)
- [Build a Polyglot Native Executable (Java and JavaScript)](build-polyglot-native-executable.md)
- [Build a Static or Mostly-Static Native Executable](build-static-and-mostly-static-executable.md)
- [Build and Run Native Executables with JFR](build-and-run-native-executable-with-jfr.md)
- [Build and Run Native Executables with Remote JMX](build-and-run-native-executable-with-remote-jmx.md)
- [Build Java Modules into a Native Executable](build-java-module-app-aot.md)
- [Configure Native Image with the Tracing Agent](build-with-reflection.md)
- [Containerize a Native Executable and Run in a Docker Container](containerise-native-executable-with-docker.md)
- [Create a Heap Dump from a Native Executable](create-heap-dump-from-native-executable.md)
- [Debug Native Executables with GDB](debug-native-executables-with-gdb.md)
- [Debug Native Executables with a Python Helper Script](debug-native-executables-with-python-helper.md)
- [Embed an SBOM in a Native Executable to Identify Its Dependencies](use-sbom-support.md)
- [Include Reachability Metadata Using the Native Image Gradle Plugin](include-reachability-metadata-gradle.md)
- [Include Reachability Metadata Using the Native Image Maven Plugin](include-reachability-metadata-maven.md)
- [Include Resources in a Native Executable](include-resources.md)
- [Optimize a Native Executable with Profile-Guided Optimization](optimize-native-executable-with-pgo.md)
- [Optimize a Native Executable for File Size](optimize-file-size.md)
- [Optimize Size of a Native Executable using Build Reports](optimize-native-executable-size-using-build-report.md)
- [Optimize Memory Footprint of a Native Executable](optimize-memory-footprint.md)
- [Specify Class Initialization Explicitly](specify-class-initialization.md)
- [Use Gradle to Build a Native Executable from a Java Application](https://graalvm.github.io/native-build-tools/latest/gradle-plugin-quickstart.html)
- [Use Maven to Build a Native Executable from a Java Application](https://graalvm.github.io/native-build-tools/latest/maven-plugin-quickstart.html)

## Microservices Frameworks

- [Build a Native Executable from a Spring Boot 3 Application](build-spring-boot-application-aot.md)
- <a href="https://guides.micronaut.io/latest/micronaut-creating-first-graal-app.html" target="_blank">Build a Native Executable from a Micronaut Application</a>
- <a href="https://quarkus.io/guides/building-native-image" target="_blank">Build a Native Executable from a Quarkus Application</a>
- <a href="https://helidon.io/docs/v3/#/mp/guides/graalnative" target="_blank">Build a Native Executable from a Helidon MP Application</a>
- <a href="https://helidon.io/docs/v3/#/se/guides/graalnative" target="_blank">Build a Native Executable from a Helidon SP Application</a>
