---
layout: docs
toc_group: tools
link_title: Tools for Graal Languages
permalink: /reference-manual/tools/
redirect_from: /tools/
---

# Tools for Graal Languages

Here you can find a set of tools for Graal languages, to debug and monitor deployed applications, as well as the GraalVM platform itself. 
Traditional tools may not be ready to diagnose polyglot applications.
GraalVM tools, however, are implemented to inspect single or multi-language applications by debugging via numerous clients, profiling, statement counting, dynamic analysis, and much more.

Learn more about each of the tools:

* [VisualVM](visualvm.md)
* [GraalVM Insight](insight/README.md)
* [Profiling Command Line Tools](profiling.md)
* [Code Coverage Command Line Tool](code-coverage.md)
* [Ideal Graph Visualizer](ideal-graph-visualizer.md)
* [Chrome Debugger](chrome-debugger.md)
* [Language Server Protocol](lsp.md)
* [Debug Adapter Protocol](dap.md)
