/*
 * Copyright (c) 2024, 2024, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

#ifndef PROBE_OPTION_TYPE_H
#define PROBE_OPTION_TYPE_H
#include <string.h>
// Generated by mx gen-gc-option-check

// Probing for the following options:
// * ActiveProcessorCount=
// * ±AlwaysPreTouch
// * ±AutomaticReferenceHandling
// * ConcGCThreads=
// * ErgoHeapSizeLimit=
// * ±ExplicitGCInvokesConcurrent
// * G1ConcMarkStepDurationMillis=
// * G1ConcRefinementThreads=
// * G1ConfidencePercent=
// * G1HeapWastePercent=
// * G1MixedGCCountTarget=
// * G1PeriodicGCInterval=
// * ±G1PeriodicGCInvokesConcurrent
// * G1PeriodicGCSystemLoadThreshold=
// * G1RSetUpdatingPauseTimePercent=
// * G1RefProcDrainInterval=
// * G1ReservePercent=
// * G1SATBBufferEnqueueingThresholdPercent=
// * G1SATBBufferSize=
// * G1UpdateBufferSize=
// * ±G1UseAdaptiveIHOP
// * ±G1UseConcRefinement
// * ±G1VerifyHeapRegionCodeRoots
// * GCDrainStackTargetSize=
// * GCPauseIntervalMillis=
// * GCTimeRatio=
// * HeapSizePerGCThread=
// * InitialHeapSize=
// * InitialRAMPercentage=
// * InitiatingHeapOccupancyPercent=
// * MarkStackSize=
// * MarkStackSizeMax=
// * MaxGCPauseMillis=
// * MaxHeapSize=
// * MaxNewSize=
// * MaxRAM=
// * MaxRAMPercentage=
// * MaxTenuringThreshold=
// * MinHeapDeltaBytes=
// * MinHeapFreeRatio=
// * MinHeapSize=
// * MinRAMPercentage=
// * MinTLABSize=
// * NewRatio=
// * NewSize=
// * OldPLABSize=
// * OldSize=
// * PLABWeight=
// * ParGCArrayScanChunk=
// * ParallelGCBufferWastePct=
// * ParallelGCThreads=
// * ±ParallelRefProcBalancingEnabled
// * ±ParallelRefProcEnabled
// * PreTouchParallelChunkSize=
// * PrefetchCopyIntervalInBytes=
// * PrefetchScanIntervalInBytes=
// * QueuedAllocationWarningCount=
// * ReservedAddressSpaceSize=
// * ±ResizePLAB
// * ±ResizeTLAB
// * SoftRefLRUPolicyMSPerMB=
// * SurvivorRatio=
// * TLABAllocationWeight=
// * TLABRefillWasteFraction=
// * TLABSize=
// * TLABWasteIncrement=
// * TLABWasteTargetPercent=
// * TargetPLABWastePct=
// * TargetSurvivorRatio=
// * ±UseDynamicNumberOfGCThreads
// * ±UsePerfData
// * ±VerifyAfterGC
// * ±VerifyBeforeGC
// * ±VerifyDuringGC
// * VerifyGCStartAt=
// * YoungPLABSize=
// * ±ZeroTLAB

#define OPTION_UNKNOWN 0
#define OPTION_BOOLEAN 1
#define OPTION_STRING 2

static int probe_option_type(const char* option) {
    switch(*option) {
        case 'A':
            option++;
            switch(*option) {
                case 'c':
                    return strncmp(option + 1, "tiveProcessorCount=", strlen("tiveProcessorCount=")) == 0 ? OPTION_STRING : OPTION_UNKNOWN;
                case 'l':
                    return strncmp(option + 1, "waysPreTouch", sizeof("waysPreTouch")) == 0 ? OPTION_BOOLEAN : OPTION_UNKNOWN;
                case 'u':
                    return strncmp(option + 1, "tomaticReferenceHandling", sizeof("tomaticReferenceHandling")) == 0 ? OPTION_BOOLEAN : OPTION_UNKNOWN;
                default:
                    return OPTION_UNKNOWN;
            }
        case 'C':
            return strncmp(option + 1, "oncGCThreads=", strlen("oncGCThreads=")) == 0 ? OPTION_STRING : OPTION_UNKNOWN;
        case 'E':
            option++;
            switch(*option) {
                case 'r':
                    return strncmp(option + 1, "goHeapSizeLimit=", strlen("goHeapSizeLimit=")) == 0 ? OPTION_STRING : OPTION_UNKNOWN;
                case 'x':
                    return strncmp(option + 1, "plicitGCInvokesConcurrent", sizeof("plicitGCInvokesConcurrent")) == 0 ? OPTION_BOOLEAN : OPTION_UNKNOWN;
                default:
                    return OPTION_UNKNOWN;
            }
        case 'G':
            option++;
            switch(*option) {
                case '1':
                    option++;
                    switch(*option) {
                        case 'C':
                            option++;
                            if (strncmp(option, "on", strlen("on")) != 0) {
                                return OPTION_UNKNOWN;
                            }
                            option += strlen("on");
                            switch(*option) {
                                case 'c':
                                    option++;
                                    switch(*option) {
                                        case 'M':
                                            return strncmp(option + 1, "arkStepDurationMillis=", strlen("arkStepDurationMillis=")) == 0 ? OPTION_STRING : OPTION_UNKNOWN;
                                        case 'R':
                                            return strncmp(option + 1, "efinementThreads=", strlen("efinementThreads=")) == 0 ? OPTION_STRING : OPTION_UNKNOWN;
                                        default:
                                            return OPTION_UNKNOWN;
                                    }
                                case 'f':
                                    return strncmp(option + 1, "idencePercent=", strlen("idencePercent=")) == 0 ? OPTION_STRING : OPTION_UNKNOWN;
                                default:
                                    return OPTION_UNKNOWN;
                            }
                        case 'H':
                            return strncmp(option + 1, "eapWastePercent=", strlen("eapWastePercent=")) == 0 ? OPTION_STRING : OPTION_UNKNOWN;
                        case 'M':
                            return strncmp(option + 1, "ixedGCCountTarget=", strlen("ixedGCCountTarget=")) == 0 ? OPTION_STRING : OPTION_UNKNOWN;
                        case 'P':
                            option++;
                            if (strncmp(option, "eriodicGC", strlen("eriodicGC")) != 0) {
                                return OPTION_UNKNOWN;
                            }
                            option += strlen("eriodicGC");
                            switch(*option) {
                                case 'I':
                                    option++;
                                    if (strncmp(option, "n", strlen("n")) != 0) {
                                        return OPTION_UNKNOWN;
                                    }
                                    option += strlen("n");
                                    switch(*option) {
                                        case 't':
                                            return strncmp(option + 1, "erval=", strlen("erval=")) == 0 ? OPTION_STRING : OPTION_UNKNOWN;
                                        case 'v':
                                            return strncmp(option + 1, "okesConcurrent", sizeof("okesConcurrent")) == 0 ? OPTION_BOOLEAN : OPTION_UNKNOWN;
                                        default:
                                            return OPTION_UNKNOWN;
                                    }
                                case 'S':
                                    return strncmp(option + 1, "ystemLoadThreshold=", strlen("ystemLoadThreshold=")) == 0 ? OPTION_STRING : OPTION_UNKNOWN;
                                default:
                                    return OPTION_UNKNOWN;
                            }
                        case 'R':
                            option++;
                            switch(*option) {
                                case 'S':
                                    return strncmp(option + 1, "etUpdatingPauseTimePercent=", strlen("etUpdatingPauseTimePercent=")) == 0 ? OPTION_STRING : OPTION_UNKNOWN;
                                case 'e':
                                    option++;
                                    switch(*option) {
                                        case 'f':
                                            return strncmp(option + 1, "ProcDrainInterval=", strlen("ProcDrainInterval=")) == 0 ? OPTION_STRING : OPTION_UNKNOWN;
                                        case 's':
                                            return strncmp(option + 1, "ervePercent=", strlen("ervePercent=")) == 0 ? OPTION_STRING : OPTION_UNKNOWN;
                                        default:
                                            return OPTION_UNKNOWN;
                                    }
                                default:
                                    return OPTION_UNKNOWN;
                            }
                        case 'S':
                            option++;
                            if (strncmp(option, "ATBBuffer", strlen("ATBBuffer")) != 0) {
                                return OPTION_UNKNOWN;
                            }
                            option += strlen("ATBBuffer");
                            switch(*option) {
                                case 'E':
                                    return strncmp(option + 1, "nqueueingThresholdPercent=", strlen("nqueueingThresholdPercent=")) == 0 ? OPTION_STRING : OPTION_UNKNOWN;
                                case 'S':
                                    return strncmp(option + 1, "ize=", strlen("ize=")) == 0 ? OPTION_STRING : OPTION_UNKNOWN;
                                default:
                                    return OPTION_UNKNOWN;
                            }
                        case 'U':
                            option++;
                            switch(*option) {
                                case 'p':
                                    return strncmp(option + 1, "dateBufferSize=", strlen("dateBufferSize=")) == 0 ? OPTION_STRING : OPTION_UNKNOWN;
                                case 's':
                                    option++;
                                    if (strncmp(option, "e", strlen("e")) != 0) {
                                        return OPTION_UNKNOWN;
                                    }
                                    option += strlen("e");
                                    switch(*option) {
                                        case 'A':
                                            return strncmp(option + 1, "daptiveIHOP", sizeof("daptiveIHOP")) == 0 ? OPTION_BOOLEAN : OPTION_UNKNOWN;
                                        case 'C':
                                            return strncmp(option + 1, "oncRefinement", sizeof("oncRefinement")) == 0 ? OPTION_BOOLEAN : OPTION_UNKNOWN;
                                        default:
                                            return OPTION_UNKNOWN;
                                    }
                                default:
                                    return OPTION_UNKNOWN;
                            }
                        case 'V':
                            return strncmp(option + 1, "erifyHeapRegionCodeRoots", sizeof("erifyHeapRegionCodeRoots")) == 0 ? OPTION_BOOLEAN : OPTION_UNKNOWN;
                        default:
                            return OPTION_UNKNOWN;
                    }
                case 'C':
                    option++;
                    switch(*option) {
                        case 'D':
                            return strncmp(option + 1, "rainStackTargetSize=", strlen("rainStackTargetSize=")) == 0 ? OPTION_STRING : OPTION_UNKNOWN;
                        case 'P':
                            return strncmp(option + 1, "auseIntervalMillis=", strlen("auseIntervalMillis=")) == 0 ? OPTION_STRING : OPTION_UNKNOWN;
                        case 'T':
                            return strncmp(option + 1, "imeRatio=", strlen("imeRatio=")) == 0 ? OPTION_STRING : OPTION_UNKNOWN;
                        default:
                            return OPTION_UNKNOWN;
                    }
                default:
                    return OPTION_UNKNOWN;
            }
        case 'H':
            return strncmp(option + 1, "eapSizePerGCThread=", strlen("eapSizePerGCThread=")) == 0 ? OPTION_STRING : OPTION_UNKNOWN;
        case 'I':
            option++;
            if (strncmp(option, "nitia", strlen("nitia")) != 0) {
                return OPTION_UNKNOWN;
            }
            option += strlen("nitia");
            switch(*option) {
                case 'l':
                    option++;
                    switch(*option) {
                        case 'H':
                            return strncmp(option + 1, "eapSize=", strlen("eapSize=")) == 0 ? OPTION_STRING : OPTION_UNKNOWN;
                        case 'R':
                            return strncmp(option + 1, "AMPercentage=", strlen("AMPercentage=")) == 0 ? OPTION_STRING : OPTION_UNKNOWN;
                        default:
                            return OPTION_UNKNOWN;
                    }
                case 't':
                    return strncmp(option + 1, "ingHeapOccupancyPercent=", strlen("ingHeapOccupancyPercent=")) == 0 ? OPTION_STRING : OPTION_UNKNOWN;
                default:
                    return OPTION_UNKNOWN;
            }
        case 'M':
            option++;
            switch(*option) {
                case 'a':
                    option++;
                    switch(*option) {
                        case 'r':
                            option++;
                            if (strncmp(option, "kStackSize", strlen("kStackSize")) != 0) {
                                return OPTION_UNKNOWN;
                            }
                            option += strlen("kStackSize");
                            switch(*option) {
                                case '=':
                                    return OPTION_STRING;
                                case 'M':
                                    return strncmp(option + 1, "ax=", strlen("ax=")) == 0 ? OPTION_STRING : OPTION_UNKNOWN;
                                default:
                                    return OPTION_UNKNOWN;
                            }
                        case 'x':
                            option++;
                            switch(*option) {
                                case 'G':
                                    return strncmp(option + 1, "CPauseMillis=", strlen("CPauseMillis=")) == 0 ? OPTION_STRING : OPTION_UNKNOWN;
                                case 'H':
                                    return strncmp(option + 1, "eapSize=", strlen("eapSize=")) == 0 ? OPTION_STRING : OPTION_UNKNOWN;
                                case 'N':
                                    return strncmp(option + 1, "ewSize=", strlen("ewSize=")) == 0 ? OPTION_STRING : OPTION_UNKNOWN;
                                case 'R':
                                    option++;
                                    if (strncmp(option, "AM", strlen("AM")) != 0) {
                                        return OPTION_UNKNOWN;
                                    }
                                    option += strlen("AM");
                                    switch(*option) {
                                        case '=':
                                            return OPTION_STRING;
                                        case 'P':
                                            return strncmp(option + 1, "ercentage=", strlen("ercentage=")) == 0 ? OPTION_STRING : OPTION_UNKNOWN;
                                        default:
                                            return OPTION_UNKNOWN;
                                    }
                                case 'T':
                                    return strncmp(option + 1, "enuringThreshold=", strlen("enuringThreshold=")) == 0 ? OPTION_STRING : OPTION_UNKNOWN;
                                default:
                                    return OPTION_UNKNOWN;
                            }
                        default:
                            return OPTION_UNKNOWN;
                    }
                case 'i':
                    option++;
                    if (strncmp(option, "n", strlen("n")) != 0) {
                        return OPTION_UNKNOWN;
                    }
                    option += strlen("n");
                    switch(*option) {
                        case 'H':
                            option++;
                            if (strncmp(option, "eap", strlen("eap")) != 0) {
                                return OPTION_UNKNOWN;
                            }
                            option += strlen("eap");
                            switch(*option) {
                                case 'D':
                                    return strncmp(option + 1, "eltaBytes=", strlen("eltaBytes=")) == 0 ? OPTION_STRING : OPTION_UNKNOWN;
                                case 'F':
                                    return strncmp(option + 1, "reeRatio=", strlen("reeRatio=")) == 0 ? OPTION_STRING : OPTION_UNKNOWN;
                                case 'S':
                                    return strncmp(option + 1, "ize=", strlen("ize=")) == 0 ? OPTION_STRING : OPTION_UNKNOWN;
                                default:
                                    return OPTION_UNKNOWN;
                            }
                        case 'R':
                            return strncmp(option + 1, "AMPercentage=", strlen("AMPercentage=")) == 0 ? OPTION_STRING : OPTION_UNKNOWN;
                        case 'T':
                            return strncmp(option + 1, "LABSize=", strlen("LABSize=")) == 0 ? OPTION_STRING : OPTION_UNKNOWN;
                        default:
                            return OPTION_UNKNOWN;
                    }
                default:
                    return OPTION_UNKNOWN;
            }
        case 'N':
            option++;
            if (strncmp(option, "ew", strlen("ew")) != 0) {
                return OPTION_UNKNOWN;
            }
            option += strlen("ew");
            switch(*option) {
                case 'R':
                    return strncmp(option + 1, "atio=", strlen("atio=")) == 0 ? OPTION_STRING : OPTION_UNKNOWN;
                case 'S':
                    return strncmp(option + 1, "ize=", strlen("ize=")) == 0 ? OPTION_STRING : OPTION_UNKNOWN;
                default:
                    return OPTION_UNKNOWN;
            }
        case 'O':
            option++;
            if (strncmp(option, "ld", strlen("ld")) != 0) {
                return OPTION_UNKNOWN;
            }
            option += strlen("ld");
            switch(*option) {
                case 'P':
                    return strncmp(option + 1, "LABSize=", strlen("LABSize=")) == 0 ? OPTION_STRING : OPTION_UNKNOWN;
                case 'S':
                    return strncmp(option + 1, "ize=", strlen("ize=")) == 0 ? OPTION_STRING : OPTION_UNKNOWN;
                default:
                    return OPTION_UNKNOWN;
            }
        case 'P':
            option++;
            switch(*option) {
                case 'L':
                    return strncmp(option + 1, "ABWeight=", strlen("ABWeight=")) == 0 ? OPTION_STRING : OPTION_UNKNOWN;
                case 'a':
                    option++;
                    if (strncmp(option, "r", strlen("r")) != 0) {
                        return OPTION_UNKNOWN;
                    }
                    option += strlen("r");
                    switch(*option) {
                        case 'G':
                            return strncmp(option + 1, "CArrayScanChunk=", strlen("CArrayScanChunk=")) == 0 ? OPTION_STRING : OPTION_UNKNOWN;
                        case 'a':
                            option++;
                            if (strncmp(option, "llel", strlen("llel")) != 0) {
                                return OPTION_UNKNOWN;
                            }
                            option += strlen("llel");
                            switch(*option) {
                                case 'G':
                                    option++;
                                    if (strncmp(option, "C", strlen("C")) != 0) {
                                        return OPTION_UNKNOWN;
                                    }
                                    option += strlen("C");
                                    switch(*option) {
                                        case 'B':
                                            return strncmp(option + 1, "ufferWastePct=", strlen("ufferWastePct=")) == 0 ? OPTION_STRING : OPTION_UNKNOWN;
                                        case 'T':
                                            return strncmp(option + 1, "hreads=", strlen("hreads=")) == 0 ? OPTION_STRING : OPTION_UNKNOWN;
                                        default:
                                            return OPTION_UNKNOWN;
                                    }
                                case 'R':
                                    option++;
                                    if (strncmp(option, "efProc", strlen("efProc")) != 0) {
                                        return OPTION_UNKNOWN;
                                    }
                                    option += strlen("efProc");
                                    switch(*option) {
                                        case 'B':
                                            return strncmp(option + 1, "alancingEnabled", sizeof("alancingEnabled")) == 0 ? OPTION_BOOLEAN : OPTION_UNKNOWN;
                                        case 'E':
                                            return strncmp(option + 1, "nabled", sizeof("nabled")) == 0 ? OPTION_BOOLEAN : OPTION_UNKNOWN;
                                        default:
                                            return OPTION_UNKNOWN;
                                    }
                                default:
                                    return OPTION_UNKNOWN;
                            }
                        default:
                            return OPTION_UNKNOWN;
                    }
                case 'r':
                    option++;
                    if (strncmp(option, "e", strlen("e")) != 0) {
                        return OPTION_UNKNOWN;
                    }
                    option += strlen("e");
                    switch(*option) {
                        case 'T':
                            return strncmp(option + 1, "ouchParallelChunkSize=", strlen("ouchParallelChunkSize=")) == 0 ? OPTION_STRING : OPTION_UNKNOWN;
                        case 'f':
                            option++;
                            if (strncmp(option, "etch", strlen("etch")) != 0) {
                                return OPTION_UNKNOWN;
                            }
                            option += strlen("etch");
                            switch(*option) {
                                case 'C':
                                    return strncmp(option + 1, "opyIntervalInBytes=", strlen("opyIntervalInBytes=")) == 0 ? OPTION_STRING : OPTION_UNKNOWN;
                                case 'S':
                                    return strncmp(option + 1, "canIntervalInBytes=", strlen("canIntervalInBytes=")) == 0 ? OPTION_STRING : OPTION_UNKNOWN;
                                default:
                                    return OPTION_UNKNOWN;
                            }
                        default:
                            return OPTION_UNKNOWN;
                    }
                default:
                    return OPTION_UNKNOWN;
            }
        case 'Q':
            return strncmp(option + 1, "ueuedAllocationWarningCount=", strlen("ueuedAllocationWarningCount=")) == 0 ? OPTION_STRING : OPTION_UNKNOWN;
        case 'R':
            option++;
            if (strncmp(option, "es", strlen("es")) != 0) {
                return OPTION_UNKNOWN;
            }
            option += strlen("es");
            switch(*option) {
                case 'e':
                    return strncmp(option + 1, "rvedAddressSpaceSize=", strlen("rvedAddressSpaceSize=")) == 0 ? OPTION_STRING : OPTION_UNKNOWN;
                case 'i':
                    option++;
                    if (strncmp(option, "ze", strlen("ze")) != 0) {
                        return OPTION_UNKNOWN;
                    }
                    option += strlen("ze");
                    switch(*option) {
                        case 'P':
                            return strncmp(option + 1, "LAB", sizeof("LAB")) == 0 ? OPTION_BOOLEAN : OPTION_UNKNOWN;
                        case 'T':
                            return strncmp(option + 1, "LAB", sizeof("LAB")) == 0 ? OPTION_BOOLEAN : OPTION_UNKNOWN;
                        default:
                            return OPTION_UNKNOWN;
                    }
                default:
                    return OPTION_UNKNOWN;
            }
        case 'S':
            option++;
            switch(*option) {
                case 'o':
                    return strncmp(option + 1, "ftRefLRUPolicyMSPerMB=", strlen("ftRefLRUPolicyMSPerMB=")) == 0 ? OPTION_STRING : OPTION_UNKNOWN;
                case 'u':
                    return strncmp(option + 1, "rvivorRatio=", strlen("rvivorRatio=")) == 0 ? OPTION_STRING : OPTION_UNKNOWN;
                default:
                    return OPTION_UNKNOWN;
            }
        case 'T':
            option++;
            switch(*option) {
                case 'L':
                    option++;
                    if (strncmp(option, "AB", strlen("AB")) != 0) {
                        return OPTION_UNKNOWN;
                    }
                    option += strlen("AB");
                    switch(*option) {
                        case 'A':
                            return strncmp(option + 1, "llocationWeight=", strlen("llocationWeight=")) == 0 ? OPTION_STRING : OPTION_UNKNOWN;
                        case 'R':
                            return strncmp(option + 1, "efillWasteFraction=", strlen("efillWasteFraction=")) == 0 ? OPTION_STRING : OPTION_UNKNOWN;
                        case 'S':
                            return strncmp(option + 1, "ize=", strlen("ize=")) == 0 ? OPTION_STRING : OPTION_UNKNOWN;
                        case 'W':
                            option++;
                            if (strncmp(option, "aste", strlen("aste")) != 0) {
                                return OPTION_UNKNOWN;
                            }
                            option += strlen("aste");
                            switch(*option) {
                                case 'I':
                                    return strncmp(option + 1, "ncrement=", strlen("ncrement=")) == 0 ? OPTION_STRING : OPTION_UNKNOWN;
                                case 'T':
                                    return strncmp(option + 1, "argetPercent=", strlen("argetPercent=")) == 0 ? OPTION_STRING : OPTION_UNKNOWN;
                                default:
                                    return OPTION_UNKNOWN;
                            }
                        default:
                            return OPTION_UNKNOWN;
                    }
                case 'a':
                    option++;
                    if (strncmp(option, "rget", strlen("rget")) != 0) {
                        return OPTION_UNKNOWN;
                    }
                    option += strlen("rget");
                    switch(*option) {
                        case 'P':
                            return strncmp(option + 1, "LABWastePct=", strlen("LABWastePct=")) == 0 ? OPTION_STRING : OPTION_UNKNOWN;
                        case 'S':
                            return strncmp(option + 1, "urvivorRatio=", strlen("urvivorRatio=")) == 0 ? OPTION_STRING : OPTION_UNKNOWN;
                        default:
                            return OPTION_UNKNOWN;
                    }
                default:
                    return OPTION_UNKNOWN;
            }
        case 'U':
            option++;
            if (strncmp(option, "se", strlen("se")) != 0) {
                return OPTION_UNKNOWN;
            }
            option += strlen("se");
            switch(*option) {
                case 'D':
                    return strncmp(option + 1, "ynamicNumberOfGCThreads", sizeof("ynamicNumberOfGCThreads")) == 0 ? OPTION_BOOLEAN : OPTION_UNKNOWN;
                case 'P':
                    return strncmp(option + 1, "erfData", sizeof("erfData")) == 0 ? OPTION_BOOLEAN : OPTION_UNKNOWN;
                default:
                    return OPTION_UNKNOWN;
            }
        case 'V':
            option++;
            if (strncmp(option, "erify", strlen("erify")) != 0) {
                return OPTION_UNKNOWN;
            }
            option += strlen("erify");
            switch(*option) {
                case 'A':
                    return strncmp(option + 1, "fterGC", sizeof("fterGC")) == 0 ? OPTION_BOOLEAN : OPTION_UNKNOWN;
                case 'B':
                    return strncmp(option + 1, "eforeGC", sizeof("eforeGC")) == 0 ? OPTION_BOOLEAN : OPTION_UNKNOWN;
                case 'D':
                    return strncmp(option + 1, "uringGC", sizeof("uringGC")) == 0 ? OPTION_BOOLEAN : OPTION_UNKNOWN;
                case 'G':
                    return strncmp(option + 1, "CStartAt=", strlen("CStartAt=")) == 0 ? OPTION_STRING : OPTION_UNKNOWN;
                default:
                    return OPTION_UNKNOWN;
            }
        case 'Y':
            return strncmp(option + 1, "oungPLABSize=", strlen("oungPLABSize=")) == 0 ? OPTION_STRING : OPTION_UNKNOWN;
        case 'Z':
            return strncmp(option + 1, "eroTLAB", sizeof("eroTLAB")) == 0 ? OPTION_BOOLEAN : OPTION_UNKNOWN;
        default:
            return OPTION_UNKNOWN;
    }
}

#endif