# Publications

## Papers

* Rigger, M.; Grimmer, M.; Wimmer, C.; Würthinger, T.; Mössenböck, H.:<br>
[Bringing Low-Level Languages to the JVM: Efficient Execution of LLVM IR on Truffle](http://conf.researchr.org/event/vmil2016/vmil2016-bringing-low-level-languages-to-the-jvm-efficient-execution-of-llvm-ir-on-truffle)<br>
Workshop on Virtual Machines and Intermediate Languages (VMIL'16),
Amsterdam, Netherlands, Oct. 31, 2016 (accepted for publication)<br>

* Rigger, M.:<br>
[Sulong: Memory Safe and Efficient Execution of LLVM-Based Languages](http://2016.ecoop.org/track/ecoop-2016-doctoral-symposium)<br>
ECOOP 2016 Doctoral Symposium, July 18, 2016, Rome, Italy<br>
[Download paper](http://ssw.jku.at/General/Staff/ManuelRigger/ECOOP16-DS.pdf)

* Rigger, M.; Grimmer, M.; Mössenböck, H.:<br>
[Sulong - Execution of LLVM-Based Languages on the JVM](http://2016.ecoop.org/event/icooolps-2016-sulong-execution-of-llvm-based-languages-on-the-jvm)<br>
Int. Workshop on Implementation, Compilation, Optimization of
Object-Oriented Languages, Programs and Systems (ICOOOLPS'16),
July 18, 2016, Rome, Italy, (accepted for publication)<br>

* Kreindl, J.; Rigger, M.; Mössenböck, H.:<br>
[Debugging Native Extensions of Dynamic Languages](http://ssw.jku.at/manlang18)<br>
15th International Conference on Managed Languages & Runtimes (ManLang'18), September 12-14, 2018, Linz, Austria<br>
[Download paper](http://ssw.jku.at/General/Staff/Kreindl/papers/ManLang_2018_SulongDebugging.pdf)

There is also a [list of general publications](../../../docs/Publications.md) about GraalVM and Truffle in general.

## Presentations

* [Sulong: An experience report of using the "other end" of LLVM in GraalVM.](http://llvm.org/devmtg/2019-04/talks.html#Talk_13)<br>
EuroLLVM'19, April 8-9, 2019, Brussels, Belgium<br>
[Download slides](http://llvm.org/devmtg/2019-04/slides/TechTalk-Schatz-Sulong_an_experience_report.pdf)<br>
[Watch video](https://youtu.be/zvsR90T_4ME)

* [LLVM IR in GraalVM: Multi-Level, Polyglot Debugging with Sulong](http://llvm.org/devmtg/2019-04/talks.html#Talk_11)<br>
EuroLLVM'19, April 8-9, 2019, Brussels, Belgium<br>
[Download slides](http://llvm.org/devmtg/2019-04/slides/TechTalk-Kreindl-LLVM_IR_in_GraalVM.pdf)<br>
[Watch video](https://www.youtube.com/watch?v=YIGoNVQctOU)

* [Using LLVM and Sulong for Language C Extensions](http://chrisseaton.com/rubytruffle/llvm-cauldron-16/llvm-cauldron-sulong.pdf)<br>
LLVM Cauldron 2016, September 8, 2016, Hebden Bridge, The United Kingdom<br>
[Download slides](http://chrisseaton.com/rubytruffle/llvm-cauldron-16/llvm-cauldron-sulong.pdf)<br>
[Watch video](https://www.youtube.com/watch?v=bJzMfYX6n9A)

* C, C++, and Fortran on the JVM via Sulong<br>
VMM'16, September 2, 2016, Lugano, Switzerland<br>
[Download slides](https://speakerdeck.com/mrigger/vmm-16-c-c-plus-plus-and-fortran-on-the-jvm-via-sulong)

* Sulong: Execution of LLVM-Based Languages on the JVM<br>
ICOOOLPS'16 (LLVM Toolchain devroom), July 18, 2016, Rome, Italy<br>
[Download slides](https://speakerdeck.com/mrigger/icooolps-16-sulong-execution-of-llvm-based-languages-on-the-jvm)

* [Sulong: Fast LLVM IR Execution on the JVM with Truffle and Graal](https://fosdem.org/2016/schedule/event/llvm_sulong/)<br>
FOSDEM'16 (LLVM Toolchain devroom), January 31, 2016, Brussels, Belgium<br>
[Download slides](https://fosdem.org/2016/schedule/event/llvm_sulong/attachments/slides/1205/export/events/attachments/llvm_sulong/slides/1205/Sulong.pdf)
