/*
 * Copyright (c) 2012, 2018, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * The Universal Permissive License (UPL), Version 1.0
 *
 * Subject to the condition set forth below, permission is hereby granted to any
 * person obtaining a copy of this software, associated documentation and/or
 * data (collectively the "Software"), free of charge and under any and all
 * copyright rights in the Software, and any and all patent rights owned or
 * freely licensable by each licensor hereunder covering either (i) the
 * unmodified Software as contributed to or provided by such licensor, or (ii)
 * the Larger Works (as defined below), to deal in both
 *
 * (a) the Software, and
 *
 * (b) any piece of software and/or hardware listed in the lrgrwrks.txt file if
 * one is included with the Software each a "Larger Work" to which the Software
 * is contributed by such licensors),
 *
 * without restriction, including without limitation the rights to copy, create
 * derivative works of, display, perform, and distribute the Software and make,
 * use, sell, offer for sale, import, export, have made, and have sold the
 * Software and the Larger Work(s), and to sublicense the foregoing rights on
 * either these or other terms.
 *
 * This license is subject to the following condition:
 *
 * The above copyright notice and either this complete permission notice or at a
 * minimum a reference to the UPL must be included in all copies or substantial
 * portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */
package com.oracle.truffle.api.nodes;

import java.lang.annotation.ElementType;
import java.lang.annotation.Inherited;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

/**
 * Annotation for providing additional information on nodes.
 *
 * @since 0.8 or earlier
 */
@Retention(RetentionPolicy.RUNTIME)
@Target(ElementType.TYPE)
@Inherited
public @interface NodeInfo {

    /**
     * Short name representing the node that can be used for debugging.
     *
     * @return the short name
     * @since 0.8 or earlier
     */
    String shortName() default "";

    /**
     * Provides a rough estimate for the cost of the annotated {@link Node}. This estimate can be
     * used by runtime systems or guest languages to implement heuristics based on Truffle ASTs.
     *
     * @see Node#getCost()
     * @see NodeCost
     * @since 0.8 or earlier
     * @deprecated in 24.1 without replacement
     */
    @SuppressWarnings("deprecation")
    @Deprecated
    NodeCost cost() default NodeCost.MONOMORPHIC;

    /**
     * A human readable explanation of the purpose of the annotated {@link Node}. Can be used e.g.
     * for debugging or visualization purposes.
     *
     * @return the description
     * @since 0.8 or earlier
     */
    String description() default "";

    /**
     * A description, providing a user-readable explanation of the source language of the annotated
     * {@link Node}. Can be used e.g. for debugging or visualization purposes. Typically this
     * information is set only in an abstract base node for the language implementation.
     *
     * @return the description
     * @since 0.8 or earlier
     */
    String language() default "";
}
