/*
 * Copyright (c) 2013, 2022, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */
package org.graalvm.visualizer.coordinator.actions;

/**
 * @author sdedic
 */
public class SaveOptions extends javax.swing.JPanel {
    /**
     * Creates new form SaveOptions
     */
    public SaveOptions() {
        initComponents();
    }

    public void configure(SaveOperation so) {
        if (!so.hasMultipleSessions()) {
            makeSingleSession();
            return;
        }
        if (so.isSaveAs()) {
            if (!so.hasGroups()) {
                optCollectGroups.setEnabled(false);
                optRetainSessions.setSelected(true);
            }
        }
        tFileComment.setText(so.getInitialFileComment());
        updateFileComment();
    }

    public void setFileComment(String fileComment) {
        tFileComment.setText(fileComment);
    }

    public boolean isPromptEachFile() {
        return optMultipleFiles.isSelected() && cbPromptNames.isSelected();
    }

    public String getFileComment() {
        if (tFileComment.isEnabled()) {
            return tFileComment.getText();
        } else {
            return null;
        }
    }

    private void updateFileComment() {
        cbPromptNames.setEnabled(optMultipleFiles.isSelected());
        boolean enable = !optMultipleFiles.isSelected() || cbPromptNames.isSelected();
        tFileComment.setEnabled(enable);
        lFileComment.setEnabled(enable);
    }

    public SaveOperation.Style getStyle() {
        if (optRetainSessions.isSelected()) {
            return SaveOperation.Style.SESSIONS;
        }
        if (optCollectGroups.isSelected()) {
            return SaveOperation.Style.GROUPS;
        }
        if (optMultipleFiles.isSelected()) {
            return SaveOperation.Style.FILES;
        }

        return SaveOperation.Style.SESSIONS;
    }

    /**
     * This method is called from within the constructor to initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is always
     * regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        saveStyle = new javax.swing.ButtonGroup();
        lFileComment = new javax.swing.JLabel();
        tFileComment = new javax.swing.JTextField();
        jLabel2 = new javax.swing.JLabel();
        optRetainSessions = new javax.swing.JRadioButton();
        optCollectGroups = new javax.swing.JRadioButton();
        optMultipleFiles = new javax.swing.JRadioButton();
        cbPromptNames = new javax.swing.JCheckBox();

        org.openide.awt.Mnemonics.setLocalizedText(lFileComment, org.openide.util.NbBundle.getMessage(SaveOptions.class, "SaveOptions.lFileComment.text")); // NOI18N

        tFileComment.setText(org.openide.util.NbBundle.getMessage(SaveOptions.class, "SaveOptions.tFileComment.text")); // NOI18N

        org.openide.awt.Mnemonics.setLocalizedText(jLabel2, org.openide.util.NbBundle.getMessage(SaveOptions.class, "SaveOptions.jLabel2.text")); // NOI18N

        saveStyle.add(optRetainSessions);
        org.openide.awt.Mnemonics.setLocalizedText(optRetainSessions, org.openide.util.NbBundle.getMessage(SaveOptions.class, "SaveOptions.optRetainSessions.text")); // NOI18N

        saveStyle.add(optCollectGroups);
        optCollectGroups.setSelected(true);
        org.openide.awt.Mnemonics.setLocalizedText(optCollectGroups, org.openide.util.NbBundle.getMessage(SaveOptions.class, "SaveOptions.optCollectGroups.text")); // NOI18N

        saveStyle.add(optMultipleFiles);
        org.openide.awt.Mnemonics.setLocalizedText(optMultipleFiles, org.openide.util.NbBundle.getMessage(SaveOptions.class, "SaveOptions.optMultipleFiles.text")); // NOI18N
        optMultipleFiles.addItemListener(new java.awt.event.ItemListener() {
            public void itemStateChanged(java.awt.event.ItemEvent evt) {
                optMultipleFilesItemStateChanged(evt);
            }
        });

        org.openide.awt.Mnemonics.setLocalizedText(cbPromptNames, org.openide.util.NbBundle.getMessage(SaveOptions.class, "SaveOptions.cbPromptNames.text")); // NOI18N
        cbPromptNames.addItemListener(new java.awt.event.ItemListener() {
            public void itemStateChanged(java.awt.event.ItemEvent evt) {
                cbPromptNamesItemStateChanged(evt);
            }
        });

        javax.swing.GroupLayout layout = new javax.swing.GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(
                layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                        .addGroup(layout.createSequentialGroup()
                                .addContainerGap()
                                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                                        .addComponent(tFileComment)
                                        .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                                                .addComponent(lFileComment)
                                                .addGroup(layout.createSequentialGroup()
                                                        .addComponent(jLabel2)
                                                        .addGap(48, 48, 48)
                                                        .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                                                                .addComponent(optCollectGroups)
                                                                .addComponent(optRetainSessions)
                                                                .addComponent(optMultipleFiles)
                                                                .addGroup(layout.createSequentialGroup()
                                                                        .addGap(21, 21, 21)
                                                                        .addComponent(cbPromptNames))))))
                                .addContainerGap())
        );
        layout.setVerticalGroup(
                layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                        .addGroup(layout.createSequentialGroup()
                                .addContainerGap()
                                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                                        .addComponent(jLabel2)
                                        .addComponent(optRetainSessions))
                                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                                .addComponent(optCollectGroups)
                                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                                .addComponent(optMultipleFiles)
                                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                                .addComponent(cbPromptNames)
                                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                                .addComponent(lFileComment)
                                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                                .addComponent(tFileComment, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                                .addContainerGap(javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
        );
    }// </editor-fold>//GEN-END:initComponents

    private void optMultipleFilesItemStateChanged(java.awt.event.ItemEvent evt) {//GEN-FIRST:event_optMultipleFilesItemStateChanged
        updateFileComment();
    }//GEN-LAST:event_optMultipleFilesItemStateChanged

    private void cbPromptNamesItemStateChanged(java.awt.event.ItemEvent evt) {//GEN-FIRST:event_cbPromptNamesItemStateChanged
        updateFileComment();
    }//GEN-LAST:event_cbPromptNamesItemStateChanged

    public void makeFilePrompt() {
        optMultipleFiles.setSelected(true);
        cbPromptNames.setSelected(true);

        optCollectGroups.setEnabled(false);
        optMultipleFiles.setEnabled(false);
        optRetainSessions.setEnabled(false);
        cbPromptNames.setEnabled(false);
        lFileComment.setEnabled(true);
        tFileComment.setEnabled(true);
    }

    public void makeSingleSession() {
        optCollectGroups.setEnabled(false);
        optMultipleFiles.setEnabled(false);
        optRetainSessions.setEnabled(false);
        cbPromptNames.setEnabled(false);
        updateFileComment();
    }

    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JCheckBox cbPromptNames;
    private javax.swing.JLabel jLabel2;
    private javax.swing.JLabel lFileComment;
    private javax.swing.JRadioButton optCollectGroups;
    private javax.swing.JRadioButton optMultipleFiles;
    private javax.swing.JRadioButton optRetainSessions;
    private javax.swing.ButtonGroup saveStyle;
    private javax.swing.JTextField tFileComment;
    // End of variables declaration//GEN-END:variables
}
