/*
 * Copyright (c) 2025, 2025, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */
package com.oracle.svm.hosted.webimage.test;

import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Suite;

import com.oracle.svm.hosted.webimage.test.spec.JS_JTT_Bytecodes;
import com.oracle.svm.hosted.webimage.test.spec.JS_JTT_JSAnnotation;
import com.oracle.svm.hosted.webimage.test.spec.JS_JTT_JavaScriptBody;
import com.oracle.svm.hosted.webimage.test.spec.JS_JTT_XHR;
import com.oracle.svm.hosted.webimage.test.util.FailFastSuite;
import com.oracle.svm.hosted.webimage.test.util.JTTTestSuite;

/**
 * This class should collect all test cases necessary to validate that code generated by Web Image
 * behaves the same as in the JVM.
 */
@RunWith(FailFastSuite.class)
@Suite.SuiteClasses({
                JS_JTT_Bytecodes.class,
                JS_JTT_JavaScriptBody.class,
                JS_JTT_JSAnnotation.class,
                JS_JTT_XHR.class,
})
public class JS_JTT_Spec_Test extends JTTTestSuite {

    @Test
    public void test() {
        // This is here just to make mx aware of the test suite class.
    }
}
