/*
 * Copyright (c) 2020, 2024, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * Licensed under the Universal Permissive License v 1.0 as shown at http://oss.oracle.com/licenses/upl.
 */

/*
 * Tests of delete operator.
 * 
 * @option debug-builtin
 */

load('assert.js');

// Test-case from https://github.com/graalvm/graaljs/issues/324
assertThrows(function() {
    "use strict";
    delete 'x'[0];
}, TypeError);

assertThrows(function() {
    "use strict";
    delete 'x'.length;
}, TypeError);

function toPropertyKeyCheck(object) {
    var called = false;
    var key = {
        toString: function() {
            called = true;
            return 'someKey';
        }
    };
    delete object[key];
    assertTrue(called);
}

toPropertyKeyCheck(42);
toPropertyKeyCheck(Debug.createSafeInteger(43));
toPropertyKeyCheck(3.14);
toPropertyKeyCheck(211n);
toPropertyKeyCheck(true);
toPropertyKeyCheck('txt');
toPropertyKeyCheck(Symbol());

var javaObject = new java.lang.Object();
toPropertyKeyCheck(javaObject);

assertTrue(delete javaObject[Symbol()]);

var point = new java.awt.Point();
assertSame(false, delete point.x);
assertSame(true, delete point.z);
assertSame(true, delete point[0]);

assertThrows(function() {
    "use strict";
    delete point.x;
}, TypeError);
