/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.truffle;

import com.oracle.svm.core.BuildPhaseProvider;
import com.oracle.svm.core.annotate.Alias;
import com.oracle.svm.core.annotate.Delete;
import com.oracle.svm.core.annotate.RecomputeFieldValue;
import com.oracle.svm.core.annotate.TargetClass;
import com.oracle.svm.core.fieldvaluetransformer.FieldValueTransformerWithAvailability;
import com.oracle.svm.core.reflect.target.ReflectionSubstitutionSupport;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.truffle.TruffleBaseFeature;
import com.oracle.svm.util.ReflectionUtil;
import com.oracle.truffle.api.dsl.InlineSupport;
import java.lang.reflect.Field;

@TargetClass(className="com.oracle.truffle.api.dsl.InlineSupport$UnsafeField", onlyWith={TruffleBaseFeature.IsEnabled.class})
final class Target_com_oracle_truffle_api_dsl_InlineSupport_UnsafeField {
    @Alias
    @RecomputeFieldValue(kind=RecomputeFieldValue.Kind.Custom, declClass=OffsetComputer.class, isFinal=true)
    private long offset;
    @Delete
    private Class<?> declaringClass;
    @Delete
    private String name;

    Target_com_oracle_truffle_api_dsl_InlineSupport_UnsafeField() {
    }

    private static final class OffsetComputer
    implements FieldValueTransformerWithAvailability {
        private OffsetComputer() {
        }

        public boolean isAvailable() {
            return BuildPhaseProvider.isHostedUniverseBuilt();
        }

        public Object transform(Object receiver, Object originalValue) {
            Class declaringClass = (Class)ReflectionUtil.readField(InlineSupport.InlinableField.class.getSuperclass(), (String)"declaringClass", (Object)receiver);
            String name = (String)ReflectionUtil.readField(InlineSupport.InlinableField.class.getSuperclass(), (String)"name", (Object)receiver);
            Field field = ReflectionUtil.lookupField((Class)declaringClass, (String)name);
            int offset = ReflectionSubstitutionSupport.singleton().getFieldOffset(field, false);
            if (offset == -1) {
                throw VMError.shouldNotReachHere((String)("Field is not marked as accessed: " + String.valueOf(field)));
            }
            return (long)offset;
        }
    }
}

