/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.truffle.api;

import com.oracle.svm.truffle.api.TruffleMethod;
import com.oracle.truffle.compiler.TruffleCompilerRuntime;
import jdk.graal.compiler.graph.Node;
import jdk.graal.compiler.nodes.DeoptimizeNode;
import jdk.graal.compiler.nodes.FixedNode;
import jdk.graal.compiler.nodes.Invoke;
import jdk.graal.compiler.nodes.InvokeWithExceptionNode;
import jdk.graal.compiler.nodes.StructuredGraph;
import jdk.graal.compiler.nodes.java.ExceptionObjectNode;
import jdk.graal.compiler.nodes.util.GraphUtil;
import jdk.graal.compiler.phases.Phase;
import jdk.graal.compiler.truffle.PartialEvaluator;
import jdk.vm.ci.meta.DeoptimizationAction;
import jdk.vm.ci.meta.DeoptimizationReason;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import jdk.vm.ci.meta.SpeculationLog;

public class TruffleBoundaryPhase
extends Phase {
    protected void run(StructuredGraph graph) {
        for (Invoke n : graph.getInvokes()) {
            ResolvedJavaMethod targetMethod;
            InvokeWithExceptionNode invoke;
            ExceptionObjectNode exceptionObject;
            FixedNode originalNext;
            if (!(n instanceof InvokeWithExceptionNode) || (originalNext = (exceptionObject = (ExceptionObjectNode)(invoke = (InvokeWithExceptionNode)n).exceptionEdge()).next()) instanceof DeoptimizeNode || invoke.callTarget().targetMethod() == null || ((TruffleMethod)(targetMethod = invoke.callTarget().targetMethod())).getTruffleMethodInfo().inlineForPartialEvaluation() != TruffleCompilerRuntime.InlineKind.DO_NOT_INLINE_WITH_SPECULATIVE_EXCEPTION) continue;
            TruffleBoundaryPhase.addDeoptimizeNode(graph, originalNext, targetMethod);
        }
    }

    private static void addDeoptimizeNode(StructuredGraph graph, FixedNode originalNext, ResolvedJavaMethod targetMethod) {
        SpeculationLog.SpeculationReason speculationReason;
        SpeculationLog speculationLog = graph.getSpeculationLog();
        if (speculationLog != null && speculationLog.maySpeculate(speculationReason = PartialEvaluator.createTruffleBoundaryExceptionSpeculation((ResolvedJavaMethod)targetMethod))) {
            SpeculationLog.Speculation exceptionSpeculation = speculationLog.speculate(speculationReason);
            DeoptimizeNode deoptimize = (DeoptimizeNode)graph.add((Node)new DeoptimizeNode(DeoptimizationAction.InvalidateRecompile, DeoptimizationReason.TransferToInterpreter, exceptionSpeculation));
            originalNext.replaceAtPredecessor((Node)deoptimize);
            GraphUtil.killCFG((FixedNode)originalNext);
        }
    }
}

