/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.reachability;

import com.oracle.graal.pointsto.AbstractAnalysisEngine;
import com.oracle.graal.pointsto.flow.MethodTypeFlowBuilder;
import com.oracle.graal.pointsto.meta.AnalysisField;
import com.oracle.graal.pointsto.meta.AnalysisType;
import com.oracle.graal.reachability.ReachabilityAnalysisEngine;
import com.oracle.graal.reachability.ReachabilityAnalysisMethod;
import com.oracle.graal.reachability.ReachabilityInvokeInfo;
import com.oracle.graal.reachability.ReachabilityMethodProcessingHandler;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Modifier;
import java.util.Iterator;
import jdk.graal.compiler.graph.Node;
import jdk.graal.compiler.nodes.CallTargetNode;
import jdk.graal.compiler.nodes.Invoke;
import jdk.graal.compiler.nodes.StructuredGraph;
import jdk.graal.compiler.nodes.ValueNode;
import jdk.graal.compiler.nodes.ValueNodeInterface;
import jdk.graal.compiler.nodes.extended.FieldOffsetProvider;
import jdk.graal.compiler.nodes.extended.GetClassNode;
import jdk.graal.compiler.nodes.extended.RawLoadNode;
import jdk.graal.compiler.nodes.extended.RawStoreNode;
import jdk.graal.compiler.nodes.java.AtomicReadAndAddNode;
import jdk.graal.compiler.nodes.java.AtomicReadAndWriteNode;
import jdk.graal.compiler.nodes.java.DynamicNewInstanceNode;
import jdk.graal.compiler.nodes.java.NewInstanceNode;
import jdk.graal.compiler.nodes.java.UnsafeCompareAndExchangeNode;
import jdk.graal.compiler.nodes.java.UnsafeCompareAndSwapNode;
import jdk.graal.compiler.nodes.type.StampTool;
import jdk.graal.compiler.nodes.virtual.AllocatedObjectNode;
import jdk.graal.compiler.nodes.virtual.CommitAllocationNode;
import jdk.graal.compiler.nodes.virtual.VirtualArrayNode;
import jdk.graal.compiler.nodes.virtual.VirtualInstanceNode;
import jdk.graal.compiler.replacements.nodes.MacroInvokable;
import jdk.vm.ci.code.BytecodePosition;
import jdk.vm.ci.meta.MetaAccessProvider;
import org.graalvm.nativeimage.AnnotationAccess;

public class DirectMethodProcessingHandler
implements ReachabilityMethodProcessingHandler {
    @Override
    public void onMethodReachable(ReachabilityAnalysisEngine bb, ReachabilityAnalysisMethod method) {
        StructuredGraph decoded = ReachabilityAnalysisMethod.getDecodedGraph(bb, method);
        DirectMethodProcessingHandler.analyzeStructuredGraph(bb, method, decoded);
    }

    @Override
    public void processGraph(ReachabilityAnalysisEngine bb, StructuredGraph graph) {
        DirectMethodProcessingHandler.analyzeStructuredGraph(bb, (ReachabilityAnalysisMethod)graph.method(), graph);
    }

    private static void analyzeStructuredGraph(ReachabilityAnalysisEngine bb, ReachabilityAnalysisMethod method, StructuredGraph graph) {
        MethodTypeFlowBuilder.registerUsedElements((AbstractAnalysisEngine)bb, (StructuredGraph)graph, (boolean)true);
        if (method != null) {
            int offset;
            boolean isStatic = Modifier.isStatic(method.getModifiers());
            int parameterCount = method.getSignature().getParameterCount(!isStatic);
            for (int i = offset = isStatic ? 0 : 1; i < parameterCount; ++i) {
                ((AnalysisType)method.getSignature().getParameterType(i - offset)).registerAsReachable((Object)("Parameter type for " + method.format("%H.%n(%p)")));
            }
            ((AnalysisType)method.getSignature().getReturnType()).registerAsReachable((Object)("Return type for " + method.format("%H.%n(%p)")));
        }
        for (Node n : graph.getNodes()) {
            DynamicNewInstanceNode node;
            Iterator iterator;
            if (n instanceof NewInstanceNode) {
                NewInstanceNode node2 = (NewInstanceNode)n;
                ((AnalysisType)node2.instanceClass()).registerAsInstantiated((Object)AbstractAnalysisEngine.sourcePosition((ValueNode)node2));
                continue;
            }
            if (n instanceof VirtualInstanceNode) {
                VirtualInstanceNode node3 = (VirtualInstanceNode)n;
                ((AnalysisType)node3.type()).registerAsInstantiated((Object)AbstractAnalysisEngine.sourcePosition((ValueNode)node3));
                continue;
            }
            if (n instanceof VirtualArrayNode) {
                VirtualArrayNode node4 = (VirtualArrayNode)n;
                ((AnalysisType)node4.componentType()).getArrayClass().registerAsInstantiated((Object)AbstractAnalysisEngine.sourcePosition((ValueNode)node4));
                continue;
            }
            if (n instanceof CommitAllocationNode) {
                CommitAllocationNode node5 = (CommitAllocationNode)n;
                iterator = node5.usages().filter(AllocatedObjectNode.class).iterator();
                while (iterator.hasNext()) {
                    AllocatedObjectNode allocatedObjectNode = (AllocatedObjectNode)iterator.next();
                    AnalysisType type = (AnalysisType)allocatedObjectNode.getVirtualObject().type();
                    type.registerAsInstantiated((Object)AbstractAnalysisEngine.sourcePosition((ValueNode)allocatedObjectNode));
                }
                continue;
            }
            if (n instanceof DynamicNewInstanceNode && (iterator = (node = (DynamicNewInstanceNode)n).getInstanceType()) instanceof GetClassNode) {
                GetClassNode getClassNode = (GetClassNode)iterator;
                AnalysisType receiverType = (AnalysisType)StampTool.typeOrNull((ValueNode)getClassNode.getObject(), (MetaAccessProvider)bb.getMetaAccess());
                receiverType.registerAsInstantiated((Object)AbstractAnalysisEngine.sourcePosition((ValueNode)node));
                continue;
            }
            if (n instanceof RawLoadNode) {
                RawLoadNode node6 = (RawLoadNode)n;
                DirectMethodProcessingHandler.processUnsafeField((ValueNode)node6, node6.offset());
                continue;
            }
            if (n instanceof RawStoreNode) {
                RawStoreNode node7 = (RawStoreNode)n;
                DirectMethodProcessingHandler.processUnsafeField((ValueNode)node7, node7.offset());
                continue;
            }
            if (n instanceof UnsafeCompareAndSwapNode) {
                UnsafeCompareAndSwapNode node8 = (UnsafeCompareAndSwapNode)n;
                DirectMethodProcessingHandler.processUnsafeField((ValueNode)node8, node8.offset());
                continue;
            }
            if (n instanceof UnsafeCompareAndExchangeNode) {
                UnsafeCompareAndExchangeNode node9 = (UnsafeCompareAndExchangeNode)n;
                DirectMethodProcessingHandler.processUnsafeField((ValueNode)node9, node9.offset());
                continue;
            }
            if (n instanceof AtomicReadAndWriteNode) {
                AtomicReadAndWriteNode node10 = (AtomicReadAndWriteNode)n;
                DirectMethodProcessingHandler.processUnsafeField((ValueNode)node10, node10.offset());
                continue;
            }
            if (n instanceof AtomicReadAndAddNode) {
                AtomicReadAndAddNode node11 = (AtomicReadAndAddNode)n;
                DirectMethodProcessingHandler.processUnsafeField((ValueNode)node11, node11.offset());
                continue;
            }
            if (n instanceof Invoke) {
                Invoke node12 = (Invoke)n;
                DirectMethodProcessingHandler.processInvoke(bb, method, (ReachabilityAnalysisMethod)node12.getTargetMethod(), node12.getInvokeKind(), (ValueNodeInterface)node12);
                continue;
            }
            if (!(n instanceof MacroInvokable)) continue;
            MacroInvokable node13 = (MacroInvokable)n;
            DirectMethodProcessingHandler.processInvoke(bb, method, (ReachabilityAnalysisMethod)node13.getTargetMethod(), node13.getInvokeKind(), (ValueNodeInterface)node13);
        }
    }

    private static void processInvoke(ReachabilityAnalysisEngine bb, ReachabilityAnalysisMethod method, ReachabilityAnalysisMethod targetMethod, CallTargetNode.InvokeKind kind, ValueNodeInterface node) {
        if (targetMethod == null || AnnotationAccess.isAnnotationPresent((AnnotatedElement)((Object)targetMethod), Node.NodeIntrinsic.class)) {
            return;
        }
        BytecodePosition reason = AbstractAnalysisEngine.sourcePosition((ValueNode)node.asNode());
        if (method != null) {
            method.addInvoke(new ReachabilityInvokeInfo(targetMethod, reason, kind.isDirect()));
        }
        if (kind == CallTargetNode.InvokeKind.Static) {
            bb.markMethodImplementationInvoked(targetMethod, reason);
        } else if (kind == CallTargetNode.InvokeKind.Special) {
            bb.markMethodSpecialInvoked(targetMethod, reason);
        } else {
            bb.markMethodInvoked(targetMethod, reason);
        }
    }

    private static void processUnsafeField(ValueNode node, ValueNode offset) {
        if (offset instanceof FieldOffsetProvider) {
            FieldOffsetProvider provider = (FieldOffsetProvider)offset;
            AnalysisField field = (AnalysisField)provider.getField();
            field.registerAsUnsafeAccessed((Object)AbstractAnalysisEngine.sourcePosition((ValueNode)node));
        }
    }
}

