/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.reachability;

import com.oracle.graal.pointsto.meta.AnalysisMethod;
import com.oracle.graal.pointsto.meta.InvokeInfo;
import com.oracle.graal.reachability.ReachabilityAnalysisMethod;
import java.util.Collection;
import java.util.List;
import jdk.vm.ci.code.BytecodePosition;

public class ReachabilityInvokeInfo
implements InvokeInfo {
    private final ReachabilityAnalysisMethod targetMethod;
    private final BytecodePosition position;
    private final boolean isDirectInvoke;

    public ReachabilityInvokeInfo(ReachabilityAnalysisMethod targetMethod, BytecodePosition position, boolean isDirectInvoke) {
        this.targetMethod = targetMethod;
        this.position = position;
        this.isDirectInvoke = isDirectInvoke;
    }

    public boolean canBeStaticallyBound() {
        return this.getOriginalCallees().size() <= 1;
    }

    public AnalysisMethod getTargetMethod() {
        return this.targetMethod;
    }

    public Collection<AnalysisMethod> getOriginalCallees() {
        if (this.isDirectInvoke) {
            return List.of(this.targetMethod);
        }
        return this.targetMethod.collectMethodImplementations(false);
    }

    public Collection<AnalysisMethod> getAllCallees() {
        return this.getOriginalCallees();
    }

    public BytecodePosition getPosition() {
        return this.position;
    }

    public boolean isDirectInvoke() {
        return this.isDirectInvoke;
    }
}

