/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core;

import com.oracle.svm.configure.ConfigurationTypeDescriptor;
import com.oracle.svm.configure.NamedConfigurationTypeDescriptor;
import com.oracle.svm.configure.UnresolvedConfigurationCondition;
import com.oracle.svm.configure.config.ConfigurationMemberInfo;
import com.oracle.svm.configure.config.ConfigurationMethod;
import com.oracle.svm.configure.config.ConfigurationType;
import com.oracle.svm.core.MissingRegistrationSupport;
import com.oracle.svm.core.SubstrateOptions;
import com.oracle.svm.core.util.ExitStatus;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.util.StringUtil;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import jdk.graal.compiler.java.LambdaUtils;
import jdk.graal.compiler.util.json.JsonPrettyWriter;
import jdk.graal.compiler.util.json.JsonPrintable;
import jdk.graal.compiler.util.json.JsonWriter;

public class MissingRegistrationUtils {
    private static final AtomicReference<Set<String>> seenOutputs = new AtomicReference<Object>(null);
    private static final ThreadLocal<Boolean> missingRegistrationErrorsSuspended = ThreadLocal.withInitial(() -> false);

    public static boolean throwMissingRegistrationErrors() {
        return SubstrateOptions.ThrowMissingRegistrationErrors.hasBeenSet();
    }

    public static SubstrateOptions.ReportingMode missingRegistrationReportingMode() {
        return SubstrateOptions.MissingRegistrationReportingMode.getValue();
    }

    public static void report(Error exception, StackTraceElement responsibleClass) {
        if (missingRegistrationErrorsSuspended.get().booleanValue() || responsibleClass != null && !MissingRegistrationSupport.singleton().reportMissingRegistrationErrors(responsibleClass)) {
            return;
        }
        switch (MissingRegistrationUtils.missingRegistrationReportingMode()) {
            case Throw: {
                throw exception;
            }
            case Exit: {
                exception.printStackTrace(System.out);
                System.exit(ExitStatus.MISSING_METADATA.getValue());
                break;
            }
            case ExitTest: {
                throw new ExitException(exception);
            }
            case Warn: {
                StackTraceElement[] stackTrace = exception.getStackTrace();
                int printed = 0;
                StackTraceElement entryPoint = null;
                StringBuilder sb = new StringBuilder(exception.toString());
                sb.append(System.lineSeparator());
                for (StackTraceElement stackTraceElement : stackTrace) {
                    if (printed == 0) {
                        String moduleName = stackTraceElement.getModuleName();
                        if (moduleName != null && (moduleName.equals("java.base") || moduleName.startsWith("org.graalvm"))) {
                            entryPoint = stackTraceElement;
                        } else {
                            MissingRegistrationUtils.printLine(sb, entryPoint);
                            ++printed;
                        }
                    }
                    if (printed > 0) {
                        MissingRegistrationUtils.printLine(sb, stackTraceElement);
                        ++printed;
                    }
                    if (printed >= SubstrateOptions.MissingRegistrationWarnContextLines.getValue()) break;
                }
                if (seenOutputs.get() == null && seenOutputs.compareAndSet(null, ConcurrentHashMap.newKeySet())) {
                    System.out.println("Note: this run will print partial stack traces of the locations where a " + String.valueOf(exception.getClass()) + " would be thrown when the '-XX:MissingRegistrationReportingMode=Warn' option is set. The trace stops at the first entry of JDK code and provides " + String.valueOf(SubstrateOptions.MissingRegistrationWarnContextLines.getValue()) + " lines of context.");
                }
                String output = sb.toString();
                if (!seenOutputs.get().add(output)) break;
                System.out.print(output);
            }
        }
    }

    public static <T> T runIgnoringMissingRegistrations(Supplier<T> callback) {
        VMError.guarantee(missingRegistrationErrorsSuspended.get() == false);
        try {
            missingRegistrationErrorsSuspended.set(true);
            T t = callback.get();
            return t;
        }
        finally {
            missingRegistrationErrorsSuspended.set(false);
        }
    }

    private static void printLine(StringBuilder sb, Object object) {
        sb.append("  ").append(object).append(System.lineSeparator());
    }

    protected static JsonWriter getJSONWriter(StringWriter json) throws IOException {
        return new JsonPrettyWriter((Writer)json).indent().appendIndentation();
    }

    protected static String elementToJSON(JsonPrintable element) {
        StringWriter json = new StringWriter();
        try {
            element.printJson(MissingRegistrationUtils.getJSONWriter(json));
        }
        catch (IOException e) {
            VMError.shouldNotReachHere("Writing to JSON to memory");
        }
        return json.toString();
    }

    protected static String quote(String element) {
        return "'" + element + "'";
    }

    protected static String registrationMessage(String failedAction, String elementDescriptor, String json, String accessManner, String section, String helpLink) {
        String optionalSpace = accessManner.isEmpty() ? "" : " ";
        return "Cannot" + optionalSpace + accessManner + " " + failedAction + " " + elementDescriptor + ". To allow this operation, add the following to the '" + section + "' section of 'reachability-metadata.json' and rebuild the native image:" + System.lineSeparator() + System.lineSeparator() + json + System.lineSeparator() + System.lineSeparator() + "The 'reachability-metadata.json' file should be located in 'META-INF/native-image/<group-id>/<artifact-id>/' of your project. For further help, see https://www.graalvm.org/latest/reference-manual/native-image/metadata/#" + helpLink;
    }

    protected static ConfigurationType namedConfigurationType(String typeName) {
        return new ConfigurationType(UnresolvedConfigurationCondition.alwaysTrue(), (ConfigurationTypeDescriptor)new NamedConfigurationTypeDescriptor(typeName), true);
    }

    protected static void addField(ConfigurationType type, String fieldName) {
        type.addField(fieldName, ConfigurationMemberInfo.ConfigurationMemberDeclaration.PRESENT, false);
    }

    protected static void addMethod(ConfigurationType type, String methodName, Class<?>[] paramTypes) {
        ArrayList<ConfigurationType> params = new ArrayList<ConfigurationType>();
        if (paramTypes != null) {
            for (Class<?> paramType : paramTypes) {
                params.add(MissingRegistrationUtils.namedConfigurationType(paramType.getTypeName()));
            }
        }
        type.addMethod(methodName, ConfigurationMethod.toInternalParamsSignature(params), ConfigurationMemberInfo.ConfigurationMemberDeclaration.PRESENT);
    }

    protected static ConfigurationType getConfigurationType(Class<?> declaringClass) {
        return new ConfigurationType(UnresolvedConfigurationCondition.alwaysTrue(), ConfigurationTypeDescriptor.fromClass(declaringClass), true);
    }

    protected static String typeDescriptor(Class<?> clazz) {
        if (Proxy.isProxyClass(clazz)) {
            return "proxy class inheriting " + MissingRegistrationUtils.interfacesString(clazz.getInterfaces());
        }
        if (LambdaUtils.isLambdaClass(clazz)) {
            String declaringClass = StringUtil.split((String)clazz.getTypeName(), (String)"$$Lambda")[0];
            return "lambda-proxy class declared in " + MissingRegistrationUtils.quote(declaringClass) + " inheriting " + MissingRegistrationUtils.interfacesString(clazz.getInterfaces());
        }
        return MissingRegistrationUtils.quote(clazz.getTypeName());
    }

    protected static String interfacesString(Class<?>[] classes) {
        return Arrays.stream(classes).map(Class::getTypeName).map(MissingRegistrationUtils::quote).collect(Collectors.joining(",", "[", "]"));
    }

    protected static StackTraceElement getResponsibleClass(Throwable t, Map<String, Set<String>> entryPoints) {
        StackTraceElement[] stackTrace = t.getStackTrace();
        boolean returnNext = false;
        for (StackTraceElement stackTraceElement : stackTrace) {
            if (entryPoints.getOrDefault(stackTraceElement.getClassName(), Set.of()).contains(stackTraceElement.getMethodName())) {
                returnNext = true;
                continue;
            }
            if (!returnNext) continue;
            return stackTraceElement;
        }
        return null;
    }

    public static final class ExitException
    extends Error {
        private static final long serialVersionUID = -3638940737396726143L;

        public ExitException(Throwable cause) {
            super(cause);
        }
    }
}

