/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.bootstrap;

import com.oracle.svm.core.bootstrap.BootstrapMethodInfo;
import com.oracle.svm.core.feature.AutomaticallyRegisteredFeature;
import com.oracle.svm.core.feature.InternalFeature;
import com.oracle.svm.util.ReflectionUtil;
import java.lang.invoke.LambdaMetafactory;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.invoke.StringConcatFactory;
import java.lang.invoke.TypeDescriptor;
import java.lang.reflect.Executable;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.lang.runtime.ObjectMethods;
import java.lang.runtime.SwitchBootstraps;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import org.graalvm.nativeimage.ImageSingletons;

@AutomaticallyRegisteredFeature
public class BootstrapMethodConfiguration
implements InternalFeature {
    private final ConcurrentMap<BootstrapMethodRecord, BootstrapMethodInfo> bootstrapMethodInfoCache = new ConcurrentHashMap<BootstrapMethodRecord, BootstrapMethodInfo>();
    private final Set<Executable> indyBuildTimeAllowList;
    private final Set<Executable> condyBuildTimeAllowList;
    private final Method metafactory = ReflectionUtil.lookupMethod(LambdaMetafactory.class, (String)"metafactory", (Class[])new Class[]{MethodHandles.Lookup.class, String.class, MethodType.class, MethodType.class, MethodHandle.class, MethodType.class});
    private final Method altMetafactory = ReflectionUtil.lookupMethod(LambdaMetafactory.class, (String)"altMetafactory", (Class[])new Class[]{MethodHandles.Lookup.class, String.class, MethodType.class, Object[].class});

    public static BootstrapMethodConfiguration singleton() {
        return (BootstrapMethodConfiguration)ImageSingletons.lookup(BootstrapMethodConfiguration.class);
    }

    public BootstrapMethodConfiguration() {
        Method makeConcat = ReflectionUtil.lookupMethod(StringConcatFactory.class, (String)"makeConcat", (Class[])new Class[]{MethodHandles.Lookup.class, String.class, MethodType.class});
        Method makeConcatWithConstants = ReflectionUtil.lookupMethod(StringConcatFactory.class, (String)"makeConcatWithConstants", (Class[])new Class[]{MethodHandles.Lookup.class, String.class, MethodType.class, String.class, Object[].class});
        Method bootstrap = ReflectionUtil.lookupMethod(ObjectMethods.class, (String)"bootstrap", (Class[])new Class[]{MethodHandles.Lookup.class, String.class, TypeDescriptor.class, Class.class, String.class, MethodHandle[].class});
        Method typeSwitch = ReflectionUtil.lookupMethod(SwitchBootstraps.class, (String)"typeSwitch", (Class[])new Class[]{MethodHandles.Lookup.class, String.class, MethodType.class, Object[].class});
        Method enumSwitch = ReflectionUtil.lookupMethod(SwitchBootstraps.class, (String)"enumSwitch", (Class[])new Class[]{MethodHandles.Lookup.class, String.class, MethodType.class, Object[].class});
        this.indyBuildTimeAllowList = Set.of(this.metafactory, this.altMetafactory, makeConcat, makeConcatWithConstants, bootstrap, typeSwitch, enumSwitch);
        this.condyBuildTimeAllowList = Set.of();
    }

    public boolean isIndyAllowedAtBuildTime(Executable method) {
        return method != null && this.indyBuildTimeAllowList.contains(method);
    }

    public boolean isMetafactory(Executable method) {
        return method != null && (method.equals(this.metafactory) || method.equals(this.altMetafactory));
    }

    public boolean isCondyAllowedAtBuildTime(Executable method) {
        return method != null && (this.condyBuildTimeAllowList.contains(method) || BootstrapMethodConfiguration.isProxyCondy(method));
    }

    private static boolean isProxyCondy(Executable method) {
        return Proxy.isProxyClass(method.getDeclaringClass()) && method.getName().equals("$getMethod");
    }

    public ConcurrentMap<BootstrapMethodRecord, BootstrapMethodInfo> getBootstrapMethodInfoCache() {
        return this.bootstrapMethodInfoCache;
    }

    public record BootstrapMethodRecord(int bci, int cpi, ResolvedJavaMethod method) {
    }
}

