/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.collections;

import com.oracle.svm.core.UnmanagedMemoryUtil;
import com.oracle.svm.core.collections.GrowableWordArray;
import com.oracle.svm.core.config.ConfigurationValues;
import com.oracle.svm.core.memory.NullableNativeMemory;
import com.oracle.svm.core.nmt.NmtCategory;
import jdk.graal.compiler.api.replacements.Fold;
import jdk.graal.compiler.word.Word;
import org.graalvm.nativeimage.c.type.WordPointer;
import org.graalvm.word.Pointer;
import org.graalvm.word.PointerBase;
import org.graalvm.word.WordBase;

public class GrowableWordArrayAccess {
    private static final int INITIAL_CAPACITY = 10;

    public static void initialize(GrowableWordArray array) {
        array.setSize(0);
        array.setCapacity(0);
        array.setData((WordPointer)Word.nullPointer());
    }

    public static Word get(GrowableWordArray array, int i) {
        assert (i >= 0 && i < array.getSize());
        return (Word)array.getData().addressOf(i).read();
    }

    public static boolean add(GrowableWordArray array, Word element, NmtCategory nmtCategory) {
        if (array.getSize() == array.getCapacity() && !GrowableWordArrayAccess.grow(array, nmtCategory)) {
            return false;
        }
        array.getData().addressOf(array.getSize()).write((WordBase)element);
        array.setSize(array.getSize() + 1);
        return true;
    }

    public static void freeData(GrowableWordArray array) {
        if (array.isNonNull()) {
            NullableNativeMemory.free((PointerBase)array.getData());
            array.setData((WordPointer)Word.nullPointer());
            array.setSize(0);
            array.setCapacity(0);
        }
    }

    private static boolean grow(GrowableWordArray array, NmtCategory nmtCategory) {
        int newCapacity = GrowableWordArrayAccess.computeNewCapacity(array);
        if (newCapacity < 0) {
            return false;
        }
        assert (newCapacity >= 10);
        WordPointer oldData = array.getData();
        WordPointer newData = (WordPointer)NullableNativeMemory.malloc(Word.unsigned((int)newCapacity).multiply(GrowableWordArrayAccess.wordSize()), nmtCategory);
        if (newData.isNull()) {
            return false;
        }
        UnmanagedMemoryUtil.copyForward((Pointer)oldData, (Pointer)newData, Word.unsigned((int)array.getSize()).multiply(GrowableWordArrayAccess.wordSize()));
        NullableNativeMemory.free((PointerBase)oldData);
        array.setData(newData);
        array.setCapacity(newCapacity);
        return true;
    }

    private static int computeNewCapacity(GrowableWordArray array) {
        int oldCapacity = array.getCapacity();
        if (oldCapacity == 0) {
            return 10;
        }
        return oldCapacity * 2;
    }

    @Fold
    static int wordSize() {
        return ConfigurationValues.getTarget().wordSize;
    }
}

