/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.genscavenge.graal;

import com.oracle.svm.core.genscavenge.graal.GenScavengeAllocationSupport;
import com.oracle.svm.core.hub.LayoutEncoding;
import com.oracle.svm.core.meta.SharedType;
import jdk.graal.compiler.core.common.NumUtil;
import jdk.graal.compiler.core.common.memory.BarrierType;
import jdk.graal.compiler.core.common.type.IntegerStamp;
import jdk.graal.compiler.debug.GraalError;
import jdk.graal.compiler.nodes.NodeView;
import jdk.graal.compiler.nodes.ValueNode;
import jdk.graal.compiler.nodes.gc.CardTableBarrierSet;
import jdk.graal.compiler.nodes.memory.FixedAccessNode;
import jdk.graal.compiler.nodes.spi.ArrayLengthProvider;
import jdk.graal.compiler.nodes.spi.CoreProviders;
import jdk.graal.compiler.nodes.type.StampTool;
import jdk.graal.compiler.nodes.util.GraphUtil;
import jdk.vm.ci.meta.ConstantReflectionProvider;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.ResolvedJavaField;
import jdk.vm.ci.meta.ResolvedJavaType;
import org.graalvm.word.UnsignedWord;

public class SubstrateCardTableBarrierSet
extends CardTableBarrierSet {
    public SubstrateCardTableBarrierSet(ResolvedJavaType objectArrayType) {
        super(objectArrayType);
    }

    public BarrierType fieldWriteBarrierType(ResolvedJavaField field, JavaKind storageKind) {
        if (field.isStatic() && storageKind == JavaKind.Object) {
            return this.arrayWriteBarrierType(storageKind);
        }
        return super.fieldWriteBarrierType(field, storageKind);
    }

    protected boolean barrierPrecise(FixedAccessNode node, ValueNode base, CoreProviders context) {
        if (!super.barrierPrecise(node, base, context)) {
            return false;
        }
        ResolvedJavaType baseType = StampTool.typeOrNull((ValueNode)base);
        if (baseType == null) {
            return true;
        }
        if (!baseType.isArray()) {
            return baseType.isInterface() || baseType.isJavaLangObject();
        }
        ValueNode length = GraphUtil.arrayLength((ValueNode)base, (ArrayLengthProvider.FindLengthMode)ArrayLengthProvider.FindLengthMode.SEARCH_ONLY, (ConstantReflectionProvider)context.getConstantReflection());
        if (length == null) {
            return true;
        }
        IntegerStamp lengthStamp = (IntegerStamp)length.stamp(NodeView.DEFAULT);
        GraalError.guarantee((lengthStamp.getBits() == 32 ? 1 : 0) != 0, (String)"unexpected length %s", (Object)lengthStamp);
        int lengthBound = NumUtil.safeToInt((long)lengthStamp.upperBound());
        SharedType componentType = (SharedType)baseType.getComponentType();
        UnsignedWord sizeBound = LayoutEncoding.getArrayAllocationSize(componentType.getHub().getLayoutEncoding(), lengthBound);
        return !GenScavengeAllocationSupport.arrayAllocatedInAlignedChunk(sizeBound);
    }
}

