/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.graal;

import com.oracle.svm.core.BuildPhaseProvider;
import com.oracle.svm.core.deopt.DeoptimizationSupport;
import com.oracle.svm.core.graal.RuntimeCompilationCanaryFeature;
import com.oracle.svm.core.util.VMError;
import jdk.graal.compiler.api.replacements.Fold;
import org.graalvm.nativeimage.ImageSingletons;

public final class RuntimeCompilation {
    @Fold
    public static boolean isEnabled() {
        VMError.guarantee(BuildPhaseProvider.isFeatureRegistrationFinished(), "RuntimeCompilation.isEnabled() must not be called before the feature registration is finished.");
        boolean enabled = ImageSingletons.contains(RuntimeCompilationCanaryFeature.class);
        assert (!enabled || DeoptimizationSupport.enabled());
        return enabled;
    }

    private RuntimeCompilation() {
    }
}

