/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.graal.meta;

import com.oracle.svm.core.graal.code.SubstrateBackend;
import com.oracle.svm.core.graal.meta.SubstrateRegisterConfig;
import com.oracle.svm.core.meta.SharedMethod;
import java.util.Collection;
import java.util.EnumMap;
import jdk.graal.compiler.debug.DebugHandlersFactory;
import jdk.graal.compiler.phases.util.Providers;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;

public final class RuntimeConfiguration {
    private final Providers providers;
    private final EnumMap<SubstrateRegisterConfig.ConfigKind, SubstrateBackend> backends;
    private final Iterable<DebugHandlersFactory> debugHandlersFactories;

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public RuntimeConfiguration(Providers providers, EnumMap<SubstrateRegisterConfig.ConfigKind, SubstrateBackend> backends, Iterable<DebugHandlersFactory> debugHandlersFactories) {
        this.providers = providers;
        this.backends = backends;
        this.debugHandlersFactories = debugHandlersFactories;
        for (SubstrateBackend backend : backends.values()) {
            backend.setRuntimeConfiguration(this);
        }
    }

    public Iterable<DebugHandlersFactory> getDebugHandlersFactories() {
        return this.debugHandlersFactories;
    }

    public Providers getProviders() {
        return this.providers;
    }

    public Collection<SubstrateBackend> getBackends() {
        return this.backends.values();
    }

    public SubstrateBackend lookupBackend(ResolvedJavaMethod method) {
        if (((SharedMethod)method).isEntryPoint()) {
            return this.backends.get((Object)SubstrateRegisterConfig.ConfigKind.NATIVE_TO_JAVA);
        }
        return this.backends.get((Object)SubstrateRegisterConfig.ConfigKind.NORMAL);
    }

    public SubstrateBackend getBackendForNormalMethod() {
        return this.backends.get((Object)SubstrateRegisterConfig.ConfigKind.NORMAL);
    }
}

