/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.graal.snippets;

import com.oracle.svm.core.graal.snippets.NodeLoweringProvider;
import com.oracle.svm.core.graal.snippets.SubstrateAllocationSnippets;
import com.oracle.svm.core.graal.snippets.SubstrateTemplates;
import com.oracle.svm.core.meta.SharedMethod;
import com.oracle.svm.core.nodes.SafepointCheckNode;
import com.oracle.svm.core.nodes.foreign.MemoryArenaValidInScopeNode;
import com.oracle.svm.core.thread.SafepointCheckCounter;
import com.oracle.svm.core.thread.SafepointSlowpath;
import java.util.Arrays;
import java.util.Map;
import jdk.graal.compiler.api.replacements.Snippet;
import jdk.graal.compiler.core.common.spi.ForeignCallDescriptor;
import jdk.graal.compiler.debug.GraalError;
import jdk.graal.compiler.graph.Node;
import jdk.graal.compiler.nodeinfo.Verbosity;
import jdk.graal.compiler.nodes.FieldLocationIdentity;
import jdk.graal.compiler.nodes.FixedNode;
import jdk.graal.compiler.nodes.SafepointNode;
import jdk.graal.compiler.nodes.ValueNode;
import jdk.graal.compiler.nodes.extended.BranchProbabilityNode;
import jdk.graal.compiler.nodes.extended.ForeignCallNode;
import jdk.graal.compiler.nodes.spi.CoreProviders;
import jdk.graal.compiler.nodes.spi.LoweringTool;
import jdk.graal.compiler.options.OptionValues;
import jdk.graal.compiler.phases.util.Providers;
import jdk.graal.compiler.replacements.SnippetTemplate;
import jdk.graal.compiler.replacements.Snippets;
import jdk.vm.ci.meta.ResolvedJavaField;
import org.graalvm.word.LocationIdentity;

public final class SafepointSnippets
extends SubstrateTemplates
implements Snippets {
    private final SnippetTemplate.SnippetInfo safepoint;

    SafepointSnippets(OptionValues options, Providers providers, Map<Class<? extends Node>, NodeLoweringProvider<?>> lowerings) {
        super(options, providers);
        this.safepoint = this.snippet(providers, SafepointSnippets.class, "safepointSnippet", SafepointSnippets.getKilledLocations(providers.getMetaAccess().lookupJavaField(MemoryArenaValidInScopeNode.STATE_FIELD)));
        lowerings.put(SafepointNode.class, new SafepointLowering());
    }

    @Snippet
    private static void safepointSnippet() {
        boolean needSlowPath = SafepointCheckNode.test();
        if (BranchProbabilityNode.probability((double)0.0010000000000000009, (boolean)needSlowPath)) {
            SafepointSnippets.callSlowPathSafepointCheck(SafepointSlowpath.ENTER_SLOW_PATH_SAFEPOINT_CHECK);
        }
    }

    private static LocationIdentity[] getKilledLocations(ResolvedJavaField memorySessionImplStateField) {
        int newLength = SubstrateAllocationSnippets.GC_LOCATIONS.length + 2;
        LocationIdentity[] locations = Arrays.copyOf(SubstrateAllocationSnippets.GC_LOCATIONS, newLength);
        locations[newLength - 2] = SafepointCheckCounter.getLocationIdentity();
        locations[newLength - 1] = new FieldLocationIdentity(memorySessionImplStateField);
        return locations;
    }

    @Node.NodeIntrinsic(value=ForeignCallNode.class)
    private static native void callSlowPathSafepointCheck(@Node.ConstantNodeParameter ForeignCallDescriptor var0);

    class SafepointLowering
    implements NodeLoweringProvider<SafepointNode> {
        SafepointLowering() {
        }

        @Override
        public void lower(SafepointNode node, LoweringTool tool) {
            if (tool.getLoweringStage() == LoweringTool.StandardLoweringStage.LOW_TIER) {
                if (((SharedMethod)node.graph().method()).isUninterruptible()) {
                    throw GraalError.shouldNotReachHere((String)("Must not insert safepoints in Uninterruptible code: " + node.stateBefore().toString(Verbosity.Debugger)));
                }
                SnippetTemplate.Arguments args = new SnippetTemplate.Arguments(SafepointSnippets.this.safepoint, node.graph().getGuardsStage(), tool.getLoweringStage());
                SafepointSnippets.this.template((CoreProviders)tool, (ValueNode)node, args).instantiate(tool.getMetaAccess(), (FixedNode)node, SnippetTemplate.DEFAULT_REPLACER, args);
            }
        }
    }
}

