/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.hub.registry;

import com.oracle.svm.core.hub.RuntimeClassLoading;
import com.oracle.svm.core.hub.registry.AbstractRuntimeClassRegistry;
import com.oracle.svm.core.hub.registry.ClassRegistries;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.espresso.classfile.descriptors.Symbol;
import com.oracle.svm.espresso.classfile.descriptors.Type;
import java.io.IOException;
import java.net.URI;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;

public final class BootClassRegistry
extends AbstractRuntimeClassRegistry {
    private volatile FileSystem jrtFS;

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public BootClassRegistry() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FileSystem getFileSystem() {
        FileSystem fs = this.jrtFS;
        if (fs == null) {
            BootClassRegistry bootClassRegistry = this;
            synchronized (bootClassRegistry) {
                fs = this.jrtFS;
                if (fs == null) {
                    this.jrtFS = fs = FileSystems.getFileSystem(URI.create("jrt:/"));
                }
            }
        }
        return fs;
    }

    @Override
    public synchronized Class<?> doLoadClass(Symbol<Type> type) {
        String pkg = BootClassRegistry.packageFromType(type);
        if (pkg == null) {
            return null;
        }
        try {
            String moduleName = ClassRegistries.getBootModuleForPackage(pkg);
            if (moduleName == null) {
                return null;
            }
            Path classPath = this.getFileSystem().getPath("/modules/" + moduleName + "/" + String.valueOf(type) + ".class", new String[0]);
            if (!Files.exists(classPath, new LinkOption[0])) {
                return null;
            }
            byte[] bytes = Files.readAllBytes(classPath);
            return this.defineClass(type, bytes, 0, bytes.length, RuntimeClassLoading.ClassDefinitionInfo.EMPTY);
        }
        catch (IOException e) {
            throw VMError.shouldNotReachHere(e);
        }
    }

    private static String packageFromType(Symbol<Type> type) {
        int lastSlash = type.lastIndexOf((byte)47);
        if (lastSlash == -1) {
            return null;
        }
        return type.subSequence(0, lastSlash).toString();
    }

    @Override
    protected boolean loaderIsBootOrPlatform() {
        return true;
    }

    @Override
    public ClassLoader getClassLoader() {
        return null;
    }
}

