/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.image;

import com.oracle.svm.core.BuildPhaseProvider;
import com.oracle.svm.core.heap.UnknownPrimitiveField;
import jdk.graal.compiler.debug.Assertions;

public class ImageHeapLayoutInfo {
    @UnknownPrimitiveField(availability=BuildPhaseProvider.AfterHeapLayout.class)
    private final long startOffset;
    @UnknownPrimitiveField(availability=BuildPhaseProvider.AfterHeapLayout.class)
    private final long imageHeapSize;
    @UnknownPrimitiveField(availability=BuildPhaseProvider.AfterHeapLayout.class)
    private final long writableOffset;
    @UnknownPrimitiveField(availability=BuildPhaseProvider.AfterHeapLayout.class)
    private final long writableSize;
    @UnknownPrimitiveField(availability=BuildPhaseProvider.AfterHeapLayout.class)
    private final long readOnlyRelocatableOffset;
    @UnknownPrimitiveField(availability=BuildPhaseProvider.AfterHeapLayout.class)
    private final long readOnlyRelocatableSize;
    @UnknownPrimitiveField(availability=BuildPhaseProvider.AfterHeapLayout.class)
    private final long writablePatchedOffset;
    @UnknownPrimitiveField(availability=BuildPhaseProvider.AfterHeapLayout.class)
    private final long writablePatchedSize;

    public ImageHeapLayoutInfo(long startOffset, long imageHeapSize, long writableOffset, long writableSize, long readOnlyRelocatableOffset, long readOnlyRelocatableSize, long writablePatchedOffset, long writablePatchedSize) {
        this.startOffset = startOffset;
        this.imageHeapSize = imageHeapSize;
        this.writableOffset = writableOffset;
        this.writableSize = writableSize;
        this.readOnlyRelocatableOffset = readOnlyRelocatableOffset;
        this.readOnlyRelocatableSize = readOnlyRelocatableSize;
        this.writablePatchedOffset = writablePatchedOffset;
        this.writablePatchedSize = writablePatchedSize;
        assert (readOnlyRelocatableOffset + readOnlyRelocatableSize <= writablePatchedOffset) : Assertions.errorMessage((Object[])new Object[]{"the writable patched section is placed after the relocations", readOnlyRelocatableOffset, readOnlyRelocatableSize, writablePatchedOffset});
    }

    public long getStartOffset() {
        return this.startOffset;
    }

    public long getImageHeapSize() {
        return this.imageHeapSize;
    }

    public long getWritableOffset() {
        return this.writableOffset;
    }

    public long getWritableSize() {
        return this.writableSize;
    }

    public long getReadOnlyRelocatableOffset() {
        return this.readOnlyRelocatableOffset;
    }

    public long getReadOnlyRelocatableSize() {
        return this.readOnlyRelocatableSize;
    }

    public boolean isReadOnlyRelocatable(long offset) {
        return offset >= this.readOnlyRelocatableOffset && offset < this.readOnlyRelocatableOffset + this.readOnlyRelocatableSize;
    }

    public long getWritablePatchedOffset() {
        return this.writablePatchedOffset;
    }

    public long getWritablePatchedSize() {
        return this.writablePatchedSize;
    }
}

