/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.jfr.events;

import com.oracle.svm.core.JavaMainWrapper;
import com.oracle.svm.core.Uninterruptible;
import java.lang.management.ManagementFactory;
import org.graalvm.nativeimage.ImageSingletons;

public class JVMInformation {
    private String jvmName;
    private String jvmVersion;
    private String jvmArguments;
    private String jvmFlags;
    private String javaArguments;
    private long jvmStartTime;
    private long jvmPid;

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public String getJvmName() {
        return this.jvmName;
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public String getJvmVersion() {
        return this.jvmVersion;
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public String getJvmArguments() {
        return this.jvmArguments;
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public String getJvmFlags() {
        return this.jvmFlags;
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public String getJavaArguments() {
        return this.javaArguments;
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public long getJvmStartTime() {
        return this.jvmStartTime;
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public long getJvmPid() {
        return this.jvmPid;
    }

    public static JVMInformation getJVMInfo() {
        JVMInformation jvmInfo = new JVMInformation();
        if (ImageSingletons.contains(JavaMainWrapper.JavaMainSupport.class)) {
            JavaMainWrapper.JavaMainSupport support = (JavaMainWrapper.JavaMainSupport)ImageSingletons.lookup(JavaMainWrapper.JavaMainSupport.class);
            jvmInfo.jvmName = System.getProperty("java.vm.name");
            jvmInfo.jvmVersion = System.getProperty("java.vm.version");
            jvmInfo.jvmArguments = JVMInformation.getVmArgs(support);
            jvmInfo.jvmFlags = "";
            jvmInfo.javaArguments = support.getJavaCommand();
            jvmInfo.jvmStartTime = ManagementFactory.getRuntimeMXBean().getStartTime();
            jvmInfo.jvmPid = ManagementFactory.getRuntimeMXBean().getPid();
        }
        return jvmInfo;
    }

    private static String getVmArgs(JavaMainWrapper.JavaMainSupport support) {
        StringBuilder vmArgs = new StringBuilder();
        for (String arg : support.getInputArguments()) {
            vmArgs.append(arg).append(' ');
        }
        return vmArgs.toString().trim();
    }
}

