/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.jfr.sampler;

import com.oracle.svm.core.BuildPhaseProvider;
import com.oracle.svm.core.NeverInline;
import com.oracle.svm.core.Uninterruptible;
import com.oracle.svm.core.jfr.SubstrateJVM;
import com.oracle.svm.core.jfr.sampler.AbstractJfrExecutionSampler;
import com.oracle.svm.core.jfr.sampler.JfrExecutionSampler;
import com.oracle.svm.core.snippets.KnownIntrinsics;
import com.oracle.svm.core.thread.RecurringCallbackSupport;
import com.oracle.svm.core.thread.VMOperation;
import com.oracle.svm.core.thread.VMThreads;
import com.oracle.svm.core.util.TimeUtils;
import com.oracle.svm.core.util.VMError;
import jdk.graal.compiler.api.replacements.Fold;
import org.graalvm.nativeimage.CurrentIsolate;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.IsolateThread;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.nativeimage.Threading;
import org.graalvm.nativeimage.c.function.CodePointer;
import org.graalvm.word.Pointer;

public final class JfrRecurringCallbackExecutionSampler
extends AbstractJfrExecutionSampler {
    private static final ExecutionSampleCallback CALLBACK = new ExecutionSampleCallback();

    @Platforms(value={Platform.HOSTED_ONLY.class})
    JfrRecurringCallbackExecutionSampler() {
    }

    @Fold
    public static boolean isPresent() {
        VMError.guarantee(BuildPhaseProvider.isSetupFinished(), "JfrRecurringCallbackExecutionSampler.isPresent() must not be called too early");
        if (ImageSingletons.contains(JfrExecutionSampler.class)) {
            JfrExecutionSampler sampler = (JfrExecutionSampler)ImageSingletons.lookup(JfrExecutionSampler.class);
            return sampler instanceof JfrRecurringCallbackExecutionSampler;
        }
        return false;
    }

    @Override
    protected void startSampling() {
        assert (VMOperation.isInProgressAtSafepoint());
        SubstrateJVM.getSamplerBufferPool().adjustBufferCount();
        IsolateThread thread = VMThreads.firstThread();
        while (thread.isNonNull()) {
            JfrRecurringCallbackExecutionSampler.install(thread, this.createRecurringCallbackTimer());
            thread = VMThreads.nextThread(thread);
        }
    }

    @Override
    protected void updateInterval() {
        assert (VMOperation.isInProgressAtSafepoint());
        IsolateThread thread = VMThreads.firstThread();
        while (thread.isNonNull()) {
            this.uninstall(thread);
            JfrRecurringCallbackExecutionSampler.install(thread, this.createRecurringCallbackTimer());
            thread = VMThreads.nextThread(thread);
        }
    }

    @Override
    protected void stopSampling() {
        assert (VMOperation.isInProgressAtSafepoint());
        IsolateThread thread = VMThreads.firstThread();
        while (thread.isNonNull()) {
            this.uninstall(thread);
            thread = VMThreads.nextThread(thread);
        }
    }

    private RecurringCallbackSupport.RecurringCallbackTimer createRecurringCallbackTimer() {
        return RecurringCallbackSupport.createCallbackTimer(TimeUtils.millisToNanos(this.newIntervalMillis), CALLBACK);
    }

    @Uninterruptible(reason="Prevent VM operations that modify the recurring callbacks.")
    private static void install(IsolateThread thread, RecurringCallbackSupport.RecurringCallbackTimer callbackTimer) {
        Threading.RecurringCallback currentCallback;
        assert (thread == CurrentIsolate.getCurrentThread() || VMOperation.isInProgressAtSafepoint());
        if (AbstractJfrExecutionSampler.ExecutionSamplerInstallation.isAllowed(thread) && (currentCallback = RecurringCallbackSupport.getCallback(thread)) == null) {
            AbstractJfrExecutionSampler.ExecutionSamplerInstallation.installed(thread);
            RecurringCallbackSupport.installCallback(thread, callbackTimer);
        }
    }

    @Override
    @Uninterruptible(reason="Prevent VM operations that modify the recurring callbacks.")
    protected void uninstall(IsolateThread thread) {
        assert (thread == CurrentIsolate.getCurrentThread() || VMOperation.isInProgressAtSafepoint());
        if (AbstractJfrExecutionSampler.ExecutionSamplerInstallation.isInstalled(thread)) {
            Threading.RecurringCallback currentCallback = RecurringCallbackSupport.getCallback(thread);
            if (currentCallback == CALLBACK) {
                RecurringCallbackSupport.uninstallCallback(thread);
            }
            AbstractJfrExecutionSampler.ExecutionSamplerInstallation.uninstalled(thread);
        }
    }

    @Override
    public void beforeThreadRun() {
        RecurringCallbackSupport.RecurringCallbackTimer callback = this.createRecurringCallbackTimer();
        this.beforeThreadRun0(callback);
    }

    @Uninterruptible(reason="Prevent VM operations that modify the execution sampler or the recurring callbacks.")
    private void beforeThreadRun0(RecurringCallbackSupport.RecurringCallbackTimer callback) {
        if (this.isSampling()) {
            SubstrateJVM.getSamplerBufferPool().adjustBufferCount();
            JfrRecurringCallbackExecutionSampler.install(CurrentIsolate.getCurrentThread(), callback);
        }
    }

    private static final class ExecutionSampleCallback
    implements Threading.RecurringCallback {
        private ExecutionSampleCallback() {
        }

        @NeverInline(value="Starting a stack walk in the caller frame")
        @Uninterruptible(reason="Avoid interference with the application.")
        public void run(Threading.RecurringCallbackAccess access) {
            Pointer sp = KnownIntrinsics.readCallerStackPointer();
            CodePointer ip = KnownIntrinsics.readReturnAddress();
            AbstractJfrExecutionSampler.tryUninterruptibleStackWalk(ip, sp, false);
        }
    }
}

