/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.jni.headers;

import com.oracle.svm.core.Uninterruptible;
import com.oracle.svm.core.jni.headers.JNIHeaderDirectives;
import com.oracle.svm.core.util.BasedOnJDKFile;
import org.graalvm.nativeimage.c.CContext;
import org.graalvm.nativeimage.c.constant.CConstant;

@CContext(value=JNIHeaderDirectives.class)
public final class JNIVersion {
    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static boolean isSupported(int version, boolean builtInLibrary) {
        if (version == JNIVersion.JNI_VERSION_LATEST() || version == JNIVersion.JNI_VERSION_24() || version == JNIVersion.JNI_VERSION_21() || version == JNIVersion.JNI_VERSION_20() || version == JNIVersion.JNI_VERSION_19() || version == JNIVersion.JNI_VERSION_10() || version == JNIVersion.JNI_VERSION_9() || version == JNIVersion.JNI_VERSION_1_8()) {
            return true;
        }
        if (builtInLibrary) {
            return false;
        }
        return version == JNIVersion.JNI_VERSION_1_6() || version == JNIVersion.JNI_VERSION_1_4() || version == JNIVersion.JNI_VERSION_1_2() || version == JNIVersion.JNI_VERSION_1_1();
    }

    @CConstant
    public static native int JNI_VERSION_1_1();

    @CConstant
    public static native int JNI_VERSION_1_2();

    @CConstant
    public static native int JNI_VERSION_1_4();

    @CConstant
    public static native int JNI_VERSION_1_6();

    @CConstant
    public static native int JNI_VERSION_1_8();

    @CConstant
    public static native int JNI_VERSION_9();

    @CConstant
    public static native int JNI_VERSION_10();

    @CConstant
    public static native int JNI_VERSION_19();

    @CConstant
    public static native int JNI_VERSION_20();

    @CConstant
    public static native int JNI_VERSION_21();

    @CConstant
    public static native int JNI_VERSION_24();

    @CConstant(value="JNI_VERSION_24")
    @BasedOnJDKFile(value="https://github.com/openjdk/jdk/blob/jdk-24+16/src/java.base/share/native/include/jni.h#L1994-L2006")
    public static native int JNI_VERSION_LATEST();

    private JNIVersion() {
    }
}

