/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.layeredimagesingleton;

import com.oracle.svm.core.graal.RuntimeCompilation;
import com.oracle.svm.core.layeredimagesingleton.ApplicationLayerOnlyImageSingleton;
import com.oracle.svm.core.layeredimagesingleton.LayeredImageSingleton;
import com.oracle.svm.core.layeredimagesingleton.MultiLayeredImageSingleton;
import com.oracle.svm.core.util.VMError;
import java.util.EnumSet;

public final class LayeredImageSingletonBuilderFlags
extends Enum<LayeredImageSingletonBuilderFlags> {
    public static final /* enum */ LayeredImageSingletonBuilderFlags RUNTIME_ACCESS = new LayeredImageSingletonBuilderFlags();
    public static final /* enum */ LayeredImageSingletonBuilderFlags BUILDTIME_ACCESS = new LayeredImageSingletonBuilderFlags();
    public static final /* enum */ LayeredImageSingletonBuilderFlags UNSUPPORTED = new LayeredImageSingletonBuilderFlags();
    public static final EnumSet<LayeredImageSingletonBuilderFlags> BUILDTIME_ACCESS_ONLY;
    public static final EnumSet<LayeredImageSingletonBuilderFlags> RUNTIME_ACCESS_ONLY;
    public static final EnumSet<LayeredImageSingletonBuilderFlags> ALL_ACCESS;
    private static final /* synthetic */ LayeredImageSingletonBuilderFlags[] $VALUES;

    public static LayeredImageSingletonBuilderFlags[] values() {
        return (LayeredImageSingletonBuilderFlags[])$VALUES.clone();
    }

    public static LayeredImageSingletonBuilderFlags valueOf(String name) {
        return Enum.valueOf(LayeredImageSingletonBuilderFlags.class, name);
    }

    public static boolean verifyImageBuilderFlags(LayeredImageSingleton singleton) {
        EnumSet<LayeredImageSingletonBuilderFlags> flags = singleton.getImageBuilderFlags();
        if (!flags.contains((Object)UNSUPPORTED) && !flags.contains((Object)BUILDTIME_ACCESS) && !flags.contains((Object)RUNTIME_ACCESS)) assert (false) : String.format("At least one of the following flags must be set: %s, %s, %s", new Object[]{UNSUPPORTED, BUILDTIME_ACCESS, RUNTIME_ACCESS});
        if (flags.contains((Object)UNSUPPORTED)) assert (flags.equals(EnumSet.of(UNSUPPORTED))) : "Unsupported should be the only flag set " + String.valueOf(flags);
        if (singleton instanceof MultiLayeredImageSingleton || ApplicationLayerOnlyImageSingleton.isSingletonInstanceOf(singleton)) assert (flags.contains((Object)RUNTIME_ACCESS)) : String.format("%s must be set when implementing either %s or %s: %s", new Object[]{RUNTIME_ACCESS, MultiLayeredImageSingleton.class, ApplicationLayerOnlyImageSingleton.class, singleton});
        assert (!(singleton instanceof MultiLayeredImageSingleton) || !ApplicationLayerOnlyImageSingleton.isSingletonInstanceOf(singleton)) : String.format("%s can only implement one of %s or %s", singleton, MultiLayeredImageSingleton.class, ApplicationLayerOnlyImageSingleton.class);
        return true;
    }

    public static void validateRuntimeLookup(Object singleton) {
        if (singleton instanceof LayeredImageSingleton) {
            LayeredImageSingleton layeredSingleton = (LayeredImageSingleton)singleton;
            if (!layeredSingleton.getImageBuilderFlags().contains((Object)RUNTIME_ACCESS) && !RuntimeCompilation.isEnabled()) {
                throw VMError.shouldNotReachHere("Layered image singleton without runtime access is in runtime graph: " + String.valueOf(layeredSingleton));
            }
            if (layeredSingleton instanceof MultiLayeredImageSingleton) {
                throw VMError.shouldNotReachHere("Forbidden lookup of MultiLayeredImageSingleton in runtime graph: " + String.valueOf(layeredSingleton));
            }
        }
    }

    private static /* synthetic */ LayeredImageSingletonBuilderFlags[] $values() {
        return new LayeredImageSingletonBuilderFlags[]{RUNTIME_ACCESS, BUILDTIME_ACCESS, UNSUPPORTED};
    }

    static {
        $VALUES = LayeredImageSingletonBuilderFlags.$values();
        BUILDTIME_ACCESS_ONLY = EnumSet.of(BUILDTIME_ACCESS);
        RUNTIME_ACCESS_ONLY = EnumSet.of(RUNTIME_ACCESS);
        ALL_ACCESS = EnumSet.of(RUNTIME_ACCESS, BUILDTIME_ACCESS);
    }
}

