/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.posix.darwin;

import com.oracle.svm.core.Uninterruptible;
import com.oracle.svm.core.feature.AutomaticallyRegisteredImageSingleton;
import com.oracle.svm.core.graal.stackvalue.UnsafeStackValue;
import com.oracle.svm.core.posix.headers.darwin.DarwinThreadInfo;
import com.oracle.svm.core.thread.ThreadCpuTimeSupport;
import com.oracle.svm.core.thread.VMThreads;
import com.oracle.svm.core.util.BasedOnJDKFile;
import org.graalvm.nativeimage.CurrentIsolate;
import org.graalvm.nativeimage.IsolateThread;
import org.graalvm.nativeimage.StackValue;
import org.graalvm.nativeimage.c.type.CIntPointer;

@AutomaticallyRegisteredImageSingleton(value={ThreadCpuTimeSupport.class})
final class DarwinThreadCpuTimeSupport
implements ThreadCpuTimeSupport {
    DarwinThreadCpuTimeSupport() {
    }

    @Override
    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public long getCurrentThreadCpuTime(boolean includeSystemTime) {
        return this.getThreadCpuTime(CurrentIsolate.getCurrentThread(), includeSystemTime);
    }

    @Override
    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public long getThreadCpuTime(IsolateThread isolateThread, boolean includeSystemTime) {
        int machThread = (int)VMThreads.getOSThreadId(isolateThread).rawValue();
        return DarwinThreadCpuTimeSupport.getThreadCpuTime(machThread, includeSystemTime);
    }

    @BasedOnJDKFile(value="https://github.com/openjdk/jdk/blob/jdk-23+10/src/hotspot/os/bsd/os_bsd.cpp#L2429-L2454")
    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    private static long getThreadCpuTime(int machThread, boolean includeSystemTime) {
        CIntPointer sizePointer = (CIntPointer)UnsafeStackValue.get(4);
        sizePointer.write(DarwinThreadInfo.THREAD_INFO_MAX());
        DarwinThreadInfo.thread_basic_info_data_t tinfo = (DarwinThreadInfo.thread_basic_info_data_t)StackValue.get(DarwinThreadInfo.thread_basic_info_data_t.class);
        int ret = DarwinThreadInfo.thread_info(machThread, DarwinThreadInfo.THREAD_BASIC_INFO(), tinfo, sizePointer);
        if (ret != 0) {
            return -1L;
        }
        long seconds = tinfo.user_time().seconds();
        long micros = tinfo.user_time().microseconds();
        if (includeSystemTime) {
            seconds += (long)tinfo.system_time().seconds();
            micros += (long)tinfo.system_time().microseconds();
        }
        return seconds * 1000000000L + micros * 1000L;
    }
}

