/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.reflect.serialize;

import com.oracle.svm.configure.config.ConfigurationType;
import com.oracle.svm.core.MissingRegistrationUtils;
import com.oracle.svm.core.reflect.serialize.MissingSerializationRegistrationError;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamClass;
import java.util.Map;
import java.util.Set;
import jdk.graal.compiler.util.json.JsonPrintable;

public final class MissingSerializationRegistrationUtils
extends MissingRegistrationUtils {
    private static final Map<String, Set<String>> serializationEntryPoints = Map.of(ObjectOutputStream.class.getTypeName(), Set.of("writeObject", "writeUnshared"), ObjectInputStream.class.getTypeName(), Set.of("readObject", "readUnshared"), ObjectStreamClass.class.getTypeName(), Set.of("lookup"), "sun.reflect.ReflectionFactory", Set.of("newConstructorForSerialization"), "jdk.internal.reflect.ReflectionFactory", Set.of("newConstructorForSerialization"));

    public static void reportSerialization(Class<?> cl) {
        MissingSerializationRegistrationUtils.reportSerialization(cl, MissingSerializationRegistrationUtils.typeDescriptor(cl));
    }

    public static void reportSerialization(Class<?> cl, String serializedType) {
        ConfigurationType type = MissingSerializationRegistrationUtils.getConfigurationType(cl);
        type.setSerializable();
        MissingSerializationRegistrationError exception = new MissingSerializationRegistrationError(MissingSerializationRegistrationUtils.serializationMessage(MissingSerializationRegistrationUtils.elementToJSON((JsonPrintable)type), serializedType), cl);
        StackTraceElement responsibleClass = MissingSerializationRegistrationUtils.getResponsibleClass(exception);
        MissingRegistrationUtils.report(exception, responsibleClass);
    }

    private static String serializationMessage(String json, String typeDescriptor) {
        return MissingSerializationRegistrationUtils.registrationMessage("serialize or deserialize", typeDescriptor, json, "", "reflection", "reflection");
    }

    private static StackTraceElement getResponsibleClass(MissingSerializationRegistrationError t) {
        StackTraceElement[] stackTrace = t.getStackTrace();
        boolean previous = false;
        StackTraceElement lastElem = null;
        for (StackTraceElement stackTraceElement : stackTrace) {
            if (previous) {
                previous = false;
                lastElem = stackTraceElement;
            }
            if (!serializationEntryPoints.getOrDefault(stackTraceElement.getClassName(), Set.of()).contains(stackTraceElement.getMethodName())) continue;
            previous = true;
        }
        return lastElem;
    }
}

