/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.thread;

import com.oracle.svm.core.NeverInline;
import com.oracle.svm.core.SubstrateOptions;
import com.oracle.svm.core.Uninterruptible;
import com.oracle.svm.core.c.function.CFunctionOptions;
import com.oracle.svm.core.config.ConfigurationValues;
import com.oracle.svm.core.graal.isolated.IsolatedCompileClient;
import com.oracle.svm.core.graal.isolated.IsolatedCompileContext;
import com.oracle.svm.core.graal.nodes.WriteCurrentVMThreadNode;
import com.oracle.svm.core.heap.Heap;
import com.oracle.svm.core.heap.VMOperationInfos;
import com.oracle.svm.core.jdk.UninterruptibleUtils;
import com.oracle.svm.core.layeredimagesingleton.InitialLayerOnlyImageSingleton;
import com.oracle.svm.core.layeredimagesingleton.LayeredImageSingletonBuilderFlags;
import com.oracle.svm.core.locks.VMCondition;
import com.oracle.svm.core.locks.VMLockSupport;
import com.oracle.svm.core.locks.VMMutex;
import com.oracle.svm.core.log.Log;
import com.oracle.svm.core.memory.UntrackedNullableNativeMemory;
import com.oracle.svm.core.nodes.CFunctionEpilogueNode;
import com.oracle.svm.core.nodes.CFunctionPrologueNode;
import com.oracle.svm.core.nodes.CodeSynchronizationNode;
import com.oracle.svm.core.thread.JavaVMOperation;
import com.oracle.svm.core.thread.PlatformThreads;
import com.oracle.svm.core.thread.RecurringCallbackSupport;
import com.oracle.svm.core.thread.SafepointCheckCounter;
import com.oracle.svm.core.thread.VMOperation;
import com.oracle.svm.core.threadlocal.FastThreadLocalBytes;
import com.oracle.svm.core.threadlocal.FastThreadLocalFactory;
import com.oracle.svm.core.threadlocal.FastThreadLocalInt;
import com.oracle.svm.core.threadlocal.FastThreadLocalWord;
import com.oracle.svm.core.threadlocal.VMThreadLocalSupport;
import com.oracle.svm.core.util.UnsignedUtils;
import com.oracle.svm.core.util.VMError;
import java.util.EnumSet;
import jdk.graal.compiler.api.directives.GraalDirectives;
import jdk.graal.compiler.api.replacements.Fold;
import jdk.graal.compiler.core.common.SuppressFBWarnings;
import jdk.graal.compiler.nodes.PauseNode;
import jdk.graal.compiler.replacements.ReplacementsUtil;
import jdk.graal.compiler.replacements.nodes.AssertionNode;
import jdk.graal.compiler.word.Word;
import jdk.vm.ci.aarch64.AArch64;
import org.graalvm.nativeimage.CurrentIsolate;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.Isolate;
import org.graalvm.nativeimage.IsolateThread;
import org.graalvm.nativeimage.c.function.CFunction;
import org.graalvm.nativeimage.c.struct.RawPointerTo;
import org.graalvm.nativeimage.c.struct.RawStructure;
import org.graalvm.nativeimage.c.type.CCharPointer;
import org.graalvm.word.ComparableWord;
import org.graalvm.word.Pointer;
import org.graalvm.word.PointerBase;
import org.graalvm.word.UnsignedWord;
import org.graalvm.word.WordBase;

public abstract class VMThreads
implements InitialLayerOnlyImageSingleton {
    protected static final VMMutex THREAD_MUTEX = new VMMutex("thread");
    protected static final VMCondition THREAD_LIST_CONDITION = new VMCondition(THREAD_MUTEX);
    private static IsolateThread head;
    private static int numAttachedThreads;
    private static final UninterruptibleUtils.AtomicWord<OSThreadHandle> detachedOsThreadToCleanup;
    public static final FastThreadLocalWord<IsolateThread> nextTL;
    public static final FastThreadLocalWord<OSThreadId> OSThreadIdTL;
    public static final FastThreadLocalWord<OSThreadHandle> OSThreadHandleTL;
    public static final FastThreadLocalWord<Isolate> IsolateTL;
    public static final FastThreadLocalWord<UnsignedWord> StackBase;
    public static final FastThreadLocalWord<UnsignedWord> StackEnd;
    private static final FastThreadLocalBytes<Pointer> StartedByCurrentIsolate;
    private static final int STATE_UNINITIALIZED = 1;
    private static final int STATE_INITIALIZING = 2;
    private static final int STATE_INITIALIZED = 3;
    private static final int STATE_TEARING_DOWN = 4;
    private static final UninterruptibleUtils.AtomicInteger initializationState;
    private static final FastThreadLocalWord<Pointer> unalignedIsolateThreadMemoryTL;

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static VMThreads singleton() {
        return (VMThreads)ImageSingletons.lookup(VMThreads.class);
    }

    @Uninterruptible(reason="Called from uninterruptible code. Too early for safepoints.")
    public static boolean isInitialized() {
        return initializationState.get() >= 3;
    }

    @Uninterruptible(reason="Called from uninterruptible code during tear down.")
    public static boolean isTearingDown() {
        return initializationState.get() >= 4;
    }

    static void setTearingDown() {
        initializationState.set(4);
    }

    @Uninterruptible(reason="Called from uninterruptible code. Too early for safepoints.")
    public static boolean ensureInitialized() {
        boolean result = true;
        if (initializationState.compareAndSet(1, 2)) {
            result = VMThreads.singleton().initializeOnce();
            initializationState.set(3);
        } else {
            while (initializationState.get() < 3) {
                PauseNode.pause();
            }
        }
        return result;
    }

    @Uninterruptible(reason="Called from uninterruptible code. Too early for safepoints.")
    protected boolean initializeOnce() {
        return VMLockSupport.singleton().initialize();
    }

    @Uninterruptible(reason="The isolate teardown is in progress.")
    protected boolean destroy() {
        return VMLockSupport.singleton().destroy();
    }

    @Uninterruptible(reason="Thread state not set up.")
    public IsolateThread allocateIsolateThread(int isolateThreadSize) {
        UnsignedWord alignment = Word.unsigned((int)64);
        UnsignedWord memorySize = Word.unsigned((int)isolateThreadSize).add(alignment);
        Pointer memory = (Pointer)UntrackedNullableNativeMemory.calloc(memorySize);
        if (memory.isNull()) {
            return (IsolateThread)Word.nullPointer();
        }
        IsolateThread isolateThread = (IsolateThread)UnsignedUtils.roundUp((UnsignedWord)memory, alignment);
        unalignedIsolateThreadMemoryTL.set(isolateThread, memory);
        return isolateThread;
    }

    @Uninterruptible(reason="Thread state no longer set up.")
    public void freeCurrentIsolateThread() {
        this.freeIsolateThread(CurrentIsolate.getCurrentThread());
        WriteCurrentVMThreadNode.writeCurrentVMThread((IsolateThread)Word.nullPointer());
    }

    @Uninterruptible(reason="Thread state no longer set up.")
    protected void freeIsolateThread(IsolateThread thread) {
        Pointer memory = unalignedIsolateThreadMemoryTL.get(thread);
        UntrackedNullableNativeMemory.free((PointerBase)memory);
    }

    @Uninterruptible(reason="Unknown thread state.")
    public abstract void failFatally(int var1, CCharPointer var2);

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static IsolateThread firstThread() {
        VMThreads.guaranteeOwnsThreadMutex("Threads mutex must be locked before accessing/iterating the thread list.");
        return VMThreads.firstThreadUnsafe();
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static IsolateThread firstThreadUnsafe() {
        return head;
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static IsolateThread nextThread(IsolateThread cur) {
        return nextTL.get(cur);
    }

    @Uninterruptible(reason="Thread is not attached yet.")
    public int attachThread(IsolateThread thread, boolean startedByCurrentIsolate) {
        StartedByCurrentIsolate.getAddress().writeByte(0, (byte)(startedByCurrentIsolate ? 1 : 0));
        return this.attachThread(thread);
    }

    @Uninterruptible(reason="Thread is not attached yet.")
    protected int attachThread(IsolateThread thread) {
        assert (StatusSupport.isStatusCreated(thread)) : "Status should be initialized on creation.";
        OSThreadIdTL.set(thread, this.getCurrentOSThreadId());
        OSThreadHandleTL.set(thread, this.getCurrentOSThreadHandle());
        assert (!RecurringCallbackSupport.isCallbackInstalled(thread));
        SafepointCheckCounter.setVolatile(thread, Integer.MAX_VALUE);
        THREAD_MUTEX.lockNoTransition();
        try {
            nextTL.set(thread, head);
            head = thread;
            assert (++numAttachedThreads > 0);
            if (!VMThreads.wasStartedByCurrentIsolate(thread)) {
                PlatformThreads.incrementNonDaemonThreads();
            }
            Heap.getHeap().attachThread(CurrentIsolate.getCurrentThread());
            ActionOnTransitionToJavaSupport.setSynchronizeCode(thread);
            StatusSupport.setStatusNative(thread);
            THREAD_LIST_CONDITION.broadcast();
        }
        finally {
            THREAD_MUTEX.unlock();
        }
        return 0;
    }

    @Uninterruptible(reason="IsolateThread will be freed.")
    public void detachCurrentThread() {
        this.threadExit();
        this.detachThread(CurrentIsolate.getCurrentThread(), true);
        WriteCurrentVMThreadNode.writeCurrentVMThread((IsolateThread)Word.nullPointer());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Uninterruptible(reason="IsolateThread will be freed. Holds the THREAD_MUTEX.")
    protected void detachThread(IsolateThread thread, boolean currentThread) {
        assert (currentThread == (thread == CurrentIsolate.getCurrentThread()));
        assert (currentThread || VMOperation.isInProgressAtSafepoint());
        OSThreadHandle threadToCleanup = (OSThreadHandle)Word.nullPointer();
        if (currentThread) {
            VMThreads.lockThreadMutexInNativeCode(false);
        }
        try {
            VMThreads.removeFromThreadList(thread);
            PlatformThreads.detach(thread);
            Heap.getHeap().detachThread(thread);
            OSThreadHandle threadHandle = VMThreads.getOSThreadHandle(thread);
            if (VMThreads.wasStartedByCurrentIsolate(thread)) {
                threadToCleanup = detachedOsThreadToCleanup.getAndSet(threadHandle);
            } else {
                PlatformThreads.singleton().closeOSThreadHandle(threadHandle);
            }
        }
        finally {
            if (currentThread) {
                THREAD_MUTEX.unlock();
            }
        }
        this.cleanupExitedOsThread(threadToCleanup);
        this.freeIsolateThread(thread);
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static boolean wasStartedByCurrentIsolate(IsolateThread thread) {
        return StartedByCurrentIsolate.getAddress(thread).readByte(0) != 0;
    }

    @Uninterruptible(reason="Thread locks/holds the THREAD_MUTEX.", callerMustBe=true)
    static void lockThreadMutexInNativeCode() {
        VMThreads.lockThreadMutexInNativeCode(false);
    }

    @Uninterruptible(reason="Thread locks/holds the THREAD_MUTEX.", callerMustBe=true)
    @NeverInline(value="Must not be inlined in a caller that has an exception handler: We only support InvokeNode and not InvokeWithExceptionNode between a CFunctionPrologueNode and CFunctionEpilogueNode.")
    private static void lockThreadMutexInNativeCode(boolean unspecifiedOwner) {
        CFunctionPrologueNode.cFunctionPrologue(3);
        VMThreads.lockThreadMutexInNativeCode0(unspecifiedOwner);
        CFunctionEpilogueNode.cFunctionEpilogue(3);
    }

    @Uninterruptible(reason="Must not stop while in native.")
    @NeverInline(value="Provide a return address for the Java frame anchor.")
    private static void lockThreadMutexInNativeCode0(boolean unspecifiedOwner) {
        if (unspecifiedOwner) {
            THREAD_MUTEX.lockNoTransitionUnspecifiedOwner();
        } else {
            THREAD_MUTEX.lockNoTransition();
        }
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    protected void cleanupExitedOsThreads() {
        OSThreadHandle threadToCleanup = detachedOsThreadToCleanup.getAndSet((OSThreadHandle)Word.nullPointer());
        this.cleanupExitedOsThread(threadToCleanup);
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    private void cleanupExitedOsThread(OSThreadHandle threadToCleanup) {
        if (threadToCleanup.isNonNull()) {
            this.joinNoTransition(threadToCleanup);
        }
    }

    @Uninterruptible(reason="Thread is detaching and holds the THREAD_MUTEX.")
    private static void removeFromThreadList(IsolateThread thread) {
        IsolateThread previous = (IsolateThread)Word.nullPointer();
        IsolateThread current = head;
        while (current.isNonNull()) {
            IsolateThread next = nextTL.get(current);
            if (current == thread) {
                if (previous.isNull()) {
                    head = next;
                } else {
                    nextTL.set(previous, next);
                }
                nextTL.set(thread, thread);
                assert (--numAttachedThreads >= 0);
                break;
            }
            previous = current;
            current = next;
        }
        THREAD_LIST_CONDITION.broadcast();
    }

    @Uninterruptible(reason="Called from uninterruptible code, but still safe at this point.", calleeMustBe=false)
    public void threadExit() {
        Thread javaThread = PlatformThreads.currentThread.get();
        if (javaThread != null) {
            PlatformThreads.exit(javaThread);
        }
        PlatformThreads.afterThreadExit(CurrentIsolate.getCurrentThread());
    }

    @Uninterruptible(reason="Only uninterruptible code may be executed after VMThreads#threadExit.")
    public void waitUntilDetachedThreadsExitedOnOSLevel() {
        this.cleanupExitedOsThreads();
    }

    public static void detachAllThreadsExceptCurrentWithoutCleanupForTearDown() {
        DetachAllExternallyStartedThreadsExceptCurrentOperation vmOp = new DetachAllExternallyStartedThreadsExceptCurrentOperation();
        vmOp.enqueue();
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    protected abstract void joinNoTransition(OSThreadHandle var1);

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    protected abstract OSThreadHandle getCurrentOSThreadHandle();

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    protected abstract OSThreadId getCurrentOSThreadId();

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public void nativeSleep(int milliseconds) {
        throw VMError.shouldNotReachHereAtRuntime();
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public void yield() {
        throw VMError.shouldNotReachHereAtRuntime();
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public boolean supportsNativeYieldAndSleep() {
        return false;
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public boolean verifyThreadIsAttached(IsolateThread thread) {
        return VMThreads.nextThread(thread) != thread;
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public boolean verifyIsCurrentThread(IsolateThread thread) {
        OSThreadId osThreadId = this.getCurrentOSThreadId();
        return OSThreadIdTL.get(thread).equal((ComparableWord)osThreadId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Uninterruptible(reason="Locking without transition requires that the whole critical section is uninterruptible.")
    @SuppressFBWarnings(value={"UC"}, justification="FB does not know that VMMutex objects are replaced, i.e., that the lock/unlock methods do not throw an error at run time.")
    public IsolateThread findIsolateThreadForCurrentOSThread(boolean inCrashHandler) {
        boolean needsLock;
        ThreadLookup threadLookup = (ThreadLookup)ImageSingletons.lookup(ThreadLookup.class);
        ComparableWord identifier = threadLookup.getThreadIdentifier();
        boolean bl = needsLock = !inCrashHandler;
        if (needsLock) {
            THREAD_MUTEX.lockNoTransitionUnspecifiedOwner();
        }
        try {
            IsolateThread thread = VMThreads.firstThreadUnsafe();
            while (thread.isNonNull() && !threadLookup.matchesThread(thread, identifier)) {
                thread = VMThreads.nextThread(thread);
            }
            IsolateThread isolateThread = thread;
            return isolateThread;
        }
        finally {
            if (needsLock) {
                THREAD_MUTEX.unlockNoTransitionUnspecifiedOwner();
            }
        }
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static OSThreadHandle getOSThreadHandle(IsolateThread isolateThread) {
        return OSThreadHandleTL.get(isolateThread);
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static OSThreadId getOSThreadId(IsolateThread isolateThread) {
        return OSThreadIdTL.get(isolateThread);
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static void guaranteeOwnsThreadMutex(String message) {
        THREAD_MUTEX.guaranteeIsOwner(message);
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static void guaranteeOwnsThreadMutex(String message, boolean allowUnspecifiedOwner) {
        THREAD_MUTEX.guaranteeIsOwner(message, allowUnspecifiedOwner);
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static boolean ownsThreadMutex() {
        return THREAD_MUTEX.isOwner();
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static boolean ownsThreadMutex(boolean allowUnspecifiedOwner) {
        return THREAD_MUTEX.isOwner(allowUnspecifiedOwner);
    }

    public static boolean printLocationInfo(Log log, UnsignedWord value, boolean allowUnsafeOperations) {
        if (!allowUnsafeOperations && !VMOperation.isInProgressAtSafepoint()) {
            return false;
        }
        IsolateThread thread = VMThreads.firstThreadUnsafe();
        while (thread.isNonNull()) {
            if (thread.equal((ComparableWord)value)) {
                log.string("is a thread");
                return true;
            }
            UnsignedWord stackBase = StackBase.get(thread);
            UnsignedWord stackEnd = StackEnd.get(thread);
            if (value.belowThan(stackBase) && value.aboveOrEqual(stackEnd)) {
                log.string("points into the stack for thread ").zhex((WordBase)thread);
                return true;
            }
            int sizeOfThreadLocals = ((VMThreadLocalSupport)ImageSingletons.lookup(VMThreadLocalSupport.class)).vmThreadSize;
            UnsignedWord endOfThreadLocals = ((UnsignedWord)thread).add(sizeOfThreadLocals);
            if (value.aboveOrEqual((UnsignedWord)thread) && value.belowThan(endOfThreadLocals)) {
                log.string("points into the thread locals for thread ").zhex((WordBase)thread);
                return true;
            }
            thread = VMThreads.nextThread(thread);
        }
        return false;
    }

    @Override
    public EnumSet<LayeredImageSingletonBuilderFlags> getImageBuilderFlags() {
        return LayeredImageSingletonBuilderFlags.RUNTIME_ACCESS_ONLY;
    }

    static {
        numAttachedThreads = 0;
        detachedOsThreadToCleanup = new UninterruptibleUtils.AtomicWord();
        nextTL = FastThreadLocalFactory.createWord("VMThreads.nextTL");
        OSThreadIdTL = FastThreadLocalFactory.createWord("VMThreads.OSThreadIdTL");
        OSThreadHandleTL = FastThreadLocalFactory.createWord("VMThreads.OSThreadHandleTL");
        IsolateTL = FastThreadLocalFactory.createWord("VMThreads.IsolateTL");
        StackBase = FastThreadLocalFactory.createWord("VMThreads.StackBase");
        StackEnd = FastThreadLocalFactory.createWord("VMThreads.StackEnd");
        StartedByCurrentIsolate = FastThreadLocalFactory.createBytes(() -> 1, "VMThreads.StartedByCurrentIsolate");
        initializationState = new UninterruptibleUtils.AtomicInteger(1);
        unalignedIsolateThreadMemoryTL = FastThreadLocalFactory.createWord("VMThreads.unalignedIsolateThreadMemoryTL");
    }

    public static class StatusSupport {
        public static final FastThreadLocalInt statusTL = (FastThreadLocalInt)FastThreadLocalFactory.createInt("StatusSupport.status").setMaxOffset(63);
        public static final int STATUS_ILLEGAL = -1;
        public static final int STATUS_CREATED = 0;
        public static final int STATUS_IN_JAVA = 1;
        public static final int STATUS_IN_SAFEPOINT = 2;
        public static final int STATUS_IN_NATIVE = 3;
        public static final int STATUS_IN_VM = 4;
        private static final int MAX_STATUS = 4;

        @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
        private static String statusToString(int status) {
            switch (status) {
                case 0: {
                    return "STATUS_CREATED";
                }
                case 1: {
                    return "STATUS_IN_JAVA";
                }
                case 2: {
                    return "STATUS_IN_SAFEPOINT";
                }
                case 3: {
                    return "STATUS_IN_NATIVE";
                }
                case 4: {
                    return "STATUS_IN_VM";
                }
            }
            return "STATUS error";
        }

        @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
        public static String getStatusString(IsolateThread vmThread) {
            return StatusSupport.statusToString(statusTL.getVolatile(vmThread));
        }

        @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
        public static int getStatusVolatile(IsolateThread vmThread) {
            return statusTL.getVolatile(vmThread);
        }

        @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
        public static int getStatusVolatile() {
            return statusTL.getVolatile();
        }

        @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
        public static void setStatusNative() {
            statusTL.setVolatile(3);
        }

        @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
        public static void setStatusNative(IsolateThread vmThread) {
            statusTL.setVolatile(vmThread, 3);
        }

        public static boolean compareAndSetNativeToSafepoint(IsolateThread vmThread) {
            return statusTL.compareAndSet(vmThread, 3, 2);
        }

        @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
        public static void setStatusJavaUnguarded() {
            statusTL.setVolatile(1);
        }

        @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
        public static void setStatusVM() {
            statusTL.setVolatile(4);
        }

        @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
        public static boolean compareAndSetNativeToNewStatus(int newStatus) {
            return statusTL.compareAndSet(3, newStatus);
        }

        @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
        public static boolean isStatusCreated(IsolateThread vmThread) {
            return statusTL.getVolatile(vmThread) == 0;
        }

        @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
        public static boolean isStatusNativeOrSafepoint(IsolateThread vmThread) {
            int status = statusTL.getVolatile(vmThread);
            return status == 3 || status == 2;
        }

        @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
        public static boolean isStatusNativeOrSafepoint() {
            int status = statusTL.getVolatile();
            return status == 3 || status == 2;
        }

        @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
        public static boolean isStatusVM() {
            return statusTL.getVolatile() == 4;
        }

        @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
        public static boolean isStatusJava() {
            return statusTL.getVolatile() == 1;
        }

        @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
        public static void assertStatusJava() {
            String msg = "Thread status must be 'Java'.";
            if (GraalDirectives.inIntrinsic()) {
                if (ReplacementsUtil.REPLACEMENTS_ASSERTIONS_ENABLED) {
                    AssertionNode.dynamicAssert((boolean)StatusSupport.isStatusJava(), (String)msg);
                }
            } else assert (StatusSupport.isStatusJava()) : msg;
        }

        @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
        public static void assertStatusNativeOrSafepoint() {
            String msg = "Thread status must be 'native' or 'safepoint'.";
            if (GraalDirectives.inIntrinsic()) {
                if (ReplacementsUtil.REPLACEMENTS_ASSERTIONS_ENABLED) {
                    AssertionNode.dynamicAssert((boolean)StatusSupport.isStatusNativeOrSafepoint(), (String)msg);
                }
            } else assert (StatusSupport.isStatusNativeOrSafepoint()) : msg;
        }

        @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
        public static void assertStatusVM() {
            String msg = "Thread status must be 'VM'.";
            if (GraalDirectives.inIntrinsic()) {
                if (ReplacementsUtil.REPLACEMENTS_ASSERTIONS_ENABLED) {
                    AssertionNode.dynamicAssert((boolean)StatusSupport.isStatusVM(), (String)msg);
                }
            } else assert (StatusSupport.isStatusVM()) : msg;
        }

        public static boolean isValidStatus(int status) {
            return status > -1 && status <= 4;
        }

        public static int getNewThreadStatus(CFunction.Transition transition) {
            switch (transition) {
                case NO_TRANSITION: {
                    return -1;
                }
                case TO_NATIVE: {
                    return 3;
                }
            }
            throw VMError.shouldNotReachHere("Unknown transition type " + String.valueOf(transition));
        }

        public static int getNewThreadStatus(CFunctionOptions.Transition transition) {
            switch (transition) {
                case TO_VM: {
                    return 4;
                }
            }
            throw VMError.shouldNotReachHere("Unknown transition type " + String.valueOf((Object)transition));
        }
    }

    public static interface OSThreadId
    extends PointerBase {
    }

    @RawStructure
    public static interface OSThreadHandle
    extends PointerBase {
    }

    public static class ActionOnTransitionToJavaSupport {
        private static final FastThreadLocalInt actionTL = FastThreadLocalFactory.createInt("ActionOnTransitionToJavaSupport.actionTL");
        private static final int NO_ACTION = 0;
        private static final int SYNCHRONIZE_CODE = 1;

        @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
        public static boolean isActionPending() {
            if (!ActionOnTransitionToJavaSupport.isAarch64()) {
                return false;
            }
            return actionTL.get() != 0;
        }

        @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
        public static void runPendingActions() {
            if (!ActionOnTransitionToJavaSupport.isAarch64() || !ActionOnTransitionToJavaSupport.isActionPending()) {
                return;
            }
            assert (actionTL.get() == 1);
            CodeSynchronizationNode.synchronizeCode();
            actionTL.set(0);
        }

        @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
        public static void setSynchronizeCode(IsolateThread vmThread) {
            if (!ActionOnTransitionToJavaSupport.isAarch64()) {
                return;
            }
            assert (StatusSupport.isStatusCreated(vmThread) || VMOperation.isInProgressAtSafepoint()) : "Invariant to avoid races between setting and clearing.";
            actionTL.set(vmThread, 1);
        }

        public static void requestAllThreadsSynchronizeCode() {
            assert (ActionOnTransitionToJavaSupport.isAarch64());
            IsolateThread myself = CurrentIsolate.getCurrentThread();
            IsolateThread vmThread = VMThreads.firstThread();
            while (vmThread.isNonNull()) {
                if (myself != vmThread) {
                    ActionOnTransitionToJavaSupport.setSynchronizeCode(vmThread);
                }
                vmThread = VMThreads.nextThread(vmThread);
            }
        }

        @Fold
        static boolean isAarch64() {
            return ConfigurationValues.getTarget().arch instanceof AArch64;
        }
    }

    private static class DetachAllExternallyStartedThreadsExceptCurrentOperation
    extends JavaVMOperation {
        DetachAllExternallyStartedThreadsExceptCurrentOperation() {
            super(VMOperationInfos.get(DetachAllExternallyStartedThreadsExceptCurrentOperation.class, "Detach all externally started threads except current", VMOperation.SystemEffect.SAFEPOINT));
        }

        @Override
        protected void operate() {
            IsolateThread operationThread = CurrentIsolate.getCurrentThread();
            IsolateThread thread = VMThreads.firstThread();
            while (thread.isNonNull()) {
                IsolateThread next = VMThreads.nextThread(thread);
                if (thread.notEqual((ComparableWord)this.queuingThread) && thread.notEqual((ComparableWord)operationThread) && !VMThreads.wasStartedByCurrentIsolate(thread)) {
                    VMThreads.singleton().detachThread(thread, false);
                }
                thread = next;
            }
        }
    }

    public static class ThreadLookup
    implements InitialLayerOnlyImageSingleton {
        @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
        public ComparableWord getThreadIdentifier() {
            return VMThreads.singleton().getCurrentOSThreadId();
        }

        @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
        public boolean matchesThread(IsolateThread thread, ComparableWord identifier) {
            return OSThreadIdTL.get(thread).equal(identifier);
        }

        @Override
        public EnumSet<LayeredImageSingletonBuilderFlags> getImageBuilderFlags() {
            return LayeredImageSingletonBuilderFlags.RUNTIME_ACCESS_ONLY;
        }
    }

    @RawPointerTo(value=OSThreadHandle.class)
    public static interface OSThreadHandlePointer
    extends PointerBase {
        public void write(int var1, OSThreadHandle var2);

        public OSThreadHandle read(int var1);
    }

    public static class SafepointBehavior {
        private static final FastThreadLocalInt safepointBehaviorTL = FastThreadLocalFactory.createInt("StatusSupport.safepointBehaviorTL");
        public static final int ALLOW_SAFEPOINT = 0;
        public static final int PREVENT_VM_FROM_REACHING_SAFEPOINT = 1;
        public static final int THREAD_CRASHED = 2;

        @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
        public static boolean ignoresSafepoints() {
            return safepointBehaviorTL.getVolatile() != 0;
        }

        @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
        public static boolean ignoresSafepoints(IsolateThread vmThread) {
            return safepointBehaviorTL.getVolatile(vmThread) != 0;
        }

        @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
        public static int getSafepointBehaviorVolatile(IsolateThread vmThread) {
            return safepointBehaviorTL.getVolatile(vmThread);
        }

        @Uninterruptible(reason="May only be called from uninterruptible code to prevent races with the safepoint handling.", callerMustBe=true)
        public static void preventSafepoints() {
            safepointBehaviorTL.setVolatile(1);
        }

        @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
        public static void markThreadAsCrashed() {
            if (SubstrateOptions.supportCompileInIsolates()) {
                IsolatedCompileClient compileClient;
                IsolatedCompileContext compileContext = IsolatedCompileContext.get();
                if (compileContext != null) {
                    safepointBehaviorTL.setVolatile(compileContext.getClient(), 2);
                }
                if ((compileClient = IsolatedCompileClient.get()) != null) {
                    safepointBehaviorTL.setVolatile(compileClient.getCompiler(), 2);
                }
            }
            safepointBehaviorTL.setVolatile(2);
        }

        @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
        public static boolean isCrashedThread(IsolateThread thread) {
            return safepointBehaviorTL.getVolatile(thread) == 2;
        }

        @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
        public static String toString(int safepointBehavior) {
            switch (safepointBehavior) {
                case 0: {
                    return "ALLOW_SAFEPOINT";
                }
                case 1: {
                    return "PREVENT_VM_FROM_REACHING_SAFEPOINT";
                }
                case 2: {
                    return "THREAD_CRASHED";
                }
            }
            return "Invalid safepoint behavior";
        }
    }
}

