/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.graal.meta;

import com.oracle.svm.core.util.ByteArrayReader;
import java.util.Arrays;
import jdk.graal.compiler.core.common.util.TypeConversion;
import jdk.graal.compiler.core.common.util.UnsafeArrayTypeReader;
import jdk.graal.compiler.core.common.util.UnsafeArrayTypeWriter;
import jdk.vm.ci.meta.LineNumberTable;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;

public class EncodedLineNumberTable {
    @Platforms(value={Platform.HOSTED_ONLY.class})
    public static byte[] encode(LineNumberTable table) {
        if (table == null) {
            return null;
        }
        int[] lineNumbers = table.getLineNumbers();
        int[] bcis = table.getBcis();
        assert (lineNumbers.length == bcis.length);
        UnsafeArrayTypeWriter encodingBuffer = UnsafeArrayTypeWriter.create((boolean)ByteArrayReader.supportsUnalignedMemoryAccess());
        int lastLineNumber = 0;
        int lastBci = 0;
        encodingBuffer.putUV((long)lineNumbers.length);
        for (int i = 0; i < lineNumbers.length; ++i) {
            encodingBuffer.putSV((long)(lineNumbers[i] - lastLineNumber));
            encodingBuffer.putSV((long)(bcis[i] - lastBci));
            lastLineNumber = lineNumbers[i];
            lastBci = bcis[i];
        }
        byte[] encodedTable = encodingBuffer.toArray(new byte[TypeConversion.asS4((long)encodingBuffer.getBytesWritten())]);
        assert (EncodedLineNumberTable.verifyTable(table, EncodedLineNumberTable.decode(encodedTable)));
        return encodedTable;
    }

    public static LineNumberTable decode(byte[] encodedTable) {
        if (encodedTable == null) {
            return null;
        }
        UnsafeArrayTypeReader readBuffer = UnsafeArrayTypeReader.create((byte[])encodedTable, (long)0L, (boolean)ByteArrayReader.supportsUnalignedMemoryAccess());
        int length = readBuffer.getUVInt();
        int[] lineNumbers = new int[length];
        int[] bcis = new int[length];
        int lastLineNumber = 0;
        int lastBci = 0;
        for (int i = 0; i < length; ++i) {
            int curLineNumber = lastLineNumber + readBuffer.getSVInt();
            int curBci = lastBci + readBuffer.getSVInt();
            lineNumbers[i] = curLineNumber;
            bcis[i] = curBci;
            lastLineNumber = curLineNumber;
            lastBci = curBci;
        }
        return new LineNumberTable(lineNumbers, bcis);
    }

    public static int getLineNumber(int atBci, byte[] encodedTable) {
        if (encodedTable == null) {
            return -1;
        }
        UnsafeArrayTypeReader readBuffer = UnsafeArrayTypeReader.create((byte[])encodedTable, (long)0L, (boolean)ByteArrayReader.supportsUnalignedMemoryAccess());
        int length = readBuffer.getUVInt();
        int lastLineNumber = 0;
        int lastBci = 0;
        for (int i = 0; i < length; ++i) {
            int curLineNumber = lastLineNumber + readBuffer.getSVInt();
            int curBci = lastBci + readBuffer.getSVInt();
            if (lastBci <= atBci && atBci < curBci) {
                assert (lastLineNumber == EncodedLineNumberTable.decode(encodedTable).getLineNumber(atBci));
                return lastLineNumber;
            }
            lastLineNumber = curLineNumber;
            lastBci = curBci;
        }
        assert (lastLineNumber == EncodedLineNumberTable.decode(encodedTable).getLineNumber(atBci));
        return lastLineNumber;
    }

    private static boolean verifyTable(LineNumberTable expected, LineNumberTable encoded) {
        assert (Arrays.equals(expected.getLineNumbers(), encoded.getLineNumbers()));
        assert (Arrays.equals(expected.getBcis(), encoded.getBcis()));
        return true;
    }
}

