/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted;

import com.oracle.graal.pointsto.heap.ImageHeapConstant;
import com.oracle.svm.core.BuildPhaseProvider;
import com.oracle.svm.core.feature.AutomaticallyRegisteredFeature;
import com.oracle.svm.core.feature.InternalFeature;
import com.oracle.svm.core.fieldvaluetransformer.FieldValueTransformerWithAvailability;
import com.oracle.svm.core.fieldvaluetransformer.ObjectToConstantFieldValueTransformer;
import com.oracle.svm.core.hub.ClassForNameSupport;
import com.oracle.svm.core.imagelayer.ImageLayerBuildingSupport;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.hosted.BootLoaderSupport;
import com.oracle.svm.hosted.FeatureImpl;
import com.oracle.svm.hosted.NativeImageSystemClassLoader;
import com.oracle.svm.hosted.imagelayer.CrossLayerConstantRegistry;
import com.oracle.svm.hosted.jdk.HostedClassLoaderPackageManagement;
import com.oracle.svm.util.ReflectionUtil;
import java.lang.reflect.Field;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import jdk.internal.loader.ClassLoaders;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.ResolvedJavaField;
import org.graalvm.nativeimage.hosted.Feature;
import org.graalvm.nativeimage.hosted.FieldValueTransformer;
import org.graalvm.nativeimage.libgraal.hosted.LibGraalLoader;

@AutomaticallyRegisteredFeature
public class ClassLoaderFeature
implements InternalFeature {
    private static final String APP_KEY_NAME = "ClassLoader#App";
    private static final String APP_PACKAGE_KEY_NAME = "ClassLoader.Packages#App";
    private static final String PLATFORM_KEY_NAME = "ClassLoader#Platform";
    private static final String BOOT_KEY_NAME = "ClassLoader#Boot";
    private static final NativeImageSystemClassLoader nativeImageSystemClassLoader = NativeImageSystemClassLoader.singleton();
    private static final ClassLoader bootClassLoader;
    private static final ClassLoader platformClassLoader;

    public static ClassLoader getRuntimeClassLoader(ClassLoader original) {
        if (ClassLoaderFeature.replaceWithAppClassLoader(original)) {
            return ClassLoaderFeature.nativeImageSystemClassLoader.defaultSystemClassLoader;
        }
        return original;
    }

    private static boolean replaceWithAppClassLoader(ClassLoader loader) {
        if (loader == nativeImageSystemClassLoader) {
            return true;
        }
        return nativeImageSystemClassLoader.isNativeImageClassLoader(loader);
    }

    private Object runtimeClassLoaderObjectReplacer(Object replaceCandidate) {
        if (replaceCandidate instanceof ClassLoader) {
            ClassLoader loader = (ClassLoader)replaceCandidate;
            return ClassLoaderFeature.getRuntimeClassLoader(loader);
        }
        return replaceCandidate;
    }

    JavaConstant replaceClassLoadersWithLayerConstant(CrossLayerConstantRegistry registry, Object object) {
        if (object instanceof ClassLoader) {
            ClassLoader loader = (ClassLoader)object;
            if (ClassLoaderFeature.replaceWithAppClassLoader(loader) || loader == ClassLoaderFeature.nativeImageSystemClassLoader.defaultSystemClassLoader) {
                return registry.getConstant(APP_KEY_NAME);
            }
            if (loader == platformClassLoader) {
                return registry.getConstant(PLATFORM_KEY_NAME);
            }
            if (loader == bootClassLoader) {
                return registry.getConstant(BOOT_KEY_NAME);
            }
            if (HostedClassLoaderPackageManagement.isGeneratedSerializationClassLoader(loader)) {
                return registry.getConstant(HostedClassLoaderPackageManagement.getClassLoaderSerializationLookupKey(loader));
            }
            throw VMError.shouldNotReachHere("Currently unhandled class loader seen in extension layer: %s", loader);
        }
        return null;
    }

    public void duringSetup(Feature.DuringSetupAccess access) {
        HostedClassLoaderPackageManagement packageManager = HostedClassLoaderPackageManagement.singleton();
        CrossLayerConstantRegistry registry = CrossLayerConstantRegistry.singletonOrNull();
        if (ImageLayerBuildingSupport.buildingImageLayer()) {
            packageManager.initialize(ClassLoaderFeature.nativeImageSystemClassLoader.defaultSystemClassLoader, registry);
        }
        FeatureImpl.DuringSetupAccessImpl config = (FeatureImpl.DuringSetupAccessImpl)access;
        if (ImageLayerBuildingSupport.firstImageBuild()) {
            LibGraalLoader libGraalLoader = ((FeatureImpl.DuringSetupAccessImpl)access).imageClassLoader.classLoaderSupport.getLibGraalLoader();
            if (libGraalLoader != null) {
                ClassLoader libGraalClassLoader = (ClassLoader)libGraalLoader;
                ClassForNameSupport.currentLayer().setLibGraalLoader(libGraalClassLoader);
            }
            access.registerObjectReplacer(this::runtimeClassLoaderObjectReplacer);
            if (ImageLayerBuildingSupport.buildingInitialLayer()) {
                config.registerObjectReachableCallback(ClassLoader.class, (a1, classLoader, reason) -> {
                    if (HostedClassLoaderPackageManagement.isGeneratedSerializationClassLoader(classLoader)) {
                        registry.registerHeapConstant(HostedClassLoaderPackageManagement.getClassLoaderSerializationLookupKey(classLoader), classLoader);
                    }
                });
            }
        } else {
            config.registerObjectToConstantReplacer(obj -> (ImageHeapConstant)this.replaceClassLoadersWithLayerConstant(registry, obj));
            config.registerObjectToConstantReplacer(packageManager::replaceWithPriorLayerPackage);
        }
    }

    public void beforeAnalysis(Feature.BeforeAnalysisAccess access) {
        Field packagesField = ReflectionUtil.lookupField(ClassLoader.class, (String)"packages");
        FeatureImpl.BeforeAnalysisAccessImpl config = (FeatureImpl.BeforeAnalysisAccessImpl)access;
        if (!ImageLayerBuildingSupport.buildingImageLayer()) {
            access.registerFieldValueTransformer(packagesField, (FieldValueTransformer)new TraditionalPackageMapTransformer());
        } else if (ImageLayerBuildingSupport.buildingInitialLayer()) {
            config.registerFieldValueTransformer(packagesField, new InitialLayerPackageMapTransformer());
        } else {
            access.registerFieldValueTransformer(packagesField, (FieldValueTransformer)new ExtensionLayerPackageMapTransformer());
        }
        if (ImageLayerBuildingSupport.buildingInitialLayer()) {
            CrossLayerConstantRegistry registry = CrossLayerConstantRegistry.singletonOrNull();
            registry.registerHeapConstant(APP_KEY_NAME, ClassLoaderFeature.nativeImageSystemClassLoader.defaultSystemClassLoader);
            registry.registerHeapConstant(PLATFORM_KEY_NAME, platformClassLoader);
            registry.registerHeapConstant(BOOT_KEY_NAME, bootClassLoader);
            registry.registerFutureHeapConstant(APP_PACKAGE_KEY_NAME, config.getMetaAccess().lookupJavaType(ConcurrentHashMap.class));
        }
        if (ImageLayerBuildingSupport.buildingApplicationLayer()) {
            config.rescanObject(HostedClassLoaderPackageManagement.singleton().getPriorAppClassLoaderPackages());
        }
    }

    public void afterAnalysis(Feature.AfterAnalysisAccess access) {
        if (ImageLayerBuildingSupport.buildingApplicationLayer()) {
            CrossLayerConstantRegistry registry = CrossLayerConstantRegistry.singletonOrNull();
            registry.finalizeFutureHeapConstant(APP_PACKAGE_KEY_NAME, HostedClassLoaderPackageManagement.singleton().getAppClassLoaderPackages());
        }
    }

    static {
        if (ImageLayerBuildingSupport.buildingImageLayer()) {
            platformClassLoader = ClassLoaders.platformClassLoader();
            bootClassLoader = BootLoaderSupport.getBootLoader();
        } else {
            platformClassLoader = null;
            bootClassLoader = null;
        }
    }

    static class TraditionalPackageMapTransformer
    extends PackageMapTransformer {
        TraditionalPackageMapTransformer() {
        }

        public Object transform(Object receiver, Object originalValue) {
            return this.doTransform(receiver, originalValue);
        }
    }

    static class InitialLayerPackageMapTransformer
    extends PackageMapTransformer
    implements ObjectToConstantFieldValueTransformer {
        final CrossLayerConstantRegistry registry = CrossLayerConstantRegistry.singletonOrNull();

        InitialLayerPackageMapTransformer() {
        }

        @Override
        public JavaConstant transformToConstant(ResolvedJavaField field, Object receiver, Object originalValue, Function<Object, JavaConstant> toConstant) {
            if (receiver == ClassLoaderFeature.nativeImageSystemClassLoader.defaultSystemClassLoader) {
                return this.registry.getConstant(ClassLoaderFeature.APP_PACKAGE_KEY_NAME);
            }
            return toConstant.apply(this.doTransform(receiver, originalValue));
        }
    }

    static class ExtensionLayerPackageMapTransformer
    implements FieldValueTransformerWithAvailability {
        ExtensionLayerPackageMapTransformer() {
        }

        @Override
        public boolean isAvailable() {
            return true;
        }

        public Object transform(Object receiver, Object originalValue) {
            throw VMError.shouldNotReachHere("No classloaders should be installed in extension layers: %s", receiver);
        }
    }

    static abstract class PackageMapTransformer
    implements FieldValueTransformerWithAvailability {
        PackageMapTransformer() {
        }

        @Override
        public boolean isAvailable() {
            return BuildPhaseProvider.isHostedUniverseBuilt();
        }

        Object doTransform(Object receiver, Object originalValue) {
            assert (receiver instanceof ClassLoader) : receiver;
            assert (originalValue instanceof ConcurrentHashMap) : "Underlying representation has changed: " + String.valueOf(originalValue);
            ConcurrentHashMap packages = HostedClassLoaderPackageManagement.singleton().getRegisteredPackages((ClassLoader)receiver);
            return packages == null ? new ConcurrentHashMap() : packages;
        }
    }
}

