/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted;

import com.oracle.graal.pointsto.heap.ImageHeapConstant;
import com.oracle.graal.pointsto.meta.AnalysisField;
import com.oracle.svm.core.StaticFieldsSupport;
import com.oracle.svm.core.feature.AutomaticallyRegisteredImageSingleton;
import com.oracle.svm.core.imagelayer.DynamicImageLayerInfo;
import com.oracle.svm.core.imagelayer.ImageLayerBuildingSupport;
import com.oracle.svm.core.meta.SharedField;
import com.oracle.svm.hosted.imagelayer.HostedImageLayerBuildingSupport;
import com.oracle.svm.hosted.imagelayer.LayeredStaticFieldSupport;
import com.oracle.svm.hosted.meta.HostedField;
import java.util.function.Function;
import jdk.graal.compiler.nodes.ConstantNode;
import jdk.graal.compiler.nodes.StructuredGraph;
import jdk.graal.compiler.nodes.calc.FloatingNode;
import jdk.graal.compiler.nodes.spi.LoweringTool;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.MetaAccessProvider;
import jdk.vm.ci.meta.ResolvedJavaField;

@AutomaticallyRegisteredImageSingleton(value={StaticFieldsSupport.HostedStaticFieldSupport.class})
public class HostedStaticFieldSupportImpl
implements StaticFieldsSupport.HostedStaticFieldSupport {
    private int currentLayerCache = -3;

    private State determineState(int layerNum) {
        if (layerNum == -1) {
            return State.UNUSED;
        }
        int currentLayerNum = this.getCurrentLayerNumber();
        if (currentLayerNum == layerNum) {
            return State.CURRENT_LAYER;
        }
        if (layerNum < currentLayerNum) {
            assert (layerNum == 0 && currentLayerNum == 1);
            return State.PRIOR_LAYER;
        }
        assert (layerNum == LayeredStaticFieldSupport.getAppLayerNumber() && currentLayerNum == 0);
        return State.FUTURE_APP_LAYER;
    }

    @Override
    public JavaConstant getStaticFieldsBaseConstant(int layerNum, boolean primitive, Function<Object, JavaConstant> toConstant) {
        return switch (this.determineState(layerNum).ordinal()) {
            default -> throw new MatchException(null, null);
            case 0, 1 -> {
                Object hostedObject = primitive ? StaticFieldsSupport.getCurrentLayerStaticPrimitiveFields() : StaticFieldsSupport.getCurrentLayerStaticObjectFields();
                yield toConstant.apply(hostedObject);
            }
            case 2 -> {
                if (primitive) {
                    yield HostedImageLayerBuildingSupport.singleton().getLoader().getBaseLayerStaticPrimitiveFields();
                }
                yield HostedImageLayerBuildingSupport.singleton().getLoader().getBaseLayerStaticObjectFields();
            }
            case 3 -> LayeredStaticFieldSupport.singleton().getAppLayerStaticFieldBaseConstant(primitive);
        };
    }

    @Override
    public FloatingNode getStaticFieldsBaseReplacement(int layerNum, boolean primitive, LoweringTool tool, StructuredGraph graph) {
        return switch (this.determineState(layerNum).ordinal()) {
            default -> throw new MatchException(null, null);
            case 0, 1 -> {
                Object hostedObject = primitive ? StaticFieldsSupport.getCurrentLayerStaticPrimitiveFields() : StaticFieldsSupport.getCurrentLayerStaticObjectFields();
                JavaConstant constant = tool.getSnippetReflection().forObject(hostedObject);
                yield ConstantNode.forConstant((JavaConstant)constant, (MetaAccessProvider)tool.getMetaAccess(), (StructuredGraph)graph);
            }
            case 2 -> {
                ImageHeapConstant constant = primitive ? HostedImageLayerBuildingSupport.singleton().getLoader().getBaseLayerStaticPrimitiveFields() : HostedImageLayerBuildingSupport.singleton().getLoader().getBaseLayerStaticObjectFields();
                yield ConstantNode.forConstant((JavaConstant)constant, (MetaAccessProvider)tool.getMetaAccess(), (StructuredGraph)graph);
            }
            case 3 -> LayeredStaticFieldSupport.singleton().getAppLayerStaticFieldsBaseReplacement(primitive, tool, graph);
        };
    }

    @Override
    public boolean isPrimitive(ResolvedJavaField field) {
        if (field instanceof AnalysisField) {
            AnalysisField aField = (AnalysisField)field;
            return aField.getStorageKind().isPrimitive();
        }
        return ((HostedField)field).getStorageKind().isPrimitive();
    }

    private int getCurrentLayerNumber() {
        if (this.currentLayerCache == -3) {
            int newLayerNumber = DynamicImageLayerInfo.getCurrentLayerNumber();
            assert (newLayerNumber != -3);
            this.currentLayerCache = newLayerNumber;
        }
        return this.currentLayerCache;
    }

    @Override
    public int getInstalledLayerNum(ResolvedJavaField field) {
        assert (ImageLayerBuildingSupport.buildingImageLayer());
        if (field instanceof SharedField) {
            SharedField sField = (SharedField)field;
            return sField.getInstalledLayerNum();
        }
        AnalysisField aField = (AnalysisField)field;
        return switch (LayeredStaticFieldSupport.singleton().getAssignmentStatus(aField)) {
            default -> throw new MatchException(null, null);
            case LayeredStaticFieldSupport.LayerAssignmentStatus.UNDECIDED -> this.getCurrentLayerNumber();
            case LayeredStaticFieldSupport.LayerAssignmentStatus.PRIOR_LAYER -> LayeredStaticFieldSupport.singleton().getPriorInstalledLayerNum(aField);
            case LayeredStaticFieldSupport.LayerAssignmentStatus.APP_LAYER_REQUESTED, LayeredStaticFieldSupport.LayerAssignmentStatus.APP_LAYER_DEFERRED -> LayeredStaticFieldSupport.getAppLayerNumber();
        };
    }

    private static enum State {
        UNUSED,
        CURRENT_LAYER,
        PRIOR_LAYER,
        FUTURE_APP_LAYER;

    }
}

