/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.annotation;

import com.oracle.svm.hosted.annotation.AnnotationMemberValue;
import com.oracle.svm.hosted.annotation.AnnotationMetadata;
import java.lang.constant.Constable;
import java.nio.ByteBuffer;
import java.util.Objects;
import jdk.internal.reflect.ConstantPool;
import sun.invoke.util.Wrapper;

public final class AnnotationPrimitiveValue
extends AnnotationMemberValue {
    private final char tag;
    private final Object value;

    static AnnotationPrimitiveValue extract(ByteBuffer buf, ConstantPool cp, char tag, boolean skip) {
        int constIndex = buf.getShort() & 0xFFFF;
        if (skip) {
            return null;
        }
        Constable value = switch (tag) {
            case 'B' -> Byte.valueOf((byte)cp.getIntAt(constIndex));
            case 'C' -> Character.valueOf((char)cp.getIntAt(constIndex));
            case 'D' -> Double.valueOf(cp.getDoubleAt(constIndex));
            case 'F' -> Float.valueOf(cp.getFloatAt(constIndex));
            case 'I' -> Integer.valueOf(cp.getIntAt(constIndex));
            case 'J' -> Long.valueOf(cp.getLongAt(constIndex));
            case 'S' -> Short.valueOf((short)cp.getIntAt(constIndex));
            case 'Z' -> Boolean.valueOf(cp.getIntAt(constIndex) != 0);
            default -> throw new AnnotationMetadata.AnnotationExtractionError((Object)Character.valueOf(tag), "Invalid annotation encoding. Unknown tag");
        };
        assert (Wrapper.forWrapperType(value.getClass()).basicTypeChar() == tag);
        return new AnnotationPrimitiveValue(tag, (Object)value);
    }

    AnnotationPrimitiveValue(Class<?> type, Object value) {
        this((type.isPrimitive() ? Wrapper.forPrimitiveType(type) : Wrapper.forWrapperType(type)).basicTypeChar(), value);
    }

    private AnnotationPrimitiveValue(char tag, Object value) {
        this.tag = tag;
        this.value = value;
    }

    @Override
    public char getTag() {
        return this.tag;
    }

    public Object getValue() {
        return this.value;
    }

    @Override
    public Object get(Class<?> memberType) {
        Class<?> boxedType = memberType.isPrimitive() ? Wrapper.forPrimitiveType(memberType).wrapperType() : memberType;
        return AnnotationMetadata.checkResult(this.value, boxedType);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AnnotationPrimitiveValue that = (AnnotationPrimitiveValue)o;
        return this.tag == that.tag && Objects.equals(this.value, that.value);
    }

    public int hashCode() {
        return Objects.hash(Character.valueOf(this.tag), this.value);
    }
}

