/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.cenum;

import com.oracle.graal.pointsto.infrastructure.GraphProvider;
import com.oracle.graal.pointsto.meta.AnalysisMethod;
import com.oracle.graal.pointsto.meta.AnalysisType;
import com.oracle.graal.pointsto.meta.HostedProviders;
import com.oracle.svm.core.Uninterruptible;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.hosted.annotation.AnnotationValue;
import com.oracle.svm.hosted.annotation.CustomSubstitutionMethod;
import com.oracle.svm.hosted.annotation.SubstrateAnnotationExtractor;
import com.oracle.svm.hosted.c.NativeLibraries;
import com.oracle.svm.hosted.c.info.EnumInfo;
import com.oracle.svm.hosted.phases.CInterfaceEnumTool;
import com.oracle.svm.hosted.phases.CInterfaceInvocationPlugin;
import com.oracle.svm.hosted.phases.HostedGraphKit;
import com.oracle.svm.util.ReflectionUtil;
import java.lang.reflect.AnnotatedElement;
import jdk.graal.compiler.debug.DebugContext;
import jdk.graal.compiler.nodes.StructuredGraph;
import jdk.graal.compiler.nodes.ValueNode;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import org.graalvm.nativeimage.c.constant.CEnumLookup;
import org.graalvm.nativeimage.c.constant.CEnumValue;

public class CEnumCallWrapperMethod
extends CustomSubstitutionMethod {
    private static final AnnotationValue[] INJECTED_ANNOTATIONS = SubstrateAnnotationExtractor.prepareInjectedAnnotations(Uninterruptible.Utils.getAnnotation(ReflectionUtil.lookupMethod(CEnumCallWrapperMethod.class, (String)"uninterruptibleAnnotationHolder", (Class[])new Class[0])));
    private final NativeLibraries nativeLibraries;

    CEnumCallWrapperMethod(NativeLibraries nativeLibraries, ResolvedJavaMethod method) {
        super(method);
        this.nativeLibraries = nativeLibraries;
    }

    @Override
    public int getModifiers() {
        return this.original.getModifiers() & 0xFFFFFEFF;
    }

    @Override
    public AnnotationValue[] getInjectedAnnotations() {
        if (this.original.getAnnotation(CEnumValue.class) != null) {
            return INJECTED_ANNOTATIONS;
        }
        return null;
    }

    public StructuredGraph buildGraph(DebugContext debug, AnalysisMethod method, HostedProviders providers, GraphProvider.Purpose purpose) {
        HostedGraphKit kit = new HostedGraphKit(debug, providers, (ResolvedJavaMethod)method);
        AnalysisType returnType = (AnalysisType)method.getSignature().getReturnType();
        ValueNode arg = kit.getInitialArguments().get(0);
        ValueNode returnValue = this.createInvoke(method, kit, returnType, arg);
        JavaKind pushKind = CInterfaceInvocationPlugin.pushKind(method);
        kit.getFrameState().push(pushKind, returnValue);
        kit.createReturn(returnValue, pushKind);
        return kit.finalizeGraph();
    }

    private ValueNode createInvoke(AnalysisMethod method, HostedGraphKit kit, AnalysisType returnType, ValueNode arg) {
        if (method.getAnnotation(CEnumLookup.class) != null) {
            EnumInfo enumInfo = (EnumInfo)this.nativeLibraries.findElementInfo((AnnotatedElement)returnType);
            return CInterfaceEnumTool.singleton().createInvokeLookupEnum(kit, returnType, enumInfo, arg);
        }
        if (method.getAnnotation(CEnumValue.class) != null) {
            AnalysisType declaringType = method.getDeclaringClass();
            EnumInfo enumInfo = (EnumInfo)this.nativeLibraries.findElementInfo((AnnotatedElement)declaringType);
            return CInterfaceEnumTool.singleton().createInvokeEnumToValue(kit, enumInfo, returnType, arg);
        }
        throw VMError.shouldNotReachHereUnexpectedInput(method);
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    private static void uninterruptibleAnnotationHolder() {
    }
}

