/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.code;

import com.oracle.graal.pointsto.meta.AnalysisMethod;
import com.oracle.graal.pointsto.meta.AnalysisType;
import com.oracle.svm.core.c.BoxedRelocatedPointer;
import com.oracle.svm.core.c.function.CEntryPointOptions;
import com.oracle.svm.core.util.UserError;
import com.oracle.svm.hosted.code.CCallStubMethod;
import com.oracle.svm.hosted.code.CEntryPointCallStubSupport;
import com.oracle.svm.hosted.phases.HostedGraphKit;
import java.lang.reflect.AnnotatedElement;
import java.util.List;
import jdk.graal.compiler.graph.Node;
import jdk.graal.compiler.nodes.CallTargetNode;
import jdk.graal.compiler.nodes.ConstantNode;
import jdk.graal.compiler.nodes.ValueNode;
import jdk.graal.compiler.nodes.java.LoadFieldNode;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import jdk.vm.ci.meta.ResolvedJavaType;
import org.graalvm.nativeimage.c.function.CEntryPoint;
import org.graalvm.nativeimage.c.function.CFunctionPointer;

public class CEntryPointJavaCallStubMethod
extends CCallStubMethod {
    private final String name;
    private final ResolvedJavaType declaringClass;
    private final CFunctionPointer target;

    CEntryPointJavaCallStubMethod(ResolvedJavaMethod original, String name, ResolvedJavaType declaringClass, CFunctionPointer target) {
        super(original, 3);
        this.name = name;
        this.declaringClass = declaringClass;
        this.target = target;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public ResolvedJavaType getDeclaringClass() {
        return this.declaringClass;
    }

    @Override
    protected String getCorrespondingAnnotationName() {
        return CEntryPoint.class.getSimpleName();
    }

    @Override
    protected void emitCallerEpilogue(HostedGraphKit kit) {
        CEntryPointOptions options = (CEntryPointOptions)this.getOriginal().getAnnotation(CEntryPointOptions.class);
        if (options != null && options.callerEpilogue() != null && options.callerEpilogue() != CEntryPointOptions.NoCallerEpilogue.class) {
            AnalysisType epilogue = kit.getMetaAccess().lookupJavaType(options.callerEpilogue());
            AnalysisMethod[] epilogueMethods = epilogue.getDeclaredMethods(false);
            UserError.guarantee(epilogueMethods.length == 1 && epilogueMethods[0].isStatic() && epilogueMethods[0].getSignature().getParameterCount(false) == 0, "Caller epilogue class must declare exactly one static method without parameters: %s -> %s", this.getOriginal(), epilogue);
            kit.createInvokeWithExceptionAndUnwind((ResolvedJavaMethod)epilogueMethods[0], CallTargetNode.InvokeKind.Static, kit.getFrameState(), kit.bci(), new ValueNode[0]);
        }
    }

    @Override
    protected ValueNode createTargetAddressNode(HostedGraphKit kit, List<ValueNode> arguments) {
        BoxedRelocatedPointer box = CEntryPointCallStubSupport.singleton().getBoxedRelocatedPointer(this.target);
        ConstantNode boxNode = kit.createObject(box);
        LoadFieldNode node = kit.createLoadFieldNode(boxNode, BoxedRelocatedPointer.class, "pointer");
        return (ValueNode)kit.append((Node)node);
    }

    @Override
    public AnnotatedElement getAnnotationRoot() {
        return null;
    }
}

