/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.code;

import com.oracle.graal.pointsto.infrastructure.ResolvedSignature;
import com.oracle.graal.pointsto.meta.AnalysisMetaAccess;
import com.oracle.graal.pointsto.meta.AnalysisMethod;
import com.oracle.graal.pointsto.meta.AnalysisType;
import com.oracle.svm.core.SubstrateUtil;
import com.oracle.svm.core.code.FactoryMethodHolder;
import com.oracle.svm.core.code.FactoryThrowMethodHolder;
import com.oracle.svm.core.feature.AutomaticallyRegisteredImageSingleton;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.hosted.code.FactoryMethod;
import com.oracle.svm.hosted.imagelayer.HostedImageLayerBuildingSupport;
import com.oracle.svm.hosted.phases.HostedGraphKit;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import jdk.graal.compiler.graph.Node;
import jdk.graal.compiler.nodes.java.AbstractNewObjectNode;
import jdk.graal.compiler.nodes.java.NewInstanceNode;
import jdk.vm.ci.meta.ConstantPool;
import jdk.vm.ci.meta.JavaMethod;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import jdk.vm.ci.meta.ResolvedJavaType;
import jdk.vm.ci.meta.Signature;
import org.graalvm.nativeimage.ImageSingletons;

@AutomaticallyRegisteredImageSingleton
public class FactoryMethodSupport {
    private final Map<ConstructorDescription, FactoryMethod> factoryMethods = new ConcurrentHashMap<ConstructorDescription, FactoryMethod>();
    private final Map<ConstructorDescription, FactoryMethod> factoryThrowMethods = new ConcurrentHashMap<ConstructorDescription, FactoryMethod>();

    public static FactoryMethodSupport singleton() {
        return (FactoryMethodSupport)ImageSingletons.lookup(FactoryMethodSupport.class);
    }

    public static boolean isFactoryMethod(AnalysisMethod method) {
        Class javaClass = method.getDeclaringClass().getJavaClass();
        return javaClass == FactoryMethodHolder.class || javaClass == FactoryThrowMethodHolder.class;
    }

    public AnalysisMethod lookup(AnalysisMetaAccess aMetaAccess, AnalysisMethod aConstructor, boolean throwAllocatedObject) {
        return this.lookup(aMetaAccess, aConstructor, aConstructor.getDeclaringClass(), throwAllocatedObject);
    }

    public AnalysisMethod lookup(AnalysisMetaAccess aMetaAccess, AnalysisMethod aConstructor, AnalysisType aInstantiatedType, boolean throwAllocatedObject) {
        AnalysisType aInstType = aInstantiatedType == null ? aConstructor.getDeclaringClass() : aInstantiatedType;
        VMError.guarantee(aConstructor.getDeclaringClass().isAssignableFrom((ResolvedJavaType)aInstType), "Must be assignable from");
        VMError.guarantee(aInstType.isInstanceClass() && !aInstType.isAbstract(), "Must be a non-abstract instance class");
        Map<ConstructorDescription, FactoryMethod> methods = throwAllocatedObject ? this.factoryThrowMethods : this.factoryMethods;
        FactoryMethod factoryMethod = methods.computeIfAbsent(new ConstructorDescription(aConstructor, aInstType), key -> {
            String name = SubstrateUtil.uniqueStubName((ResolvedJavaMethod)aConstructor);
            ResolvedJavaType[] unwrappedParameterTypes = new ResolvedJavaType[aConstructor.getSignature().getParameterCount(false)];
            for (int i = 0; i < unwrappedParameterTypes.length; ++i) {
                unwrappedParameterTypes[i] = ((AnalysisType)aConstructor.getSignature().getParameterType(i)).getWrapped();
            }
            ResolvedJavaType unwrappedReturnType = (throwAllocatedObject ? aMetaAccess.lookupJavaType(Void.TYPE) : aInstType).getWrapped();
            ResolvedSignature unwrappedSignature = ResolvedSignature.fromArray((ResolvedJavaType[])unwrappedParameterTypes, (ResolvedJavaType)unwrappedReturnType);
            ResolvedJavaMethod unwrappedConstructor = aConstructor.getWrapped();
            ResolvedJavaType unwrappedInstantiatedType = aInstType.getWrapped();
            ResolvedJavaType unwrappedDeclaringClass = aMetaAccess.lookupJavaType(throwAllocatedObject ? FactoryThrowMethodHolder.class : FactoryMethodHolder.class).getWrapped();
            ConstantPool unwrappedConstantPool = unwrappedConstructor.getConstantPool();
            return new FactoryMethod(name, unwrappedConstructor, unwrappedInstantiatedType, unwrappedDeclaringClass, (Signature)unwrappedSignature, unwrappedConstantPool, throwAllocatedObject);
        });
        AnalysisMethod aMethod = aMetaAccess.getUniverse().lookup((JavaMethod)factoryMethod);
        if (HostedImageLayerBuildingSupport.buildingSharedLayer()) {
            aMetaAccess.getUniverse().getBigbang().registerMethodForBaseImage(aMethod);
        }
        return aMethod;
    }

    protected AbstractNewObjectNode createNewInstance(HostedGraphKit kit, ResolvedJavaType type, boolean fillContents) {
        return (AbstractNewObjectNode)kit.append((Node)new NewInstanceNode(type, fillContents));
    }

    private record ConstructorDescription(AnalysisMethod aConstructor, AnalysisType aInstantiatedType) {
    }
}

