/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.code;

import com.oracle.graal.pointsto.infrastructure.WrappedElement;
import com.oracle.graal.pointsto.meta.AnalysisField;
import com.oracle.graal.pointsto.meta.AnalysisMetaAccess;
import com.oracle.graal.pointsto.meta.AnalysisMethod;
import com.oracle.graal.pointsto.meta.AnalysisType;
import com.oracle.graal.pointsto.meta.BaseLayerType;
import com.oracle.graal.pointsto.util.AnalysisError;
import com.oracle.svm.core.annotate.Delete;
import com.oracle.svm.core.code.CodeInfoEncoder;
import com.oracle.svm.core.code.RuntimeMetadataDecoderImpl;
import com.oracle.svm.core.code.RuntimeMetadataEncoding;
import com.oracle.svm.core.configure.ConditionalRuntimeValue;
import com.oracle.svm.core.configure.RuntimeConditionSet;
import com.oracle.svm.core.encoder.SymbolEncoder;
import com.oracle.svm.core.feature.AutomaticallyRegisteredImageSingleton;
import com.oracle.svm.core.hub.DynamicHub;
import com.oracle.svm.core.imagelayer.ImageLayerBuildingSupport;
import com.oracle.svm.core.layeredimagesingleton.ImageSingletonLoader;
import com.oracle.svm.core.layeredimagesingleton.ImageSingletonWriter;
import com.oracle.svm.core.layeredimagesingleton.LayeredImageSingleton;
import com.oracle.svm.core.layeredimagesingleton.LayeredImageSingletonBuilderFlags;
import com.oracle.svm.core.reflect.target.EncodedRuntimeMetadataSupplier;
import com.oracle.svm.core.util.ByteArrayReader;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.hosted.annotation.AnnotationMemberValue;
import com.oracle.svm.hosted.annotation.AnnotationValue;
import com.oracle.svm.hosted.annotation.TypeAnnotationValue;
import com.oracle.svm.hosted.code.AnnotationMetadataEncoder;
import com.oracle.svm.hosted.code.ReflectionRuntimeMetadata;
import com.oracle.svm.hosted.image.NativeImageCodeCache;
import com.oracle.svm.hosted.imagelayer.CapnProtoAdapters;
import com.oracle.svm.hosted.imagelayer.SVMImageLayerSingletonLoader;
import com.oracle.svm.hosted.imagelayer.SVMImageLayerWriter;
import com.oracle.svm.hosted.imagelayer.SharedLayerSnapshotCapnProtoSchemaHolder;
import com.oracle.svm.hosted.meta.HostedField;
import com.oracle.svm.hosted.meta.HostedMetaAccess;
import com.oracle.svm.hosted.meta.HostedMethod;
import com.oracle.svm.hosted.meta.HostedType;
import com.oracle.svm.hosted.reflect.ReflectionDataBuilder;
import com.oracle.svm.hosted.reflect.ReflectionHostedSupport;
import com.oracle.svm.hosted.substitute.DeletedElementException;
import com.oracle.svm.hosted.substitute.SubstitutionReflectivityFilter;
import com.oracle.svm.util.ReflectionUtil;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Constructor;
import java.lang.reflect.Executable;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.lang.reflect.RecordComponent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import jdk.graal.compiler.api.replacements.SnippetReflectionProvider;
import jdk.graal.compiler.core.common.util.TypeConversion;
import jdk.graal.compiler.core.common.util.UnsafeArrayTypeWriter;
import jdk.internal.reflect.Reflection;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.MetaAccessProvider;
import org.graalvm.collections.Pair;
import org.graalvm.nativeimage.AnnotationAccess;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.impl.RuntimeReflectionSupport;

public class RuntimeMetadataEncoderImpl
implements NativeImageCodeCache.RuntimeMetadataEncoder {
    private final SnippetReflectionProvider snippetReflection;
    private final CodeInfoEncoder.Encoders encoders;
    private final ReflectionDataAccessors accessors;
    private final ReflectionDataBuilder dataBuilder;
    private final SymbolEncoder symbolEncoder = SymbolEncoder.singleton();
    private TreeSet<HostedType> sortedTypes = new TreeSet<HostedType>(Comparator.comparingLong(t -> t.getHub().getTypeID()));
    private Map<HostedType, ReflectionRuntimeMetadata.ClassMetadata> classData = new HashMap<HostedType, ReflectionRuntimeMetadata.ClassMetadata>();
    private Map<HostedType, Map<Object, ReflectionRuntimeMetadata.FieldMetadata>> fieldData = new HashMap<HostedType, Map<Object, ReflectionRuntimeMetadata.FieldMetadata>>();
    private Map<HostedType, Map<Object, ReflectionRuntimeMetadata.MethodMetadata>> methodData = new HashMap<HostedType, Map<Object, ReflectionRuntimeMetadata.MethodMetadata>>();
    private Map<HostedType, Map<Object, ReflectionRuntimeMetadata.ConstructorMetadata>> constructorData = new HashMap<HostedType, Map<Object, ReflectionRuntimeMetadata.ConstructorMetadata>>();
    private Map<HostedType, Throwable> classLookupErrors = new HashMap<HostedType, Throwable>();
    private Map<HostedType, Throwable> fieldLookupErrors = new HashMap<HostedType, Throwable>();
    private Map<HostedType, Throwable> methodLookupErrors = new HashMap<HostedType, Throwable>();
    private Map<HostedType, Throwable> constructorLookupErrors = new HashMap<HostedType, Throwable>();
    private Map<HostedType, Throwable> recordComponentLookupErrors = new HashMap<HostedType, Throwable>();
    private Set<ReflectionRuntimeMetadata.AccessibleObjectMetadata> heapData = new HashSet<ReflectionRuntimeMetadata.AccessibleObjectMetadata>();
    private Map<AccessibleObject, byte[]> annotationsEncodings = new HashMap<AccessibleObject, byte[]>();
    private Map<Executable, byte[]> parameterAnnotationsEncodings = new HashMap<Executable, byte[]>();
    private Map<Method, byte[]> annotationDefaultEncodings = new HashMap<Method, byte[]>();
    private Map<AccessibleObject, byte[]> typeAnnotationsEncodings = new HashMap<AccessibleObject, byte[]>();
    private Map<Executable, byte[]> reflectParametersEncodings = new HashMap<Executable, byte[]>();
    private static final Method getEnclosingMethod0 = ReflectionUtil.lookupMethod(Class.class, (String)"getEnclosingMethod0", (Class[])new Class[0]);
    private static final Method getPermittedSubclasses = ReflectionUtil.lookupMethod((boolean)true, Class.class, (String)"getPermittedSubclasses", (Class[])new Class[0]);
    private static final Method isFieldTrustedFinal = ReflectionUtil.lookupMethod((boolean)true, Field.class, (String)"isTrustedFinal", (Class[])new Class[0]);
    private static final Method getFieldSignature = ReflectionUtil.lookupMethod(Field.class, (String)"getGenericSignature", (Class[])new Class[0]);
    private static final Method getMethodSignature = ReflectionUtil.lookupMethod(Method.class, (String)"getGenericSignature", (Class[])new Class[0]);
    private static final Method getConstructorSignature = ReflectionUtil.lookupMethod(Constructor.class, (String)"getSignature", (Class[])new Class[0]);
    private static final Method getExecutableParameters = ReflectionUtil.lookupMethod(Executable.class, (String)"getParameters0", (Class[])new Class[0]);

    public RuntimeMetadataEncoderImpl(SnippetReflectionProvider snippetReflection, CodeInfoEncoder.Encoders encoders) {
        this.snippetReflection = snippetReflection;
        this.encoders = encoders;
        this.accessors = new ReflectionDataAccessors();
        this.dataBuilder = (ReflectionDataBuilder)ImageSingletons.lookup(RuntimeReflectionSupport.class);
        if (ImageLayerBuildingSupport.buildingInitialLayer()) {
            ImageSingletons.add(LayeredRuntimeMetadataSingleton.class, (Object)new LayeredRuntimeMetadataSingleton());
        }
    }

    private void addType(HostedType type) {
        if (type.getWrapped().isReachable() && this.sortedTypes.add(type)) {
            this.encoders.classes.addObject(type.getJavaClass());
        }
    }

    private void registerClass(HostedType type, ReflectionRuntimeMetadata.ClassMetadata metadata) {
        this.addType(type);
        this.classData.put(type, metadata);
    }

    private void registerField(HostedType declaringType, Object field, ReflectionRuntimeMetadata.FieldMetadata metadata) {
        if (ImageLayerBuildingSupport.buildingImageLayer() && !LayeredRuntimeMetadataSingleton.singleton().shouldRegisterField(field, declaringType.getWrapped().getUniverse().getBigbang().getMetaAccess(), metadata)) {
            return;
        }
        this.addType(declaringType);
        ReflectionRuntimeMetadata.FieldMetadata oldData = this.fieldData.computeIfAbsent(declaringType, t -> new HashMap()).put(field, metadata);
        assert (oldData == null);
    }

    private ReflectionRuntimeMetadata.FieldMetadata[] getFields(HostedType declaringType) {
        Field[] jdkFields = this.accessors.getDeclaredFields(declaringType.getJavaClass());
        Map fieldMetadata = this.fieldData.getOrDefault(declaringType, Collections.emptyMap());
        return RuntimeMetadataEncoderImpl.sortElements(jdkFields, fieldMetadata).toArray(new ReflectionRuntimeMetadata.FieldMetadata[0]);
    }

    private void registerMethod(HostedType declaringType, Object method, ReflectionRuntimeMetadata.MethodMetadata metadata) {
        if (ImageLayerBuildingSupport.buildingImageLayer() && !LayeredRuntimeMetadataSingleton.singleton().shouldRegisterMethod(method, declaringType.getWrapped().getUniverse().getBigbang().getMetaAccess(), metadata)) {
            return;
        }
        this.addType(declaringType);
        ReflectionRuntimeMetadata.MethodMetadata oldData = this.methodData.computeIfAbsent(declaringType, t -> new HashMap()).put(method, metadata);
        assert (oldData == null);
    }

    private ReflectionRuntimeMetadata.MethodMetadata[] getMethods(HostedType declaringType) {
        Method[] jdkMethods = this.accessors.getDeclaredMethods(declaringType.getJavaClass());
        Map methodMetadata = this.methodData.getOrDefault(declaringType, Collections.emptyMap());
        return RuntimeMetadataEncoderImpl.sortElements(jdkMethods, methodMetadata).toArray(new ReflectionRuntimeMetadata.MethodMetadata[0]);
    }

    private void registerConstructor(HostedType declaringType, Object constructor, ReflectionRuntimeMetadata.ConstructorMetadata metadata) {
        if (ImageLayerBuildingSupport.buildingImageLayer() && !LayeredRuntimeMetadataSingleton.singleton().shouldRegisterMethod(constructor, declaringType.getWrapped().getUniverse().getBigbang().getMetaAccess(), metadata)) {
            return;
        }
        this.addType(declaringType);
        ReflectionRuntimeMetadata.ConstructorMetadata oldData = this.constructorData.computeIfAbsent(declaringType, t -> new HashMap()).put(constructor, metadata);
        assert (oldData == null);
    }

    private ReflectionRuntimeMetadata.ConstructorMetadata[] getConstructors(HostedType declaringType) {
        Constructor<?>[] jdkConstructors = this.accessors.getDeclaredConstructors(declaringType.getJavaClass());
        Map constructorMetadata = this.constructorData.getOrDefault(declaringType, Collections.emptyMap());
        return RuntimeMetadataEncoderImpl.sortElements(jdkConstructors, constructorMetadata).toArray(new ReflectionRuntimeMetadata.ConstructorMetadata[0]);
    }

    private static <T, M> List<M> sortElements(T[] jdkElements, Map<T, M> metadata) {
        ArrayList<Object> orderedElements = new ArrayList<Object>();
        ArrayList<M> trailingElements = new ArrayList<M>();
        for (T element : jdkElements) {
            if (!metadata.containsKey(element)) continue;
            M elementMetadata = metadata.remove(element);
            if (element instanceof Method && ((Method)element).isBridge()) {
                trailingElements.add(elementMetadata);
                continue;
            }
            orderedElements.add(elementMetadata);
        }
        orderedElements.addAll(metadata.values());
        orderedElements.addAll(trailingElements);
        return orderedElements;
    }

    @Override
    public byte[] getAnnotationsEncoding(AccessibleObject object) {
        return this.annotationsEncodings.get(object);
    }

    @Override
    public byte[] getParameterAnnotationsEncoding(Executable object) {
        return this.parameterAnnotationsEncodings.get(object);
    }

    @Override
    public byte[] getAnnotationDefaultEncoding(Method object) {
        return this.annotationDefaultEncodings.get(object);
    }

    @Override
    public byte[] getTypeAnnotationsEncoding(AccessibleObject object) {
        return this.typeAnnotationsEncodings.get(object);
    }

    @Override
    public byte[] getReflectParametersEncoding(Executable object) {
        return this.reflectParametersEncodings.get(object);
    }

    @Override
    public void addClassMetadata(MetaAccessProvider metaAccess, HostedType type, Class<?>[] innerClasses) {
        int enabledQueries;
        Class<?> javaClass = type.getHub().getHostedJavaClass();
        Object enclosingMethodInfo = this.getEnclosingMethodInfo(javaClass);
        ReflectionRuntimeMetadata.RecordComponentMetadata[] recordComponents = this.getRecordComponents(metaAccess, type, javaClass);
        Class<?>[] permittedSubclasses = this.getPermittedSubclasses(metaAccess, javaClass);
        Class<?>[] nestMembers = this.getNestMembers(metaAccess, javaClass);
        Object[] signers = this.getSigners(javaClass);
        int classAccessFlags = Reflection.getClassAccessFlags(javaClass) & 0x1FFF;
        VMError.guarantee((classAccessFlags & (enabledQueries = this.dataBuilder.getEnabledReflectionQueries(javaClass))) == 0);
        int flags = classAccessFlags | enabledQueries;
        this.encoders.classes.addObject(javaClass);
        if (enclosingMethodInfo instanceof Throwable) {
            this.registerError((Throwable)enclosingMethodInfo);
        } else {
            this.registerEnclosingMethodInfo((Object[])enclosingMethodInfo);
        }
        HostedType[] innerTypes = this.registerClassValues(metaAccess, innerClasses);
        HostedType[] permittedSubtypes = permittedSubclasses != null ? this.registerClassValues(metaAccess, permittedSubclasses) : null;
        HostedType[] nestMemberTypes = nestMembers != null ? this.registerClassValues(metaAccess, nestMembers) : null;
        JavaConstant[] signerConstants = null;
        if (signers != null) {
            signerConstants = new JavaConstant[signers.length];
            for (int i = 0; i < signers.length; ++i) {
                signerConstants[i] = this.snippetReflection.forObject(signers[i]);
                this.addConstantObject(signerConstants[i]);
            }
        }
        AnalysisType analysisType = type.getWrapped();
        AnnotationValue[] annotations = this.registerAnnotationValues((AnnotatedElement)analysisType);
        TypeAnnotationValue[] typeAnnotations = this.registerTypeAnnotationValues((AnnotatedElement)analysisType);
        this.registerClass(type, new ReflectionRuntimeMetadata.ClassMetadata(innerTypes, enclosingMethodInfo, recordComponents, permittedSubtypes, nestMemberTypes, signerConstants, flags, annotations, typeAnnotations));
    }

    private void addConstantObject(JavaConstant constant) {
        this.encoders.objectConstants.addObject((Object)constant);
    }

    private void registerError(Throwable error) {
        this.addConstantObject(this.snippetReflection.forObject((Object)error));
    }

    private Object getEnclosingMethodInfo(Class<?> clazz) {
        try {
            Object[] enclosingMethod = (Object[])getEnclosingMethod0.invoke(clazz, new Object[0]);
            if (enclosingMethod == null || enclosingMethod[1] == null) {
                return enclosingMethod;
            }
            enclosingMethod[1] = this.symbolEncoder.encodeMethod((String)enclosingMethod[1], clazz);
            return enclosingMethod;
        }
        catch (InvocationTargetException e) {
            if (e.getCause() instanceof LinkageError) {
                return e.getCause();
            }
            throw VMError.shouldNotReachHere(e);
        }
        catch (IllegalAccessException e) {
            throw VMError.shouldNotReachHere(e);
        }
    }

    private void registerEnclosingMethodInfo(Object[] enclosingMethodInfo) {
        if (enclosingMethodInfo == null) {
            return;
        }
        this.encoders.classes.addObject((Object)((Class)enclosingMethodInfo[0]));
        this.encoders.memberNames.addObject((Object)((String)enclosingMethodInfo[1]));
        this.encoders.otherStrings.addObject((Object)((String)enclosingMethodInfo[2]));
    }

    private Class<?>[] getPermittedSubclasses(MetaAccessProvider metaAccess, Class<?> clazz) {
        if ((this.dataBuilder.getEnabledReflectionQueries(clazz) & 0x2000000) == 0) {
            return null;
        }
        try {
            Class[] permittedSubclasses = (Class[])getPermittedSubclasses.invoke(clazz, new Object[0]);
            return RuntimeMetadataEncoderImpl.filterDeletedClasses(metaAccess, permittedSubclasses);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw VMError.shouldNotReachHere(e);
        }
    }

    private Class<?>[] getNestMembers(MetaAccessProvider metaAccess, Class<?> clazz) {
        if ((this.dataBuilder.getEnabledReflectionQueries(clazz) & 0x4000000) == 0) {
            return null;
        }
        return RuntimeMetadataEncoderImpl.filterDeletedClasses(metaAccess, clazz.getNestMembers());
    }

    private Object[] getSigners(Class<?> clazz) {
        if ((this.dataBuilder.getEnabledReflectionQueries(clazz) & 0x8000000) == 0) {
            return null;
        }
        return clazz.getSigners();
    }

    private static Class<?>[] filterDeletedClasses(MetaAccessProvider metaAccess, Class<?>[] classes) {
        if (classes == null) {
            return null;
        }
        AnalysisMetaAccess aMetaAccess = (AnalysisMetaAccess)((HostedMetaAccess)metaAccess).getWrapped();
        HashSet reachableClasses = new HashSet();
        for (Class<?> clazz : classes) {
            try {
                if (SubstitutionReflectivityFilter.shouldExclude(clazz, aMetaAccess, aMetaAccess.getUniverse())) continue;
                metaAccess.lookupJavaType(clazz);
                reachableClasses.add(clazz);
            }
            catch (AnalysisError.TypeNotFoundError | DeletedElementException object) {
                // empty catch block
            }
        }
        return reachableClasses.toArray(new Class[0]);
    }

    @Override
    public void addReflectionFieldMetadata(MetaAccessProvider metaAccess, HostedField hostedField, ConditionalRuntimeValue<Field> conditionalReflectField) {
        Field reflectField = conditionalReflectField.getValueUnconditionally();
        HostedType declaringType = hostedField.getDeclaringClass();
        String name = hostedField.getName();
        HostedType type = hostedField.getType();
        int modifiers = reflectField.getModifiers();
        boolean trustedFinal = RuntimeMetadataEncoderImpl.isTrustedFinal(reflectField);
        String signature = RuntimeMetadataEncoderImpl.getSignature(reflectField);
        int offset = hostedField.wrapped.isUnsafeAccessed() ? hostedField.getOffset() : -1;
        Delete deleteAnnotation = (Delete)AnnotationAccess.getAnnotation((AnnotatedElement)hostedField, Delete.class);
        String deletedReason = deleteAnnotation != null ? deleteAnnotation.value() : null;
        RuntimeConditionSet conditions = conditionalReflectField.getConditions();
        for (Class<?> conditionType : conditions.getTypesForEncoding()) {
            this.encoders.classes.addObject(conditionType);
        }
        this.encoders.memberNames.addObject((Object)name);
        this.encoders.classes.addObject(type.getJavaClass());
        this.encoders.otherStrings.addObject((Object)signature);
        this.encoders.otherStrings.addObject((Object)deletedReason);
        AnalysisField analysisField = hostedField.getWrapped();
        AnnotationValue[] annotations = this.registerAnnotationValues((AnnotatedElement)analysisField);
        TypeAnnotationValue[] typeAnnotations = this.registerTypeAnnotationValues((AnnotatedElement)analysisField);
        this.registerField(declaringType, reflectField, new ReflectionRuntimeMetadata.FieldMetadata(conditions, declaringType, name, type, modifiers, trustedFinal, signature, annotations, typeAnnotations, offset, deletedReason));
    }

    @Override
    public void addReflectionExecutableMetadata(MetaAccessProvider metaAccess, HostedMethod hostedMethod, ConditionalRuntimeValue<Executable> conditionalMethod, Object accessor) {
        boolean isMethod = !hostedMethod.isConstructor();
        HostedType declaringType = hostedMethod.getDeclaringClass();
        String name = isMethod ? hostedMethod.getReflectionName() : null;
        HostedType[] parameterTypes = RuntimeMetadataEncoderImpl.getParameterTypes(hostedMethod);
        Executable reflectMethod = conditionalMethod.getValueUnconditionally();
        RuntimeConditionSet conditions = conditionalMethod.getConditions();
        int modifiers = reflectMethod.getModifiers();
        HostedType returnType = (HostedType)hostedMethod.getSignature().getReturnType();
        HostedType[] exceptionTypes = RuntimeMetadataEncoderImpl.getExceptionTypes(metaAccess, reflectMethod);
        String signature = RuntimeMetadataEncoderImpl.getSignature(reflectMethod);
        for (Class<?> type : conditions.getTypesForEncoding()) {
            this.encoders.classes.addObject(type);
        }
        if (isMethod) {
            this.encoders.memberNames.addObject((Object)name);
            this.encoders.classes.addObject(returnType.getJavaClass());
        }
        for (HostedType parameterType : parameterTypes) {
            this.encoders.classes.addObject(parameterType.getJavaClass());
        }
        for (HostedType exceptionType : exceptionTypes) {
            this.encoders.classes.addObject(exceptionType.getJavaClass());
        }
        this.encoders.otherStrings.addObject((Object)signature);
        AnalysisMethod analysisMethod = hostedMethod.getWrapped();
        AnnotationValue[] annotations = this.registerAnnotationValues((AnnotatedElement)analysisMethod);
        AnnotationValue[][] parameterAnnotations = this.registerParameterAnnotationValues(analysisMethod);
        AnnotationMemberValue annotationDefault = isMethod ? this.registerAnnotationDefaultValues(analysisMethod) : null;
        TypeAnnotationValue[] typeAnnotations = this.registerTypeAnnotationValues((AnnotatedElement)analysisMethod);
        Object reflectParameters = this.registerReflectParameters(reflectMethod);
        JavaConstant accessorConstant = null;
        if (accessor != null) {
            accessorConstant = this.snippetReflection.forObject(accessor);
            this.addConstantObject(accessorConstant);
        }
        if (isMethod) {
            this.registerMethod(declaringType, reflectMethod, new ReflectionRuntimeMetadata.MethodMetadata(conditions, declaringType, name, parameterTypes, modifiers, returnType, exceptionTypes, signature, annotations, parameterAnnotations, annotationDefault, typeAnnotations, reflectParameters, accessorConstant));
        } else {
            this.registerConstructor(declaringType, reflectMethod, new ReflectionRuntimeMetadata.ConstructorMetadata(conditions, declaringType, parameterTypes, modifiers, exceptionTypes, signature, annotations, parameterAnnotations, typeAnnotations, reflectParameters, accessorConstant));
        }
    }

    private static boolean isTrustedFinal(Field field) {
        try {
            return (Boolean)isFieldTrustedFinal.invoke((Object)field, new Object[0]);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw VMError.shouldNotReachHere(e);
        }
    }

    @Override
    public void addHeapAccessibleObjectMetadata(MetaAccessProvider metaAccess, WrappedElement hostedObject, AccessibleObject object, boolean registered) {
        ReflectionRuntimeMetadata.AccessibleObjectMetadata metadata;
        boolean isExecutable = object instanceof Executable;
        boolean isMethod = object instanceof Method;
        AnnotatedElement analysisObject = hostedObject.getWrapped();
        AnnotationValue[] annotations = this.registerAnnotationValues(analysisObject);
        AnnotationValue[][] parameterAnnotations = isExecutable ? this.registerParameterAnnotationValues((AnalysisMethod)analysisObject) : null;
        TypeAnnotationValue[] typeAnnotations = this.registerTypeAnnotationValues(analysisObject);
        AnnotationMemberValue annotationDefault = isMethod ? this.registerAnnotationDefaultValues((AnalysisMethod)analysisObject) : null;
        Object reflectParameters = isExecutable ? this.registerReflectParameters((Executable)object) : null;
        AccessibleObject holder = NativeImageCodeCache.RuntimeMetadataEncoder.getHolder(object);
        JavaConstant heapObjectConstant = this.snippetReflection.forObject((Object)holder);
        this.addConstantObject(heapObjectConstant);
        RuntimeConditionSet alwaysSatisfied = RuntimeConditionSet.unmodifiableEmptySet();
        if (isMethod) {
            metadata = new ReflectionRuntimeMetadata.MethodMetadata(alwaysSatisfied, registered, heapObjectConstant, annotations, parameterAnnotations, annotationDefault, typeAnnotations, reflectParameters);
            this.registerMethod((HostedType)metaAccess.lookupJavaType(((Method)object).getDeclaringClass()), holder, (ReflectionRuntimeMetadata.MethodMetadata)metadata);
        } else if (isExecutable) {
            metadata = new ReflectionRuntimeMetadata.ConstructorMetadata(alwaysSatisfied, registered, heapObjectConstant, annotations, parameterAnnotations, typeAnnotations, reflectParameters);
            this.registerConstructor((HostedType)metaAccess.lookupJavaType(((Constructor)object).getDeclaringClass()), holder, (ReflectionRuntimeMetadata.ConstructorMetadata)metadata);
        } else {
            metadata = new ReflectionRuntimeMetadata.FieldMetadata(alwaysSatisfied, registered, heapObjectConstant, annotations, typeAnnotations);
            this.registerField((HostedType)metaAccess.lookupJavaType(((Field)object).getDeclaringClass()), holder, (ReflectionRuntimeMetadata.FieldMetadata)metadata);
        }
        this.heapData.add(metadata);
    }

    private HostedType[] registerClassValues(MetaAccessProvider metaAccess, Class<?>[] classes) {
        HashSet<HostedType> includedClasses = new HashSet<HostedType>();
        for (Class<?> clazz : classes) {
            HostedType type;
            try {
                type = ((HostedMetaAccess)metaAccess).optionalLookupJavaType(clazz).orElse(null);
            }
            catch (DeletedElementException e) {
                type = null;
            }
            if (type == null || !type.getWrapped().isReachable()) continue;
            this.encoders.classes.addObject(type.getJavaClass());
            includedClasses.add(type);
        }
        return includedClasses.toArray(HostedType.EMPTY_ARRAY);
    }

    private AnnotationValue[] registerAnnotationValues(AnnotatedElement element) {
        AnnotationValue[] annotations;
        for (AnnotationValue annotation : annotations = this.dataBuilder.getAnnotationData(element)) {
            this.registerValues(annotation);
        }
        return annotations;
    }

    private AnnotationValue[][] registerParameterAnnotationValues(AnalysisMethod element) {
        AnnotationValue[][] parameterAnnotations;
        AnnotationValue[][] annotationValueArray = parameterAnnotations = this.dataBuilder.getParameterAnnotationData(element);
        int n = annotationValueArray.length;
        for (int i = 0; i < n; ++i) {
            AnnotationValue[] annotations;
            for (AnnotationValue annotation : annotations = annotationValueArray[i]) {
                this.registerValues(annotation);
            }
        }
        return parameterAnnotations;
    }

    private AnnotationMemberValue registerAnnotationDefaultValues(AnalysisMethod method) {
        AnnotationMemberValue annotationDefault = this.dataBuilder.getAnnotationDefaultData((AnnotatedElement)method);
        if (annotationDefault != null) {
            this.registerValues(annotationDefault);
        }
        return annotationDefault;
    }

    private TypeAnnotationValue[] registerTypeAnnotationValues(AnnotatedElement element) {
        TypeAnnotationValue[] typeAnnotations;
        for (TypeAnnotationValue typeAnnotation : typeAnnotations = this.dataBuilder.getTypeAnnotationData(element)) {
            this.registerValues(typeAnnotation.getAnnotationData());
        }
        return typeAnnotations;
    }

    private void registerValues(AnnotationMemberValue annotationValue) {
        AnnotationMetadataEncoder.registerAnnotationMember(annotationValue, this.encoders, this.snippetReflection);
    }

    private Object registerReflectParameters(Executable executable) {
        Object reflectParameters = RuntimeMetadataEncoderImpl.getReflectParameters(executable);
        if (reflectParameters != null) {
            if (reflectParameters instanceof Throwable) {
                Throwable paramError = (Throwable)reflectParameters;
                this.registerError(paramError);
            } else {
                for (ReflectionRuntimeMetadata.ReflectParameterMetadata parameter : (ReflectionRuntimeMetadata.ReflectParameterMetadata[])reflectParameters) {
                    this.encoders.otherStrings.addObject((Object)parameter.name);
                }
            }
        }
        return reflectParameters;
    }

    @Override
    public void addHidingFieldMetadata(AnalysisField analysisField, HostedType declaringType, String name, HostedType type, int modifiers) {
        this.encoders.memberNames.addObject((Object)name);
        this.encoders.classes.addObject(type.getJavaClass());
        this.addType(declaringType);
        this.registerField(declaringType, analysisField, new ReflectionRuntimeMetadata.FieldMetadata(RuntimeConditionSet.emptySet(), declaringType, name, type, modifiers));
    }

    @Override
    public void addHidingMethodMetadata(AnalysisMethod analysisMethod, HostedType declaringType, String name, HostedType[] parameterTypes, int modifiers, HostedType returnType) {
        this.encoders.memberNames.addObject((Object)name);
        for (HostedType parameterType : parameterTypes) {
            this.encoders.classes.addObject(parameterType.getJavaClass());
        }
        this.encoders.classes.addObject(returnType.getJavaClass());
        this.addType(declaringType);
        this.registerMethod(declaringType, analysisMethod, new ReflectionRuntimeMetadata.MethodMetadata(RuntimeConditionSet.emptySet(), declaringType, name, parameterTypes, modifiers, returnType));
    }

    @Override
    public void addReachableFieldMetadata(HostedField field) {
        HostedType declaringType = field.getDeclaringClass();
        String name = field.getName();
        this.encoders.memberNames.addObject((Object)name);
        this.registerField(declaringType, field, new ReflectionRuntimeMetadata.FieldMetadata(RuntimeConditionSet.emptySet(), declaringType, name, false));
    }

    @Override
    public void addReachableExecutableMetadata(HostedMethod executable) {
        boolean isMethod = !executable.isConstructor();
        HostedType declaringType = executable.getDeclaringClass();
        String name = isMethod ? executable.getReflectionName() : null;
        String[] parameterTypeNames = RuntimeMetadataEncoderImpl.getParameterTypeNames(executable);
        if (isMethod) {
            this.encoders.memberNames.addObject((Object)name);
        }
        for (String parameterTypeName : parameterTypeNames) {
            this.encoders.otherStrings.addObject((Object)parameterTypeName);
        }
        if (isMethod) {
            this.registerMethod(declaringType, executable, new ReflectionRuntimeMetadata.MethodMetadata(RuntimeConditionSet.emptySet(), declaringType, name, parameterTypeNames));
        } else {
            this.registerConstructor(declaringType, executable, new ReflectionRuntimeMetadata.ConstructorMetadata(RuntimeConditionSet.emptySet(), declaringType, parameterTypeNames));
        }
    }

    @Override
    public void addNegativeFieldQueryMetadata(HostedType declaringClass, String fieldName) {
        this.encoders.memberNames.addObject((Object)fieldName);
        this.registerField(declaringClass, fieldName, new ReflectionRuntimeMetadata.FieldMetadata(RuntimeConditionSet.emptySet(), declaringClass, fieldName, true));
    }

    @Override
    public void addNegativeMethodQueryMetadata(HostedType declaringClass, String methodName, HostedType[] parameterTypes) {
        this.encoders.memberNames.addObject((Object)methodName);
        for (HostedType parameterType : parameterTypes) {
            this.encoders.classes.addObject(parameterType.getJavaClass());
        }
        this.registerMethod(declaringClass, Pair.create((Object)methodName, (Object)parameterTypes), new ReflectionRuntimeMetadata.MethodMetadata(RuntimeConditionSet.emptySet(), declaringClass, methodName, parameterTypes));
    }

    @Override
    public void addNegativeConstructorQueryMetadata(HostedType declaringClass, HostedType[] parameterTypes) {
        for (HostedType parameterType : parameterTypes) {
            this.encoders.classes.addObject(parameterType.getJavaClass());
        }
        this.registerConstructor(declaringClass, parameterTypes, new ReflectionRuntimeMetadata.ConstructorMetadata(RuntimeConditionSet.emptySet(), declaringClass, parameterTypes));
    }

    @Override
    public void addClassLookupError(HostedType declaringClass, Throwable exception) {
        this.addType(declaringClass);
        this.registerError(exception);
        this.classLookupErrors.put(declaringClass, exception);
    }

    @Override
    public void addFieldLookupError(HostedType declaringClass, Throwable exception) {
        this.addType(declaringClass);
        this.registerError(exception);
        this.fieldLookupErrors.put(declaringClass, exception);
    }

    @Override
    public void addMethodLookupError(HostedType declaringClass, Throwable exception) {
        this.addType(declaringClass);
        this.registerError(exception);
        this.methodLookupErrors.put(declaringClass, exception);
    }

    @Override
    public void addConstructorLookupError(HostedType declaringClass, Throwable exception) {
        this.addType(declaringClass);
        this.registerError(exception);
        this.constructorLookupErrors.put(declaringClass, exception);
    }

    @Override
    public void addRecordComponentsLookupError(HostedType declaringClass, Throwable exception) {
        this.addType(declaringClass);
        this.registerError(exception);
        this.recordComponentLookupErrors.put(declaringClass, exception);
    }

    private static HostedType[] getParameterTypes(HostedMethod method) {
        int len = method.getSignature().getParameterCount(false);
        HostedType[] parameterTypes = len == 0 ? HostedType.EMPTY_ARRAY : new HostedType[len];
        for (int i = 0; i < parameterTypes.length; ++i) {
            parameterTypes[i] = (HostedType)method.getSignature().getParameterType(i);
        }
        return parameterTypes;
    }

    private static String[] getParameterTypeNames(HostedMethod method) {
        String[] parameterTypeNames = new String[method.getSignature().getParameterCount(false)];
        for (int i = 0; i < parameterTypeNames.length; ++i) {
            parameterTypeNames[i] = ((HostedType)method.getSignature().getParameterType(i)).toJavaName();
        }
        return parameterTypeNames;
    }

    private static HostedType[] getExceptionTypes(MetaAccessProvider metaAccess, Executable reflectMethod) {
        Class<?>[] exceptionClasses = reflectMethod.getExceptionTypes();
        HostedType[] exceptionTypes = exceptionClasses.length == 0 ? HostedType.EMPTY_ARRAY : new HostedType[exceptionClasses.length];
        for (int i = 0; i < exceptionClasses.length; ++i) {
            exceptionTypes[i] = (HostedType)metaAccess.lookupJavaType(exceptionClasses[i]);
        }
        return exceptionTypes;
    }

    private static Object getReflectParameters(Executable reflectMethod) {
        Parameter[] rawParameters;
        try {
            rawParameters = (Parameter[])ReflectionUtil.invokeMethod((Method)getExecutableParameters, (Object)reflectMethod, (Object[])new Object[0]);
        }
        catch (IllegalArgumentException ex) {
            return ex;
        }
        if (rawParameters == null) {
            return null;
        }
        ReflectionRuntimeMetadata.ReflectParameterMetadata[] reflectParameters = new ReflectionRuntimeMetadata.ReflectParameterMetadata[rawParameters.length];
        for (int i = 0; i < rawParameters.length; ++i) {
            reflectParameters[i] = new ReflectionRuntimeMetadata.ReflectParameterMetadata(rawParameters[i].getName(), rawParameters[i].getModifiers());
        }
        return reflectParameters;
    }

    private ReflectionRuntimeMetadata.RecordComponentMetadata[] getRecordComponents(MetaAccessProvider metaAccess, HostedType declaringType, Class<?> clazz) {
        RecordComponent[] recordComponents = ((ReflectionHostedSupport)ImageSingletons.lookup(ReflectionHostedSupport.class)).getRecordComponents(clazz);
        if (recordComponents == null) {
            return null;
        }
        ReflectionRuntimeMetadata.RecordComponentMetadata[] metadata = new ReflectionRuntimeMetadata.RecordComponentMetadata[recordComponents.length];
        for (int i = 0; i < recordComponents.length; ++i) {
            RecordComponent recordComponent = recordComponents[i];
            String name = recordComponent.getName();
            HostedType type = (HostedType)metaAccess.lookupJavaType(recordComponent.getType());
            String signature = recordComponent.getGenericSignature();
            this.encoders.memberNames.addObject((Object)name);
            this.encoders.classes.addObject(type.getJavaClass());
            this.encoders.otherStrings.addObject((Object)signature);
            AnnotationValue[] annotations = this.registerAnnotationValues(recordComponent);
            TypeAnnotationValue[] typeAnnotations = this.registerTypeAnnotationValues(recordComponent);
            metadata[i] = new ReflectionRuntimeMetadata.RecordComponentMetadata(declaringType, name, type, signature, annotations, typeAnnotations);
        }
        return metadata;
    }

    @Override
    public void encodeAllAndInstall() {
        UnsafeArrayTypeWriter buf = UnsafeArrayTypeWriter.create((boolean)ByteArrayReader.supportsUnalignedMemoryAccess());
        int typesIndex = this.encodeAndAddCollection(buf, this.sortedTypes.toArray(HostedType.EMPTY_ARRAY), this::encodeType, false);
        assert (typesIndex == 0);
        for (HostedType declaringType : this.sortedTypes) {
            int signersEncodingIndex;
            int nestMembersEncodingIndex;
            int permittedSubclassesIndex;
            int classesEncodingIndex;
            int typeAnnotationsIndex;
            int annotationsIndex;
            int enclosingMethodInfoIndex;
            DynamicHub hub = declaringType.getHub();
            ReflectionRuntimeMetadata.ClassMetadata classMetadata = this.classData.get(declaringType);
            if (declaringType.getWrapped().getWrapped() instanceof BaseLayerType) continue;
            if (!declaringType.getWrapped().isInBaseLayer() && RuntimeMetadataEncoderImpl.anySet(enclosingMethodInfoIndex = classMetadata.enclosingMethodInfo instanceof Throwable ? this.encodeErrorIndex((Throwable)classMetadata.enclosingMethodInfo) : RuntimeMetadataEncoderImpl.addElement(buf, this.encodeEnclosingMethodInfo((Object[])classMetadata.enclosingMethodInfo)), annotationsIndex = RuntimeMetadataEncoderImpl.addEncodedElement(buf, this.encodeAnnotations(classMetadata.annotations)), typeAnnotationsIndex = RuntimeMetadataEncoderImpl.addEncodedElement(buf, this.encodeTypeAnnotations(classMetadata.typeAnnotations)), classesEncodingIndex = this.encodeAndAddCollection(buf, classMetadata.classes, this.classLookupErrors.get(declaringType), this::encodeType, false), permittedSubclassesIndex = this.encodeAndAddCollection(buf, classMetadata.permittedSubclasses, this::encodeType, true), nestMembersEncodingIndex = this.encodeAndAddCollection(buf, classMetadata.nestMembers, this::encodeType, true), signersEncodingIndex = this.encodeAndAddCollection(buf, classMetadata.signers, this::encodeObject, true))) {
                hub.setHubMetadata(enclosingMethodInfoIndex, annotationsIndex, typeAnnotationsIndex, classesEncodingIndex, permittedSubclassesIndex, nestMembersEncodingIndex, signersEncodingIndex);
            }
            int fieldsIndex = this.encodeAndAddCollection(buf, this.getFields(declaringType), this.fieldLookupErrors.get(declaringType), this::encodeField, false);
            int methodsIndex = this.encodeAndAddCollection(buf, this.getMethods(declaringType), this.methodLookupErrors.get(declaringType), this::encodeExecutable, false);
            int constructorsIndex = this.encodeAndAddCollection(buf, this.getConstructors(declaringType), this.constructorLookupErrors.get(declaringType), this::encodeExecutable, false);
            int recordComponentsIndex = this.encodeAndAddCollection(buf, classMetadata.recordComponents, this.recordComponentLookupErrors.get(declaringType), this::encodeRecordComponent, true);
            int classFlags = classMetadata.flags;
            if (!RuntimeMetadataEncoderImpl.anySet(fieldsIndex, methodsIndex, constructorsIndex, recordComponentsIndex) && classFlags == hub.getModifiers()) continue;
            hub.setReflectionMetadata(fieldsIndex, methodsIndex, constructorsIndex, recordComponentsIndex, classFlags);
        }
        for (ReflectionRuntimeMetadata.AccessibleObjectMetadata metadata : this.heapData) {
            AccessibleObject heapObject = (AccessibleObject)this.snippetReflection.asObject(AccessibleObject.class, metadata.heapObject);
            this.annotationsEncodings.put(heapObject, this.encodeAnnotations(metadata.annotations));
            this.typeAnnotationsEncodings.put(heapObject, this.encodeTypeAnnotations(metadata.typeAnnotations));
            if (!(metadata instanceof ReflectionRuntimeMetadata.ExecutableMetadata)) continue;
            this.parameterAnnotationsEncodings.put((Executable)heapObject, this.encodeParameterAnnotations(((ReflectionRuntimeMetadata.ExecutableMetadata)metadata).parameterAnnotations));
            if (((ReflectionRuntimeMetadata.ExecutableMetadata)metadata).reflectParameters != null) {
                this.reflectParametersEncodings.put((Executable)heapObject, this.encodeReflectParameters(((ReflectionRuntimeMetadata.ExecutableMetadata)metadata).reflectParameters));
            }
            if (!(metadata instanceof ReflectionRuntimeMetadata.MethodMetadata)) continue;
            this.annotationDefaultEncodings.put((Method)heapObject, this.encodeAnnotationDefault(((ReflectionRuntimeMetadata.MethodMetadata)metadata).annotationDefault));
        }
        RuntimeMetadataEncoderImpl.install(buf);
        EncodedRuntimeMetadataSupplierImpl supplierImpl = new EncodedRuntimeMetadataSupplierImpl(this.annotationsEncodings, this.parameterAnnotationsEncodings, this.annotationDefaultEncodings, this.typeAnnotationsEncodings, this.reflectParametersEncodings);
        this.clearDataAfterEncoding();
        ImageSingletons.add(EncodedRuntimeMetadataSupplier.class, (Object)supplierImpl);
    }

    private void clearDataAfterEncoding() {
        this.annotationsEncodings = null;
        this.parameterAnnotationsEncodings = null;
        this.annotationDefaultEncodings = null;
        this.typeAnnotationsEncodings = null;
        this.reflectParametersEncodings = null;
        this.sortedTypes = null;
        this.classData = null;
        this.fieldData = null;
        this.methodData = null;
        this.constructorData = null;
        this.classLookupErrors = null;
        this.fieldLookupErrors = null;
        this.methodLookupErrors = null;
        this.constructorLookupErrors = null;
        this.recordComponentLookupErrors = null;
        this.heapData = null;
    }

    private int encodeErrorIndex(Throwable error) {
        int index = this.encoders.objectConstants.getIndex((Object)this.snippetReflection.forObject((Object)error));
        int encodedIndex = -2 - index;
        VMError.guarantee(RuntimeMetadataDecoderImpl.isErrorIndex(encodedIndex));
        return encodedIndex;
    }

    private <T> int encodeAndAddCollection(UnsafeArrayTypeWriter buf, T[] data, BiConsumer<UnsafeArrayTypeWriter, T> encodeCallback, boolean canBeNull) {
        return this.encodeAndAddCollection(buf, data, null, encodeCallback, canBeNull);
    }

    private <T> int encodeAndAddCollection(UnsafeArrayTypeWriter buf, T[] data, Throwable lookupError, BiConsumer<UnsafeArrayTypeWriter, T> encodeCallback, boolean canBeNull) {
        int offset = TypeConversion.asS4((long)buf.getBytesWritten());
        if (lookupError != null) {
            buf.putSV((long)this.encodeErrorIndex(lookupError));
        } else {
            if (data == null || !canBeNull && data.length == 0) {
                return -1;
            }
            RuntimeMetadataEncoderImpl.encodeArray(buf, data, element -> encodeCallback.accept(buf, element));
        }
        return offset;
    }

    private static int addElement(UnsafeArrayTypeWriter buf, byte[] encoding) {
        if (encoding == null) {
            return -1;
        }
        int offset = TypeConversion.asS4((long)buf.getBytesWritten());
        RuntimeMetadataEncoderImpl.encodeBytes(buf, encoding);
        return offset;
    }

    private static int addEncodedElement(UnsafeArrayTypeWriter buf, byte[] encoding) {
        if (encoding == null) {
            return -1;
        }
        int offset = TypeConversion.asS4((long)buf.getBytesWritten());
        RuntimeMetadataEncoderImpl.encodeByteArray(buf, encoding);
        return offset;
    }

    private static void install(UnsafeArrayTypeWriter encodingBuffer) {
        int encodingSize = TypeConversion.asS4((long)encodingBuffer.getBytesWritten());
        byte[] dataEncoding = new byte[encodingSize];
        RuntimeMetadataEncoding.currentLayer().setEncoding(encodingBuffer.toArray(dataEncoding));
    }

    private static boolean anySet(int ... indices) {
        for (int index : indices) {
            if (index == -1) continue;
            return true;
        }
        return false;
    }

    private void encodeField(UnsafeArrayTypeWriter buf, ReflectionRuntimeMetadata.FieldMetadata field) {
        assert ((field.modifiers & 0xF0000000) == 0);
        int modifiers = field.modifiers;
        modifiers |= field.complete ? Integer.MIN_VALUE : 0;
        modifiers |= field.heapObject != null ? 0x40000000 : 0;
        modifiers |= field.hiding ? 0x20000000 : 0;
        buf.putUV((long)(modifiers |= field.negative ? 0x10000000 : 0));
        this.encodeConditions(buf, field.conditions);
        if (field.heapObject != null) {
            this.encodeObject(buf, field.heapObject);
        } else {
            this.encodeMemberName(buf, field.name);
            if (field.complete || field.hiding) {
                this.encodeType(buf, field.type);
            }
            if (field.complete) {
                buf.putU1(field.trustedFinal ? 1L : 0L);
                this.encodeOtherString(buf, field.signature);
                RuntimeMetadataEncoderImpl.encodeByteArray(buf, this.encodeAnnotations(field.annotations));
                RuntimeMetadataEncoderImpl.encodeByteArray(buf, this.encodeTypeAnnotations(field.typeAnnotations));
                buf.putSV((long)field.offset);
                this.encodeOtherString(buf, field.deletedReason);
            }
        }
    }

    private void encodeConditions(UnsafeArrayTypeWriter buf, RuntimeConditionSet conditions) {
        RuntimeMetadataEncoderImpl.encodeArray(buf, (Class[])conditions.getTypesForEncoding().toArray(Class[]::new), t -> this.encodeType(buf, (Class<?>)t));
    }

    private void encodeExecutable(UnsafeArrayTypeWriter buf, ReflectionRuntimeMetadata.ExecutableMetadata executable) {
        boolean isHiding;
        boolean isMethod = executable instanceof ReflectionRuntimeMetadata.MethodMetadata;
        boolean bl = isHiding = isMethod && ((ReflectionRuntimeMetadata.MethodMetadata)executable).hiding;
        assert ((executable.modifiers & 0xF0000000) == 0);
        int modifiers = executable.modifiers;
        modifiers |= executable.complete ? Integer.MIN_VALUE : 0;
        modifiers |= executable.heapObject != null ? 0x40000000 : 0;
        modifiers |= isHiding ? 0x20000000 : 0;
        buf.putUV((long)(modifiers |= executable.negative ? 0x10000000 : 0));
        this.encodeConditions(buf, executable.conditions);
        if (executable.heapObject != null) {
            this.encodeObject(buf, executable.heapObject);
        } else {
            if (isMethod) {
                this.encodeMemberName(buf, ((ReflectionRuntimeMetadata.MethodMetadata)executable).name);
            }
            if (executable.complete || isHiding || executable.negative) {
                RuntimeMetadataEncoderImpl.encodeArray(buf, (HostedType[])executable.parameterTypes, parameterType -> this.encodeType(buf, (HostedType)parameterType));
            } else {
                RuntimeMetadataEncoderImpl.encodeArray(buf, (String[])executable.parameterTypes, parameterTypeName -> this.encodeOtherString(buf, (String)parameterTypeName));
            }
            if (isMethod && (executable.complete || isHiding)) {
                this.encodeType(buf, ((ReflectionRuntimeMetadata.MethodMetadata)executable).returnType);
            }
            if (executable.complete) {
                RuntimeMetadataEncoderImpl.encodeArray(buf, executable.exceptionTypes, exceptionType -> this.encodeType(buf, (HostedType)exceptionType));
                this.encodeOtherString(buf, executable.signature);
                RuntimeMetadataEncoderImpl.encodeByteArray(buf, this.encodeAnnotations(executable.annotations));
                RuntimeMetadataEncoderImpl.encodeByteArray(buf, this.encodeParameterAnnotations(executable.parameterAnnotations));
                if (isMethod && executable.declaringType.getHub().getHostedJavaClass().isAnnotation()) {
                    RuntimeMetadataEncoderImpl.encodeByteArray(buf, this.encodeAnnotationDefault(((ReflectionRuntimeMetadata.MethodMetadata)executable).annotationDefault));
                }
                RuntimeMetadataEncoderImpl.encodeByteArray(buf, this.encodeTypeAnnotations(executable.typeAnnotations));
                RuntimeMetadataEncoderImpl.encodeByteArray(buf, this.encodeReflectParameters(executable.reflectParameters));
                this.encodeObject(buf, executable.accessor);
            }
        }
    }

    private void encodeType(UnsafeArrayTypeWriter buf, HostedType type) {
        this.encodeType(buf, type.getJavaClass());
    }

    private void encodeType(UnsafeArrayTypeWriter buf, Class<?> type) {
        buf.putSV((long)this.encoders.classes.getIndex(type));
    }

    private void encodeMemberName(UnsafeArrayTypeWriter buf, String name) {
        buf.putSV((long)this.encoders.memberNames.getIndex((Object)name));
    }

    private void encodeOtherString(UnsafeArrayTypeWriter buf, String str) {
        buf.putSV((long)this.encoders.otherStrings.getIndex((Object)str));
    }

    private void encodeObject(UnsafeArrayTypeWriter buf, JavaConstant object) {
        if (object == null) {
            buf.putSV(-1L);
        } else {
            buf.putSV((long)this.encoders.objectConstants.getIndex((Object)object));
        }
    }

    private <T> void encodeArrayOrError(UnsafeArrayTypeWriter buf, Object arrayOrError, Consumer<T> elementEncoder) {
        if (arrayOrError instanceof Throwable) {
            Throwable error = (Throwable)arrayOrError;
            buf.putSV((long)this.encodeErrorIndex(error));
        } else {
            Object[] array = (Object[])arrayOrError;
            RuntimeMetadataEncoderImpl.encodeArray(buf, array, elementEncoder);
        }
    }

    private static <T> void encodeArray(UnsafeArrayTypeWriter buf, T[] array, Consumer<T> elementEncoder) {
        buf.putSV((long)array.length);
        for (T elem : array) {
            elementEncoder.accept(elem);
        }
    }

    private static void encodeByteArray(UnsafeArrayTypeWriter buf, byte[] array) {
        if (array == null) {
            buf.putUV(-1L);
            return;
        }
        buf.putUV((long)array.length);
        RuntimeMetadataEncoderImpl.encodeBytes(buf, array);
    }

    private static void encodeBytes(UnsafeArrayTypeWriter buf, byte[] bytes) {
        for (byte b : bytes) {
            buf.putS1((long)b);
        }
    }

    private static String getSignature(Field field) {
        try {
            return (String)getFieldSignature.invoke((Object)field, new Object[0]);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw VMError.shouldNotReachHere(e);
        }
    }

    private static String getSignature(Executable executable) {
        try {
            return (String)(executable instanceof Method ? getMethodSignature.invoke((Object)executable, new Object[0]) : getConstructorSignature.invoke((Object)executable, new Object[0]));
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw VMError.shouldNotReachHere(e);
        }
    }

    private byte[] encodeAnnotations(AnnotationValue[] annotations) {
        if (annotations.length == 0) {
            return null;
        }
        UnsafeArrayTypeWriter buf = UnsafeArrayTypeWriter.create((boolean)ByteArrayReader.supportsUnalignedMemoryAccess(), (boolean)true);
        AnnotationMetadataEncoder.encodeArray(buf, annotations, annotation -> AnnotationMetadataEncoder.encodeAnnotation(buf, annotation, this.encoders));
        return buf.toArray();
    }

    private byte[] encodeParameterAnnotations(AnnotationValue[][] parameterAnnotations) {
        if (parameterAnnotations.length == 0) {
            return null;
        }
        UnsafeArrayTypeWriter buf = UnsafeArrayTypeWriter.create((boolean)ByteArrayReader.supportsUnalignedMemoryAccess(), (boolean)true);
        buf.putU1((long)parameterAnnotations.length);
        for (AnnotationValue[] annotations : parameterAnnotations) {
            AnnotationMetadataEncoder.encodeArray(buf, annotations, annotation -> AnnotationMetadataEncoder.encodeAnnotation(buf, annotation, this.encoders));
        }
        return buf.toArray();
    }

    private byte[] encodeAnnotationDefault(AnnotationMemberValue annotationDefault) {
        if (annotationDefault == null) {
            return null;
        }
        UnsafeArrayTypeWriter buf = UnsafeArrayTypeWriter.create((boolean)ByteArrayReader.supportsUnalignedMemoryAccess(), (boolean)true);
        AnnotationMetadataEncoder.encodeAnnotationMember(buf, annotationDefault, this.encoders);
        return buf.toArray();
    }

    private byte[] encodeTypeAnnotations(TypeAnnotationValue[] typeAnnotations) {
        if (typeAnnotations.length == 0) {
            return null;
        }
        UnsafeArrayTypeWriter buf = UnsafeArrayTypeWriter.create((boolean)ByteArrayReader.supportsUnalignedMemoryAccess(), (boolean)true);
        AnnotationMetadataEncoder.encodeArray(buf, typeAnnotations, typeAnnotation -> AnnotationMetadataEncoder.encodeTypeAnnotation(buf, typeAnnotation, this.encoders));
        return buf.toArray();
    }

    private byte[] encodeReflectParameters(Object reflectParameters) {
        if (reflectParameters == null) {
            return null;
        }
        UnsafeArrayTypeWriter buf = UnsafeArrayTypeWriter.create((boolean)ByteArrayReader.supportsUnalignedMemoryAccess());
        this.encodeArrayOrError(buf, reflectParameters, reflectParameter -> this.encodeReflectParameter(buf, (ReflectionRuntimeMetadata.ReflectParameterMetadata)reflectParameter));
        return buf.toArray();
    }

    private void encodeReflectParameter(UnsafeArrayTypeWriter buf, ReflectionRuntimeMetadata.ReflectParameterMetadata reflectParameter) {
        this.encodeOtherString(buf, reflectParameter.name);
        buf.putUV((long)reflectParameter.modifiers);
    }

    private void encodeRecordComponent(UnsafeArrayTypeWriter buf, ReflectionRuntimeMetadata.RecordComponentMetadata recordComponent) {
        this.encodeMemberName(buf, recordComponent.name);
        this.encodeType(buf, recordComponent.type);
        this.encodeOtherString(buf, recordComponent.signature);
        RuntimeMetadataEncoderImpl.encodeByteArray(buf, this.encodeAnnotations(recordComponent.annotations));
        RuntimeMetadataEncoderImpl.encodeByteArray(buf, this.encodeTypeAnnotations(recordComponent.typeAnnotations));
    }

    private byte[] encodeEnclosingMethodInfo(Object[] enclosingMethodInfo) {
        if (enclosingMethodInfo == null) {
            return null;
        }
        assert (enclosingMethodInfo.length == 3);
        UnsafeArrayTypeWriter buf = UnsafeArrayTypeWriter.create((boolean)ByteArrayReader.supportsUnalignedMemoryAccess());
        this.encodeType(buf, (Class)enclosingMethodInfo[0]);
        this.encodeMemberName(buf, (String)enclosingMethodInfo[1]);
        this.encodeOtherString(buf, (String)enclosingMethodInfo[2]);
        return buf.toArray();
    }

    static final class ReflectionDataAccessors {
        private final Method privateGetDeclaredFields = ReflectionUtil.lookupMethod(Class.class, (String)"privateGetDeclaredFields", (Class[])new Class[]{Boolean.TYPE});
        private final Method privateGetDeclaredMethods = ReflectionUtil.lookupMethod(Class.class, (String)"privateGetDeclaredMethods", (Class[])new Class[]{Boolean.TYPE});
        private final Method privateGetDeclaredConstructors = ReflectionUtil.lookupMethod(Class.class, (String)"privateGetDeclaredConstructors", (Class[])new Class[]{Boolean.TYPE});

        ReflectionDataAccessors() {
        }

        Field[] getDeclaredFields(Object obj) {
            try {
                return (Field[])this.privateGetDeclaredFields.invoke(obj, false);
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                return new Field[0];
            }
        }

        Method[] getDeclaredMethods(Object obj) {
            try {
                return (Method[])this.privateGetDeclaredMethods.invoke(obj, false);
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                return new Method[0];
            }
        }

        Constructor<?>[] getDeclaredConstructors(Object obj) {
            try {
                return (Constructor[])this.privateGetDeclaredConstructors.invoke(obj, false);
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                return new Constructor[0];
            }
        }
    }

    private static final class LayeredRuntimeMetadataSingleton
    implements LayeredImageSingleton {
        private final Set<Integer> registeredMethods;
        private final Set<Integer> registeredFields;

        private LayeredRuntimeMetadataSingleton() {
            this.registeredMethods = new HashSet<Integer>();
            this.registeredFields = new HashSet<Integer>();
        }

        private LayeredRuntimeMetadataSingleton(Set<Integer> registeredMethods, Set<Integer> registeredFields) {
            this.registeredMethods = registeredMethods;
            this.registeredFields = registeredFields;
        }

        private static LayeredRuntimeMetadataSingleton singleton() {
            return (LayeredRuntimeMetadataSingleton)ImageSingletons.lookup(LayeredRuntimeMetadataSingleton.class);
        }

        public boolean shouldRegisterMethod(Object method, AnalysisMetaAccess metaAccess, ReflectionRuntimeMetadata.AccessibleObjectMetadata metadata) {
            if (!metadata.complete) {
                return true;
            }
            if (method instanceof AnalysisMethod) {
                AnalysisMethod analysisMethod = (AnalysisMethod)method;
                return this.registeredMethods.add(analysisMethod.getId());
            }
            if (method instanceof HostedMethod) {
                HostedMethod hostedMethod = (HostedMethod)method;
                return this.registeredMethods.add(hostedMethod.getWrapped().getId());
            }
            if (method instanceof Method) {
                Method m = (Method)method;
                return this.registeredMethods.add(metaAccess.lookupJavaMethod((Executable)m).getId());
            }
            if (method instanceof Constructor) {
                Constructor c = (Constructor)method;
                return this.registeredMethods.add(metaAccess.lookupJavaMethod((Executable)c).getId());
            }
            return true;
        }

        public boolean shouldRegisterField(Object field, AnalysisMetaAccess metaAccess, ReflectionRuntimeMetadata.AccessibleObjectMetadata metadata) {
            if (!metadata.complete) {
                return true;
            }
            if (field instanceof AnalysisField) {
                AnalysisField analysisField = (AnalysisField)field;
                return this.registeredFields.add(analysisField.getId());
            }
            if (field instanceof HostedField) {
                HostedField hostedField = (HostedField)field;
                return this.registeredFields.add(hostedField.getWrapped().getId());
            }
            if (field instanceof Field) {
                Field f = (Field)field;
                return this.registeredFields.add(metaAccess.lookupJavaField(f).getId());
            }
            return true;
        }

        @Override
        public EnumSet<LayeredImageSingletonBuilderFlags> getImageBuilderFlags() {
            return LayeredImageSingletonBuilderFlags.BUILDTIME_ACCESS_ONLY;
        }

        @Override
        public LayeredImageSingleton.PersistFlags preparePersist(ImageSingletonWriter writer) {
            SVMImageLayerWriter.ImageSingletonWriterImpl writerImpl = (SVMImageLayerWriter.ImageSingletonWriterImpl)writer;
            SharedLayerSnapshotCapnProtoSchemaHolder.LayeredRuntimeMetadataSingleton.Builder builder = writerImpl.getSnapshotBuilder().getLayeredRuntimeMetadataSingleton();
            SVMImageLayerWriter.initInts(builder::initMethods, this.registeredMethods.stream().mapToInt(i -> i));
            SVMImageLayerWriter.initInts(builder::initFields, this.registeredFields.stream().mapToInt(i -> i));
            return LayeredImageSingleton.PersistFlags.CREATE;
        }

        public static Object createFromLoader(ImageSingletonLoader loader) {
            SVMImageLayerSingletonLoader.ImageSingletonLoaderImpl loaderImpl = (SVMImageLayerSingletonLoader.ImageSingletonLoaderImpl)loader;
            SharedLayerSnapshotCapnProtoSchemaHolder.LayeredRuntimeMetadataSingleton.Reader reader = loaderImpl.getSnapshotReader().getLayeredRuntimeMetadataSingleton();
            Set registeredMethods = CapnProtoAdapters.toCollection(reader.getMethods(), Integer::valueOf, HashSet::new);
            Set registeredFields = CapnProtoAdapters.toCollection(reader.getFields(), Integer::valueOf, HashSet::new);
            return new LayeredRuntimeMetadataSingleton(registeredMethods, registeredFields);
        }
    }

    public record EncodedRuntimeMetadataSupplierImpl(Map<AccessibleObject, byte[]> annotationsEncodings, Map<Executable, byte[]> parameterAnnotationsEncodings, Map<Method, byte[]> annotationDefaultEncodings, Map<AccessibleObject, byte[]> typeAnnotationsEncodings, Map<Executable, byte[]> reflectParametersEncodings) implements EncodedRuntimeMetadataSupplier
    {
        @Override
        public byte[] getAnnotationsEncoding(AccessibleObject object) {
            return this.annotationsEncodings.get(object);
        }

        @Override
        public byte[] getParameterAnnotationsEncoding(Executable object) {
            return this.parameterAnnotationsEncodings.get(object);
        }

        @Override
        public byte[] getAnnotationDefaultEncoding(Method object) {
            return this.annotationDefaultEncodings.get(object);
        }

        @Override
        public byte[] getTypeAnnotationsEncoding(AccessibleObject object) {
            return this.typeAnnotationsEncodings.get(object);
        }

        @Override
        public byte[] getReflectParametersEncoding(Executable object) {
            return this.reflectParametersEncodings.get(object);
        }
    }

    @AutomaticallyRegisteredImageSingleton(value={NativeImageCodeCache.ReflectionMetadataEncoderFactory.class})
    static class Factory
    implements NativeImageCodeCache.ReflectionMetadataEncoderFactory {
        Factory() {
        }

        @Override
        public NativeImageCodeCache.RuntimeMetadataEncoder create(SnippetReflectionProvider snippetReflection, CodeInfoEncoder.Encoders encoders) {
            return new RuntimeMetadataEncoderImpl(snippetReflection, encoders);
        }
    }
}

