/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.driver;

import com.oracle.svm.core.SubstrateUtil;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.hosted.driver.IncludeOptionsSupport;
import java.nio.file.Path;
import java.util.List;
import java.util.stream.Stream;

public class LayerOptionsSupport
extends IncludeOptionsSupport {

    public record LayerOption(Path fileName, IncludeOptionsSupport.ExtendedOption[] extendedOptions) {
        public static LayerOption parse(String layerOptionValue) {
            VMError.guarantee(!layerOptionValue.isEmpty());
            return LayerOption.parse(List.of(SubstrateUtil.split(layerOptionValue, ",")));
        }

        public static LayerOption parse(List<String> options) {
            String fileName;
            VMError.guarantee(!options.isEmpty());
            Stream optionsStream = options.stream();
            String first = options.getFirst();
            if (first.isEmpty() || first.endsWith(".nil")) {
                optionsStream = optionsStream.skip(1L);
                fileName = first;
            } else {
                fileName = "";
            }
            IncludeOptionsSupport.ExtendedOption[] extendedOptions = (IncludeOptionsSupport.ExtendedOption[])optionsStream.map(IncludeOptionsSupport.ExtendedOption::parse).toArray(IncludeOptionsSupport.ExtendedOption[]::new);
            return new LayerOption(Path.of(fileName, new String[0]), extendedOptions);
        }
    }
}

