/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.fieldfolding;

import com.oracle.graal.pointsto.BigBang;
import com.oracle.graal.pointsto.flow.AnalysisParsedGraph;
import com.oracle.graal.pointsto.meta.AnalysisField;
import com.oracle.graal.pointsto.meta.AnalysisMethod;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.hosted.ameta.FieldValueInterceptionSupport;
import com.oracle.svm.hosted.fieldfolding.IsStaticFinalFieldInitializedNode;
import com.oracle.svm.hosted.fieldfolding.StaticFinalFieldFoldingFeature;
import com.oracle.svm.hosted.fieldfolding.StaticFinalFieldFoldingSingleton;
import java.util.Arrays;
import jdk.graal.compiler.graph.Node;
import jdk.graal.compiler.nodes.AbstractMergeNode;
import jdk.graal.compiler.nodes.ConstantNode;
import jdk.graal.compiler.nodes.EndNode;
import jdk.graal.compiler.nodes.FixedNode;
import jdk.graal.compiler.nodes.FixedWithNextNode;
import jdk.graal.compiler.nodes.FrameState;
import jdk.graal.compiler.nodes.IfNode;
import jdk.graal.compiler.nodes.LogicNode;
import jdk.graal.compiler.nodes.MergeNode;
import jdk.graal.compiler.nodes.NodeView;
import jdk.graal.compiler.nodes.StructuredGraph;
import jdk.graal.compiler.nodes.ValueNode;
import jdk.graal.compiler.nodes.ValuePhiNode;
import jdk.graal.compiler.nodes.calc.IntegerEqualsNode;
import jdk.graal.compiler.nodes.extended.BranchProbabilityNode;
import jdk.graal.compiler.nodes.extended.StateSplitProxyNode;
import jdk.graal.compiler.nodes.java.LoadFieldNode;
import jdk.graal.compiler.nodes.spi.CoreProviders;
import jdk.graal.compiler.nodes.type.StampTool;
import jdk.graal.compiler.phases.BasePhase;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.MetaAccessProvider;
import jdk.vm.ci.meta.ResolvedJavaField;

public final class StaticFinalFieldFoldingPhase
extends BasePhase<CoreProviders> {
    private final FieldValueInterceptionSupport fieldValueInterceptionSupport;
    private final BigBang bb;

    public StaticFinalFieldFoldingPhase() {
        assert (StaticFinalFieldFoldingFeature.isAvailable());
        this.bb = StaticFinalFieldFoldingFeature.singleton().bb;
        this.fieldValueInterceptionSupport = FieldValueInterceptionSupport.singleton();
    }

    public static boolean isEnabled() {
        return StaticFinalFieldFoldingFeature.isAvailable();
    }

    protected void run(StructuredGraph graph, CoreProviders context) {
        assert (StaticFinalFieldFoldingFeature.isAvailable());
        for (Node node : graph.getNodes()) {
            if (!(node instanceof LoadFieldNode)) continue;
            LoadFieldNode loadFieldNode = (LoadFieldNode)node;
            this.handleLoadFieldNode(graph, context.getMetaAccess(), loadFieldNode);
        }
    }

    private void handleLoadFieldNode(StructuredGraph graph, MetaAccessProvider metaAccess, LoadFieldNode loadFieldNode) {
        AnalysisParsedGraph.Stage stage;
        AnalysisMethod definingClassInitializer;
        ResolvedJavaField field = loadFieldNode.field();
        if (!field.isStatic() || !field.isFinal()) {
            return;
        }
        AnalysisField aField = StaticFinalFieldFoldingSingleton.toAnalysisField(field);
        if (!StaticFinalFieldFoldingFeature.isOptimizationCandidate(aField, definingClassInitializer = aField.getDeclaringClass().getClassInitializer(), this.fieldValueInterceptionSupport)) {
            return;
        }
        assert (StaticFinalFieldFoldingFeature.isAllowedTargetMethod(graph.method()));
        boolean inClassInitializer = graph.method().isClassInitializer();
        AnalysisParsedGraph.Stage stage2 = stage = inClassInitializer ? AnalysisParsedGraph.Stage.BYTECODE_PARSED : AnalysisParsedGraph.Stage.OPTIMIZATIONS_APPLIED;
        if (!inClassInitializer || !graph.method().equals((Object)definingClassInitializer)) {
            assert (definingClassInitializer.isOriginalMethod());
            definingClassInitializer.ensureGraphParsed(this.bb, stage);
        }
        VMError.guarantee(loadFieldNode.next() instanceof StateSplitProxyNode, "missing StateSplitProxy");
        StateSplitProxyNode stateSplitProxyNode = (StateSplitProxyNode)loadFieldNode.next();
        JavaConstant initializedValue = StaticFinalFieldFoldingSingleton.singleton().getFoldedFieldValue(stage, aField);
        if (initializedValue == null) {
            FrameState frameState = stateSplitProxyNode.stateAfter();
            stateSplitProxyNode.setStateAfter(null);
            frameState.safeDelete();
            stateSplitProxyNode.replaceAtUsages((Node)loadFieldNode);
            graph.removeFixed((FixedWithNextNode)stateSplitProxyNode);
            return;
        }
        IsStaticFinalFieldInitializedNode fieldCheckStatusNode = (IsStaticFinalFieldInitializedNode)graph.add((Node)new IsStaticFinalFieldInitializedNode(field));
        graph.addBeforeFixed((FixedNode)loadFieldNode, (FixedWithNextNode)fieldCheckStatusNode);
        ConstantNode falseConst = (ConstantNode)graph.addOrUnique((Node)ConstantNode.forBoolean((boolean)false));
        LogicNode isUninitializedNode = (LogicNode)graph.addOrUnique((Node)IntegerEqualsNode.create((ValueNode)fieldCheckStatusNode, (ValueNode)falseConst, (NodeView)NodeView.DEFAULT));
        JavaConstant uninitializedValue = aField.getConstantValue();
        if (uninitializedValue == null) {
            uninitializedValue = JavaConstant.defaultForKind((JavaKind)aField.getStorageKind());
        }
        ConstantNode uninitializedValueNode = (ConstantNode)graph.addOrUnique((Node)ConstantNode.forConstant((JavaConstant)uninitializedValue, (MetaAccessProvider)metaAccess));
        ConstantNode initializedValueNode = (ConstantNode)graph.addOrUnique((Node)ConstantNode.forConstant((JavaConstant)initializedValue, (MetaAccessProvider)metaAccess));
        EndNode uninitializedEndNode = (EndNode)graph.add((Node)new EndNode());
        EndNode initializedEndNode = (EndNode)graph.add((Node)new EndNode());
        IfNode add = (IfNode)graph.add((Node)new IfNode(isUninitializedNode, (FixedNode)uninitializedEndNode, (FixedNode)initializedEndNode, BranchProbabilityNode.EXTREMELY_SLOW_PATH_PROFILE));
        loadFieldNode.replaceAtPredecessor((Node)add);
        MergeNode merge = (MergeNode)graph.add((Node)new MergeNode());
        merge.addForwardEnd(uninitializedEndNode);
        merge.addForwardEnd(initializedEndNode);
        ConstantNode[] phiValueNodes = new ConstantNode[]{uninitializedValueNode, initializedValueNode};
        ValuePhiNode phi = (ValuePhiNode)graph.addOrUnique((Node)new ValuePhiNode(StampTool.meet(Arrays.asList(phiValueNodes)), (AbstractMergeNode)merge, (ValueNode[])phiValueNodes));
        stateSplitProxyNode.replaceAtUsages((Node)phi);
        merge.setStateAfter(stateSplitProxyNode.stateAfter());
        stateSplitProxyNode.setStateAfter(null);
        loadFieldNode.replaceAtUsages((Node)phi);
        graph.replaceFixedWithFixed((FixedWithNextNode)loadFieldNode, (FixedWithNextNode)merge);
        assert (!loadFieldNode.isAlive());
        graph.removeFixed((FixedWithNextNode)stateSplitProxyNode);
        assert (!stateSplitProxyNode.isAlive());
    }
}

